/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.zsy.exam.common.group.UserGroup;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.controller.ExaminationPaperController;
import com.zsy.exam.model.dto.UserOperateLogDTO;
import com.zsy.exam.model.dto.UserPostDTO;
import com.zsy.exam.model.dto.UserUpdateDTO;
import com.zsy.exam.model.form.UserForm;
import com.zsy.exam.model.vo.MenuTreeListVO;
import com.zsy.exam.model.vo.UserVO;
import com.zsy.exam.model.vo.region.SchoolInfoExportVo;
import com.zsy.exam.service.IUserService;
import com.zsy.exam.util.CryptoUtils;
import jakarta.annotation.Resource;
import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/user"})
public class UserController {
    @Resource
    private IUserService iUserService;

    @GetMapping(value={"/info"})
    @PreAuthorize(value="hasAnyAuthority('user-info')")
    public Result<UserVO> info() {
        return this.iUserService.info();
    }

    @GetMapping(value={"/menu"})
    @PreAuthorize(value="hasAnyAuthority('user-menu')")
    public Result<List<MenuTreeListVO>> menu() {
        return Result.success((Object)this.iUserService.getRoleMenuList());
    }

    @PutMapping
    @PreAuthorize(value="hasAnyAuthority('user-update-password')")
    public Result<String> updatePassword(@Validated(value={UserGroup.UpdatePasswordGroup.class}) @RequestBody UserForm userForm) {
        return this.iUserService.updatePassword(userForm);
    }

    @GetMapping(value={"reset"})
    @PreAuthorize(value="hasAnyAuthority('user-reset-password-staff','user-reset-password-student')")
    public Result resetPassword(Long userId) {
        this.iUserService.resetPassword(userId);
        return Result.success();
    }

    @PostMapping(value={"update"})
    @PreAuthorize(value="hasAnyAuthority('user-update')")
    public Result update(@RequestBody UserUpdateDTO dto) {
        this.iUserService.updateUser(dto);
        return Result.success();
    }

    @DeleteMapping(value={"/{ids}"})
    @PreAuthorize(value="hasAnyAuthority('user-delete')")
    public Result<String> deleteBatchByIds(@PathVariable(value="ids") String ids) {
        return this.iUserService.deleteBatchByIds(ids);
    }

    @PostMapping(value={"/import"})
    @PreAuthorize(value="hasAnyAuthority('user-import')")
    public Result<String> importUsers(@RequestParam(value="file") MultipartFile file) {
        return this.iUserService.importUsers(file);
    }

    @PutMapping(value={"/clbum/join"})
    @PreAuthorize(value="hasAnyAuthority('user-clbum-join')")
    public Result<String> joinClbum(@RequestParam(value="code") String code) {
        return this.iUserService.joinClbum(code);
    }

    @GetMapping(value={"/paging"})
    @PreAuthorize(value="hasAnyAuthority('user-paging')")
    public Result<IPage<UserVO>> pagingUser(@RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize, @RequestParam(value="clbumId", required=false) Long clbumId, @RequestParam(value="realName", required=false) String realName) {
        return this.iUserService.pagingUser(pageNum, pageSize, clbumId, realName);
    }

    @PutMapping(value={"/uploadAvatar"})
    @PreAuthorize(value="hasAnyAuthority('user-uploadAvatar')")
    public Result<String> uploadAvatar(@RequestPart(value="file") MultipartFile file) {
        return this.iUserService.uploadAvatar(file);
    }

    @PostMapping(value={"/addPost"})
    @PreAuthorize(value="hasAnyAuthority('user-addPost')")
    public Result addPost(@RequestBody List<UserPostDTO> dtos) {
        this.iUserService.addUserPosts(dtos);
        return Result.success();
    }

    @PostMapping(value={"/syncUser"})
    @PreAuthorize(value="hasAnyAuthority('user-syncUser')")
    public Result syncUser(@RequestBody UserOperateLogDTO dto) {
        this.iUserService.syncZhglUser(dto);
        return Result.success();
    }

    @GetMapping(value={"/sync/schoolInfo/export"})
    public Result exportSchoolInfo() {
        SchoolInfoExportVo vo = this.iUserService.exportSchoolInfo();
        String cipherText = "";
        try {
            cipherText = CryptoUtils.encryptSymmetrically((String)ExaminationPaperController.exportSecretKey, null, (String)JSONUtil.toJsonStr((Object)vo), (CryptoUtils.Algorithm)CryptoUtils.Algorithm.Encryption.AES_ECB_PKCS5);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Result success = Result.success();
        success.setData((Object)cipherText);
        return success;
    }

    @GetMapping(value={"/sync/schoolInfo/import"})
    public Result importSchoolInfo() {
        this.iUserService.importSchoolInfoOnline();
        return Result.success();
    }
}

