/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.entity.UserMessage;
import com.zsy.exam.model.vo.MessageCountVO;
import com.zsy.exam.service.IUserMessageService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="user-message", description="\u7528\u6237\u6d88\u606f\u8868")
@RequestMapping(value={"/api/user-message"})
public class UserMessageController {
    @Autowired
    private IUserMessageService userMessageService;

    @GetMapping(value={"/page"})
    @Operation(summary="\u7528\u6237\u6d88\u606f\u8868\u67e5\u8be2\u5168\u90e8")
    @PreAuthorize(value="hasAnyAuthority('user-message-page')")
    public Result<Page<UserMessage>> getAllUserMessage(Page page, String type) {
        Page userMessageList = this.userMessageService.getAllUserMessage(page, type);
        return Result.success((Object)userMessageList);
    }

    @PostMapping(value={"/delete"})
    @Operation(summary="\u7528\u6237\u6d88\u606f\u8868\u5220\u9664(\u591a\u4e2a\u6761\u76ee\uff0c\u4f7f\u7528\u9017\u53f7\u5206\u9694)")
    @PreAuthorize(value="hasAnyAuthority('user-message-delete')")
    public Result remove(@RequestParam String ids) {
        this.userMessageService.remove(ids);
        return Result.success();
    }

    @PostMapping(value={"/read"})
    @Operation(summary="\u5df2\u8bfb")
    @PreAuthorize(value="hasAnyAuthority('user-message-read')")
    public Result read(@RequestParam String ids) {
        this.userMessageService.read(ids);
        return Result.success();
    }

    @GetMapping(value={"/message-count"})
    @Operation(summary="\u6d88\u606f\u6570\u91cf")
    @PreAuthorize(value="hasAnyAuthority('user-message-message-count')")
    public Result<List<MessageCountVO>> messageCount() {
        List messageCountVO = this.userMessageService.messageCount();
        return Result.success((Object)messageCountVO);
    }
}

