/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.vo.wx.QrCodeRes;
import com.zsy.exam.model.vo.wx.ScanStatusAuthRes;
import com.zsy.exam.service.IWechatService;
import com.zsy.exam.service.WeChatMpService;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateData;
import me.chanjar.weixin.mp.bean.template.WxMpTemplateMessage;
import me.chanjar.weixin.mp.config.WxMpConfigStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"wechat"})
public class WechatController {
    private static final Logger log = LoggerFactory.getLogger(WechatController.class);
    @Autowired
    WeChatMpService weChatMpService;
    private final IWechatService wechatService;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @GetMapping
    public void get(@RequestParam(required=false) String signature, @RequestParam(required=false) String timestamp, @RequestParam(required=false) String nonce, @RequestParam(required=false) String echostr, HttpServletResponse response) throws IOException {
        if (!this.weChatMpService.checkSignature(timestamp, nonce, signature)) {
            this.logger.warn("\u63a5\u6536\u5230\u4e86\u672a\u901a\u8fc7\u6821\u9a8c\u7684\u5fae\u4fe1\u6d88\u606f\uff0c\u8fd9\u53ef\u80fd\u662ftoken\u914d\u7f6e\u9519\u4e86\uff0c\u6216\u662f\u63a5\u6536\u4e86\u975e\u5fae\u4fe1\u5b98\u65b9\u7684\u8bf7\u6c42");
            return;
        }
        response.setCharacterEncoding("UTF-8");
        response.getWriter().write(echostr);
        response.getWriter().flush();
        response.getWriter().close();
    }

    @PostMapping(produces={"text/xml; charset=UTF-8"})
    public void api(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, @RequestParam(value="signature") String signature, @RequestParam(name="encrypt_type", required=false) String encType, @RequestParam(name="msg_signature", required=false) String msgSignature, @RequestParam(value="timestamp") String timestamp, @RequestParam(value="nonce") String nonce) throws IOException {
        String str;
        if (!this.weChatMpService.checkSignature(timestamp, nonce, signature)) {
            this.logger.warn("\u63a5\u6536\u5230\u4e86\u672a\u901a\u8fc7\u6821\u9a8c\u7684\u5fae\u4fe1\u6d88\u606f\uff0c\u8fd9\u53ef\u80fd\u662ftoken\u914d\u7f6e\u9519\u4e86\uff0c\u6216\u662f\u63a5\u6536\u4e86\u975e\u5fae\u4fe1\u5b98\u65b9\u7684\u8bf7\u6c42");
            return;
        }
        BufferedReader bufferedReader = httpServletRequest.getReader();
        StringBuilder requestBodyBuilder = new StringBuilder();
        while ((str = bufferedReader.readLine()) != null) {
            requestBodyBuilder.append(str);
        }
        String requestBody = requestBodyBuilder.toString();
        this.logger.info("\n\u63a5\u6536\u5fae\u4fe1\u8bf7\u6c42\uff1a[signature=[{}], encType=[{}], msgSignature=[{}], timestamp=[{}], nonce=[{}], requestBody=[\\n{}\\n]", new Object[]{signature, encType, msgSignature, timestamp, nonce, requestBody});
        if (this.logger.isDebugEnabled()) {
            this.logger.info("\n\u63a5\u6536\u5fae\u4fe1\u8bf7\u6c42\uff1a[signature=[{}], encType=[{}], msgSignature=[{}], timestamp=[{}], nonce=[{}], requestBody=[\\n{}\\n]", new Object[]{signature, encType, msgSignature, timestamp, nonce, requestBody});
            this.logger.info(httpServletRequest.getQueryString());
            this.logger.info(httpServletRequest.getContentType());
        }
        WxMpXmlMessage inMessage2 = WxMpXmlMessage.fromXml((String)requestBody);
        this.logger.info("\u4e8b\u4ef6\u4e3a" + inMessage2.getEventKey());
        String out = null;
        if (encType == null) {
            WxMpXmlMessage inMessage = WxMpXmlMessage.fromXml((String)requestBody);
            WxMpXmlOutMessage outMessage = this.weChatMpService.route(inMessage);
            if (outMessage == null) {
                httpServletResponse.getOutputStream().write(new byte[0]);
                httpServletResponse.flushBuffer();
                httpServletResponse.getOutputStream().close();
                return;
            }
            out = outMessage.toXml();
        } else if ("aes".equals(encType)) {
            WxMpXmlOutMessage outMessage;
            WxMpXmlMessage inMessage = WxMpXmlMessage.fromEncryptedXml((String)requestBody, (WxMpConfigStorage)this.weChatMpService.getWxMpConfigStorage(), (String)timestamp, (String)nonce, (String)msgSignature);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\n\u6d88\u606f\u89e3\u5bc6\u540e\u5185\u5bb9\u4e3a\uff1a\n{} ", (Object)inMessage.toString());
            }
            if ((outMessage = this.weChatMpService.route(inMessage)) == null) {
                httpServletResponse.getOutputStream().write(new byte[0]);
                httpServletResponse.flushBuffer();
                httpServletResponse.getOutputStream().close();
                return;
            }
            out = outMessage.toEncryptedXml(this.weChatMpService.getWxMpConfigStorage());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.info("\n\u7ec4\u88c5\u56de\u590d\u4fe1\u606f\uff1a{}", (Object)out);
        }
        httpServletResponse.getOutputStream().write(out.getBytes(StandardCharsets.UTF_8));
        httpServletResponse.flushBuffer();
        httpServletResponse.getOutputStream().close();
    }

    public void wechatValidate(HttpServletRequest request, HttpServletResponse response) throws IOException, NoSuchAlgorithmException {
        this.wechatService.wechatValidate(request, response);
    }

    public String handleMessage(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.wechatService.receiveAndResponseMessage(request);
    }

    @Operation(summary="\u83b7\u53d6\u626b\u7801\u767b\u5f55\u4e8c\u7ef4\u7801")
    @GetMapping(value={"/scanLogin"})
    public Result<QrCodeRes> qrcodeCreate() {
        return Result.ok((Object)this.wechatService.qrCodeCreate());
    }

    @Operation(summary="\u8f6e\u8be2\u83b7\u53d6\u767b\u5f55\u72b6\u6001")
    @GetMapping(value={"/scanStatus"})
    public Result<ScanStatusAuthRes> scanStatus(@RequestParam(value="sceneStr") String sceneStr) {
        return Result.ok((Object)this.wechatService.scanStatus(sceneStr));
    }

    @RequestMapping(value={"notifyTemplate"})
    public void notifyOrderPaySuccessTemplate(HttpServletResponse response, HttpServletRequest request) {
        WxMpTemplateMessage orderPaySuccessTemplate = WxMpTemplateMessage.builder().build();
        orderPaySuccessTemplate.setToUser(request.getParameter("openid"));
        orderPaySuccessTemplate.setTemplateId("aUh1Ep8cvO7FoJIL0x9vAdbbBc57YuSj7CtNupHIAhk");
        orderPaySuccessTemplate.setUrl(request.getParameter("url"));
        WxMpTemplateData orderNo = new WxMpTemplateData("character_string2", "202301017465634", "#32CD32");
        WxMpTemplateData thing3 = new WxMpTemplateData("thing3", "\u534e\u4e3aMate60 Pro+", "#32CD32");
        WxMpTemplateData amount4 = new WxMpTemplateData("amount4", "7999", "#32CD32");
        WxMpTemplateData phrase5 = new WxMpTemplateData("phrase5", "\u5fae\u4fe1\u652f\u4ed8", "#32CD32");
        WxMpTemplateData phone_number10 = new WxMpTemplateData("phone_number10", "13112345678", "#32CD32");
        orderPaySuccessTemplate.addData(orderNo).addData(thing3).addData(amount4).addData(phrase5).addData(phone_number10);
        try {
            this.weChatMpService.getTemplateMsgService().sendTemplateMsg(orderPaySuccessTemplate);
        }
        catch (WxErrorException e) {
            this.logger.error(e.getMessage());
        }
    }

    public WechatController(IWechatService wechatService) {
        this.wechatService = wechatService;
    }
}

