/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.dto.ExamUserWrongDTO;
import com.zsy.exam.model.dto.UpdateStatusDTO;
import com.zsy.exam.model.dto.WrongQuestionBookAddDTO;
import com.zsy.exam.model.vo.ExamUserWrongVO;
import com.zsy.exam.model.vo.WrongQuestionBookDetailVO;
import com.zsy.exam.model.vo.WrongQuestionBookExamVO;
import com.zsy.exam.model.vo.WrongQuestionBookKnowledgeVO;
import com.zsy.exam.model.vo.WrongQuestionBookVO;
import com.zsy.exam.service.IWrongQuestionBookService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="wrong-question-book", description="\u9519\u9898\u672c")
@RequestMapping(value={"/api/wrong-question-book"})
public class WrongQuestionBookController {
    @Autowired
    private IWrongQuestionBookService wrongQuestionBookService;

    @GetMapping(value={"/detailByExercise"})
    @Operation(summary="\u9519\u9898\u672c\u901a\u8fc7\u7ec3\u4e60\u67e5\u8be2")
    @PreAuthorize(value="hasAnyAuthority('wrong-question-book-detailByExercise')")
    public Result<List<WrongQuestionBookDetailVO>> detailByExercise(@RequestParam(value="relationId") Long relationId) {
        List list = this.wrongQuestionBookService.detailByExercise(relationId);
        return Result.success((Object)list);
    }

    @GetMapping(value={"/detailByKnowledge"})
    @Operation(summary="\u9519\u9898\u672c\u901a\u8fc7\u77e5\u8bc6\u70b9\u67e5\u8be2")
    @PreAuthorize(value="hasAnyAuthority('wrong-question-book-detailByKnowledge')")
    public Result<List<WrongQuestionBookDetailVO>> detailByKnowledge(@RequestParam(value="repoId") Long repoId, @RequestParam(value="type") Integer type) {
        List list = this.wrongQuestionBookService.detailByKnowledge(repoId, type);
        return Result.success((Object)list);
    }

    @GetMapping(value={"/detailByExam"})
    @Operation(summary="\u9519\u9898\u672c\u901a\u8fc7\u77e5\u8bc6\u70b9\u67e5\u8be2")
    @PreAuthorize(value="hasAnyAuthority('wrong-question-book-detailByExam')")
    public Result<List<WrongQuestionBookDetailVO>> detailByExam(@RequestParam(value="relationId") Long relationId) {
        List list = this.wrongQuestionBookService.detailByExam(relationId);
        return Result.success((Object)list);
    }

    @GetMapping(value={"/exercise-page"})
    @Operation(summary="\u6839\u636e\u7ec3\u4e60\u67e5\u8be2\u9519\u9898\u672c\u5206\u9875")
    @PreAuthorize(value="hasAnyAuthority('wrong-question-book-exercise-page')")
    public Result<Page<WrongQuestionBookVO>> exercisePage(Page page, String key, Long userId) {
        Page wrongQuestionBookList = this.wrongQuestionBookService.exercisePage(page, key, userId);
        return Result.success((Object)wrongQuestionBookList);
    }

    @GetMapping(value={"/knowledge-page"})
    @Operation(summary="\u6839\u636e\u77e5\u8bc6\u70b9\u67e5\u8be2\u9519\u9898\u672c\u5206\u9875")
    @PreAuthorize(value="hasAnyAuthority('wrong-question-book-knowledge-page')")
    public Result<Page<WrongQuestionBookKnowledgeVO>> knowledgePage(Page page, String key, Integer type, Long userId) {
        Page wrongQuestionBookList = this.wrongQuestionBookService.knowledgePage(page, key, type, userId);
        return Result.success((Object)wrongQuestionBookList);
    }

    @GetMapping(value={"/exam-page"})
    @Operation(summary="\u8003\u8bd5\u9519\u9898\u672c\u5206\u9875")
    @PreAuthorize(value="hasAnyAuthority('wrong-question-book-exam-page')")
    public Result<Page<WrongQuestionBookExamVO>> examPage(Page page, String key) {
        Page wrongQuestionBookList = this.wrongQuestionBookService.examPage(page, key);
        return Result.success((Object)wrongQuestionBookList);
    }

    @PostMapping(value={"/add"})
    @Operation(summary="\u9519\u9898\u672c\u65b0\u589e")
    @PreAuthorize(value="hasAnyAuthority('wrong-question-book-add')")
    public Result add(@Valid @RequestBody WrongQuestionBookAddDTO wrongQuestionBook) {
        this.wrongQuestionBookService.add(wrongQuestionBook);
        return Result.success();
    }

    @PostMapping(value={"/addBatch/{relationId}"})
    @Operation(summary="\u9519\u9898\u672c\u6279\u91cf\u65b0\u589e\uff0c\u4e14\u5220\u9664\u539f\u6709\u9519\u9898")
    @PreAuthorize(value="hasAnyAuthority('wrong-question-book-addBatch')")
    public Result add(@Valid @RequestBody List<WrongQuestionBookAddDTO> wrongQuestionBooks, @PathVariable(value="relationId") Long relationId) {
        this.wrongQuestionBookService.addBatch(wrongQuestionBooks, relationId);
        return Result.success();
    }

    @GetMapping(value={"/delete"})
    @Operation(summary="\u9519\u9898\u672c\u5220\u9664(\u591a\u4e2a\u6761\u76ee\uff0c\u4f7f\u7528\u9017\u53f7\u5206\u9694)")
    @PreAuthorize(value="hasAnyAuthority('wrong-question-book-delete')")
    public Result remove(String ids) {
        this.wrongQuestionBookService.remove(ids);
        return Result.success();
    }

    @PostMapping(value={"/update-collect"})
    @Operation(summary="\u6536\u85cf")
    @PreAuthorize(value="hasAnyAuthority('wrong-question-book-update-collect')")
    public Result updateCollect(@RequestBody UpdateStatusDTO dto) {
        this.wrongQuestionBookService.updateCollect(dto);
        return Result.success();
    }

    @GetMapping(value={"/user-wrong-list"})
    @Operation(summary="\u5206\u6790\u8df3\u8f6c\u9519\u9898\u672c")
    @PreAuthorize(value="hasAnyAuthority('wrong-question-book-user-wrong-list')")
    public Result<Page<ExamUserWrongVO>> getExamUserWrongList(Page page, ExamUserWrongDTO dto) {
        Page examUserWrongList = this.wrongQuestionBookService.getExamUserWrongList(page, dto);
        return Result.success((Object)examUserWrongList);
    }

    @GetMapping(value={"/exercise-clubm-page"})
    @Operation(summary="\u6839\u636e\u7ec3\u4e60\u67e5\u8be2\u73ed\u7ea7\u9519\u9898\u672c\u5206\u9875")
    @PreAuthorize(value="hasAnyAuthority('role_teacher','role_admin','role_student')")
    public Result<Page<WrongQuestionBookVO>> exerciseClbumPage(Page page, String key, Long clbumId) {
        Page wrongQuestionBookList = this.wrongQuestionBookService.exerciseClbumPage(page, key, clbumId);
        return Result.success((Object)wrongQuestionBookList);
    }

    @GetMapping(value={"/knowledge-clbum-page"})
    @Operation(summary="\u6839\u636e\u77e5\u8bc6\u70b9\u67e5\u8be2\u73ed\u7ea7\u9519\u9898\u672c\u5206\u9875")
    @PreAuthorize(value="hasAnyAuthority('role_teacher','role_admin','role_student')")
    public Result<Page<WrongQuestionBookKnowledgeVO>> knowledgeClbumPage(Page page, String key, Long clbumId, Integer type) {
        Page wrongQuestionBookList = this.wrongQuestionBookService.knowledgeClbumPage(page, key, clbumId, type);
        return Result.success((Object)wrongQuestionBookList);
    }
}

