/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.converter;

import com.zsy.exam.constant.QuestionTypeEnum;
import com.zsy.exam.converter.QuestionConverter;
import com.zsy.exam.model.entity.Question;
import com.zsy.exam.model.form.question.QuestionFrom;
import com.zsy.exam.model.vo.exercise.QuestionSheetVO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class QuestionConverterImpl
implements QuestionConverter {
    public Question fromToEntity(QuestionFrom questionFrom) {
        if (questionFrom == null) {
            return null;
        }
        Question question = new Question();
        question.setRepoId(questionFrom.getRepoId());
        question.setId(questionFrom.getId());
        question.setQuType(questionFrom.getQuType());
        question.setDifficulty(questionFrom.getDifficulty());
        question.setIsCombination(questionFrom.getIsCombination());
        question.setMainCombinationId(questionFrom.getMainCombinationId());
        question.setWeightDistribution(questionFrom.getWeightDistribution());
        question.setCode(questionFrom.getCode());
        question.setImage(questionFrom.getImage());
        question.setContent(questionFrom.getContent());
        question.setCreateTime(questionFrom.getCreateTime());
        question.setAnalysis(questionFrom.getAnalysis());
        question.setMasteryLevel(questionFrom.getMasteryLevel());
        question.setSource(questionFrom.getSource());
        return question;
    }

    public List<QuestionSheetVO> listEntityToVO(List<Question> questions) {
        if (questions == null) {
            return null;
        }
        ArrayList<QuestionSheetVO> list = new ArrayList<QuestionSheetVO>(questions.size());
        for (Question question : questions) {
            list.add(this.entityToVO(question));
        }
        return list;
    }

    public QuestionSheetVO entityToVO(Question question) {
        if (question == null) {
            return null;
        }
        QuestionSheetVO questionSheetVO = new QuestionSheetVO();
        questionSheetVO.setQuId(question.getId());
        if (question.getQuType() != null) {
            questionSheetVO.setQuType(Enum.valueOf(QuestionTypeEnum.class, question.getQuType()));
        }
        if (question.getRepoId() != null) {
            questionSheetVO.setRepoId(Integer.valueOf(question.getRepoId().intValue()));
        }
        return questionSheetVO;
    }
}

