/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.filter;

import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.constant.RoleEnum;
import com.zsy.exam.mapper.UserMapper;
import com.zsy.exam.model.entity.Staff;
import com.zsy.exam.model.entity.Subject;
import com.zsy.exam.model.entity.User;
import com.zsy.exam.security.SysUserDetails;
import com.zsy.exam.service.IPostService;
import com.zsy.exam.service.IStaffService;
import com.zsy.exam.service.ISubjectService;
import com.zsy.exam.util.JwtUtil;
import com.zsy.exam.util.ResponseUtil;
import jakarta.annotation.Resource;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class VerifyTokenFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(VerifyTokenFilter.class);
    @Resource
    private JwtUtil jwtUtil;
    @Resource
    private ResponseUtil responseUtil;
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private ObjectMapper objectMapper;
    @Resource
    private UserMapper userMapper;
    @Resource
    private IStaffService staffService;
    @Resource
    private ISubjectService subjectService;
    @Resource
    private IPostService postService;
    @Value(value="${springdoc.swagger-ui.enabled:false}")
    Boolean isDebug;
    static AntPathMatcher antPathMatcher = new AntPathMatcher();
    public static List<String> exclusionUrl = Arrays.asList("/api/auths/login", "/api/auths/register", "/api/auths/verifyCode/*", "/api/auths/captcha", "/api/sys-param/getByType/*", "/api/questions/getMaxSerialNumber/**", "/ws/zsy", "/api/exams/region/push", "/api/exams/region/monitor", "/api/exams/region/screen", "/api/user/sync/schoolInfo/export");

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String redisSessionId;
        String requestSessionId;
        Staff staff;
        String uri = request.getRequestURI();
        if (this.isExclusionUrl(uri)) {
            this.doFilter((ServletRequest)request, (ServletResponse)response, filterChain);
            return;
        }
        String authorization = request.getHeader("Authorization");
        String requestOrigion = request.getHeader("request-origion");
        if (this.isDebug.booleanValue() && (uri.contains("/swagger-ui") || uri.contains("/v3") || uri.contains("doc.html") || uri.contains("/webjars") || requestOrigion != null && requestOrigion.contains("Knife4j"))) {
            this.doFilter((ServletRequest)request, (ServletResponse)response, filterChain);
            return;
        }
        if (StringUtils.isBlank((CharSequence)authorization)) {
            this.responseUtil.response(response, Result.loginFailure((String)"Authorization\u4e3a\u7a7a\uff0c\u8bf7\u5148\u767b\u5f55"));
            return;
        }
        boolean verify = this.jwtUtil.verifyToken(authorization);
        if (!verify) {
            this.responseUtil.response(response, Result.loginFailure((String)"token\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55"));
            return;
        }
        if (Boolean.FALSE.equals(this.stringRedisTemplate.hasKey((Object)("token" + request.getSession().getId())))) {
            this.responseUtil.response(response, Result.loginFailure((String)"token\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55"));
            return;
        }
        String userInfo = this.jwtUtil.getUser(authorization);
        List authList = this.jwtUtil.getAuthList(authorization);
        User sysUser = (User)this.objectMapper.readValue(userInfo, User.class);
        List<SimpleGrantedAuthority> permissions = authList.stream().map(SimpleGrantedAuthority::new).toList();
        SysUserDetails securityUser = new SysUserDetails(sysUser);
        securityUser.setPermissions(permissions);
        if (RoleEnum.TEACHER.getId().equals(sysUser.getRoleId()) && StringUtils.isNotBlank((CharSequence)(staff = (Staff)this.staffService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Staff::getUserId, (Object)sysUser.getId())).eq(Staff::getDeleted, (Object)false))).getSubjectId())) {
            List<String> list = Arrays.asList(staff.getSubjectId().split(","));
            List ids = list.stream().map(Long::valueOf).collect(Collectors.toList());
            securityUser.setSubjectId(ids);
            List subjects = this.subjectService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Subject::getEnable, (Object)true)).in(Subject::getId, ids));
            securityUser.setSubjectCode(CollectionUtils.isEmpty((Collection)subjects) ? null : subjects.stream().map(Subject::getCode).collect(Collectors.toList()));
        }
        if (RoleEnum.STUDENT.getId().equals(sysUser.getRoleId()) && !(requestSessionId = request.getSession().getId()).equals(redisSessionId = (String)this.stringRedisTemplate.opsForValue().get((Object)("CONCURRENT_LOGIN_" + sysUser.getId())))) {
            this.responseUtil.response(response, Result.loginFailure((String)"\u5f53\u524d\u7528\u6237\u5df2\u5728\u5176\u4ed6\u7aef\u767b\u5f55\uff0c\u8bf7\u786e\u8ba4\u8d26\u53f7\u5bc6\u7801\u662f\u5426\u6cc4\u6f0f"));
            return;
        }
        List postCodeList = this.postService.getPostCodeListByUserId(sysUser.getId());
        securityUser.setPostCodeList(postCodeList);
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)securityUser, null, permissions);
        SecurityContextHolder.getContext().setAuthentication((Authentication)token);
        this.doFilter((ServletRequest)request, (ServletResponse)response, filterChain);
    }

    public static void main(String[] args) {
        String json = "{\"principal\":{\"permissions\":[{}],\"user\":{\"id\":1,\"userName\":\"admin\",\"realName\":\"\u7ba1\u7406\u5458\",\"avatar\":\"https://online-exam-system-backend.oss-cn-beijing.aliyuncs.com/27eb3a59-4d05-4bce-90ec-4a2457452886.png\",\"roleId\":3,\"clbumId\":78,\"createTime\":1716451567000,\"status\":1,\"isDeleted\":false,\"updateTime\":1720690080130},\"username\":\"admin\"},\"authorities\":[{}],\"details\":{\"remoteAddress\":\"0:0:0:0:0:0:0:1\",\"sessionId\":\"31A20D713A1C2794E2624342F42428F3\"},\"authenticated\":false}";
        UsernamePasswordAuthenticationToken bean = (UsernamePasswordAuthenticationToken)JSONUtil.toBean((String)json, UsernamePasswordAuthenticationToken.class);
        System.out.println(bean);
    }

    private boolean isExclusionUrl(String path) {
        if (exclusionUrl.size() == 0) {
            return false;
        }
        return exclusionUrl.stream().anyMatch(action -> antPathMatcher.match(action, path));
    }
}

