/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.handler;

import com.zsy.exam.handler.AbstractHandler;
import com.zsy.exam.model.entity.User;
import com.zsy.exam.service.IUserService;
import com.zsy.exam.service.IWechatService;
import com.zsy.exam.service.WeChatMpService;
import java.util.Map;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.session.WxSessionManager;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ScanHandler
extends AbstractHandler {
    private static final Logger log = LoggerFactory.getLogger(ScanHandler.class);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    final IWechatService wechatService;
    final IUserService userService;

    public ScanHandler(WeChatMpService weChatMpService, @Lazy IWechatService wechatService, @Lazy IUserService userService) {
        super(weChatMpService);
        this.wechatService = wechatService;
        this.userService = userService;
    }

    public WxMpXmlOutMessage handle(WxMpXmlMessage wxMessage, Map<String, Object> context, WxMpService wxMpService, WxSessionManager sessionManager) throws WxErrorException {
        String eventKey;
        log.info("\u626b\u7801\u6210\u529f {}", (Object)wxMessage);
        String ticket = wxMessage.getTicket();
        if (ticket != null && StringUtils.isNotBlank((CharSequence)(eventKey = wxMessage.getEventKey()))) {
            this.wechatService.handleLogin(wxMessage.getFromUser(), eventKey);
        }
        return null;
    }

    private WxMpXmlOutMessage handleKey(User weChatUser, WxMpXmlMessage wxMpXmlMessage) {
        return this.handleByEventKey(wxMpXmlMessage.getEventKey(), weChatUser, wxMpXmlMessage);
    }
}

