/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.handler;

import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.model.dto.wx.WechatAccessToken;
import com.zsy.exam.model.entity.ThirdConfig;
import com.zsy.exam.model.entity.User;
import com.zsy.exam.service.IThirdConfigService;
import com.zsy.exam.service.IUserService;
import com.zsy.exam.util.SecurityUtil;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component(value="WX")
public class WeChatLoginHandler {
    private static final Logger log = LoggerFactory.getLogger(WeChatLoginHandler.class);
    @Autowired
    private IUserService userService;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private IThirdConfigService thirdConfigService;
    public static final String WECHAT_GET_ACCESS_TOKEN = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s";
    public static final String WX_AUTHORIZATION_CODE_URL = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=%s&secret=%s&code=%s&grant_type=authorization_code";
    public static final String WX_LOGIN_URL = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=code&scope=snsapi_userinfo&state=WX_LOGIN&connect_redirect=1#wechat_redirect";
    public static final String WECHAT_ACCESS_TOKEN = "WECHAT_ACCESS_TOKEN:";

    public String getAccessToken() {
        String accessToken = (String)this.redisTemplate.opsForValue().get((Object)"wechat");
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            ThirdConfig wx = (ThirdConfig)this.thirdConfigService.getOne((Wrapper)new LambdaQueryWrapper().eq(ThirdConfig::getType, (Object)"WX"));
            String appid = wx.getAppId();
            String appsecret = wx.getAppSecret();
            if (StringUtils.isBlank((CharSequence)appid) || StringUtils.isBlank((CharSequence)appsecret)) {
                log.error("appid:{}appsecret:{}\u4e0d\u80fd\u4e3a\u7a7a", (Object)appid, (Object)appsecret);
                return "";
            }
            String url = String.format(WECHAT_GET_ACCESS_TOKEN, appid, appsecret);
            String result = HttpUtil.get((String)url);
            log.info("\u83b7\u53d6\u5fae\u4fe1accessToken\u54cd\u5e94\u62a5\u6587:{}", (Object)result);
            WechatAccessToken wxAccessToken = (WechatAccessToken)JSONUtil.toBean((String)result, WechatAccessToken.class);
            if (wxAccessToken.getErrcode() != null && wxAccessToken.getErrcode() != 0) {
                log.error("\u83b7\u53d6\u5fae\u4fe1accessToken\u5f02\u5e38: {}", (Object)wxAccessToken);
                throw new AppException("\u83b7\u53d6\u5fae\u4fe1accessToken\u5f02\u5e38");
            }
            accessToken = wxAccessToken.getAccess_token();
            this.redisTemplate.opsForValue().set((Object)WECHAT_ACCESS_TOKEN, (Object)wxAccessToken.getAccess_token(), 119L, TimeUnit.MINUTES);
        }
        return accessToken;
    }

    public String identify(String code) {
        ThirdConfig wx = (ThirdConfig)this.thirdConfigService.getOne((Wrapper)new LambdaQueryWrapper().eq(ThirdConfig::getType, (Object)"WX"));
        String appid = wx.getAppId();
        String appsecret = wx.getAppSecret();
        if (StringUtils.isBlank((CharSequence)appid) || StringUtils.isBlank((CharSequence)appsecret)) {
            log.error("appid:{},appsecret:{}\u4e0d\u80fd\u4e3a\u7a7a", (Object)appid, (Object)appsecret);
            return "";
        }
        String url = String.format(WX_AUTHORIZATION_CODE_URL, appid, appsecret, code);
        String result = HttpUtil.get((String)url);
        log.info("\u5fae\u4fe1\u54cd\u5e94\u62a5\u6587:{}", (Object)result);
        Object obj = JSONUtil.parseObj((String)result).get((Object)"openid");
        return null == obj ? "" : obj.toString();
    }

    public User info(String wxOpenId) {
        User user = (User)this.userService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(User::getWechatOpenId, (Object)wxOpenId)).eq(User::getIsDeleted, (Object)false));
        if (user == null) {
            log.info("\u5fae\u4fe1\u672a\u7ed1\u5b9a:{}", (Object)wxOpenId);
        }
        return user;
    }

    public Boolean bind(User user, String identify) {
        User userSelect = (User)this.userService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(User::getWechatOpenId, (Object)identify)).eq(User::getIsDeleted, (Object)false));
        if (userSelect != null) {
            log.error("\u5fae\u4fe1\u8d26\u53f7\u5df2\u7ed1\u5b9a:{}", (Object)identify);
            return Boolean.FALSE;
        }
        Long userId = SecurityUtil.getUserId();
        User loginUser = (User)this.userService.getById((Serializable)userId);
        if (null != loginUser && StringUtils.isNotBlank((CharSequence)loginUser.getWechatOpenId())) {
            log.error("\u8d26\u53f7\u5df2\u7ed1\u5b9a\u5fae\u4fe1:{}", (Object)identify);
            return Boolean.FALSE;
        }
        loginUser.setWechatOpenId(identify);
        return this.userService.updateById((Object)loginUser);
    }

    public void unbind(User user) {
        this.userService.unbind(user.getId(), "wx_open_id");
    }
}

