/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.model.entity;

import cn.hutool.core.util.StrUtil;
import java.util.Arrays;

public class CodeRule {
    private String subject;
    private String course;
    private String unit;
    private String knowledgePoint;
    private String quType;
    private String difficulty;
    private String serialNumber;

    public static CodeRule getByCode(String code) {
        if (StrUtil.isBlank((CharSequence)code) || !code.contains("\uff0d")) {
            return null;
        }
        String[] parts = code.split("\uff0d");
        if (parts.length < 6 || parts.length > 7) {
            return null;
        }
        CodeRule codeRule = new CodeRule();
        codeRule.setSubject(parts[0]);
        codeRule.setCourse(parts[1]);
        codeRule.setUnit(parts[2]);
        codeRule.setKnowledgePoint(parts[3]);
        codeRule.setQuType(parts[4]);
        codeRule.setDifficulty(parts[5]);
        if (parts.length == 7) {
            codeRule.setSerialNumber(parts[6]);
        }
        return codeRule;
    }

    public static String getRepoPathCode(String code) {
        if (StrUtil.isBlank((CharSequence)code) || !code.contains("\uff0d")) {
            return null;
        }
        String[] parts = code.split("\uff0d");
        if (4 >= parts.length) {
            return code;
        }
        return String.join((CharSequence)"\uff0d", Arrays.copyOfRange(parts, 0, 4));
    }

    public String getSubject() {
        return this.subject;
    }

    public String getCourse() {
        return this.course;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getKnowledgePoint() {
        return this.knowledgePoint;
    }

    public String getQuType() {
        return this.quType;
    }

    public String getDifficulty() {
        return this.difficulty;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setCourse(String course) {
        this.course = course;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setKnowledgePoint(String knowledgePoint) {
        this.knowledgePoint = knowledgePoint;
    }

    public void setQuType(String quType) {
        this.quType = quType;
    }

    public void setDifficulty(String difficulty) {
        this.difficulty = difficulty;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CodeRule)) {
            return false;
        }
        CodeRule other = (CodeRule)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$subject = this.getSubject();
        String other$subject = other.getSubject();
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        String this$course = this.getCourse();
        String other$course = other.getCourse();
        if (this$course == null ? other$course != null : !this$course.equals(other$course)) {
            return false;
        }
        String this$unit = this.getUnit();
        String other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
            return false;
        }
        String this$knowledgePoint = this.getKnowledgePoint();
        String other$knowledgePoint = other.getKnowledgePoint();
        if (this$knowledgePoint == null ? other$knowledgePoint != null : !this$knowledgePoint.equals(other$knowledgePoint)) {
            return false;
        }
        String this$quType = this.getQuType();
        String other$quType = other.getQuType();
        if (this$quType == null ? other$quType != null : !this$quType.equals(other$quType)) {
            return false;
        }
        String this$difficulty = this.getDifficulty();
        String other$difficulty = other.getDifficulty();
        if (this$difficulty == null ? other$difficulty != null : !this$difficulty.equals(other$difficulty)) {
            return false;
        }
        String this$serialNumber = this.getSerialNumber();
        String other$serialNumber = other.getSerialNumber();
        return !(this$serialNumber == null ? other$serialNumber != null : !this$serialNumber.equals(other$serialNumber));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CodeRule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $subject = this.getSubject();
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        String $course = this.getCourse();
        result = result * 59 + ($course == null ? 43 : $course.hashCode());
        String $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
        String $knowledgePoint = this.getKnowledgePoint();
        result = result * 59 + ($knowledgePoint == null ? 43 : $knowledgePoint.hashCode());
        String $quType = this.getQuType();
        result = result * 59 + ($quType == null ? 43 : $quType.hashCode());
        String $difficulty = this.getDifficulty();
        result = result * 59 + ($difficulty == null ? 43 : $difficulty.hashCode());
        String $serialNumber = this.getSerialNumber();
        result = result * 59 + ($serialNumber == null ? 43 : $serialNumber.hashCode());
        return result;
    }

    public String toString() {
        return "CodeRule(subject=" + this.getSubject() + ", course=" + this.getCourse() + ", unit=" + this.getUnit() + ", knowledgePoint=" + this.getKnowledgePoint() + ", quType=" + this.getQuType() + ", difficulty=" + this.getDifficulty() + ", serialNumber=" + this.getSerialNumber() + ")";
    }
}

