/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.zsy.exam.handler.ScanHandler;
import com.zsy.exam.handler.WeChatMpEventKeyHandler;
import com.zsy.exam.model.entity.ThirdConfig;
import com.zsy.exam.service.IThirdConfigService;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import me.chanjar.weixin.mp.api.WxMpMessageHandler;
import me.chanjar.weixin.mp.api.WxMpMessageRouter;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.impl.WxMpServiceImpl;
import me.chanjar.weixin.mp.bean.kefu.result.WxMpKfOnlineList;
import me.chanjar.weixin.mp.bean.message.WxMpXmlMessage;
import me.chanjar.weixin.mp.bean.message.WxMpXmlOutMessage;
import me.chanjar.weixin.mp.config.WxMpConfigStorage;
import me.chanjar.weixin.mp.config.impl.WxMpDefaultConfigImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class WeChatMpService
extends WxMpServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(WeChatMpService.class);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ConcurrentHashMap<String, WeChatMpEventKeyHandler> hashMap = new ConcurrentHashMap();
    @Autowired
    @Lazy
    protected ScanHandler scanHandler;
    private WxMpMessageRouter router;
    @Autowired
    private IThirdConfigService thirdConfigService;

    @PostConstruct
    public void init() {
        WxMpDefaultConfigImpl config = new WxMpDefaultConfigImpl();
        ThirdConfig wx = (ThirdConfig)this.thirdConfigService.getOne((Wrapper)new LambdaQueryWrapper().eq(ThirdConfig::getType, (Object)"WX"));
        if (null == wx) {
            log.info("\u83b7\u53d6\u5fae\u4fe1\u914d\u7f6e\u5931\u8d25");
            return;
        }
        String appid = wx.getAppId();
        String appsecret = wx.getAppSecret();
        config.setAppId(appid);
        config.setSecret(appsecret);
        config.setToken(wx.getToken());
        config.setAesKey(wx.getAesKey());
        super.setWxMpConfigStorage((WxMpConfigStorage)config);
        this.refreshRouter();
    }

    public void addHandler(String key, WeChatMpEventKeyHandler weChatMpEventKeyHandler) {
        this.hashMap.put(key, weChatMpEventKeyHandler);
    }

    public void removeHandler(String key) {
        this.hashMap.remove(key);
    }

    public WeChatMpEventKeyHandler getHandler(String sceneStr) {
        this.logger.info("key:" + sceneStr);
        this.randomRemoveExpiredHandler();
        WeChatMpEventKeyHandler weChatMpEventKeyHandler = (WeChatMpEventKeyHandler)this.hashMap.get(sceneStr);
        return weChatMpEventKeyHandler;
    }

    private void randomRemoveExpiredHandler() {
        if (new Random().nextInt(10) % 10 == 1) {
            ArrayList removeKes = new ArrayList();
            if (new Random().nextInt(10) % 10 == 1) {
                for (String string : this.hashMap.keySet()) {
                }
            }
            for (String removeKey : removeKes) {
                this.hashMap.remove(removeKey);
            }
        }
    }

    private void refreshRouter() {
        WxMpMessageRouter newRouter = new WxMpMessageRouter((WxMpService)this);
        newRouter.rule().async(false).msgType("event").event("SCAN").handler((WxMpMessageHandler)this.scanHandler).end();
        this.router = newRouter;
    }

    public WxMpXmlOutMessage route(WxMpXmlMessage message) {
        try {
            return this.router.route(message);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean hasKefuOnline() {
        try {
            WxMpKfOnlineList kfOnlineList = this.getKefuService().kfOnlineList();
            return kfOnlineList != null && kfOnlineList.getKfOnlineList().size() > 0;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u5ba2\u670d\u5728\u7ebf\u72b6\u6001\u5f02\u5e38: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

