/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.mapper.AddressChannelMapper;
import com.zsy.exam.model.entity.AddressChannel;
import com.zsy.exam.service.IAddressChannelService;
import com.zsy.exam.util.SecurityUtil;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AddressChannelServiceImpl
extends ServiceImpl<AddressChannelMapper, AddressChannel>
implements IAddressChannelService {
    @Autowired
    AddressChannelMapper addressChannelMapper;

    public AddressChannel getAddressChannel(Long id) {
        return (AddressChannel)this.addressChannelMapper.selectById((Serializable)id);
    }

    public Page<AddressChannel> getAllAddressChannel(Page page) {
        Long userId = SecurityUtil.getUserId();
        return (Page)this.addressChannelMapper.selectPage((IPage)page, (Wrapper)new LambdaQueryWrapper().eq(AddressChannel::getUserId, (Object)userId));
    }

    @Transactional(rollbackFor={Exception.class})
    public void add(AddressChannel addressChannel) {
        Long userId = SecurityUtil.getUserId();
        addressChannel.setUserId(userId);
        this.addressChannelMapper.insert((Object)addressChannel);
    }

    @Transactional(rollbackFor={Exception.class})
    public int modify(AddressChannel addressChannel) {
        return this.addressChannelMapper.updateById((Object)addressChannel);
    }

    @Transactional(rollbackFor={Exception.class})
    public void remove(String ids) {
        String[] array;
        if (StringUtils.isNotEmpty((CharSequence)ids) && !CollectionUtils.isEmpty(Arrays.asList(array = ids.split(",")))) {
            this.addressChannelMapper.deleteBatchIds(Arrays.asList(array));
        }
    }
}

