/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.mapper.AnalysisExamMapper;
import com.zsy.exam.mapper.ClbumMapper;
import com.zsy.exam.mapper.ExamAreaDetailMapper;
import com.zsy.exam.mapper.UserExamsScoreMapper;
import com.zsy.exam.model.entity.ExamAreaDetail;
import com.zsy.exam.model.entity.UserExamsScore;
import com.zsy.exam.model.vo.analysis.AnalysisClbumDetailVO;
import com.zsy.exam.model.vo.analysis.AnalysisClbumVO;
import com.zsy.exam.model.vo.analysis.AnalysisExamClbumVO;
import com.zsy.exam.model.vo.analysis.AnalysisExamPointVO;
import com.zsy.exam.model.vo.analysis.AnalysisExamQuestionDetailVO;
import com.zsy.exam.model.vo.analysis.AnalysisExamQuestionVO;
import com.zsy.exam.model.vo.analysis.AnalysisExamVO;
import com.zsy.exam.model.vo.analysis.AnalysisGradeVO;
import com.zsy.exam.model.vo.analysis.AnalysisSpecTotalVO;
import com.zsy.exam.model.vo.analysis.AnalysisSpecVO;
import com.zsy.exam.service.IAnalysisExamService;
import jakarta.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class AnalysisExamServiceImpl
implements IAnalysisExamService {
    @Resource
    private AnalysisExamMapper analysisExamMapper;
    @Resource
    private UserExamsScoreMapper userExamsScoreMapper;
    @Resource
    private ExamAreaDetailMapper examAreaDetailMapper;
    @Resource
    private ClbumMapper clbumMapper;

    public AnalysisExamVO getAnalysisExamSubject(Long examId) {
        AnalysisExamVO vo = new AnalysisExamVO();
        String subjectName = this.analysisExamMapper.getSubjectName(examId);
        vo.setSubjectName(subjectName);
        List analysisExamKnowledgeVO = this.analysisExamMapper.getAnalysisExamKnowledgeVO(examId);
        vo.setAnalysisExamKnowledgeVOS(analysisExamKnowledgeVO);
        List analysisExamQuestionDetailVO = this.analysisExamMapper.getAnalysisExamQuestionDetailVO(examId);
        ArrayList<AnalysisExamQuestionVO> questionVOS = new ArrayList<AnalysisExamQuestionVO>();
        if (CollectionUtils.isNotEmpty((Collection)analysisExamQuestionDetailVO)) {
            Map firstMap = analysisExamQuestionDetailVO.stream().collect(Collectors.groupingBy(AnalysisExamQuestionDetailVO::getQuestionTopicName, LinkedHashMap::new, Collectors.toList()));
            for (Map.Entry entry : firstMap.entrySet()) {
                AnalysisExamQuestionVO questionVO = new AnalysisExamQuestionVO();
                questionVO.setQuestionTopicName((String)entry.getKey());
                questionVO.setQuestionDetails((List)entry.getValue());
                questionVOS.add(questionVO);
            }
        }
        vo.setAnalysisExamQuestionVOS(questionVOS);
        List analysisExamStudentVO = this.analysisExamMapper.getAnalysisExamStudentVO(examId);
        vo.setAnalysisExamStudentVOS(analysisExamStudentVO);
        AnalysisExamPointVO analysisExamPointVO = this.analysisExamMapper.getAnalysisExamPointVO(examId);
        List userExamsScores = this.userExamsScoreMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UserExamsScore::getExamId, (Object)examId)).eq(UserExamsScore::getIsAttend, (Object)1));
        if (CollectionUtils.isNotEmpty((Collection)userExamsScores)) {
            List avgCount = userExamsScores.stream().filter(score -> score.getUserScore().compareTo(analysisExamPointVO.getAvgPoint()) >= 0).collect(Collectors.toList());
            List score90 = userExamsScores.stream().filter(score -> score.getUserScore().compareTo(analysisExamPointVO.getPaperTotalPoint().multiply(new BigDecimal(0.9)).setScale(2, RoundingMode.HALF_UP)) >= 0).collect(Collectors.toList());
            List score60 = userExamsScores.stream().filter(score -> score.getUserScore().compareTo(analysisExamPointVO.getPaperTotalPoint().multiply(new BigDecimal(0.6)).setScale(2, RoundingMode.HALF_UP)) >= 0).collect(Collectors.toList());
            List score40 = userExamsScores.stream().filter(score -> score.getUserScore().compareTo(analysisExamPointVO.getPaperTotalPoint().multiply(new BigDecimal(0.4)).setScale(2, RoundingMode.HALF_UP)) < 0).collect(Collectors.toList());
            analysisExamPointVO.setAvgRatio(new BigDecimal(avgCount.size()).divide(new BigDecimal(userExamsScores.size()), 2, RoundingMode.HALF_UP));
            analysisExamPointVO.setExcellentRatio(new BigDecimal(score90.size()).divide(new BigDecimal(userExamsScores.size()), 2, RoundingMode.HALF_UP));
            analysisExamPointVO.setPassRatio(new BigDecimal(score60.size()).divide(new BigDecimal(userExamsScores.size()), 2, RoundingMode.HALF_UP));
            analysisExamPointVO.setPoorRatio(new BigDecimal(score40.size()).divide(new BigDecimal(userExamsScores.size()), 2, RoundingMode.HALF_UP));
        }
        vo.setAnalysisExamPointVOS(analysisExamPointVO);
        return vo;
    }

    public AnalysisSpecVO getAnalysisExamSpec(Long examId) {
        AnalysisSpecVO vo = new AnalysisSpecVO();
        String subjectName = this.analysisExamMapper.getSubjectName(examId);
        vo.setSubjectName(subjectName);
        List examAreaDetails = this.examAreaDetailMapper.getByExamId(examId);
        if (CollectionUtils.isEmpty((Collection)examAreaDetails)) {
            throw new AppException("\u8bf7\u5148\u914d\u7f6e\u7edf\u8003\u8fbe\u6807\u7b49\u7ea7\u4fe1\u606f");
        }
        List analysisExamKnowledgeVO = this.analysisExamMapper.getAnalysisExamKnowledgeVO(examId);
        vo.setAnalysisExamKnowledgeVOS(analysisExamKnowledgeVO);
        List analysisExamQuestionDetailVO = this.analysisExamMapper.getAnalysisExamQuestionDetailVO(examId);
        ArrayList<AnalysisExamQuestionVO> questionVOS = new ArrayList<AnalysisExamQuestionVO>();
        if (CollectionUtils.isNotEmpty((Collection)analysisExamQuestionDetailVO)) {
            Map firstMap = analysisExamQuestionDetailVO.stream().collect(Collectors.groupingBy(AnalysisExamQuestionDetailVO::getQuestionTopicName, LinkedHashMap::new, Collectors.toList()));
            for (Map.Entry entry : firstMap.entrySet()) {
                AnalysisExamQuestionVO questionVO = new AnalysisExamQuestionVO();
                questionVO.setQuestionTopicName((String)entry.getKey());
                questionVO.setQuestionDetails((List)entry.getValue());
                questionVOS.add(questionVO);
            }
        }
        vo.setAnalysisExamQuestionVOS(questionVOS);
        ExamAreaDetail examAreaDetailAB = examAreaDetails.stream().filter(item -> "B".equals(item.getLevel())).findFirst().get();
        List analysisExamClbumVOS = this.analysisExamMapper.getAnalysisExamClbumVO(examId, new BigDecimal(examAreaDetailAB.getStartPoint()).divide(new BigDecimal(100)));
        AnalysisSpecTotalVO analysisExamTotal = this.analysisExamMapper.getAnalysisExamTotal(examId, new BigDecimal(examAreaDetailAB.getStartPoint()).divide(new BigDecimal(100)));
        BigDecimal totalAvgPoint = analysisExamTotal.getTotalClubmPoint();
        BigDecimal totalPassRange = analysisExamTotal.getTotalPassRange();
        BigDecimal totalExcellentRange = analysisExamTotal.getTotalExcellentRange();
        for (AnalysisExamClbumVO analysisExamClbumVO : analysisExamClbumVOS) {
            analysisExamClbumVO.setGradeRange(analysisExamClbumVO.getAvgPoint().subtract(totalAvgPoint));
            analysisExamClbumVO.setPassRange(analysisExamClbumVO.getPassScale().subtract(totalPassRange));
            analysisExamClbumVO.setExcellentRange(analysisExamClbumVO.getExcellentScale().subtract(totalExcellentRange));
        }
        vo.setAnalysisExamClbumVOS(analysisExamClbumVOS);
        return vo;
    }

    public List<AnalysisGradeVO> getGradeDetail(Long examAreaId) {
        List examAreaDetails = this.examAreaDetailMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(ExamAreaDetail::getExamAreaId, (Object)examAreaId));
        if (CollectionUtils.isEmpty((Collection)examAreaDetails)) {
            throw new AppException("\u8bf7\u5148\u914d\u7f6e\u7edf\u8003\u8fbe\u6807\u7b49\u7ea7\u4fe1\u606f");
        }
        ExamAreaDetail examAreaDetailA = examAreaDetails.stream().filter(item -> "A".equals(item.getLevel())).findFirst().get();
        ExamAreaDetail examAreaDetailAB = examAreaDetails.stream().filter(item -> "B".equals(item.getLevel())).findFirst().get();
        List analysisGradeVO = this.analysisExamMapper.getAnalysisGradeVO(examAreaId, new BigDecimal(examAreaDetailA.getStartPoint()).divide(new BigDecimal(100)), new BigDecimal(examAreaDetailAB.getStartPoint()).divide(new BigDecimal(100)));
        return analysisGradeVO;
    }

    public List<AnalysisClbumVO> getClbumDetail(Long examAreaId, Long clbumId) {
        List examAreaDetails = this.examAreaDetailMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(ExamAreaDetail::getExamAreaId, (Object)examAreaId));
        if (CollectionUtils.isEmpty((Collection)examAreaDetails)) {
            throw new AppException("\u8bf7\u5148\u914d\u7f6e\u7edf\u8003\u8fbe\u6807\u7b49\u7ea7\u4fe1\u606f");
        }
        ExamAreaDetail examAreaDetailA = examAreaDetails.stream().filter(item -> "A".equals(item.getLevel())).findFirst().get();
        ExamAreaDetail examAreaDetailB = examAreaDetails.stream().filter(item -> "B".equals(item.getLevel())).findFirst().get();
        ExamAreaDetail examAreaDetailC = examAreaDetails.stream().filter(item -> "C".equals(item.getLevel())).findFirst().get();
        List analysisClbumVO = this.analysisExamMapper.getAnalysisClbumVO(examAreaId, clbumId, new BigDecimal(examAreaDetailA.getStartPoint()).divide(new BigDecimal(100)), new BigDecimal(examAreaDetailB.getStartPoint()).divide(new BigDecimal(100)), new BigDecimal(examAreaDetailC.getStartPoint()).divide(new BigDecimal(100)), new BigDecimal(examAreaDetailC.getCriticalUpperLimit()).divide(new BigDecimal(100)), new BigDecimal(examAreaDetailC.getCriticalLowerLimit()).divide(new BigDecimal(100)));
        for (AnalysisClbumVO vo : analysisClbumVO) {
            String subjectCode = vo.getSubjectCode();
            List subjectList = analysisClbumVO.stream().filter(item -> item.getSubjectCode().equals(subjectCode)).collect(Collectors.toList());
            AnalysisSpecTotalVO analysisAreaTotal = this.analysisExamMapper.getAnalysisAreaTotal(examAreaId, subjectCode, new BigDecimal(examAreaDetailB.getStartPoint()).divide(new BigDecimal(100)));
            double sumClbumAll = subjectList.stream().map(AnalysisClbumVO::getClbumAvgPoint).mapToDouble(BigDecimal::doubleValue).sum();
            double sumPassClbumAll = subjectList.stream().map(AnalysisClbumVO::getClbumPassScale).mapToDouble(BigDecimal::doubleValue).sum();
            double sumExcellentClbumAll = subjectList.stream().map(AnalysisClbumVO::getABExcellentScale).mapToDouble(BigDecimal::doubleValue).sum();
            BigDecimal avgRange = new BigDecimal(sumClbumAll).divide(new BigDecimal(subjectList.size()), 2, RoundingMode.HALF_UP).subtract(analysisAreaTotal.getTotalClubmPoint());
            BigDecimal passRange = new BigDecimal(sumPassClbumAll).divide(new BigDecimal(subjectList.size()), 2, RoundingMode.HALF_UP).subtract(analysisAreaTotal.getTotalPassRange());
            BigDecimal excellentRange = new BigDecimal(sumExcellentClbumAll).divide(new BigDecimal(subjectList.size()), 2, RoundingMode.HALF_UP).subtract(analysisAreaTotal.getTotalExcellentRange());
            vo.setGradeRange(avgRange);
            vo.setPassRange(passRange);
            vo.setExcellentRange(excellentRange);
            String teacherName = this.clbumMapper.getTeacherNameByClbum(vo.getClbumId());
            vo.setClbumTeacherName(teacherName);
        }
        return analysisClbumVO;
    }

    public List<AnalysisClbumDetailVO> getClbumStudentDetail(Long examAreaId, Long clbumId) {
        List examAreaDetails = this.examAreaDetailMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(ExamAreaDetail::getExamAreaId, (Object)examAreaId));
        if (CollectionUtils.isEmpty((Collection)examAreaDetails)) {
            throw new AppException("\u8bf7\u5148\u914d\u7f6e\u7edf\u8003\u8fbe\u6807\u7b49\u7ea7\u4fe1\u606f");
        }
        ExamAreaDetail examAreaDetailA = examAreaDetails.stream().filter(item -> "A".equals(item.getLevel())).findFirst().get();
        ExamAreaDetail examAreaDetailB = examAreaDetails.stream().filter(item -> "B".equals(item.getLevel())).findFirst().get();
        ExamAreaDetail examAreaDetailC = examAreaDetails.stream().filter(item -> "C".equals(item.getLevel())).findFirst().get();
        List analysisStudentClbumVO = this.analysisExamMapper.getAnalysisStudentClbumVO(examAreaId, clbumId);
        if (CollectionUtils.isEmpty((Collection)analysisStudentClbumVO)) {
            return analysisStudentClbumVO;
        }
        for (AnalysisClbumDetailVO detailVO : analysisStudentClbumVO) {
            List analysisStudentClbumDetailVO = this.analysisExamMapper.getAnalysisStudentClbumDetailVO(examAreaId, clbumId, detailVO.getUserId(), new BigDecimal(examAreaDetailA.getStartPoint()).divide(new BigDecimal(100)), new BigDecimal(examAreaDetailB.getStartPoint()).divide(new BigDecimal(100)), new BigDecimal(examAreaDetailC.getStartPoint()).divide(new BigDecimal(100)));
            detailVO.setStudentDetails(analysisStudentClbumDetailVO);
        }
        return analysisStudentClbumVO;
    }
}

