/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import com.wf.captcha.ArithmeticCaptcha;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.constant.RoleEnum;
import com.zsy.exam.constant.SysParamEnum;
import com.zsy.exam.converter.UserConverter;
import com.zsy.exam.mapper.LoginLogMapper;
import com.zsy.exam.mapper.RoleMapper;
import com.zsy.exam.mapper.UserDailyLoginDurationMapper;
import com.zsy.exam.mapper.UserMapper;
import com.zsy.exam.model.entity.LoginLog;
import com.zsy.exam.model.entity.School;
import com.zsy.exam.model.entity.SysParam;
import com.zsy.exam.model.entity.User;
import com.zsy.exam.model.form.Auth.LoginForm;
import com.zsy.exam.model.form.UserForm;
import com.zsy.exam.security.SysUserDetails;
import com.zsy.exam.service.IAuthService;
import com.zsy.exam.service.ISchoolService;
import com.zsy.exam.service.ISysParamService;
import com.zsy.exam.util.IpUtils;
import com.zsy.exam.util.JwtUtil;
import com.zsy.exam.util.SecretUtils;
import com.zsy.exam.util.SecurityUtil;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.Serializable;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.stereotype.Service;

@Service
public class AuthServiceImpl
implements IAuthService {
    private static final Logger log = LoggerFactory.getLogger(AuthServiceImpl.class);
    private static final String HEARTBEAT_KEY_PREFIX = "user:heartbeat:";
    private static final long HEARTBEAT_INTERVAL_MILLIS = 600000L;
    public static final String CONCURRENT_LOGIN_REDIS_KEY = "CONCURRENT_LOGIN_";
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private UserMapper userMapper;
    @Resource
    private RoleMapper roleMapper;
    @Resource
    private UserConverter userConverter;
    @Resource
    private ObjectMapper objectMapper;
    @Resource
    private JwtUtil jwtUtil;
    @Resource
    private UserDailyLoginDurationMapper userDailyLoginDurationMapper;
    @Resource
    private LoginLogMapper loginLogMapper;
    @Resource
    private ISchoolService schoolService;
    @Resource
    private ISysParamService sysParamService;
    public static final String loginTypeWechat = "wechat";
    public static final String loginTypePWD = "pwd";
    public static ThreadPoolExecutor executor = new ThreadPoolExecutor(10, 20, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());

    public Result<Map> login(HttpServletRequest request, HttpServletResponse response, LoginForm loginForm) {
        long days;
        BCryptPasswordEncoder encoder;
        String s = (String)this.stringRedisTemplate.opsForValue().get((Object)("isVerifyCode" + request.getSession().getId()));
        if (StringUtils.isBlank((CharSequence)s)) {
            return Result.failed((String)"\u8bf7\u5148\u83b7\u53d6\u9a8c\u8bc1\u7801");
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(User::getUserName, (Object)loginForm.getUsername())).eq(User::getIsDeleted, (Object)0)).and(wp -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wp.isNull(User::getEffectiveTime)).or()).gt(User::getEffectiveTime, (Object)new Date()));
        User user = (User)this.userMapper.selectOne((Wrapper)wrapper);
        String lType = loginForm.getType();
        if (StringUtils.isNotBlank((CharSequence)lType) && StringUtils.equals((CharSequence)lType, (CharSequence)loginTypeWechat)) {
            user = this.getWechatAuthentication(request, response);
        }
        if (Objects.isNull(user)) {
            throw new UsernameNotFoundException("\u8be5\u7528\u6237\u8d26\u53f7\u5230\u671f,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (Integer.valueOf(0).equals(user.getStatus())) {
            throw new UsernameNotFoundException("\u8be5\u7528\u6237\u8d26\u53f7\u7981\u7528,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (RoleEnum.TEACHER.getId().equals(user.getRoleId()) && !RoleEnum.TEACHER.getId().equals(loginForm.getUserType())) {
            throw new UsernameNotFoundException("\u5f53\u524d\u7528\u6237\u8bf7\u767b\u5f55\u6559\u5e08\u7aef");
        }
        if (RoleEnum.ADMIN.getId().equals(user.getRoleId()) && !RoleEnum.TEACHER.getId().equals(loginForm.getUserType())) {
            throw new UsernameNotFoundException("\u5f53\u524d\u7528\u6237\u8bf7\u767b\u5f55\u6559\u5e08\u7aef");
        }
        if (RoleEnum.STUDENT.getId().equals(user.getRoleId()) && !RoleEnum.STUDENT.getId().equals(loginForm.getUserType())) {
            throw new UsernameNotFoundException("\u5f53\u524d\u7528\u6237\u8bf7\u767b\u5f55\u5b66\u751f\u7aef");
        }
        if (null != user.getSchoolId() && !RoleEnum.SUPER_ADMIN.getId().equals(user.getRoleId())) {
            School school = (School)this.schoolService.getById((Serializable)user.getSchoolId());
            if (Integer.valueOf(0).equals(school.getStatus()) || System.currentTimeMillis() > school.getEffectiveTime().getTime()) {
                throw new AppException("\u8be5\u5b66\u6821\u4f7f\u7528\u65f6\u95f4\u5230\u671f\u6216\u8005\u5df2\u7981\u7528");
            }
        }
        if ((StringUtils.isBlank((CharSequence)lType) || StringUtils.equals((CharSequence)lType, (CharSequence)loginTypePWD)) && !(encoder = new BCryptPasswordEncoder()).matches((CharSequence)SecretUtils.desEncrypt((String)loginForm.getPassword()), user.getPassword())) {
            this.saveLog(request, null, loginForm.getUsername(), null, Integer.valueOf(0), "\u5bc6\u7801\u9519\u8bef", null);
            return Result.failed((String)"\u8be5\u7528\u6237\u8d26\u53f7/\u5bc6\u7801\u9519\u8bef");
        }
        Boolean isResertPassword = false;
        SysParam passwordEffectiveDays = this.sysParamService.getByType(SysParamEnum.PASSWORD_EFFECTIVE_DAYS.getType());
        if (null != passwordEffectiveDays && (days = DateUtil.betweenDay((Date)Date.from(user.getLastChangePasswordTime().atZone(ZoneId.systemDefault()).toInstant()), (Date)new Date(), (boolean)false)) > Long.valueOf(passwordEffectiveDays.getValue())) {
            isResertPassword = true;
        }
        user.setPassword(null);
        List permissions = this.roleMapper.selectCodeByUserId(user.getId());
        if (CollectionUtils.isEmpty((Collection)permissions)) {
            return Result.failed((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u89d2\u8272\u540e\u518d\u767b\u5f55");
        }
        List<SimpleGrantedAuthority> userPermissions = permissions.stream().map(permission -> new SimpleGrantedAuthority(permission)).toList();
        SysUserDetails sysUserDetails = new SysUserDetails(user);
        sysUserDetails.setPermissions(userPermissions);
        String userInfo = this.objectMapper.writeValueAsString((Object)user);
        String token = this.jwtUtil.createJwt(userInfo, userPermissions.stream().map(String::valueOf).toList());
        this.stringRedisTemplate.opsForValue().set((Object)("token" + request.getSession().getId()), (Object)token, 24L, TimeUnit.HOURS);
        this.stringRedisTemplate.opsForValue().set((Object)(CONCURRENT_LOGIN_REDIS_KEY + user.getId()), (Object)request.getSession().getId(), 24L, TimeUnit.HOURS);
        UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new UsernamePasswordAuthenticationToken((Object)sysUserDetails, (Object)user.getPassword(), userPermissions);
        usernamePasswordAuthenticationToken.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(request));
        SecurityContextHolder.getContext().setAuthentication((Authentication)usernamePasswordAuthenticationToken);
        if (CollectionUtils.isNotEmpty((Collection)permissions)) {
            for (String roleCode : permissions) {
                List menuPermissions;
                Map entries = this.stringRedisTemplate.opsForHash().entries((Object)roleCode);
                if (null != entries && !entries.isEmpty()) {
                    this.deleteRedisHashKey(roleCode);
                }
                if (CollectionUtils.isEmpty((Collection)(menuPermissions = this.roleMapper.selectPermissionByRoleCode(roleCode)))) continue;
                Map collect = menuPermissions.stream().collect(HashMap::new, (m, o) -> m.put(o.getId().toString(), o.getPermission()), HashMap::putAll);
                this.stringRedisTemplate.opsForHash().putAll((Object)roleCode, collect);
                this.stringRedisTemplate.expire((Object)roleCode, 1L, TimeUnit.DAYS);
            }
        }
        this.stringRedisTemplate.delete((Object)("isVerifyCode" + request.getSession().getId()));
        this.saveLog(request, user.getId(), user.getUserName(), user.getRealName(), Integer.valueOf(1), null, userPermissions.get(0).toString());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("token", token);
        map.put("isReset", isResertPassword);
        return Result.success(map);
    }

    private User getWechatAuthentication(HttpServletRequest request, HttpServletResponse response) {
        String openId = request.getParameter("openId");
        String sceneStr = request.getParameter("sceneStr");
        if (StringUtils.isBlank((CharSequence)openId) || StringUtils.isBlank((CharSequence)sceneStr)) {
            throw new AppException("openId\u6216\u573a\u666f\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!this.stringRedisTemplate.hasKey((Object)sceneStr).booleanValue() || StringUtils.isBlank((CharSequence)((CharSequence)this.stringRedisTemplate.opsForValue().get((Object)sceneStr)))) {
            throw new AppException("\u626b\u7801\u767b\u5f55\u5df2\u8fc7\u671f,\u8bf7\u5237\u65b0\u4e8c\u7ef4\u7801\u540e\u91cd\u65b0\u767b\u5f55!");
        }
        User user = (User)this.userMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(User::getWechatOpenId, (Object)openId)).eq(User::getIsDeleted, (Object)false));
        if (null == user) {
            throw new AppException("\u5fae\u4fe1\u672a\u7ed1\u5b9a\uff0c\u8bf7\u5148\u7ed1\u5b9a");
        }
        this.stringRedisTemplate.delete((Object)sceneStr);
        return user;
    }

    public Result<String> logout(HttpServletRequest request) {
        Long userId;
        HttpSession session = request.getSession(false);
        if (session != null) {
            this.stringRedisTemplate.delete((Object)("token" + session.getId()));
            session.invalidate();
        }
        if (null != (userId = SecurityUtil.getUserId())) {
            this.stringRedisTemplate.delete((Object)(CONCURRENT_LOGIN_REDIS_KEY + userId));
        }
        return Result.success((String)"\u9000\u51fa\u6210\u529f");
    }

    public Result getCaptcha(HttpServletRequest request, HttpServletResponse response) {
        ArithmeticCaptcha captcha = new ArithmeticCaptcha(150, 50, 2);
        String code = captcha.text();
        String key = "code" + request.getSession().getId();
        this.stringRedisTemplate.opsForValue().set((Object)key, (Object)code, 120L, TimeUnit.SECONDS);
        log.info("\u9a8c\u8bc1\u7801\u56fe\u7247\uff1akey={},code={}", (Object)key, (Object)code);
        HashMap map = Maps.newHashMap();
        map.put("image", captcha.toBase64());
        return Result.ok((Object)map);
    }

    public Result<String> verifyCode(HttpServletRequest request, String code) {
        String key = "code" + request.getSession().getId();
        String rightCode = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
        if (StringUtils.isBlank((CharSequence)rightCode)) {
            return Result.failed((String)"\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f");
        }
        if (!rightCode.equalsIgnoreCase(code)) {
            return Result.failed((String)"\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        this.stringRedisTemplate.delete((Object)key);
        this.stringRedisTemplate.opsForValue().set((Object)("isVerifyCode" + request.getSession().getId()), (Object)"1", 5L, TimeUnit.MINUTES);
        return Result.success((String)"\u9a8c\u8bc1\u7801\u6821\u9a8c\u6210\u529f");
    }

    public Result<String> register(HttpServletRequest request, UserForm userForm) {
        String s = (String)this.stringRedisTemplate.opsForValue().get((Object)("isVerifyCode" + request.getSession().getId()));
        if (StringUtils.isBlank((CharSequence)s)) {
            return Result.failed((String)"\u8bf7\u5148\u9a8c\u8bc1\u9a8c\u8bc1\u7801");
        }
        if (!SecretUtils.desEncrypt((String)userForm.getPassword()).equals(SecretUtils.desEncrypt((String)userForm.getCheckedPassword()))) {
            return Result.failed((String)"\u4e24\u6b21\u5bc6\u7801\u4e0d\u4e00\u81f4");
        }
        User user = this.userConverter.fromToEntity(userForm);
        user.setPassword(new BCryptPasswordEncoder().encode((CharSequence)SecretUtils.desEncrypt((String)user.getPassword())));
        user.setRoleId(Long.valueOf(1L));
        this.userMapper.insert((Object)user);
        this.stringRedisTemplate.delete((Object)("isVerifyCode" + request.getSession().getId()));
        return Result.success((String)"\u6ce8\u518c\u6210\u529f");
    }

    private void saveLog(HttpServletRequest request, Long userId, String username, String name, Integer isSuccess, String reason, String roleName) {
        LoginLog loginLog = new LoginLog();
        loginLog.setUserId(userId);
        loginLog.setUserName(username);
        loginLog.setLoginRole(roleName);
        loginLog.setIsSuccess(isSuccess);
        loginLog.setName(name);
        loginLog.setLoginFailReason(reason);
        loginLog.setIpAddr(IpUtils.getIpAddr((HttpServletRequest)request));
        this.loginLogMapper.insert((Object)loginLog);
    }

    private static void writeResp(HttpServletResponse response, String msg) {
        try {
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/json");
            response.setStatus(403);
            response.getWriter().write(JSONUtil.toJsonStr((Object)Result.failed((String)msg)));
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
    }

    private void deleteRedisHashKey(String key) {
        HashOperations hashOperations = this.stringRedisTemplate.opsForHash();
        Set sets = hashOperations.keys((Object)key);
        if (CollectionUtils.isNotEmpty((Collection)sets)) {
            hashOperations.delete((Object)key, sets.toArray());
        }
    }
}

