/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.constant.RoleEnum;
import com.zsy.exam.mapper.CatalogueMapper;
import com.zsy.exam.model.dto.CatalogueExcelDTO;
import com.zsy.exam.model.entity.Catalogue;
import com.zsy.exam.model.entity.Question;
import com.zsy.exam.model.entity.Subject;
import com.zsy.exam.model.vo.CatalogueSimpleVO;
import com.zsy.exam.model.vo.catalog.CatalogueTreeVo;
import com.zsy.exam.model.vo.kp.KnowledgePointsTreeDetailVO;
import com.zsy.exam.model.vo.kp.KwQuTypeDetailVO;
import com.zsy.exam.service.ICatalogueService;
import com.zsy.exam.service.IQuestionService;
import com.zsy.exam.service.IRoleService;
import com.zsy.exam.service.ISubjectService;
import com.zsy.exam.util.SecurityUtil;
import com.zsy.exam.util.excel.ExcelUtils;
import com.zsy.exam.util.tree.TreeNodeBuilder;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CatalogueServiceImpl
extends ServiceImpl<CatalogueMapper, Catalogue>
implements ICatalogueService {
    @Autowired
    private CatalogueMapper catalogueMapper;
    @Resource
    @Lazy
    private IQuestionService questionService;
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private IRoleService roleService;
    @Resource
    private ISubjectService subjectService;
    public static String REDIS_CATALOGUE_NAME = "catalogue_all_path_name_";

    public List<CatalogueTreeVo> getTree(String type, String pathCode, Boolean demo) {
        List subjectCodes = null;
        List subjectList = this.subjectService.list();
        List<String> allSubjectCodes = subjectList.stream().map(Subject::getCode).toList();
        List roles = this.roleService.getCurrentRoles();
        if (roles.contains(RoleEnum.TEACHER.getCode())) {
            subjectCodes = SecurityUtil.getSubjectCode();
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(Catalogue::getType, (Object)type);
        if (demo == null || !demo.booleanValue()) {
            wrapper.in(CollectionUtils.isNotEmpty((Collection)subjectCodes), Catalogue::getSubjectCode, (Collection)subjectCodes);
        }
        wrapper.in(Catalogue::getSubjectCode, allSubjectCodes);
        if (StringUtils.isNotBlank((CharSequence)pathCode)) {
            wrapper.last(" and FIND_IN_SET('" + pathCode + "',REPLACE(path_code,'\uff0d',',')) >0");
        }
        List list = this.list((Wrapper)wrapper);
        List listVo = list.parallelStream().map(db -> {
            CatalogueTreeVo vo = new CatalogueTreeVo();
            vo.setId("" + db.getId());
            vo.setPId("" + db.getPId());
            vo.setType(db.getType());
            vo.setName(db.getName());
            vo.setCode(db.getCode());
            vo.setSubjectCode(db.getSubjectCode());
            vo.setLevel(db.getLevel());
            vo.setPath(db.getPath());
            return vo;
        }).collect(Collectors.toList());
        List catalogueTreeVos = TreeNodeBuilder.assembleTree(listVo);
        return catalogueTreeVos;
    }

    public Catalogue getCatalogue(Long id) {
        return (Catalogue)this.catalogueMapper.selectById((Serializable)id);
    }

    public List<Catalogue> getListByPathCode(String pathCode) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(Catalogue::getPathCode, (Object)pathCode);
        return this.list((Wrapper)qw);
    }

    public List<Catalogue> getAllCatalogue() {
        return this.catalogueMapper.selectList(null);
    }

    public List<Catalogue> getBySubject(List<String> subjectList) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        if (CollUtil.isEmpty(subjectList)) {
            return new ArrayList<Catalogue>();
        }
        qw.in(Catalogue::getSubjectCode, subjectList);
        return this.catalogueMapper.selectList((Wrapper)qw);
    }

    public void add(Catalogue catalogue, Boolean isWeb) {
        StringBuffer pathBuffer = new StringBuffer();
        StringBuffer pathCodeBuffer = new StringBuffer();
        Long pId = catalogue.getPId();
        if (null == pId || 0L == pId) {
            if (isWeb.booleanValue()) {
                throw new AppException("\u4e0d\u5141\u8bb8\u589e\u52a0\u5b66\u79d1\u5206\u7c7b\uff0c\u8bf7\u5230\u5b66\u79d1\u7ba1\u7406\u4e2d\u6dfb\u52a0");
            }
            catalogue.setSubjectCode(catalogue.getCode());
            catalogue.setLevel(Integer.valueOf(1));
            catalogue.setSort(Integer.valueOf(1));
        } else {
            Catalogue fCatalogue = (Catalogue)this.getById((Serializable)pId);
            if (null == fCatalogue) {
                throw new AppException("\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u7684\u7236\u8282\u70b9\u5c42\u7ea7");
            }
            pathBuffer.append(fCatalogue.getPath());
            pathCodeBuffer.append(fCatalogue.getPathCode()).append("\uff0d");
            catalogue.setPath(pathBuffer.toString());
            catalogue.setLevel(Integer.valueOf(fCatalogue.getLevel() + 1));
            catalogue.setSubjectCode(fCatalogue.getSubjectCode());
            if (catalogue.getType().equals("repo") && catalogue.getLevel() > 4) {
                throw new AppException("\u77e5\u8bc6\u70b9\u540e\u65e0\u6cd5\u518d\u589e\u52a0\u5c42\u7ea7");
            }
        }
        pathCodeBuffer.append(catalogue.getCode());
        catalogue.setPathCode(pathCodeBuffer.toString());
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(Catalogue::getPathCode, (Object)catalogue.getPathCode());
        if (CollUtil.isNotEmpty((Collection)this.list((Wrapper)qw))) {
            throw new AppException("\u8be5\u5206\u7c7b\u7684\u7f16\u7801\u91cd\u590d,\u8bf7\u4fee\u6539\u540e\u518d\u5f55\u5165");
        }
        catalogue.setCreatorId(SecurityUtil.getUserId());
        this.save((Object)catalogue);
        Long id = catalogue.getId();
        Catalogue db = (Catalogue)this.getById((Serializable)id);
        pathBuffer.append(id).append("/");
        db.setPath(pathBuffer.toString());
        this.updateById((Object)db);
    }

    @Transactional(rollbackFor={Exception.class})
    public int modify(Catalogue catalogue) {
        List questions;
        List sonIdList;
        Catalogue db = (Catalogue)this.getById((Serializable)catalogue.getId());
        String oldCode = db.getCode();
        String newCode = catalogue.getCode();
        String oldPathCode = db.getPathCode();
        Boolean isChangeCode = !oldCode.equals(newCode);
        db.setName(catalogue.getName());
        db.setCode(newCode);
        List sonDbList = ((CatalogueMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(Catalogue::getPathCode, (Object)oldPathCode)).ne(Catalogue::getId, (Object)catalogue.getId()));
        if (isChangeCode.booleanValue() && CollUtil.isNotEmpty(sonIdList = sonDbList.stream().map(Catalogue::getId).collect(Collectors.toList())) && CollUtil.isNotEmpty((Collection)(questions = this.questionService.list((Wrapper)new LambdaQueryWrapper().in(Question::getRepoId, sonIdList))))) {
            throw new AppException("\u5f53\u524d\u76ee\u5f55\u6709\u5173\u8054\u7684\u8bd5\u9898,\u4e0d\u80fd\u4fee\u6539");
        }
        Long pId = db.getPId();
        StringBuffer pathCodeBuffer = new StringBuffer();
        if (null != pId && pId > 0L) {
            Catalogue fCatalogue = (Catalogue)this.getById((Serializable)pId);
            pathCodeBuffer.append(fCatalogue.getPathCode()).append("\uff0d");
        }
        pathCodeBuffer.append(newCode);
        db.setPathCode(pathCodeBuffer.toString());
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)qw.eq(Catalogue::getCode, (Object)newCode)).eq(null != pId, Catalogue::getPId, (Object)pId)).ne(null != catalogue.getId(), Catalogue::getId, (Object)catalogue.getId());
        if (CollUtil.isNotEmpty((Collection)this.list((Wrapper)qw))) {
            throw new AppException("\u8be5\u5206\u7c7b\u7684\u7f16\u7801\u91cd\u590d,\u8bf7\u4fee\u6539\u540e\u518d\u5f55\u5165");
        }
        if (isChangeCode.booleanValue() && CollUtil.isNotEmpty((Collection)sonDbList)) {
            sonDbList.forEach(sonDb -> {
                String pathCode = sonDb.getPathCode();
                sonDb.setPathCode(pathCode.replace(oldPathCode, db.getPathCode()));
            });
            this.updateBatchById((Collection)sonDbList);
        }
        return this.catalogueMapper.updateById((Object)db);
    }

    @Transactional(rollbackFor={Exception.class})
    public void remove(String ids) {
        if (StringUtils.isNotEmpty((CharSequence)ids)) {
            List<Long> list = Arrays.stream(ids.split(",")).map(Long::parseLong).toList();
            list.forEach(id -> {
                List catalogues = ((CatalogueMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(Catalogue::getPath, id)).ne(Catalogue::getId, id));
                if (CollectionUtils.isNotEmpty((Collection)catalogues)) {
                    throw new AppException("\u5f53\u524d\u76ee\u5f55\u6709\u4e0b\u7ea7\u76ee\u5f55,\u4e0d\u80fd\u5220\u9664");
                }
                List questions = this.questionService.list((Wrapper)new LambdaQueryWrapper().eq(Question::getRepoId, id));
                if (CollUtil.isNotEmpty((Collection)questions)) {
                    throw new AppException("\u5f53\u524d\u76ee\u5f55\u6709\u5173\u8054\u7684\u8bd5\u9898,\u4e0d\u80fd\u5220\u9664");
                }
            });
            ((CatalogueMapper)this.baseMapper).deleteBatchIds(list);
        }
    }

    public Page<KnowledgePointsTreeDetailVO> getTreeKpDetails(Page page, Long repoId, String subjectCode, String name) {
        Page treeKpDetails = this.catalogueMapper.getTreeKpDetails(page, repoId, subjectCode, name);
        return treeKpDetails;
    }

    public Page<KwQuTypeDetailVO> getDataTreePageByQuType(Page page, Long repoId, String subjectCode, String type) {
        return this.catalogueMapper.getDataTreePageByQuType(page, repoId, subjectCode, type);
    }

    public List<String> getQuTypePageByQuType(Page page, Long repoId, String subjectCode, String type) {
        return this.catalogueMapper.getQuTypePageByQuType(page, repoId, subjectCode, type);
    }

    public List<CatalogueSimpleVO> getByNameAndLevel(String name, Integer level, String pathCode) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Catalogue::getLevel, (Object)level)).eq(Catalogue::getDeleted, (Object)false);
        String newName = CatalogueServiceImpl.getStringBetween((String)name, (String)"(", (String)")");
        wrapper.and(wrap -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wrap.like(Catalogue::getName, (Object)newName)).or()).eq(Catalogue::getPathCode, (Object)newName));
        if (StringUtils.isNotEmpty((CharSequence)pathCode)) {
            wrapper.last(" and FIND_IN_SET('" + pathCode + "',REPLACE(path_code,'\uff0d',',')) >0");
        }
        List catalogues = ((CatalogueMapper)this.baseMapper).selectList((Wrapper)wrapper);
        ArrayList<CatalogueSimpleVO> catalogueSimpleVOS = new ArrayList<CatalogueSimpleVO>();
        if (CollectionUtils.isNotEmpty((Collection)catalogues)) {
            List list = ((CatalogueMapper)this.baseMapper).selectList((Wrapper)new LambdaQueryWrapper().eq(Catalogue::getDeleted, (Object)false));
            for (Catalogue catalogue : catalogues) {
                CatalogueSimpleVO vo = new CatalogueSimpleVO();
                BeanUtils.copyProperties((Object)catalogue, (Object)vo);
                List pathCodes = this.getStringList(catalogue.getPathCode());
                List collect = list.stream().filter(item -> pathCodes.contains(item.getPathCode())).collect(Collectors.toList());
                String pathName = collect.stream().map(Catalogue::getName).collect(Collectors.joining("\uff0d"));
                vo.setPathName(pathName);
                catalogueSimpleVOS.add(vo);
            }
        }
        return catalogueSimpleVOS;
    }

    private List<String> getStringList(String pathCode) {
        Integer count = 0;
        ArrayList<String> list = new ArrayList<String>();
        while (true) {
            String s = "";
            int i = pathCode.indexOf("\uff0d", count + 1);
            if (i < 0) break;
            String result = pathCode.substring(0, i);
            list.add(result);
            count = i;
        }
        list.add(pathCode);
        return list;
    }

    public static String getStringBetween(String str, String start, String end) {
        int startIndex = str.indexOf(start);
        int endIndex = str.indexOf(end);
        if (startIndex != -1 && endIndex != -1) {
            return str.substring(startIndex + start.length(), endIndex);
        }
        return str;
    }

    @Transactional(rollbackFor={Exception.class})
    public String importExcel(MultipartFile file) {
        if (!ExcelUtils.isExcel((String)Objects.requireNonNull(file.getOriginalFilename()))) {
            throw new AppException("\u6587\u4ef6\u7c7b\u578b\u5fc5\u987b\u662fxls\u6216xlsx");
        }
        StringBuffer bf = new StringBuffer();
        try {
            ArrayList updateList = new ArrayList();
            List list = ExcelUtils.readMultipartFile((MultipartFile)file, CatalogueExcelDTO.class);
            HashMap l2Map = new HashMap();
            HashMap l3Map = new HashMap();
            HashMap l4Map = new HashMap();
            for (int i = 0; i < list.size(); ++i) {
                Long p3id;
                Long p2id;
                CatalogueExcelDTO dto = (CatalogueExcelDTO)list.get(i);
                String l1Name = dto.getL1Name();
                String l1Code = dto.getL1Code();
                String l2Name = dto.getL2Name();
                String l2Code = dto.getL2Code();
                String l3Name = dto.getL3Name();
                String l3Code = dto.getL3Code();
                String l4Name = dto.getL4Name();
                String l4Code = dto.getL4Code();
                if (StrUtil.isBlank((CharSequence)l2Name)) {
                    bf.append("\u8bfe\u7a0b/\u6a21\u5757\u540d\u79f0\u4e3a\u7a7a,\u8bf7\u6821\u9a8c");
                }
                if (StrUtil.isBlank((CharSequence)l3Name)) {
                    bf.append("\u5355\u5143/\u7ae0\u8282\u540d\u79f0\u4e3a\u7a7a,\u8bf7\u6821\u9a8c");
                }
                if (StrUtil.isBlank((CharSequence)l4Name)) {
                    bf.append("\u77e5\u8bc6\u70b9/\u6280\u80fd\u540d\u79f0\u4e3a\u7a7a,\u8bf7\u6821\u9a8c");
                }
                if (3 != l2Code.length() || !NumberUtil.isNumber((CharSequence)l2Code)) {
                    bf.append(l2Name).append("\u7684\u8bfe\u7a0b/\u6a21\u5757\u7f16\u7801\u5fc5\u987b\u662f\u957f\u5ea6\u4e3a3\u7684\u6570\u5b57,\u4f8b\u5982\uff1a001,002\uff0c003...");
                    continue;
                }
                if (3 != l3Code.length() || !NumberUtil.isNumber((CharSequence)l3Code)) {
                    bf.append(l3Name).append("\u7684\u5355\u5143/\u7ae0\u8282\u7f16\u7801\u5fc5\u987b\u662f\u957f\u5ea6\u4e3a3\u7684\u6570\u5b57,\u4f8b\u5982\uff1a001,002\uff0c003...");
                    continue;
                }
                if (4 != l4Code.length() || !NumberUtil.isNumber((CharSequence)l4Code)) {
                    bf.append(l4Name).append("\u7684\u77e5\u8bc6\u70b9/\u6280\u80fd\u7f16\u7801\u5fc5\u987b\u662f\u957f\u5ea6\u4e3a3\u7684\u6570\u5b57,\u4f8b\u5982\uff1a0001,0002\uff0c0003...");
                    continue;
                }
                Catalogue catalogue1 = this.getByCode(l1Code, Integer.valueOf(1), null);
                if (null == catalogue1) {
                    bf.append("\u6ca1\u6709\u627e\u5230\u79d1\u76ee\u3010").append(l1Name).append("\u3011\u5bf9\u5e94\u7684\u7f16\u7801\u3010").append(l1Code).append("\u3011\u8bf7\u5728\u79d1\u76ee\u7ba1\u7406\u4e2d\u6dfb\u52a0");
                    continue;
                }
                Long p1id = catalogue1.getId();
                Catalogue catalogue2 = (Catalogue)l2Map.get(p1id + "-" + l2Code);
                if (catalogue2 == null) {
                    catalogue2 = new Catalogue();
                    catalogue2.setName(l2Name);
                    catalogue2.setCode(l2Code);
                    catalogue2.setLevel(Integer.valueOf(2));
                    catalogue2.setPId(p1id);
                    catalogue2.setSubjectCode(l1Code);
                }
                if (null == (p2id = (catalogue2 = this.lsonMap(catalogue2, l2Map, updateList, bf)).getId())) continue;
                Catalogue catalogue3 = (Catalogue)l3Map.get(p2id + "-" + l3Code);
                if (catalogue3 == null) {
                    catalogue3 = new Catalogue();
                    catalogue3.setName(l3Name);
                    catalogue3.setCode(l3Code);
                    catalogue3.setLevel(Integer.valueOf(3));
                    catalogue3.setPId(p2id);
                    catalogue3.setSubjectCode(l1Code);
                }
                if (null == (p3id = (catalogue3 = this.lsonMap(catalogue3, l3Map, updateList, bf)).getId())) continue;
                Catalogue catalogue4 = (Catalogue)l4Map.get(p3id + "-" + l4Code);
                if (catalogue4 == null) {
                    catalogue4 = new Catalogue();
                    catalogue4.setName(l4Name);
                    catalogue4.setCode(l4Code);
                    catalogue4.setLevel(Integer.valueOf(4));
                    catalogue4.setPId(p3id);
                    catalogue4.setSubjectCode(l1Code);
                }
                catalogue4 = this.lsonMap(catalogue4, l4Map, updateList, bf);
            }
            this.updateBatchById(updateList);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new AppException("\u89e3\u6790excel\u5931\u8d25" + String.valueOf(bf));
        }
        return bf.toString();
    }

    public String getAllPathName(String path) {
        String pathName = (String)this.stringRedisTemplate.opsForValue().get((Object)(REDIS_CATALOGUE_NAME + path));
        if (StrUtil.isBlank((CharSequence)pathName)) {
            pathName = ((CatalogueMapper)this.baseMapper).getAllPathName(path);
            this.stringRedisTemplate.opsForValue().set((Object)(REDIS_CATALOGUE_NAME + path), (Object)pathName, 10L, TimeUnit.MINUTES);
        }
        return pathName;
    }

    Catalogue lsonMap(Catalogue catalogue, HashMap<String, Catalogue> cacheMap, List<Catalogue> updateList, StringBuffer errorInfo) {
        Long pid;
        String name = catalogue.getName();
        String code = catalogue.getCode();
        String subjectCode = catalogue.getSubjectCode();
        Integer level = catalogue.getLevel();
        if (null != (catalogue = this.getByCode(code, level, pid = catalogue.getPId()))) {
            if (!catalogue.getName().equals(name)) {
                catalogue.setName(name);
                updateList.add(catalogue);
            }
        } else {
            catalogue = new Catalogue();
            catalogue.setName(name);
            catalogue.setCode(code);
            catalogue.setType("repo");
            catalogue.setLevel(level);
            catalogue.setPId(pid);
            catalogue.setSubjectCode(subjectCode);
            try {
                this.add(catalogue, Boolean.FALSE);
                cacheMap.put(pid + "-" + code, catalogue);
            }
            catch (Exception e) {
                errorInfo.append("\u5bfc\u5165\u3010").append(name).append("\u3011\u5931\u8d25:").append(e.getMessage());
            }
        }
        return catalogue;
    }

    Catalogue getByCode(String code, Integer leve, Long pid) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        System.out.println("-------\u67e5\u8be2-----");
        ((LambdaQueryWrapper)((LambdaQueryWrapper)qw.eq(Catalogue::getCode, (Object)code)).eq(Catalogue::getLevel, (Object)leve)).eq(null != pid, Catalogue::getPId, (Object)pid);
        return (Catalogue)this.getOne((Wrapper)qw);
    }
}

