/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.converter.CertificateConverter;
import com.zsy.exam.mapper.CertificateMapper;
import com.zsy.exam.model.entity.Certificate;
import com.zsy.exam.model.form.CertificateForm;
import com.zsy.exam.model.vo.certificate.MyCertificateVO;
import com.zsy.exam.service.ICertificateService;
import com.zsy.exam.util.CacheClient;
import com.zsy.exam.util.SecurityUtil;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CertificateServiceImpl
extends ServiceImpl<CertificateMapper, Certificate>
implements ICertificateService {
    @Resource
    private CertificateMapper certificateMapper;
    @Resource
    private CertificateConverter certificateConverter;
    @Resource
    private CacheClient cacheClient;
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    public Result<String> addCertificate(CertificateForm certificateForm) {
        Certificate certificate = this.certificateConverter.fromToEntity(certificateForm);
        int insertRows = this.certificateMapper.insert((Object)certificate);
        if (insertRows > 0) {
            if (certificate.getId() != null) {
                this.stringRedisTemplate.delete((Object)("cache:certificate:pagingCertificate:" + certificate.getId().toString()));
                Map<Long, Certificate> map = Map.of(certificate.getId(), certificate);
                this.cacheClient.batchPut("cache:certificate:pagingCertificate:", map, 10L, TimeUnit.MINUTES);
            }
            return Result.success((String)"\u6dfb\u52a0\u8bc1\u4e66\u6210\u529f");
        }
        return Result.failed((String)"\u6dfb\u52a0\u8bc1\u4e66\u5931\u8d25");
    }

    public Result<IPage<Certificate>> pagingCertificate(Integer pageNum, Integer pageSize, String certificateName, String certificationUnit) {
        int total = this.certificateMapper.countByCondition(SecurityUtil.getUserId(), certificateName, certificationUnit);
        int offset = (pageNum - 1) * pageSize;
        List certificateIds = this.certificateMapper.selectCertificateIdsPage(SecurityUtil.getUserId(), certificateName, certificationUnit, Integer.valueOf(offset), pageSize);
        Map cachedClbumsMap = this.cacheClient.batchGet("cache:certificate:pagingCertificate:", certificateIds, Certificate.class);
        ArrayList<Long> missIds = new ArrayList<Long>();
        for (Long id : certificateIds) {
            if (cachedClbumsMap.containsKey(id)) continue;
            missIds.add(id);
        }
        if (!missIds.isEmpty()) {
            List missedClbums = this.certificateMapper.batchSelectByIds(missIds);
            Map missedClbumsMap = missedClbums.stream().collect(Collectors.toMap(Certificate::getId, Function.identity()));
            this.cacheClient.batchPut("cache:certificate:pagingCertificate:", missedClbumsMap, 10L, TimeUnit.MINUTES);
            cachedClbumsMap.putAll(missedClbumsMap);
        }
        ArrayList<Certificate> finalResult = new ArrayList<Certificate>(certificateIds.size());
        for (Long id : certificateIds) {
            finalResult.add((Certificate)cachedClbumsMap.get(id));
        }
        Page resultPage = new Page((long)pageNum.intValue(), (long)pageSize.intValue(), Long.valueOf(total).longValue());
        resultPage.setRecords(finalResult);
        return Result.success((String)"\u67e5\u8be2\u6210\u529f", (Object)resultPage);
    }

    @Transactional
    public Result<String> updateCertificate(CertificateForm certificateForm) {
        Certificate certificate = this.certificateConverter.fromToEntity(certificateForm);
        int affectedRows = this.certificateMapper.updateById((Object)certificate);
        if (affectedRows > 0) {
            if (certificate.getId() != null) {
                this.stringRedisTemplate.delete((Object)("cache:certificate:pagingCertificate:" + certificate.getId().toString()));
                Map<Long, Certificate> map = Map.of(certificate.getId(), certificate);
                this.cacheClient.batchPut("cache:certificate:pagingCertificate:", map, 10L, TimeUnit.MINUTES);
            }
            return Result.success((String)"\u4fee\u6539\u8bc1\u4e66\u6210\u529f");
        }
        return Result.failed((String)"\u4fee\u6539\u8bc1\u4e66\u5931\u8d25");
    }

    public Result<String> deleteCertificate(Long id) {
        LambdaUpdateWrapper certificateLambdaUpdateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)certificateLambdaUpdateWrapper.eq(Certificate::getId, (Object)id)).set(Certificate::getIsDeleted, (Object)1);
        int affectedRows = this.certificateMapper.update((Wrapper)certificateLambdaUpdateWrapper);
        if (affectedRows > 0) {
            this.stringRedisTemplate.delete((Object)("cache:certificate:pagingCertificate:" + id));
            return Result.success((String)"\u5220\u9664\u8bc1\u4e66\u6210\u529f");
        }
        return Result.failed((String)"\u5220\u9664\u8bc1\u4e66\u5931\u8d25");
    }

    public Result<IPage<MyCertificateVO>> getMyCertificatePaging(Integer pageNum, Integer pageSize, String examName) {
        Page myCertificateVOPage = new Page();
        myCertificateVOPage = this.certificateMapper.selectMyCertificate(myCertificateVOPage, pageNum, pageSize, SecurityUtil.getUserId(), examName);
        return Result.success((String)"\u67e5\u8be2\u6210\u529f", (Object)myCertificateVOPage);
    }
}

