/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.constant.RoleEnum;
import com.zsy.exam.converter.ClbumConverter;
import com.zsy.exam.mapper.ClbumHeadTeacherMapper;
import com.zsy.exam.mapper.ClbumMapper;
import com.zsy.exam.mapper.ExamMapper;
import com.zsy.exam.mapper.QuestionMapper;
import com.zsy.exam.mapper.StudentMapper;
import com.zsy.exam.mapper.UserMapper;
import com.zsy.exam.model.dto.ClbumExcelDTO;
import com.zsy.exam.model.entity.Clbum;
import com.zsy.exam.model.entity.ClbumHeadTeacher;
import com.zsy.exam.model.entity.Grade;
import com.zsy.exam.model.entity.Specialty;
import com.zsy.exam.model.entity.Staff;
import com.zsy.exam.model.entity.Student;
import com.zsy.exam.model.entity.User;
import com.zsy.exam.model.form.ClbumForm;
import com.zsy.exam.model.vo.ClbumTreeVO;
import com.zsy.exam.model.vo.ClbumVO;
import com.zsy.exam.service.IClbumService;
import com.zsy.exam.service.IGradeService;
import com.zsy.exam.service.ISpecialtyService;
import com.zsy.exam.service.IStaffService;
import com.zsy.exam.util.CacheClient;
import com.zsy.exam.util.ClassTokenGenerator;
import com.zsy.exam.util.excel.ExcelUtils;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ClbumServiceImpl
extends ServiceImpl<ClbumMapper, Clbum>
implements IClbumService {
    @Resource
    private ClbumMapper clbumMapper;
    @Resource
    private ExamMapper examMapper;
    @Resource
    private QuestionMapper questionMapper;
    @Resource
    private ClbumConverter clbumConverter;
    @Resource
    private UserMapper userMapper;
    @Resource
    private IClbumService clbumService;
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    private CacheClient cacheClient;
    @Resource
    private ClbumHeadTeacherMapper clbumHeadTeacherMapper;
    @Resource
    private IGradeService gradeService;
    @Resource
    private ISpecialtyService specialtyService;
    @Resource
    private IStaffService staffService;
    @Resource
    private StudentMapper studentMapper;

    public Clbum addClbum(ClbumForm clbumForm) {
        if (null == clbumForm.getCode()) {
            clbumForm.setCode(ClassTokenGenerator.generateClassToken((int)18));
        }
        Clbum clbum = this.clbumConverter.formToEntity(clbumForm);
        LambdaUpdateWrapper clbumUpdateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)clbumUpdateWrapper.eq(Clbum::getClbumName, (Object)clbum.getClbumName())).eq(Clbum::getIsDeleted, (Object)0);
        boolean exists = this.clbumMapper.exists((Wrapper)clbumUpdateWrapper);
        if (exists) {
            throw new AppException("\u5df2\u5b58\u5728\u76f8\u540c\u7684\u73ed\u7ea7\u540d\u79f0");
        }
        int rows = this.clbumMapper.insert((Object)clbum);
        if (rows == 0) {
            throw new AppException("\u6dfb\u52a0\u5931\u8d25");
        }
        if (null != clbumForm.getLeaderId()) {
            ClbumHeadTeacher clbumHeadTeacher = new ClbumHeadTeacher();
            clbumHeadTeacher.setClbumId(clbum.getId());
            clbumHeadTeacher.setHeadTeacherId(clbumForm.getLeaderId());
            this.clbumHeadTeacherMapper.insert((Object)clbumHeadTeacher);
        }
        return clbum;
    }

    public Result<String> updateClbum(Long id, ClbumForm clbumForm) {
        LambdaUpdateWrapper clbumUpdateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)clbumUpdateWrapper.eq(Clbum::getClbumName, (Object)clbumForm.getClbumName())).eq(Clbum::getIsDeleted, (Object)0);
        Clbum exists = (Clbum)this.clbumMapper.selectOne((Wrapper)clbumUpdateWrapper);
        if (exists != null && !exists.getId().equals(id)) {
            return Result.failed((String)"\u5df2\u5b58\u5728\u76f8\u540c\u7684\u73ed\u7ea7\u540d\u79f0");
        }
        LambdaUpdateWrapper clbumUpdateWrapper2 = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)clbumUpdateWrapper2.set(Clbum::getClbumCount, (Object)clbumForm.getClbumCount())).set(Clbum::getClbumName, (Object)clbumForm.getClbumName())).set(Clbum::getGradeId, (Object)clbumForm.getGradeId())).set(Clbum::getLeaderId, (Object)clbumForm.getLeaderId())).set(Clbum::getSpecialtyId, (Object)clbumForm.getSpecialtyId())).eq(Clbum::getId, (Object)id);
        int rows = this.clbumMapper.update((Wrapper)clbumUpdateWrapper2);
        if (rows == 0) {
            return Result.failed((String)"\u4fee\u6539\u5931\u8d25");
        }
        this.clbumHeadTeacherMapper.delete((Wrapper)new LambdaQueryWrapper().eq(ClbumHeadTeacher::getClbumId, (Object)id));
        ClbumHeadTeacher clbumHeadTeacher = new ClbumHeadTeacher();
        clbumHeadTeacher.setClbumId(id);
        clbumHeadTeacher.setHeadTeacherId(clbumForm.getLeaderId());
        this.clbumHeadTeacherMapper.insert((Object)clbumHeadTeacher);
        return Result.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @Transactional
    public Result<String> deleteClbum(List<Long> ids) {
        LambdaQueryWrapper studentLambdaUpdateWrapper = new LambdaQueryWrapper();
        studentLambdaUpdateWrapper.in(Student::getAdministrativeClbumId, ids);
        Long clbumCount = this.studentMapper.selectCount((Wrapper)studentLambdaUpdateWrapper);
        if (clbumCount > 0L) {
            return Result.failed((String)"\u73ed\u7ea7\u4e0b\u6709\u5b66\u751f\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u5148\u5220\u9664\u5b66\u751f");
        }
        LambdaUpdateWrapper clbumLambdaUpdateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)clbumLambdaUpdateWrapper.in(Clbum::getId, ids)).set(Clbum::getIsDeleted, (Object)1);
        int rows = this.clbumMapper.update((Wrapper)clbumLambdaUpdateWrapper);
        if (rows == 0) {
            return Result.failed((String)"\u5220\u9664\u5931\u8d25");
        }
        LambdaUpdateWrapper clbumHeadTeacherWrapper = new LambdaUpdateWrapper();
        clbumHeadTeacherWrapper.in(ClbumHeadTeacher::getClbumId, ids);
        this.clbumHeadTeacherMapper.delete((Wrapper)clbumHeadTeacherWrapper);
        return Result.success((String)"\u5220\u9664\u6210\u529f");
    }

    public Result<Page<ClbumVO>> getPaging(Page page, String clbumName, Long gradeId, Long specialtyId) {
        Page clbums = this.clbumMapper.selectPageForClbumName(page, clbumName, gradeId, specialtyId);
        return Result.success((String)"\u67e5\u8be2\u6210\u529f", (Object)clbums);
    }

    public Result<String> removeUserClbum(String ids) {
        List<Long> userIds = Arrays.stream(ids.split(",")).map(Long::parseLong).toList();
        Long rows = this.userMapper.removeUserClbum(userIds);
        if (rows == 0L) {
            return Result.failed((String)"\u79fb\u9664\u5931\u8d25");
        }
        return Result.success((String)"\u79fb\u9664\u6210\u529f");
    }

    public Result<List<ClbumVO>> getAllClbum() {
        Page page = new Page();
        page.setSize(Long.MAX_VALUE);
        page.setCurrent(1L);
        Page clbumVOS = this.clbumMapper.selectPageForClbumName(page, null, null, null);
        List result = clbumVOS.getRecords();
        return Result.success((String)"\u67e5\u8be2\u6210\u529f", (Object)result);
    }

    public Result<List<ClbumTreeVO>> getAllClbumTree(Long clbumId, Long specialtyId, Long gradeId) {
        return Result.ok((Object)this.clbumMapper.getAllClbumTree(clbumId, specialtyId, gradeId));
    }

    public Result<List<ClbumTreeVO>> getAllClbumTreeForExam(Long examId, Long clbumId, Long specialtyId, Long gradeId) {
        return Result.ok((Object)this.clbumMapper.getAllClbumTreeForExam(examId, clbumId, specialtyId, gradeId));
    }

    public Result<List<Clbum>> getAllClbumFromGrade(Long gradeId) {
        LambdaUpdateWrapper clbumLambdaUpdateWrapper = new LambdaUpdateWrapper();
        clbumLambdaUpdateWrapper.eq(Clbum::getGradeId, (Object)gradeId);
        List result = this.clbumMapper.selectList((Wrapper)clbumLambdaUpdateWrapper);
        return Result.success((Object)result);
    }

    public Result<List<Clbum>> getAllClbumFromSpecialty(Long specialtyId) {
        LambdaUpdateWrapper clbumLambdaUpdateWrapper = new LambdaUpdateWrapper();
        clbumLambdaUpdateWrapper.eq(Clbum::getSpecialtyId, (Object)specialtyId);
        List result = this.clbumMapper.selectList((Wrapper)clbumLambdaUpdateWrapper);
        return Result.success((Object)result);
    }

    public Result<List<Clbum>> getAllClbumFromSpecialtyAndgradeId(Long specialtyId, Long gradeId) {
        LambdaUpdateWrapper clbumLambdaUpdateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)clbumLambdaUpdateWrapper.eq(Clbum::getSpecialtyId, (Object)specialtyId)).and(gradeId != null, e -> e.eq(Clbum::getGradeId, (Object)gradeId))).and(true, e -> e.eq(Clbum::getIsDeleted, (Object)0));
        List result = this.clbumMapper.selectList((Wrapper)clbumLambdaUpdateWrapper);
        return Result.success((Object)result);
    }

    public List<Clbum> listByNotTeacher(Long userId) {
        List clbums = ((ClbumMapper)this.baseMapper).listByNotTeacher(userId);
        return clbums;
    }

    public void importClbum(MultipartFile file) {
        if (!ExcelUtils.isExcel((String)Objects.requireNonNull(file.getOriginalFilename()))) {
            throw new AppException("\u6587\u4ef6\u7c7b\u578b\u5fc5\u987b\u662fxls\u6216xlsx");
        }
        List list = ExcelUtils.readMultipartFile((MultipartFile)file, ClbumExcelDTO.class);
        this.checkImportSpecialty(list);
        for (ClbumExcelDTO dto : list) {
            User user;
            Specialty specialty;
            Grade grade;
            Clbum clbum = new Clbum();
            clbum.setCode(ClassTokenGenerator.generateClassToken((int)18));
            clbum.setClbumName(dto.getName());
            clbum.setClbumCount(Integer.valueOf(dto.getClbumCount()));
            if (StringUtils.isNotBlank((CharSequence)dto.getGradeName()) && null != (grade = (Grade)this.gradeService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Grade::getName, (Object)dto.getGradeName())).eq(Grade::getDeleted, (Object)false)).last(" limit 1")))) {
                clbum.setGradeId(grade.getId());
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getSpecialtyName()) && null != (specialty = (Specialty)this.specialtyService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Specialty::getName, (Object)dto.getSpecialtyName())).eq(Specialty::getDeleted, (Object)false)).last(" limit 1")))) {
                clbum.setSpecialtyId(specialty.getId());
            }
            Long staffId = null;
            if (StringUtils.isNotBlank((CharSequence)dto.getHeadTeacherName()) && null != (user = (User)this.userMapper.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(User::getRealName, (Object)dto.getHeadTeacherName())).eq(User::getIsDeleted, (Object)false)).eq(User::getRoleId, (Object)RoleEnum.TEACHER.getId())).last(" limit 1")))) {
                Staff staff = (Staff)this.staffService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Staff::getUserId, (Object)user.getId())).eq(Staff::getDeleted, (Object)false));
                staffId = staff.getId();
            }
            clbum.setLeaderId(staffId);
            this.clbumMapper.insert((Object)clbum);
            if (null == staffId) continue;
            ClbumHeadTeacher clbumHeadTeacher = new ClbumHeadTeacher();
            clbumHeadTeacher.setClbumId(clbum.getId());
            clbumHeadTeacher.setHeadTeacherId(staffId);
            this.clbumHeadTeacherMapper.insert((Object)clbumHeadTeacher);
        }
    }

    public void exportClbum(HttpServletResponse response, String clbumName) {
        List clbumExcelDTOS = this.clbumMapper.selectExcel(clbumName);
        ExcelUtils.export((HttpServletResponse)response, (String)"\u73ed\u7ea7\u5bfc\u51fa", (List)clbumExcelDTOS, ClbumExcelDTO.class);
    }

    public void exportClbumTemp(HttpServletResponse response) {
        ExcelUtils.export((HttpServletResponse)response, (String)"\u73ed\u7ea7\u5bfc\u51fa\u6a21\u677f", null, ClbumExcelDTO.class);
    }

    private void checkImportSpecialty(List<ClbumExcelDTO> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new AppException("\u5f53\u524d\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a,\u5bfc\u5165\u5931\u8d25");
        }
        for (int i = 0; i < list.size(); ++i) {
            ClbumExcelDTO dto = list.get(i);
            if (StringUtils.isBlank((CharSequence)dto.getName())) {
                throw new AppException("\u73ed\u7ea7\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a,\u884c\u53f7\uff1a" + i + "2");
            }
            LambdaUpdateWrapper clbumUpdateWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)clbumUpdateWrapper.eq(Clbum::getClbumName, (Object)dto.getName())).eq(Clbum::getIsDeleted, (Object)0);
            boolean exists = this.clbumMapper.exists((Wrapper)clbumUpdateWrapper);
            if (!exists) continue;
            throw new AppException("\u5df2\u5b58\u5728\u76f8\u540c\u7684\u73ed\u7ea7\u540d\u79f0,\u884c\u53f7\uff1a" + i + "2");
        }
    }
}

