/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.mapper.ExamAreaDetailMapper;
import com.zsy.exam.mapper.ExamAreaMapper;
import com.zsy.exam.mapper.ExamAreaSchoolMapper;
import com.zsy.exam.mapper.ExamAreaSubjectMapper;
import com.zsy.exam.model.dto.ExamAreaDTO;
import com.zsy.exam.model.entity.ExamArea;
import com.zsy.exam.model.entity.ExamAreaDetail;
import com.zsy.exam.model.entity.ExamAreaSchool;
import com.zsy.exam.model.entity.ExamAreaSubject;
import com.zsy.exam.model.entity.ExaminationPaper;
import com.zsy.exam.model.vo.ExamAreaVO;
import com.zsy.exam.service.IExamAreaService;
import com.zsy.exam.service.IExaminationPaperService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExamAreaServiceImpl
extends ServiceImpl<ExamAreaMapper, ExamArea>
implements IExamAreaService {
    @Autowired
    ExamAreaMapper examAreaMapper;
    @Autowired
    private ExamAreaSchoolMapper examAreaSchoolMapper;
    @Autowired
    private ExamAreaSubjectMapper examAreaSubjectMapper;
    @Autowired
    @Lazy
    private IExaminationPaperService examinationPaperService;
    @Autowired
    private ExamAreaDetailMapper examAreaDetailMapper;

    public ExamAreaVO getExamArea(Long id) {
        ExamAreaVO detail = this.examAreaMapper.detail(id);
        List examAreaDetails = this.examAreaDetailMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(ExamAreaDetail::getExamAreaId, (Object)id));
        detail.setExamAreaDetails(examAreaDetails);
        List clbums = this.examAreaMapper.getClbumById(id);
        detail.setClbums(clbums);
        return detail;
    }

    public Page<ExamAreaVO> getAllExamArea(Page page, String name) {
        return this.examAreaMapper.pageList(page, name);
    }

    @Transactional(rollbackFor={Exception.class})
    public void add(ExamAreaDTO dto) {
        if (dto == null || CollectionUtils.isEmpty((Collection)dto.getSchools()) || CollectionUtils.isEmpty((Collection)dto.getSubjects())) {
            throw new AppException("\u53c2\u6570\u9519\u8bef");
        }
        ExamArea examArea = new ExamArea();
        BeanUtils.copyProperties((Object)dto, (Object)examArea);
        this.examAreaMapper.insert((Object)examArea);
        this.addOrUpdateSchoolAndSubject(examArea.getId(), dto.getSchools(), dto.getSubjects());
        this.addOrUpdateAreaDetail(examArea.getId(), dto.getExamAreaDetails());
    }

    @Transactional(rollbackFor={Exception.class})
    public void modify(ExamAreaDTO dto) {
        ExamArea examArea = (ExamArea)this.getById((Serializable)dto.getId());
        if (null == examArea) {
            throw new AppException("\u53c2\u6570\u9519\u8bef");
        }
        BeanUtils.copyProperties((Object)dto, (Object)examArea, (String[])new String[]{"id"});
        this.examAreaMapper.updateById((Object)examArea);
        this.addOrUpdateSchoolAndSubject(examArea.getId(), dto.getSchools(), dto.getSubjects());
        this.addOrUpdateAreaDetail(examArea.getId(), dto.getExamAreaDetails());
    }

    @Transactional(rollbackFor={Exception.class})
    public void remove(String ids) {
        if (StringUtils.isNotEmpty((CharSequence)ids)) {
            String[] array = ids.split(",");
            for (String id : Arrays.asList(array)) {
                List examinationPapers = this.examinationPaperService.list((Wrapper)new LambdaQueryWrapper().eq(ExaminationPaper::getExamAreaId, (Object)id));
                if (CollectionUtils.isNotEmpty((Collection)examinationPapers)) {
                    throw new AppException("\u5df2\u7ecf\u5173\u8054\u8bd5\u5377,\u4e0d\u80fd\u5220\u9664");
                }
                this.removeById((Serializable)Long.valueOf(id));
                this.examAreaSubjectMapper.delete((Wrapper)new LambdaQueryWrapper().eq(ExamAreaSubject::getExamAreaId, (Object)id));
                this.examAreaSchoolMapper.delete((Wrapper)new LambdaQueryWrapper().eq(ExamAreaSchool::getExamAreaId, (Object)id));
                this.examAreaDetailMapper.delete((Wrapper)new LambdaQueryWrapper().eq(ExamAreaDetail::getExamAreaId, (Object)id));
            }
        }
    }

    private void addOrUpdateSchoolAndSubject(Long id, List<Long> schools, List<Long> subjects) {
        this.examAreaSubjectMapper.delete((Wrapper)new LambdaQueryWrapper().eq(ExamAreaSubject::getExamAreaId, (Object)id));
        this.examAreaSchoolMapper.delete((Wrapper)new LambdaQueryWrapper().eq(ExamAreaSchool::getExamAreaId, (Object)id));
        for (Long schoolId : schools) {
            ExamAreaSchool examAreaSchool = new ExamAreaSchool();
            examAreaSchool.setExamAreaId(id);
            examAreaSchool.setSchoolId(schoolId);
            this.examAreaSchoolMapper.insert((Object)examAreaSchool);
        }
        for (Long subjectId : subjects) {
            ExamAreaSubject examAreaSubject = new ExamAreaSubject();
            examAreaSubject.setExamAreaId(id);
            examAreaSubject.setSubjectId(subjectId);
            this.examAreaSubjectMapper.insert((Object)examAreaSubject);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void addOrUpdateAreaDetail(Long examAreaId, List<ExamAreaDetail> examAreaDetails) {
        this.examAreaDetailMapper.delete((Wrapper)new LambdaQueryWrapper().eq(ExamAreaDetail::getExamAreaId, (Object)examAreaId));
        if (CollectionUtils.isEmpty(examAreaDetails)) {
            ExamAreaDetail examAreaDetailA = new ExamAreaDetail();
            examAreaDetailA.setExamAreaId(examAreaId);
            examAreaDetailA.setStartPoint(Integer.valueOf(90));
            examAreaDetailA.setEndPoint(Integer.valueOf(100));
            examAreaDetailA.setLevel("A");
            this.examAreaDetailMapper.insert((Object)examAreaDetailA);
            ExamAreaDetail examAreaDetailB = new ExamAreaDetail();
            examAreaDetailB.setExamAreaId(examAreaId);
            examAreaDetailB.setStartPoint(Integer.valueOf(80));
            examAreaDetailB.setEndPoint(Integer.valueOf(90));
            examAreaDetailB.setLevel("B");
            this.examAreaDetailMapper.insert((Object)examAreaDetailB);
            ExamAreaDetail examAreaDetailC = new ExamAreaDetail();
            examAreaDetailC.setExamAreaId(examAreaId);
            examAreaDetailC.setStartPoint(Integer.valueOf(60));
            examAreaDetailC.setEndPoint(Integer.valueOf(80));
            examAreaDetailC.setLevel("C");
            this.examAreaDetailMapper.insert((Object)examAreaDetailC);
            ExamAreaDetail examAreaDetailD = new ExamAreaDetail();
            examAreaDetailD.setExamAreaId(examAreaId);
            examAreaDetailD.setStartPoint(Integer.valueOf(0));
            examAreaDetailD.setEndPoint(Integer.valueOf(60));
            examAreaDetailD.setLevel("D");
            this.examAreaDetailMapper.insert((Object)examAreaDetailD);
            return;
        }
        for (ExamAreaDetail examAreaDetail : examAreaDetails) {
            if ("A".equals(examAreaDetail.getLevel()) && null == examAreaDetail.getStartPoint()) {
                examAreaDetail.setStartPoint(Integer.valueOf(90));
            }
            if ("A".equals(examAreaDetail.getLevel()) && null == examAreaDetail.getEndPoint()) {
                examAreaDetail.setEndPoint(Integer.valueOf(100));
            }
            if ("B".equals(examAreaDetail.getLevel()) && null == examAreaDetail.getStartPoint()) {
                examAreaDetail.setStartPoint(Integer.valueOf(80));
            }
            if ("B".equals(examAreaDetail.getLevel()) && null == examAreaDetail.getEndPoint()) {
                examAreaDetail.setEndPoint(Integer.valueOf(90));
            }
            if ("C".equals(examAreaDetail.getLevel()) && null == examAreaDetail.getStartPoint()) {
                examAreaDetail.setStartPoint(Integer.valueOf(60));
            }
            if ("C".equals(examAreaDetail.getLevel()) && null == examAreaDetail.getEndPoint()) {
                examAreaDetail.setEndPoint(Integer.valueOf(80));
            }
            if ("D".equals(examAreaDetail.getLevel()) && null == examAreaDetail.getStartPoint()) {
                examAreaDetail.setStartPoint(Integer.valueOf(0));
            }
            if ("D".equals(examAreaDetail.getLevel()) && null == examAreaDetail.getEndPoint()) {
                examAreaDetail.setEndPoint(Integer.valueOf(60));
            }
            examAreaDetail.setExamAreaId(examAreaId);
            this.examAreaDetailMapper.insert((Object)examAreaDetail);
        }
    }
}

