/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.mapper.ExamInfoMapper;
import com.zsy.exam.model.entity.ExamInfo;
import com.zsy.exam.model.entity.ExamInfoRankBySubject;
import com.zsy.exam.service.IExamInfoService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ExamInfoServiceImpl
extends ServiceImpl<ExamInfoMapper, ExamInfo>
implements IExamInfoService {
    @Autowired
    ExamInfoMapper examInfoMapper;

    public ExamInfo getExamInfo(Long id) {
        return (ExamInfo)this.examInfoMapper.selectById((Serializable)id);
    }

    public Page<ExamInfo> getAllExamInfo(Page page) {
        return (Page)this.examInfoMapper.selectPage((IPage)page, null);
    }

    @Transactional(rollbackFor={Exception.class})
    public void add(ExamInfo examInfo) {
        this.examInfoMapper.insert((Object)examInfo);
    }

    @Transactional(rollbackFor={Exception.class})
    public int modify(ExamInfo examInfo) {
        return this.examInfoMapper.updateById((Object)examInfo);
    }

    @Transactional(rollbackFor={Exception.class})
    public void remove(String ids) {
        String[] array;
        if (StringUtils.isNotEmpty((CharSequence)ids) && !CollectionUtils.isEmpty(Arrays.asList(array = ids.split(",")))) {
            this.examInfoMapper.deleteBatchIds(Arrays.asList(array));
        }
    }

    public List<Map> queryRemoteSchoolExamInfoMenuTree(String examJobId, String schoolCode) {
        return this.examInfoMapper.queryRemoteSchoolExamInfoMenuTree(examJobId, schoolCode);
    }

    public Page<ExamInfoRankBySubject> getIndividuleDetailsBySubject(Page page, String examJobId, String schoolCode, String subjectId, String gardName, String clbumName, String realName, String userId, String speName, String fuzzySearch) {
        return this.examInfoMapper.getIndividuleDetailsBySubject(page, examJobId, schoolCode, subjectId, gardName, clbumName, realName, userId, speName, fuzzySearch);
    }

    public Page<ExamInfo> queryRemoteSchoolExamInfo(Page page, String examJobId, String schoolCode, String specialtyId, String examName, String realName, String studentCode, String studyCode, String clbumName, String specialtyName, String gradeName, String subjectName, String paperName, String fuzzySearch) {
        return this.examInfoMapper.queryWithCondition(page, examJobId, schoolCode, specialtyId, examName, realName, studentCode, studyCode, clbumName, specialtyName, gradeName, subjectName, paperName, fuzzySearch);
    }
}

