/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.constant.QuestionTypeEnum;
import com.zsy.exam.constant.RoleEnum;
import com.zsy.exam.constant.SysParamEnum;
import com.zsy.exam.converter.ExamConverter;
import com.zsy.exam.converter.ExamQuAnswerConverter;
import com.zsy.exam.mapper.CertificateUserMapper;
import com.zsy.exam.mapper.ExamClbumMapper;
import com.zsy.exam.mapper.ExamMapper;
import com.zsy.exam.mapper.ExamQuAnswerMapper;
import com.zsy.exam.mapper.ExamQuestionMapper;
import com.zsy.exam.mapper.ExamRepoMapper;
import com.zsy.exam.mapper.ExamStudentTeacherMappingMapper;
import com.zsy.exam.mapper.ExaminationPaperMapper;
import com.zsy.exam.mapper.ManualScoreMapper;
import com.zsy.exam.mapper.OptionMapper;
import com.zsy.exam.mapper.QuestionMapper;
import com.zsy.exam.mapper.StudentMapper;
import com.zsy.exam.mapper.SubjectMapper;
import com.zsy.exam.mapper.UserBookMapper;
import com.zsy.exam.mapper.UserExamsScoreMapper;
import com.zsy.exam.mapper.UserMapper;
import com.zsy.exam.mapper.WrongQuestionBookMapper;
import com.zsy.exam.model.entity.Clbum;
import com.zsy.exam.model.entity.Exam;
import com.zsy.exam.model.entity.ExamClbum;
import com.zsy.exam.model.entity.ExamQuAnswer;
import com.zsy.exam.model.entity.ExamStudentTeacherMapping;
import com.zsy.exam.model.entity.ExaminationPaper;
import com.zsy.exam.model.entity.ManualScore;
import com.zsy.exam.model.entity.OngoingExam;
import com.zsy.exam.model.entity.Option;
import com.zsy.exam.model.entity.Question;
import com.zsy.exam.model.entity.QuestionAndMisc;
import com.zsy.exam.model.entity.School;
import com.zsy.exam.model.entity.Student;
import com.zsy.exam.model.entity.Subject;
import com.zsy.exam.model.entity.SysParam;
import com.zsy.exam.model.entity.User;
import com.zsy.exam.model.entity.UserExamsScore;
import com.zsy.exam.model.entity.WrongQuestionBook;
import com.zsy.exam.model.entity.exam.ExamInfoScreenRaw;
import com.zsy.exam.model.entity.exam.ExamQuestionAndPoint;
import com.zsy.exam.model.entity.exam.NotHandExam;
import com.zsy.exam.model.form.exam.ExamAddForm;
import com.zsy.exam.model.form.examquanswer.ExamQuAnswerAddForm;
import com.zsy.exam.model.vo.Key2ValueVo;
import com.zsy.exam.model.vo.exam.AnalyseIntroduceVo;
import com.zsy.exam.model.vo.exam.ExamClbumListVO;
import com.zsy.exam.model.vo.exam.ExamDetailVO;
import com.zsy.exam.model.vo.exam.ExamHandSimpleReportVO;
import com.zsy.exam.model.vo.exam.ExamQuAnswserMiss;
import com.zsy.exam.model.vo.exam.ExamQuCollectVO;
import com.zsy.exam.model.vo.exam.ExamQuDetailVO;
import com.zsy.exam.model.vo.exam.ExamQuestionListVO;
import com.zsy.exam.model.vo.exam.ExamVO;
import com.zsy.exam.model.vo.exam.MyExamDetailVO;
import com.zsy.exam.model.vo.exam.MyExamListVO;
import com.zsy.exam.model.vo.exam.OptionVO;
import com.zsy.exam.model.vo.exam.StudentRankVo;
import com.zsy.exam.model.vo.score.ExamAnalyzeVO;
import com.zsy.exam.service.IClbumService;
import com.zsy.exam.service.IExamQuAnswerService;
import com.zsy.exam.service.IExamService;
import com.zsy.exam.service.IOptionService;
import com.zsy.exam.service.IQuestionService;
import com.zsy.exam.service.IRoleService;
import com.zsy.exam.service.ISchoolService;
import com.zsy.exam.service.ISysParamService;
import com.zsy.exam.service.impl.ExamServiceImpl;
import com.zsy.exam.util.AESEncryptUtils;
import com.zsy.exam.util.MinioUtil;
import com.zsy.exam.util.SM2Utils;
import com.zsy.exam.util.SecurityUtil;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ExamServiceImpl
extends ServiceImpl<ExamMapper, Exam>
implements IExamService {
    private static final Logger log = LoggerFactory.getLogger(ExamServiceImpl.class);
    @Resource
    private ExamMapper examMapper;
    @Resource
    private ExamConverter examConverter;
    @Resource
    private IExamQuAnswerService examQuAnswerService;
    @Resource
    private QuestionMapper questionMapper;
    @Resource
    private IQuestionService questionService;
    @Resource
    private IClbumService clbumService;
    @Resource
    private ExamClbumMapper examClbumMapper;
    @Resource
    private ExamRepoMapper examRepoMapper;
    @Resource
    private ExamQuestionMapper examQuestionMapper;
    @Resource
    private OptionMapper optionMapper;
    @Resource
    private IOptionService optionService;
    @Resource
    private ExamQuAnswerMapper examQuAnswerMapper;
    @Resource
    private UserExamsScoreMapper userExamsScoreMapper;
    @Resource
    private UserBookMapper userBookMapper;
    @Resource
    private ExamQuAnswerConverter examQuAnswerConverter;
    @Resource
    private ExaminationPaperMapper examinationPaperMapper;
    @Resource
    private UserMapper userMapper;
    @Resource
    private StudentMapper studentMapper;
    @Resource
    private SubjectMapper subjectMapper;
    @Resource
    private CertificateUserMapper certificateUserMapper;
    @Resource
    private WrongQuestionBookMapper wrongQuestionBookMapper;
    @Resource
    private ManualScoreMapper manualScoreMapper;
    @Resource
    private OptionMapper OptionMapper;
    @Resource
    private ExamStudentTeacherMappingMapper examStudentTeacherMappingMapper;
    @Resource
    private MinioUtil minioUtil;
    @Resource
    private IRoleService roleService;
    @Resource
    private ISchoolService schoolService;
    @Resource
    private KafkaTemplate kafkaTemplate;
    @Autowired
    private ISysParamService sysParamService;
    private ExecutorService threadPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());

    @Transactional
    public Result<String> createExam(ExamAddForm examAddForm) {
        Exam exam = this.examConverter.formToEntity(examAddForm);
        Result result = this.examValidator(exam);
        if (Result.isFailed((Result)result).booleanValue()) {
            return result;
        }
        int examRows = this.examMapper.insert((Object)exam);
        if (examRows == 0) {
            return Result.failed((String)"\u521b\u5efa\u5931\u8d25");
        }
        List examStudentTeacherMappingList = exam.getExamStudentTeacherMappingList();
        for (ExamStudentTeacherMapping markingClbumTeacherId : examStudentTeacherMappingList) {
            ExamStudentTeacherMapping examStudentTeacherMapping = new ExamStudentTeacherMapping();
            examStudentTeacherMapping.setExamId(exam.getId());
            examStudentTeacherMapping.setUserId(markingClbumTeacherId.getUserId());
            examStudentTeacherMapping.setClbumId(markingClbumTeacherId.getClbumId());
            examStudentTeacherMapping.setStuId(markingClbumTeacherId.getStuId());
            this.examStudentTeacherMappingMapper.insert((Object)examStudentTeacherMapping);
        }
        String clbumIdsStr = examAddForm.getClbumIds();
        List<Long> clbumIds = Arrays.stream(clbumIdsStr.split(",")).map(Long::parseLong).toList();
        Integer clbumRows = this.examClbumMapper.addExamClbum(exam.getId(), clbumIds);
        if (clbumRows == 0) {
            return Result.failed((String)"\u521b\u5efa\u5931\u8d25");
        }
        return Result.success((String)"\u521b\u5efa\u6210\u529f");
    }

    public Result examValidator(Exam exam) {
        String[] clbumIdList;
        LocalDateTime now = LocalDateTime.now();
        ExaminationPaper examinationPaper = (ExaminationPaper)this.examinationPaperMapper.selectById((Serializable)exam.getExaminationPaperId());
        if (exam.getStartTime().isBefore(examinationPaper.getExamStartTime()) || exam.getEndTime().isAfter(examinationPaper.getExamEndTime())) {
            return Result.failed((String)"\u8be5\u8bd5\u5377\u6682\u65f6\u4e0d\u53ef\u7528\uff0c\u53ef\u7528\u65f6\u95f4\u4e3a\uff1a%s\u5230%s".formatted(examinationPaper.getExamStartTime(), examinationPaper.getExamEndTime()));
        }
        if (exam.getStartTime().isAfter(exam.getEndTime()) || exam.getEndTime().isBefore(exam.getStartTime())) {
            return Result.failed((String)"\u8003\u8bd5\u7684\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u9519\u8bef");
        }
        String clbumIds = exam.getClbumIds();
        for (String clbumId : clbumIdList = clbumIds.split(",")) {
            String startTime = exam.getStartTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            String endTime = exam.getEndTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            List exams = this.examMapper.selectOverlapOfExamTime(exam.getId(), clbumId, startTime, endTime);
            if (exams.size() <= 0) continue;
            Clbum clbum = (Clbum)this.clbumService.getById((Serializable)((Object)clbumId));
            Exam existsExam = (Exam)exams.get(0);
            return Result.failed((String)"\u8be5\u73ed\u7ea7\uff1a[%s]\uff0c\u5df2\u88ab\u5b89\u6392\u5230[%s]\u8003\u8bd5\u4e2d\uff0c\u8be5\u573a\u8003\u8bd5\u65f6\u95f4\u4e3a%s\u5230%s\uff0c\u65f6\u95f4\u51b2\u7a81\u4e86\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574".formatted(clbum.getClbumName(), existsExam.getTitle(), existsExam.getStartTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")), existsExam.getEndTime().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))));
        }
        Duration between = Duration.between(exam.getStartTime(), exam.getEndTime());
        long seconds = between.getSeconds();
        double minus = seconds / 60L;
        if (minus < 10.0) {
            return Result.failed((String)"\u8003\u8bd5\u65f6\u95f4\u5c0f\u4e8e\u5341\u5206\u949f");
        }
        if ((double)exam.getEarlySubmissionTime().intValue() >= minus) {
            return Result.failed((String)"\u53ef\u63d0\u524d\u4ea4\u5377\u65f6\u95f4\u5927\u4e8e\u8003\u8bd5\u65f6\u95f4");
        }
        if ((double)exam.getLateTime().intValue() > minus) {
            return Result.failed((String)"\u5141\u8bb8\u52a0\u5165\u65f6\u95f4\u5927\u4e8e\u8003\u8bd5\u65f6\u95f4");
        }
        if (exam.getLateTime() < 1) {
            return Result.failed((String)"\u5141\u8bb8\u52a0\u5165\u65f6\u95f4\u5c0f\u4e8e1\u5206\u949f");
        }
        if (exam.getPassedScore() > exam.getGrossScore()) {
            return Result.failed((String)"\u53ca\u683c\u5206\u6570\u5927\u4e8e\u603b\u5206\u6570");
        }
        return Result.success();
    }

    @Transactional
    public Result<String> updateExam(Exam exam) {
        Result result = this.examValidator(exam);
        if (Result.isFailed((Result)result).booleanValue()) {
            return result;
        }
        int examRows = this.examMapper.updateById((Object)exam);
        if (examRows == 0) {
            throw new AppException("\u4fee\u6539\u5931\u8d25");
        }
        LambdaQueryWrapper examClbumLambdaQueryWrapper = new LambdaQueryWrapper();
        examClbumLambdaQueryWrapper.eq(ExamClbum::getExamId, (Object)exam.getId());
        this.examClbumMapper.delete((Wrapper)examClbumLambdaQueryWrapper);
        String clbumIdsStr = exam.getClbumIds();
        List<Long> clbumIds = Arrays.stream(clbumIdsStr.split(",")).map(Long::parseLong).toList();
        this.examClbumMapper.addExamClbum(exam.getId(), clbumIds);
        LambdaQueryWrapper examMarkingLambdaQueryWrapper = new LambdaQueryWrapper();
        examMarkingLambdaQueryWrapper.eq(ExamStudentTeacherMapping::getExamId, (Object)exam.getId());
        this.examStudentTeacherMappingMapper.delete((Wrapper)examMarkingLambdaQueryWrapper);
        LambdaQueryWrapper examStudentTeacherMappingLambdaQueryWrapper = new LambdaQueryWrapper();
        examStudentTeacherMappingLambdaQueryWrapper.eq(ExamStudentTeacherMapping::getExamId, (Object)exam.getId());
        this.examStudentTeacherMappingMapper.delete((Wrapper)examStudentTeacherMappingLambdaQueryWrapper);
        List examStudentTeacherMappingList = exam.getExamStudentTeacherMappingList();
        for (ExamStudentTeacherMapping markingClbumTeacherId : examStudentTeacherMappingList) {
            ExamStudentTeacherMapping examStudentTeacherMapping = new ExamStudentTeacherMapping();
            examStudentTeacherMapping.setExamId(exam.getId());
            examStudentTeacherMapping.setUserId(markingClbumTeacherId.getUserId());
            examStudentTeacherMapping.setStuId(markingClbumTeacherId.getStuId());
            examStudentTeacherMapping.setClbumId(markingClbumTeacherId.getClbumId());
            this.examStudentTeacherMappingMapper.insert((Object)examStudentTeacherMapping);
        }
        return Result.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @Transactional
    public Result<String> deleteExam(String ids) {
        List<Long> examIds = Arrays.stream(ids.split(",")).map(Long::parseLong).toList();
        for (Long examId : examIds) {
            LambdaQueryWrapper examClbumLambdaQueryWrapper = new LambdaQueryWrapper();
            examClbumLambdaQueryWrapper.eq(ExamClbum::getExamId, (Object)examId);
            this.examClbumMapper.delete((Wrapper)examClbumLambdaQueryWrapper);
            LambdaQueryWrapper examStudentTeacherMappingLambdaQueryWrapper = new LambdaQueryWrapper();
            examStudentTeacherMappingLambdaQueryWrapper.eq(ExamStudentTeacherMapping::getExamId, (Object)examId);
            this.examStudentTeacherMappingMapper.delete((Wrapper)examStudentTeacherMappingLambdaQueryWrapper);
        }
        int examRows = this.examMapper.deleteExams(examIds);
        if (examRows == 0) {
            throw new AppException("\u5220\u9664\u5931\u8d25\uff0c\u5220\u9664\u8003\u8bd5\u8868\u65f6\u5931\u8d25");
        }
        return Result.success((String)"\u5220\u9664\u6210\u529f");
    }

    public Result<IPage<ExamVO>> getPagingExam(Integer pageNum, Integer pageSize, String title, Long subjectId, String examStartDate, String examEndDate) {
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        List roles = this.roleService.getCurrentRoles();
        Long userId = null;
        if (roles.contains(RoleEnum.TEACHER.getCode())) {
            userId = SecurityUtil.getUserId();
        }
        Page examVOPage = this.examMapper.selectExamPage(page, userId, title, subjectId, examStartDate, examEndDate);
        return Result.success((String)"\u67e5\u8be2\u6210\u529f", (Object)examVOPage);
    }

    public Result<ExamQuestionListVO> getQuestionList(Long examId) {
        if (!this.isUserTakingExam(examId)) {
            return Result.failed((String)"\u6ca1\u6709\u8003\u8bd5\u5728\u8fdb\u884c");
        }
        ExamQuestionListVO examQuestionListVO = new ExamQuestionListVO();
        Exam byId = (Exam)this.getById((Serializable)examId);
        examQuestionListVO.setExamDuration(byId.getExamDuration());
        LambdaQueryWrapper userExamsScoreLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)userExamsScoreLambdaQueryWrapper.eq(UserExamsScore::getUserId, (Object)SecurityUtil.getUserId())).eq(UserExamsScore::getExamId, (Object)examId)).eq(UserExamsScore::getState, (Object)0);
        UserExamsScore userExamsScore = (UserExamsScore)this.userExamsScoreMapper.selectOne((Wrapper)userExamsScoreLambdaQueryWrapper);
        if (userExamsScore == null) {
            throw new RuntimeException("\u6ca1\u6709\u5f00\u59cb\u8003\u8bd5\uff0c\u8bf7\u5f00\u59cb\u8003\u8bd5");
        }
        Calendar cl = Calendar.getInstance();
        LocalDateTime createTime = userExamsScore.getCreateTime();
        if (createTime == null) {
            return Result.failed((String)"\u9519\u8bef");
        }
        Date date = Date.from(createTime.atZone(ZoneId.systemDefault()).toInstant());
        cl.setTime(date);
        cl.add(12, byId.getExamDuration());
        long leftSeconds = (cl.getTimeInMillis() - System.currentTimeMillis()) / 1000L;
        if (leftSeconds < 0L) {
            throw new RuntimeException("\u5df2\u8d85\u8fc7\u8003\u8bd5\u65f6\u95f4");
        }
        examQuestionListVO.setLeftSeconds(Long.valueOf(leftSeconds));
        List questionDetailList = this.examMapper.selectQuestionDetailList(examId, SecurityUtil.getUserId());
        examQuestionListVO.setQuestionList(questionDetailList);
        return Result.success((String)"\u67e5\u8be2\u6210\u529f", (Object)examQuestionListVO);
    }

    public Result<List<ExamQuDetailVO>> getQuestionSingleList(Long examId) {
        if (!this.isUserTakingExam(examId)) {
            return Result.failed((String)"\u6ca1\u6709\u8003\u8bd5\u5728\u8fdb\u884c");
        }
        Long userId = SecurityUtil.getUserId();
        List examQuDetailVOS = this.examMapper.selectQuestionSingleList(examId, userId);
        if (examQuDetailVOS == null || examQuDetailVOS.size() < 1) {
            return Result.failed((String)"\u83b7\u53d6\u8bd5\u9898\u5931\u8d25");
        }
        examQuDetailVOS.parallelStream().forEach(a -> {
            Long quId = a.getQuId();
            List forExam = this.optionMapper.getForExam(quId, a.getTypeId(), examId, userId);
            a.setAnswerList(forExam);
        });
        return Result.success((String)"\u83b7\u53d6\u6210\u529f", (Object)examQuDetailVOS);
    }

    public Result<ExamQuDetailVO> getQuestionSingle(Long examId, Long questionId) {
        if (!this.isUserTakingExam(examId)) {
            return Result.failed((String)"\u6ca1\u6709\u8003\u8bd5\u5728\u8fdb\u884c");
        }
        Exam exam = (Exam)this.getById((Serializable)examId);
        ExamQuDetailVO examQuDetailVO = new ExamQuDetailVO();
        QuestionAndMisc quById = this.questionService.getQuestion(exam.getExaminationPaperId(), questionId);
        if (quById == null) {
            return Result.failed((String)"\u83b7\u53d6\u8bd5\u9898\u5931\u8d25");
        }
        examQuDetailVO.setImage(quById.getImage());
        examQuDetailVO.setContent(quById.getContent());
        examQuDetailVO.setQuType(quById.getQuType());
        examQuDetailVO.setSort(quById.getSort());
        examQuDetailVO.setPoint(quById.getPoint());
        LambdaQueryWrapper optionLambdaQuery = new LambdaQueryWrapper();
        optionLambdaQuery.eq(Option::getQuId, (Object)questionId);
        List list = this.optionMapper.selectList((Wrapper)optionLambdaQuery);
        List optionVOS = this.examConverter.opListEntityToVO(list);
        for (OptionVO option : optionVOS) {
            LambdaQueryWrapper examQuAnswerLambdaQueryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)examQuAnswerLambdaQueryWrapper.eq(ExamQuAnswer::getQuestionId, (Object)option.getQuId())).eq(ExamQuAnswer::getExamId, (Object)examId)).eq(ExamQuAnswer::getUserId, (Object)SecurityUtil.getUserId());
            List examQuAnswers = this.examQuAnswerMapper.selectList((Wrapper)examQuAnswerLambdaQueryWrapper);
            if (examQuAnswers.size() > 0) {
                for (ExamQuAnswer userAnwser : examQuAnswers) {
                    QuestionTypeEnum questionType = userAnwser.getQuestionType();
                    String answerId = userAnwser.getAnswerId();
                    String answerContent = userAnwser.getAnswerContent();
                    String idstr = option.getId().toString();
                    switch (1.$SwitchMap$com$zsy$exam$constant$QuestionTypeEnum[questionType.ordinal()]) {
                        case 1: 
                        case 2: {
                            if (answerId.equals(idstr)) {
                                option.setCheckout(Boolean.valueOf(true));
                                break;
                            }
                            option.setCheckout(Boolean.valueOf(false));
                            break;
                        }
                        case 3: {
                            List<Long> quIds = Arrays.stream(userAnwser.getAnswerId().split(",")).map(Long::parseLong).toList();
                            if (quIds.contains(option.getId())) {
                                option.setCheckout(Boolean.valueOf(true));
                                break;
                            }
                            option.setCheckout(Boolean.valueOf(false));
                            break;
                        }
                        default: {
                            if (StringUtils.isNotBlank((CharSequence)answerContent)) {
                                option.setCheckout(Boolean.valueOf(true));
                            }
                            option.setContent(answerContent);
                        }
                    }
                }
            }
            examQuDetailVO.setAnswerList(optionVOS);
        }
        return Result.success((String)"\u83b7\u53d6\u6210\u529f", (Object)examQuDetailVO);
    }

    public Result<List<ExamQuCollectVO>> getCollect(Long examId, Integer isRight) {
        Long userId = SecurityUtil.getUserId();
        return this.getCollect0(examId, isRight, userId, Boolean.valueOf(false));
    }

    public Result<List<ExamQuCollectVO>> getCollect0(Long examId, Integer isRight, Long userId, Boolean onlySubjective) {
        Exam exam = (Exam)((ExamMapper)this.baseMapper).selectById((Serializable)examId);
        LocalDateTime nowTime = LocalDateTime.now();
        if (exam.getEndTime().isAfter(nowTime)) {
            return Result.failed((String)"\u8003\u8bd5\u8fd8\u6ca1\u7ed3\u675f,\u65e0\u6cd5\u67e5\u770b\u8003\u8bd5\u8be6\u7ec6");
        }
        ArrayList<ExamQuCollectVO> examQuCollectVOS = new ArrayList<ExamQuCollectVO>();
        List questions = this.examMapper.selectQuestionList(examId, onlySubjective);
        for (ExamQuestionAndPoint temp : questions) {
            ExamQuCollectVO examQuCollectVO = new ExamQuCollectVO();
            examQuCollectVO.setQuId(temp.getId());
            examQuCollectVO.setTitle(temp.getContent());
            examQuCollectVO.setQuType(QuestionTypeEnum.getByType((String)temp.getQuType()));
            examQuCollectVO.setPoint(temp.getPoint());
            examQuCollectVO.setAnalysis(temp.getAnalysis());
            LambdaQueryWrapper optionWrapper = new LambdaQueryWrapper();
            optionWrapper.eq(Option::getQuId, (Object)temp.getId());
            List options = this.optionMapper.selectList((Wrapper)optionWrapper);
            examQuCollectVO.setOption(options);
            LambdaQueryWrapper examQuAnswerWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)((LambdaQueryWrapper)examQuAnswerWrapper.eq(ExamQuAnswer::getUserId, (Object)userId)).eq(ExamQuAnswer::getExamId, (Object)examId)).eq(ExamQuAnswer::getQuestionId, (Object)temp.getId());
            ExamQuAnswer examQuAnswer = (ExamQuAnswer)this.examQuAnswerMapper.selectOne((Wrapper)examQuAnswerWrapper);
            if (examQuAnswer == null) {
                examQuCollectVO.setIsMiss(Boolean.valueOf(true));
                if (isRight != null && isRight == 0) {
                    examQuCollectVO.setIsRight(Integer.valueOf(0));
                    examQuCollectVO.setScore(new BigDecimal(0));
                    examQuCollectVOS.add(examQuCollectVO);
                }
                if (isRight != null) continue;
                examQuCollectVO.setIsRight(Integer.valueOf(0));
                examQuCollectVO.setScore(new BigDecimal(0));
                examQuCollectVOS.add(examQuCollectVO);
                continue;
            }
            examQuCollectVO.setIsMiss(Boolean.valueOf(false));
            examQuCollectVO.setIsRight(examQuAnswer.getIsRight());
            if (isRight != null && !examQuAnswer.getIsRight().equals(isRight)) continue;
            switch (1.$SwitchMap$com$zsy$exam$constant$QuestionTypeEnum[QuestionTypeEnum.getByType((String)temp.getQuType()).ordinal()]) {
                case 1: {
                    LambdaQueryWrapper optionLambdaQueryWrapper = new LambdaQueryWrapper();
                    optionLambdaQueryWrapper.eq(Option::getId, (Object)examQuAnswer.getAnswerId());
                    Option op1 = (Option)this.optionMapper.selectOne((Wrapper)optionLambdaQueryWrapper);
                    examQuCollectVO.setMyOption(examQuAnswer.getAnswerId());
                    if (examQuAnswer.getIsRight() == 1) {
                        examQuCollectVO.setScore(examQuAnswer.getPoint());
                        break;
                    }
                    examQuCollectVO.setScore(new BigDecimal(0));
                    break;
                }
                case 3: {
                    String answerId = examQuAnswer.getAnswerId();
                    List<Long> opIds = Arrays.stream(answerId.split(",")).map(Long::parseLong).toList();
                    ArrayList<Integer> sorts = new ArrayList<Integer>();
                    for (Long opId : opIds) {
                        LambdaQueryWrapper optionLambdaQueryWrapper = new LambdaQueryWrapper();
                        optionLambdaQueryWrapper.eq(Option::getId, (Object)opId);
                        Option option = (Option)this.optionMapper.selectOne((Wrapper)optionLambdaQueryWrapper);
                        sorts.add(option.getSort());
                    }
                    List shortList = sorts.stream().map(String::valueOf).collect(Collectors.toList());
                    String myOption = String.join((CharSequence)",", shortList);
                    examQuCollectVO.setMyOption(examQuAnswer.getAnswerId());
                    if (examQuAnswer.getIsRight() == 1) {
                        examQuCollectVO.setScore(examQuAnswer.getPoint());
                        break;
                    }
                    examQuCollectVO.setScore(new BigDecimal(0));
                    break;
                }
                case 2: {
                    LambdaQueryWrapper optionLambdaQueryWrapper = new LambdaQueryWrapper();
                    optionLambdaQueryWrapper.eq(Option::getId, (Object)examQuAnswer.getAnswerId());
                    Option op1 = (Option)this.optionMapper.selectOne((Wrapper)optionLambdaQueryWrapper);
                    examQuCollectVO.setMyOption(examQuAnswer.getAnswerId());
                    if (examQuAnswer.getIsRight() == 1) {
                        examQuCollectVO.setScore(examQuAnswer.getPoint());
                        break;
                    }
                    examQuCollectVO.setScore(new BigDecimal(0));
                    break;
                }
                default: {
                    LambdaQueryWrapper optionLambdaQueryWrapper = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)optionLambdaQueryWrapper.eq(ManualScore::getExamQuAnswerId, (Object)examQuAnswer.getId())).eq(ManualScore::getUserId, (Object)userId);
                    ManualScore manualScore = (ManualScore)this.manualScoreMapper.selectOne((Wrapper)optionLambdaQueryWrapper);
                    if (manualScore != null) {
                        examQuCollectVO.setScore(manualScore.getScore());
                        examQuCollectVO.setComments(manualScore.getComments());
                    }
                    examQuCollectVO.setMyOption(examQuAnswer.getAnswerContent());
                }
            }
            examQuCollectVOS.add(examQuCollectVO);
        }
        return Result.success((String)"\u67e5\u8be2\u6210\u529f", examQuCollectVOS);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Result<ExamDetailVO> getDetail(Long examId) {
        Exam exam = (Exam)this.getById((Serializable)examId);
        LambdaQueryWrapper examClbumLambdaQueryWrapper = new LambdaQueryWrapper();
        examClbumLambdaQueryWrapper.eq(ExamClbum::getExamId, (Object)examId);
        List examClbums = this.examClbumMapper.selectList((Wrapper)examClbumLambdaQueryWrapper);
        ExamDetailVO examDetailVO = this.examConverter.examToExamDetailVO(exam);
        LambdaQueryWrapper examStudentTeacherMappingLambdaQueryWrapper = new LambdaQueryWrapper();
        examStudentTeacherMappingLambdaQueryWrapper.eq(ExamStudentTeacherMapping::getExamId, (Object)examId);
        List examStudentTeacherMappings = this.examStudentTeacherMappingMapper.selectList((Wrapper)examStudentTeacherMappingLambdaQueryWrapper);
        examDetailVO.setExamStudentTeacherMappingList(examStudentTeacherMappings);
        LambdaQueryWrapper userLambdaQueryWrapper = new LambdaQueryWrapper();
        userLambdaQueryWrapper.eq(User::getId, (Object)examDetailVO.getUserId());
        User user = (User)this.userMapper.selectOne((Wrapper)userLambdaQueryWrapper);
        examDetailVO.setUsername(user.getUserName());
        LambdaQueryWrapper userExamsScoreLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)userExamsScoreLambdaQueryWrapper.eq(UserExamsScore::getUserId, (Object)SecurityUtil.getUserId())).eq(UserExamsScore::getExamId, (Object)examId);
        UserExamsScore examsScore = (UserExamsScore)this.userExamsScoreMapper.selectOne((Wrapper)userExamsScoreLambdaQueryWrapper);
        if (examsScore != null) {
            examDetailVO.setIsAttend(examsScore.getIsAttend());
            examDetailVO.setExamCount(examsScore.getCount());
            if (examsScore.getState().equals(0)) {
                examDetailVO.setExamStatus(Integer.valueOf(0));
            } else {
                if (!examsScore.getState().equals(1)) throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u8003\u8bd5\u72b6\u6001");
                examDetailVO.setExamStatus(Integer.valueOf(1));
            }
        } else {
            examDetailVO.setExamStatus(Integer.valueOf(-1));
        }
        if (examClbums.isEmpty()) return Result.success((String)"\u67e5\u8be2\u6210\u529f", (Object)examDetailVO);
        List clbumIds = examClbums.stream().map(e -> e.getClbumId().toString()).collect(Collectors.toList());
        examDetailVO.setClbumIds(String.join((CharSequence)",", clbumIds));
        return Result.success((String)"\u67e5\u8be2\u6210\u529f", (Object)examDetailVO);
    }

    public Result<Integer> addCheat(Long examId) {
        LambdaQueryWrapper userExamsScoreLambdaQuery = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)userExamsScoreLambdaQuery.eq(UserExamsScore::getExamId, (Object)examId)).eq(UserExamsScore::getUserId, (Object)SecurityUtil.getUserId());
        UserExamsScore userExamsScore = (UserExamsScore)this.userExamsScoreMapper.selectOne((Wrapper)userExamsScoreLambdaQuery);
        Exam exam = (Exam)this.getById((Serializable)examId);
        if (userExamsScore.getCount() > exam.getMaxCount()) {
            this.handExam0(examId, SecurityUtil.getUserId(), Boolean.valueOf(false));
            return Result.success((String)"\u5df2\u8d85\u8fc7\u6700\u5927\u5207\u5c4f\u6b21\u6570\uff0c\u5df2\u81ea\u52a8\u4ea4\u5377", (Object)1);
        }
        LambdaUpdateWrapper userExamsScoreLambdaUpdateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)userExamsScoreLambdaUpdateWrapper.eq(UserExamsScore::getExamId, (Object)examId)).eq(UserExamsScore::getUserId, (Object)SecurityUtil.getUserId())).set(UserExamsScore::getCount, (Object)(userExamsScore.getCount() + 1));
        int insert = this.userExamsScoreMapper.update((Wrapper)userExamsScoreLambdaUpdateWrapper);
        return Result.success((String)("\u8bf7\u52ff\u5207\u5c4f\uff0c\u6700\u5927\u5207\u5c4f\u6b21\u6570\uff1a" + exam.getMaxCount() + ",\u5df2\u5207\u5c4f\u6b21\u6570:" + (userExamsScore.getCount() + 1)), (Object)0);
    }

    public Result<String> addAnswer(ExamQuAnswerAddForm examQuAnswerForm) {
        if (!this.isUserTakingExam(examQuAnswerForm.getExamId())) {
            return Result.failed((String)"\u6ca1\u6709\u8003\u8bd5\u5728\u8fdb\u884c");
        }
        if (StringUtils.isBlank((CharSequence)examQuAnswerForm.getAnswer()) && StringUtils.isBlank((CharSequence)examQuAnswerForm.getAnswerId())) {
            return Result.failed((String)"\u6ca1\u6709\u7b54\u6848");
        }
        LambdaQueryWrapper QuWrapper = new LambdaQueryWrapper();
        QuWrapper.eq(Question::getId, (Object)examQuAnswerForm.getQuId());
        Question qu = (Question)this.questionMapper.selectOne((Wrapper)QuWrapper);
        QuestionTypeEnum quType = QuestionTypeEnum.getByType((String)qu.getQuType());
        if (QuestionTypeEnum.getObjective().contains(qu.getQuType())) {
            if (this.questionMapper.optionExists(examQuAnswerForm.getQuId(), examQuAnswerForm.getAnswerId()) <= 0) {
                return Result.failed((String)"\u56de\u7b54\u7684\u7b54\u6848Id\u9519\u8bef");
            }
        } else if (StringUtils.isBlank((CharSequence)examQuAnswerForm.getAnswer())) {
            return Result.failed((String)"\u56de\u7b54\u7684\u7b54\u6848\u5185\u5bb9\u4e3a\u7a7a");
        }
        LambdaQueryWrapper examQuAnswerLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)examQuAnswerLambdaQueryWrapper.eq(ExamQuAnswer::getExamId, (Object)examQuAnswerForm.getExamId())).eq(ExamQuAnswer::getQuestionId, (Object)examQuAnswerForm.getQuId())).eq(ExamQuAnswer::getUserId, (Object)SecurityUtil.getUserId());
        List existingAnswers = this.examQuAnswerMapper.selectList((Wrapper)examQuAnswerLambdaQueryWrapper);
        if (!existingAnswers.isEmpty()) {
            return this.updateAnswerIfExists(examQuAnswerForm, quType);
        }
        return this.insertNewAnswer(examQuAnswerForm, quType);
    }

    public Result<String> insertNewAnswer(ExamQuAnswerAddForm examQuAnswerForm, QuestionTypeEnum quType) {
        ExamQuAnswer examQuAnswer = this.prepareExamQuAnswer(examQuAnswerForm, quType);
        return switch (1.$SwitchMap$com$zsy$exam$constant$QuestionTypeEnum[quType.ordinal()]) {
            case 1 -> {
                Option byId = (Option)this.optionService.getById((Serializable)((Object)examQuAnswerForm.getAnswerId()));
                if (byId.getIsRight() == 1) {
                    examQuAnswer.setIsRight(Integer.valueOf(1));
                    this.examQuAnswerMapper.insert((Object)examQuAnswer);
                    yield Result.success((String)"\u8bf7\u6c42\u6210\u529f");
                }
                examQuAnswer.setIsRight(Integer.valueOf(0));
                this.examQuAnswerMapper.insert((Object)examQuAnswer);
                yield Result.success((String)"\u8bf7\u6c42\u6210\u529f");
            }
            case 3 -> {
                LambdaQueryWrapper optionWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)optionWrapper.eq(Option::getIsRight, (Object)1)).eq(Option::getQuId, (Object)examQuAnswerForm.getQuId());
                List examQuAnswers = this.optionMapper.selectList((Wrapper)optionWrapper);
                List quIds = Arrays.stream(examQuAnswerForm.getAnswerId().split(",")).map(Long::parseLong).collect(Collectors.toList());
                List userAnswerIds = examQuAnswers.stream().map(e -> e.getId()).collect(Collectors.toList());
                Collections.sort(userAnswerIds);
                Collections.sort(quIds);
                if (!quIds.equals(userAnswerIds)) {
                    examQuAnswer.setIsRight(Integer.valueOf(0));
                    this.examQuAnswerMapper.insert((Object)examQuAnswer);
                    yield Result.success((String)"\u8bf7\u6c42\u6210\u529f");
                }
                examQuAnswer.setIsRight(Integer.valueOf(1));
                this.examQuAnswerMapper.insert((Object)examQuAnswer);
                yield Result.success((String)"\u8bf7\u6c42\u6210\u529f");
            }
            case 2 -> {
                Option byId = (Option)this.optionService.getById((Serializable)((Object)examQuAnswerForm.getAnswerId()));
                if (byId.getIsRight() == 1) {
                    examQuAnswer.setIsRight(Integer.valueOf(1));
                    this.examQuAnswerMapper.insert((Object)examQuAnswer);
                    yield Result.success((String)"\u8bf7\u6c42\u6210\u529f");
                }
                examQuAnswer.setIsRight(Integer.valueOf(0));
                this.examQuAnswerMapper.insert((Object)examQuAnswer);
                yield Result.success((String)"\u8bf7\u6c42\u6210\u529f");
            }
            default -> {
                examQuAnswer.setAnswerContent(examQuAnswerForm.getAnswer());
                this.examQuAnswerMapper.insert((Object)examQuAnswer);
                yield Result.success((String)"\u8bf7\u6c42\u6210\u529f");
            }
        };
    }

    public Result<String> updateAnswerIfExists(ExamQuAnswerAddForm examQuAnswerForm, QuestionTypeEnum quType) {
        return switch (1.$SwitchMap$com$zsy$exam$constant$QuestionTypeEnum[quType.ordinal()]) {
            case 1 -> {
                Option byId = (Option)this.optionService.getById((Serializable)((Object)examQuAnswerForm.getAnswerId()));
                if (byId == null) {
                    yield Result.failed((String)"\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u8be5\u8bd5\u9898\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u89e3\u51b3");
                }
                if (byId.getIsRight() == 1) {
                    LambdaUpdateWrapper examQuAnswerWrapper = new LambdaUpdateWrapper();
                    ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)examQuAnswerWrapper.eq(ExamQuAnswer::getUserId, (Object)SecurityUtil.getUserId())).eq(ExamQuAnswer::getExamId, (Object)examQuAnswerForm.getExamId())).eq(ExamQuAnswer::getQuestionId, (Object)examQuAnswerForm.getQuId())).set(ExamQuAnswer::getIsRight, (Object)1)).set(ExamQuAnswer::getAnswerId, (Object)examQuAnswerForm.getAnswerId());
                    this.examQuAnswerMapper.update((Wrapper)examQuAnswerWrapper);
                    yield Result.success((String)"\u8bf7\u6c42\u6210\u529f");
                }
                LambdaUpdateWrapper examQuAnswerLambdaUpdateWrapper = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)examQuAnswerLambdaUpdateWrapper.eq(ExamQuAnswer::getUserId, (Object)SecurityUtil.getUserId())).eq(ExamQuAnswer::getExamId, (Object)examQuAnswerForm.getExamId())).eq(ExamQuAnswer::getQuestionId, (Object)examQuAnswerForm.getQuId())).set(ExamQuAnswer::getIsRight, (Object)0)).set(ExamQuAnswer::getAnswerId, (Object)examQuAnswerForm.getAnswerId());
                this.examQuAnswerMapper.update((Wrapper)examQuAnswerLambdaUpdateWrapper);
                yield Result.success((String)"\u8bf7\u6c42\u6210\u529f");
            }
            case 3 -> {
                LambdaQueryWrapper optionWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)optionWrapper.eq(Option::getIsRight, (Object)1)).eq(Option::getQuId, (Object)examQuAnswerForm.getQuId());
                List examQuAnswers = this.optionMapper.selectList((Wrapper)optionWrapper);
                if (examQuAnswers.isEmpty()) {
                    yield Result.failed((String)"\u8be5\u9898\u6b63\u786e\u7b54\u6848\u9009\u9879\u4e0d\u5b58\u5728");
                }
                List quIds = Arrays.stream(examQuAnswerForm.getAnswerId().split(",")).map(Long::parseLong).collect(Collectors.toList());
                List userAnswerIds = examQuAnswers.stream().map(e -> e.getId()).collect(Collectors.toList());
                Collections.sort(userAnswerIds);
                Collections.sort(quIds);
                if (!quIds.equals(userAnswerIds)) {
                    LambdaUpdateWrapper examQuAnswerWrapper = new LambdaUpdateWrapper();
                    ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)examQuAnswerWrapper.eq(ExamQuAnswer::getUserId, (Object)SecurityUtil.getUserId())).eq(ExamQuAnswer::getExamId, (Object)examQuAnswerForm.getExamId())).eq(ExamQuAnswer::getQuestionId, (Object)examQuAnswerForm.getQuId())).set(ExamQuAnswer::getIsRight, (Object)0)).set(ExamQuAnswer::getAnswerId, (Object)examQuAnswerForm.getAnswerId());
                    this.examQuAnswerMapper.update((Wrapper)examQuAnswerWrapper);
                    yield Result.success((String)"\u8bf7\u6c42\u6210\u529f");
                }
                LambdaUpdateWrapper examQuAnswerWrapper = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)examQuAnswerWrapper.eq(ExamQuAnswer::getUserId, (Object)SecurityUtil.getUserId())).eq(ExamQuAnswer::getExamId, (Object)examQuAnswerForm.getExamId())).eq(ExamQuAnswer::getQuestionId, (Object)examQuAnswerForm.getQuId())).set(ExamQuAnswer::getIsRight, (Object)1)).set(ExamQuAnswer::getAnswerId, (Object)examQuAnswerForm.getAnswerId());
                this.examQuAnswerMapper.update((Wrapper)examQuAnswerWrapper);
                yield Result.success((String)"\u8bf7\u6c42\u6210\u529f");
            }
            case 2 -> {
                Option byId = (Option)this.optionService.getById((Serializable)((Object)examQuAnswerForm.getAnswerId()));
                if (byId == null) {
                    yield Result.failed((String)"\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728\u8be5\u8bd5\u9898\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u89e3\u51b3");
                }
                if (byId.getIsRight() == 1) {
                    LambdaUpdateWrapper examQuAnswerWrapper = new LambdaUpdateWrapper();
                    ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)examQuAnswerWrapper.eq(ExamQuAnswer::getUserId, (Object)SecurityUtil.getUserId())).eq(ExamQuAnswer::getExamId, (Object)examQuAnswerForm.getExamId())).eq(ExamQuAnswer::getQuestionId, (Object)examQuAnswerForm.getQuId())).set(ExamQuAnswer::getIsRight, (Object)1)).set(ExamQuAnswer::getAnswerId, (Object)examQuAnswerForm.getAnswerId());
                    this.examQuAnswerMapper.update((Wrapper)examQuAnswerWrapper);
                    yield Result.success((String)"\u8bf7\u6c42\u6210\u529f");
                }
                LambdaUpdateWrapper examQuAnswerLambdaUpdateWrapper = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)examQuAnswerLambdaUpdateWrapper.eq(ExamQuAnswer::getUserId, (Object)SecurityUtil.getUserId())).eq(ExamQuAnswer::getExamId, (Object)examQuAnswerForm.getExamId())).eq(ExamQuAnswer::getQuestionId, (Object)examQuAnswerForm.getQuId())).set(ExamQuAnswer::getIsRight, (Object)0)).set(ExamQuAnswer::getAnswerId, (Object)examQuAnswerForm.getAnswerId());
                this.examQuAnswerMapper.update((Wrapper)examQuAnswerLambdaUpdateWrapper);
                yield Result.success((String)"\u8bf7\u6c42\u6210\u529f");
            }
            default -> {
                LambdaUpdateWrapper examQuAnswerLambdaUpdateWrapper = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)examQuAnswerLambdaUpdateWrapper.eq(ExamQuAnswer::getUserId, (Object)SecurityUtil.getUserId())).eq(ExamQuAnswer::getExamId, (Object)examQuAnswerForm.getExamId())).eq(ExamQuAnswer::getQuestionId, (Object)examQuAnswerForm.getQuId())).set(ExamQuAnswer::getAnswerContent, (Object)examQuAnswerForm.getAnswer());
                this.examQuAnswerMapper.update((Wrapper)examQuAnswerLambdaUpdateWrapper);
                yield Result.success((String)"\u8bf7\u6c42\u6210\u529f");
            }
        };
    }

    public ExamQuAnswer prepareExamQuAnswer(ExamQuAnswerAddForm form, QuestionTypeEnum quType) {
        ExamQuAnswer examQuAnswer = this.examQuAnswerConverter.formToEntity(form);
        if (!QuestionTypeEnum.getObjective().contains(quType.getType())) {
            examQuAnswer.setAnswerContent(form.getAnswer());
        } else {
            examQuAnswer.setAnswerId(form.getAnswerId());
        }
        examQuAnswer.setUserId(SecurityUtil.getUserId());
        examQuAnswer.setQuestionType(quType);
        examQuAnswer.setPoint(form.getPoint());
        return examQuAnswer;
    }

    public boolean isUserTakingExam(Long examId) {
        LambdaQueryWrapper userExamsScoreLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)userExamsScoreLambdaQueryWrapper.eq(UserExamsScore::getUserId, (Object)SecurityUtil.getUserId())).eq(UserExamsScore::getExamId, (Object)examId)).eq(UserExamsScore::getState, (Object)0);
        List userExamsScores = this.userExamsScoreMapper.selectList((Wrapper)userExamsScoreLambdaQueryWrapper);
        return userExamsScores.size() != 0;
    }

    public boolean isUserTakingExam(Long examId, Long userId) {
        LambdaQueryWrapper userExamsScoreLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)userExamsScoreLambdaQueryWrapper.eq(UserExamsScore::getUserId, (Object)userId)).eq(UserExamsScore::getExamId, (Object)examId)).eq(UserExamsScore::getState, (Object)0);
        List userExamsScores = this.userExamsScoreMapper.selectList((Wrapper)userExamsScoreLambdaQueryWrapper);
        return userExamsScores.size() != 0;
    }

    public Result<IPage<ExamClbumListVO>> getClbumExamList(Integer pageNum, Integer pageSize, String title) {
        Page examPage = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        List roles = this.roleService.getCurrentRoles();
        if (roles.contains(RoleEnum.STUDENT.getCode())) {
            examPage = this.examClbumMapper.selectClassExam((IPage)examPage, SecurityUtil.getUserId(), title);
        } else if (roles.contains(RoleEnum.ADMIN.getCode()) || roles.contains(RoleEnum.SUPER_ADMIN.getCode())) {
            examPage = this.examClbumMapper.selectAdminClassExam((IPage)examPage, title);
        }
        return Result.success((String)"\u67e5\u8be2\u6210\u529f", (Object)examPage);
    }

    @Scheduled(fixedDelay=10000L)
    public void autoHandExamByNotCommit() {
        List notAttendExamList;
        ArrayList array = new ArrayList();
        List notHandExamList = this.examMapper.getNotHandExamList();
        if (notHandExamList != null && notHandExamList.size() > 0) {
            array.addAll(notHandExamList);
        }
        if ((notAttendExamList = this.examMapper.getNotAttendExamList()) != null && notAttendExamList.size() > 0) {
            array.addAll(notAttendExamList);
        }
        for (NotHandExam notHandExam : array) {
            try {
                Result result = this.handExam0(notHandExam.getExamId(), notHandExam.getUserId(), Boolean.valueOf(true));
            }
            catch (Exception e) {
                log.error("\u81ea\u52a8\u4ea4\u5377\u51fa\u9519\uff01", (Throwable)e);
            }
        }
    }

    public Result<ExamHandSimpleReportVO> handExam(Long examId) {
        Long userId = SecurityUtil.getUserId();
        return this.handExam0(examId, userId, Boolean.valueOf(false));
    }

    @Transactional
    public Result<ExamHandSimpleReportVO> handExam0(Long examId, Long userId, Boolean isAuto) {
        if (!this.isUserTakingExam(examId, userId) && !isAuto.booleanValue()) {
            return Result.failed((String)"\u6ca1\u6709\u8003\u8bd5\u5728\u8fdb\u884c");
        }
        LocalDateTime nowTime = LocalDateTime.now();
        Exam examOne = (Exam)this.getById((Serializable)examId);
        if (!examOne.getEnable().booleanValue()) {
            return Result.failed((String)"\u8003\u8bd5\u5904\u4e8e\u672a\u5f00\u653e\u72b6\u6001");
        }
        LocalDateTime endTime = examOne.getEndTime();
        if (!isAuto.booleanValue()) {
            if (endTime.isBefore(nowTime)) {
                return Result.failed((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u5df2\u8fc7\u4ea4\u5377\u65f6\u95f4");
            }
            LocalDateTime canHandleExamTime = endTime.minusMinutes(examOne.getEarlySubmissionTime().intValue());
            if (canHandleExamTime.isAfter(nowTime)) {
                if (examOne.getEarlySubmissionTime() != null && examOne.getEarlySubmissionTime() > 0) {
                    return Result.failed((String)("\u63d0\u4ea4\u5931\u8d25\uff0c\u53ef\u4ee5\u63d0\u524d" + examOne.getEarlySubmissionTime() + "\u5206\u949f\u4ea4\u5377,\u53ef\u4ee5\u4ea4\u5377\u65f6\u95f4\u4e3a\uff1a" + canHandleExamTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))));
                }
                return Result.failed((String)"\u63d0\u4ea4\u5931\u8d25\uff0c\u65e0\u6cd5\u63d0\u524d\u4ea4\u5377\uff0c\u5c06\u81ea\u52a8\u4ea4\u5377");
            }
        }
        LambdaQueryWrapper userExamsScoreLambdaQuery = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)userExamsScoreLambdaQuery.eq(UserExamsScore::getExamId, (Object)examId)).eq(UserExamsScore::getUserId, (Object)userId);
        Boolean isExistExamRecord = this.userExamsScoreMapper.exists((Wrapper)userExamsScoreLambdaQuery);
        if (!isExistExamRecord.booleanValue()) {
            UserExamsScore userExamsScore = new UserExamsScore();
            userExamsScore.setExamId(examId);
            userExamsScore.setTotalTime(examOne.getExamDuration());
            userExamsScore.setState(Integer.valueOf(1));
            userExamsScore.setCount(Integer.valueOf(1));
            userExamsScore.setUserId(userId);
            userExamsScore.setExamId(examId);
            userExamsScore.setCreateTime(nowTime);
            userExamsScore.setUserTime(Integer.valueOf(0));
            userExamsScore.setSubjectiveScore(new BigDecimal(0));
            userExamsScore.setObjectiveScore(new BigDecimal(0));
            userExamsScore.setUserScore(new BigDecimal(0));
            userExamsScore.setIsAttend(Boolean.valueOf(false));
            int rows = this.userExamsScoreMapper.insert((Object)userExamsScore);
            if (rows == 0) {
                return Result.failed((String)"\u589e\u52a0\u8003\u8bd5\u8bb0\u5f55\u5931\u8d25");
            }
        }
        LambdaQueryWrapper userExamsScoreLambdaQueryWrapper1 = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)userExamsScoreLambdaQueryWrapper1.eq(UserExamsScore::getExamId, (Object)examId)).eq(UserExamsScore::getUserId, (Object)userId);
        UserExamsScore userExamsScore = (UserExamsScore)this.userExamsScoreMapper.selectOne((Wrapper)userExamsScoreLambdaQueryWrapper1);
        userExamsScore.setUserScore(new BigDecimal(0));
        userExamsScore.setState(Integer.valueOf(1));
        LambdaQueryWrapper examQuAnswerLambdaQuery = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)examQuAnswerLambdaQuery.eq(ExamQuAnswer::getUserId, (Object)userId)).eq(ExamQuAnswer::getExamId, (Object)examId);
        List examQuAnswer = this.examQuAnswerMapper.selectList((Wrapper)examQuAnswerLambdaQuery);
        HashSet<WrongQuestionBook> userBookArraySet = new HashSet<WrongQuestionBook>();
        for (Object temp : examQuAnswer) {
            if (!QuestionTypeEnum.getObjective().contains(temp.getQuestionType().getType())) continue;
            if (temp.getIsRight() == 1) {
                if (temp.getQuestionType() == QuestionTypeEnum.SINGLE) {
                    userExamsScore.setUserScore(userExamsScore.getUserScore().add(temp.getPoint()));
                    continue;
                }
                if (temp.getQuestionType() == QuestionTypeEnum.MULTI) {
                    userExamsScore.setUserScore(userExamsScore.getUserScore().add(temp.getPoint()));
                    continue;
                }
                if (temp.getQuestionType() != QuestionTypeEnum.JUDGE) continue;
                userExamsScore.setUserScore(userExamsScore.getUserScore().add(temp.getPoint()));
                continue;
            }
            if (temp.getIsRight() == 0) {
                Question question = (Question)this.questionMapper.selectById((Serializable)temp.getQuestionId());
                Long examinationPaperId = examOne.getExaminationPaperId();
                ExaminationPaper examinationPaper = (ExaminationPaper)this.examinationPaperMapper.selectById((Serializable)examinationPaperId);
                WrongQuestionBook userBook = new WrongQuestionBook();
                if (question.getMainCombinationId() != null) {
                    question = (Question)this.questionMapper.selectById((Serializable)question.getMainCombinationId());
                }
                userBook.setType(Integer.valueOf(1));
                userBook.setUserId(userId);
                userBook.setSubjectCode(examinationPaper.getSubjectCode());
                userBook.setRelationId(temp.getExamId());
                userBook.setQuestionId(question.getId());
                userBook.setIsMiss(Boolean.valueOf(false));
                userBook.setRepoId(question.getRepoId());
                userBook.setCreateTime(nowTime);
                userBook.setCreatorId(Long.valueOf(9527L));
                userBookArraySet.add(userBook);
                continue;
            }
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7b54\u6848\u7c7b\u578b");
        }
        if (userExamsScore.getIsAttend().booleanValue()) {
            List examQuAnswers = this.examQuAnswerMapper.selectMissExamQuestion(userId, examId);
            for (ExamQuAnswserMiss quAnswer : examQuAnswers) {
                if (quAnswer.getMainCombinationId() != null) {
                    quAnswer.setQuestionId(quAnswer.getMainCombinationId());
                    quAnswer.setRepoId(quAnswer.getRepoId());
                }
                WrongQuestionBook userBook = new WrongQuestionBook();
                userBook.setType(Integer.valueOf(1));
                userBook.setUserId(userId);
                userBook.setSubjectCode(quAnswer.getSubjectCode());
                userBook.setRelationId(quAnswer.getExamId());
                userBook.setQuestionId(quAnswer.getQuestionId());
                userBook.setRepoId(quAnswer.getRepoId());
                userBook.setCreateTime(nowTime);
                userBook.setIsMiss(Boolean.valueOf(true));
                userBook.setCreatorId(Long.valueOf(9527L));
                userBookArraySet.add(userBook);
            }
            if (!userBookArraySet.isEmpty()) {
                this.threadPool.execute(() -> this.wrongQuestionBookMapper.insertWrongQestionList(userBookArraySet.stream().toList()));
            }
        }
        LambdaQueryWrapper userExamsScoreLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)userExamsScoreLambdaQueryWrapper.eq(UserExamsScore::getUserId, (Object)userId)).eq(UserExamsScore::getExamId, (Object)examId);
        UserExamsScore userExamsScore1 = (UserExamsScore)this.userExamsScoreMapper.selectOne((Wrapper)userExamsScoreLambdaQueryWrapper);
        if (userExamsScore.getIsAttend().booleanValue()) {
            LocalDateTime createTime = userExamsScore1.getCreateTime();
            long secondsDifference = Duration.between(createTime, nowTime).getSeconds();
            int differenceAsInteger = (int)secondsDifference;
            userExamsScore.setUserTime(Integer.valueOf(differenceAsInteger));
        }
        LambdaUpdateWrapper userExamsScoreLambdaUpdate = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)userExamsScoreLambdaUpdate.eq(UserExamsScore::getUserId, (Object)userId)).eq(UserExamsScore::getExamId, (Object)examId);
        userExamsScore.setLimitTime(nowTime);
        userExamsScore.setObjectiveScore(userExamsScore.getUserScore());
        this.userExamsScoreMapper.update((Object)userExamsScore, (Wrapper)userExamsScoreLambdaUpdate);
        List examQuestionAndPoints = this.examMapper.selectQuestionList(examId, Boolean.valueOf(true));
        Long otherQuestionCount = examQuestionAndPoints != null ? (long)examQuestionAndPoints.size() : 0L;
        if (userExamsScore.getIsAttend().booleanValue() && otherQuestionCount != 0L) {
            LambdaUpdateWrapper userExamsScoreLambdaUpdateWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)userExamsScoreLambdaUpdateWrapper.set(UserExamsScore::getWhetherMark, (Object)0)).set(UserExamsScore::getState, (Object)1)).eq(UserExamsScore::getExamId, (Object)examId)).eq(UserExamsScore::getUserId, (Object)userId);
            this.userExamsScoreMapper.update((Wrapper)userExamsScoreLambdaUpdateWrapper);
            return Result.success((String)"\u63d0\u4ea4\u6210\u529f\uff0c\u5f85\u8001\u5e08\u9605\u5377");
        }
        if (!userExamsScore.getIsAttend().booleanValue()) {
            LambdaUpdateWrapper userExamsScoreLambdaUpdateWrapper = new LambdaUpdateWrapper();
            if (otherQuestionCount != 0L) {
                userExamsScoreLambdaUpdateWrapper.set(UserExamsScore::getWhetherMark, (Object)1);
            } else {
                userExamsScoreLambdaUpdateWrapper.set(UserExamsScore::getWhetherMark, (Object)-1);
            }
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)userExamsScoreLambdaUpdateWrapper.set(UserExamsScore::getSubjectiveScore, (Object)new BigDecimal(0))).set(UserExamsScore::getState, (Object)1)).eq(UserExamsScore::getExamId, (Object)examId)).eq(UserExamsScore::getUserId, (Object)userId);
            this.userExamsScoreMapper.update((Wrapper)userExamsScoreLambdaUpdateWrapper);
            return Result.success((String)"\u63d0\u4ea4\u6210\u529f\uff0c\u672a\u53c2\u52a0\u4e0d\u9700\u8981\u8001\u5e08\u9605\u5377");
        }
        LambdaUpdateWrapper userExamsScoreLambdaUpdateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)userExamsScoreLambdaUpdateWrapper.set(UserExamsScore::getWhetherMark, (Object)-1)).set(UserExamsScore::getState, (Object)1)).eq(UserExamsScore::getExamId, (Object)examId)).eq(UserExamsScore::getUserId, (Object)userId);
        this.userExamsScoreMapper.update((Wrapper)userExamsScoreLambdaUpdateWrapper);
        return Result.success((String)"\u4ea4\u5377\u6210\u529f");
    }

    public Result<String> startExam(Long examId) {
        Exam exam = (Exam)this.getById((Serializable)examId);
        if (!exam.getEnable().booleanValue()) {
            return Result.failed((String)"\u8003\u8bd5\u5904\u4e8e\u672a\u5f00\u653e\u72b6\u6001");
        }
        if (exam.getStartTime().isAfter(LocalDateTime.now())) {
            return Result.failed((String)"\u8003\u8bd5\u8fd8\u6ca1\u6709\u5f00\u59cb");
        }
        LambdaQueryWrapper studentLambdaQueryWrapper = new LambdaQueryWrapper();
        studentLambdaQueryWrapper.eq(Student::getUserId, (Object)SecurityUtil.getUserId());
        Student student = (Student)this.studentMapper.selectOne((Wrapper)studentLambdaQueryWrapper);
        LambdaQueryWrapper examClbumLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)examClbumLambdaQueryWrapper.eq(ExamClbum::getExamId, (Object)examId)).eq(ExamClbum::getClbumId, (Object)student.getAdministrativeClbumId());
        List examClbums = this.examClbumMapper.selectList((Wrapper)examClbumLambdaQueryWrapper);
        if (examClbums == null || examClbums.isEmpty()) {
            return Result.failed((String)"\u60a8\u6ca1\u5728\u672c\u573a\u8003\u8bd5\u53c2\u52a0\u8303\u56f4\u5185");
        }
        LambdaQueryWrapper userExamsScoreLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)userExamsScoreLambdaQueryWrapper.eq(UserExamsScore::getExamId, (Object)examId)).eq(UserExamsScore::getUserId, (Object)SecurityUtil.getUserId());
        UserExamsScore examsScore = (UserExamsScore)this.userExamsScoreMapper.selectOne((Wrapper)userExamsScoreLambdaQueryWrapper);
        if (examsScore == null && exam.getStartTime().plusMinutes(exam.getLateTime().intValue()).isBefore(LocalDateTime.now())) {
            return Result.failed((String)"\u60a8\u8fdf\u5230\u4e86\uff0c\u5141\u8bb8\u7684\u8003\u8bd5\u65f6\u95f4\u5df2\u8fc7\u4e0d\u80fd\u8fdb\u884c\u8003\u8bd5");
        }
        if (examsScore != null) {
            if (examsScore.getState() == 1) {
                return Result.failed((String)"\u60a8\u5df2\u4ea4\u5377\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u8003\u8bd5");
            }
            if (examsScore.getCount() > exam.getMaxCount()) {
                this.handExam0(examId, SecurityUtil.getUserId(), Boolean.valueOf(false));
                return Result.failed((String)"\u5df2\u8fbe\u5230\u6700\u5927\u8003\u8bd5\u6b21\u6570\u65e0\u6cd5\u8fdb\u884c\u8003\u8bd5");
            }
            examsScore.setCount(Integer.valueOf(examsScore.getCount() + 1));
            this.userExamsScoreMapper.updateById((Object)examsScore);
        } else {
            UserExamsScore userExamsScore = new UserExamsScore();
            userExamsScore.setExamId(examId);
            userExamsScore.setTotalTime(exam.getExamDuration());
            userExamsScore.setState(Integer.valueOf(0));
            userExamsScore.setCount(Integer.valueOf(1));
            userExamsScore.setIsAttend(Boolean.valueOf(true));
            int rows = this.userExamsScoreMapper.insert((Object)userExamsScore);
            if (rows == 0) {
                return Result.failed((String)"\u589e\u52a0\u8003\u8bd5\u8bb0\u5f55\u5931\u8d25");
            }
        }
        return Result.success((String)"\u5df2\u5f00\u59cb\u8003\u8bd5");
    }

    public Result<IPage<MyExamListVO>> myExamList(Page page) {
        Long userId = SecurityUtil.getUserId();
        return Result.success((Object)this.userExamsScoreMapper.selectMyExam((IPage)page, userId));
    }

    public Result<IPage<OngoingExam>> myOngoingExamList(Page page) {
        Long userId = SecurityUtil.getUserId();
        return Result.success((Object)this.userExamsScoreMapper.selectMyOngoingExamList(page, userId));
    }

    public Result<MyExamDetailVO> myExamDetail(Long examId) {
        Long userId = SecurityUtil.getUserId();
        Exam exam = (Exam)this.examMapper.selectById((Serializable)examId);
        MyExamDetailVO myExamDetailVO = this.examMapper.myExamDetail(examId, userId);
        if (exam.getIsScoreSensitive().booleanValue()) {
            myExamDetailVO.setScore("*");
            myExamDetailVO.setSubjectiveScore("*");
            myExamDetailVO.setObjectiveScore("*");
        }
        return Result.success((Object)myExamDetailVO);
    }

    public List<Key2ValueVo> totalBySubject(Integer days, String subject) {
        DateTime today = DateUtil.endOfDay((Date)DateUtil.date());
        DateTime previousDate = DateUtil.offsetDay((Date)today, (int)(-days.intValue()));
        String todayStr = today.toString("yyyy-MM-dd HH:mm:ss");
        String previousStr = previousDate.toString("yyyy-MM-dd HH:mm:ss");
        if (StrUtil.isBlank((CharSequence)subject)) {
            return ((ExamMapper)this.baseMapper).totalGroupBySubject(previousStr, todayStr);
        }
        return ((ExamMapper)this.baseMapper).subjectTotalGroupByDay(previousStr, todayStr, subject);
    }

    public List<Map<String, Object>> reportByClbum(Long examId) {
        return ((ExamMapper)this.baseMapper).reportByClbum(examId);
    }

    public List<Map<String, Object>> reportBySpecialty(Long examId) {
        return ((ExamMapper)this.baseMapper).reportBySpecialty(examId);
    }

    public List<StudentRankVo> studentRankByClbum(Long examId, Long clbumId) {
        List studentRankVos = ((ExamMapper)this.baseMapper).studentRankByClbum(examId, clbumId);
        int currentRank = 1;
        if (CollUtil.isNotEmpty((Collection)studentRankVos)) {
            Double currentScore = ((StudentRankVo)studentRankVos.get(0)).getScore();
            for (StudentRankVo student : studentRankVos) {
                if (!currentScore.equals(student.getScore())) {
                    ++currentRank;
                    currentScore = student.getScore();
                }
                student.setRank(Integer.valueOf(currentRank));
            }
        }
        return studentRankVos;
    }

    public AnalyseIntroduceVo analyseIntroduce(@Param(value="examId") Long examId) {
        AnalyseIntroduceVo vo = ((ExamMapper)this.baseMapper).analyseIntroduce(examId);
        List maxScoreClbumName = ((ExamMapper)this.baseMapper).getMaxScoreClbumName(examId);
        vo.setMaxScoreClbumNames(maxScoreClbumName);
        return vo;
    }

    public Result analyze(Long examId, Long clbumId) {
        ExamAnalyzeVO analyze = this.userExamsScoreMapper.analyze(examId, clbumId);
        if (analyze == null) {
            return Result.failed((String)"\u6ca1\u6709\u627e\u5230\u8be5\u73ed\u7ea7\u7684\u8003\u8bd5\u60c5\u51b5");
        }
        analyze.setAttendCount(this.examClbumMapper.selectClassSize(examId));
        analyze.setExamAnalyzeByClbumList(this.userExamsScoreMapper.analyzeByClbum(examId, clbumId));
        analyze.setExamAnalyzeByQuTypeList(this.userExamsScoreMapper.analyzeByQuestionType(examId, clbumId));
        return Result.success((Object)analyze);
    }

    public Result<Map<String, Object>> indexAnalyse() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        DateTime dateTime = DateUtil.lastWeek();
        String nowStr = new SimpleDateFormat("yyyy-MM-dd").format(dateTime.toJdkDate());
        LambdaQueryWrapper examLambdaQueryWrapper = new LambdaQueryWrapper();
        examLambdaQueryWrapper.gt(Exam::getCreateTime, (Object)nowStr);
        Long examNumberThisMonth = this.examMapper.selectCount((Wrapper)examLambdaQueryWrapper);
        result.put("examNumberThisMonth", examNumberThisMonth);
        Long countLast = this.examMapper.getCountByExamStartBetweetWeekEnd(ExamServiceImpl.getWeekDayByOffset((int)-7), ExamServiceImpl.getWeekDayByOffset((int)-1));
        Long countLastLst = this.examMapper.getCountByExamStartBetweetWeekEnd(ExamServiceImpl.getWeekDayByOffset((int)-14), ExamServiceImpl.getWeekDayByOffset((int)-8));
        if (null == countLast || null == countLastLst || 0L == countLast * countLastLst) {
            result.put("examMonthOnmonthPercentage", 0);
        } else {
            BigDecimal bdCountLast = new BigDecimal(countLast);
            BigDecimal bdCountLastLst = new BigDecimal(countLastLst);
            BigDecimal bdResult = bdCountLast.subtract(bdCountLastLst).divide(bdCountLast, 2, RoundingMode.HALF_UP);
            result.put("examMonthOnmonthPercentage", bdResult);
        }
        LambdaQueryWrapper userExamsScoreLambdaQueryWrapper = new LambdaQueryWrapper();
        userExamsScoreLambdaQueryWrapper.gt(UserExamsScore::getCreateTime, (Object)nowStr);
        Long examattendedThisMonth = this.userExamsScoreMapper.selectCount((Wrapper)userExamsScoreLambdaQueryWrapper);
        result.put("examattendedThisMonth", examattendedThisMonth);
        Long countLast2 = this.userExamsScoreMapper.getCountByScoreStartBetweetWeekEnd(ExamServiceImpl.getWeekDayByOffset((int)-7), ExamServiceImpl.getWeekDayByOffset((int)-1));
        Long countLastLst2 = this.userExamsScoreMapper.getCountByScoreStartBetweetWeekEnd(ExamServiceImpl.getWeekDayByOffset((int)-14), ExamServiceImpl.getWeekDayByOffset((int)-8));
        if (null == countLast2 || null == countLastLst2 || 0L == countLast2 * countLastLst2) {
            result.put("examattendedMonthOnmonthPercentage", 0);
        } else {
            BigDecimal bdCountLast2 = new BigDecimal(countLast2);
            BigDecimal bdCountLastLst2 = new BigDecimal(countLastLst2);
            BigDecimal bdResult2 = bdCountLast2.subtract(bdCountLastLst2).divide(bdCountLast2, 2, RoundingMode.HALF_UP);
            result.put("examattendedMonthOnmonthPercentage", bdResult2);
        }
        LambdaQueryWrapper subjectLambdaQueryWrapper = new LambdaQueryWrapper();
        subjectLambdaQueryWrapper.gt(Subject::getCreateTime, (Object)nowStr);
        Long subjectCountThisMonth = this.subjectMapper.selectCount((Wrapper)subjectLambdaQueryWrapper);
        result.put("subjectCountThisMonth", subjectCountThisMonth);
        List LastDayWeek = this.examMapper.selectCountLastWeek();
        result.put("LastWeek", LastDayWeek);
        return Result.success(result);
    }

    public static String getWeekDayByOffset(int offset) {
        Calendar c = Calendar.getInstance();
        c.set(7, 2);
        c.add(5, offset);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
        return simpleDateFormat.format(c.getTime());
    }

    public Result<Map<String, Object>> examInfoMonitor(Long examId) {
        return Result.ok((Object)this.examMapper.examInfoMonitor(examId));
    }

    public Result<Boolean> isCheat(Long examId) {
        Exam exam = (Exam)this.examMapper.selectById((Serializable)examId);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(UserExamsScore::getExamId, (Object)examId)).eq(UserExamsScore::getUserId, (Object)SecurityUtil.getUserId());
        UserExamsScore userExamsScore = (UserExamsScore)this.userExamsScoreMapper.selectOne((Wrapper)queryWrapper);
        return Result.ok((Object)(userExamsScore.getCount() > exam.getMaxCount() ? 1 : 0));
    }

    public Result<Map<String, Object>> examInfoScreen(String examDateTime) {
        return Result.ok((Object)this.examInfoScreen0(examDateTime, Boolean.valueOf(false)));
    }

    public Map<String, Object> examInfoScreen0(String examDateTime, Boolean isAppendRaw) {
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>();
        List rawInfo = this.examMapper.examInfoScreen(examDateTime);
        if (rawInfo.size() <= 0) {
            return null;
        }
        res.put("schoolCode", ((ExamInfoScreenRaw)rawInfo.get(0)).getSchoolCode());
        res.put("schoolName", ((ExamInfoScreenRaw)rawInfo.get(0)).getSchoolName());
        if (isAppendRaw.booleanValue()) {
            res.put("raw", rawInfo);
        }
        DecimalFormat formater = new DecimalFormat("0.00");
        long examCount = rawInfo.stream().count();
        res.put("examCount", examCount);
        Long sumTakingCount = rawInfo.stream().map(ExamInfoScreenRaw::getTakingCount).collect(Collectors.summingLong(Long::longValue));
        res.put("sumTakingCount", sumTakingCount);
        Long sumAttendCount = rawInfo.stream().map(ExamInfoScreenRaw::getAttendCount).collect(Collectors.summingLong(Long::longValue));
        res.put("sumAttendCount", sumAttendCount);
        Long sumAbsenceCount = sumTakingCount - sumAttendCount;
        res.put("sumAbsenceCount", sumAbsenceCount);
        res.put("attendRate", formater.format(sumAttendCount.doubleValue() / sumTakingCount.doubleValue()));
        Map<String, Long> sumTakingCountBySubjectName = rawInfo.stream().collect(Collectors.groupingBy(ExamInfoScreenRaw::getSubjectName, Collectors.summingLong(ExamInfoScreenRaw::getTakingCount)));
        Map<String, Long> sumHandingCountBySubjectName = rawInfo.stream().collect(Collectors.groupingBy(ExamInfoScreenRaw::getSubjectName, Collectors.summingLong(ExamInfoScreenRaw::getHandingCount)));
        HashMap<String, String> subjectHandingRate = new HashMap<String, String>();
        for (String subjectName : sumTakingCountBySubjectName.keySet()) {
            Long a1 = sumTakingCountBySubjectName.get(subjectName);
            Long a2 = sumHandingCountBySubjectName.get(subjectName);
            subjectHandingRate.put(subjectName, formater.format(a2.doubleValue() / a1.doubleValue()));
        }
        res.put("subjectHandingRate", subjectHandingRate);
        Set subjectNameList = rawInfo.stream().map(ExamInfoScreenRaw::getSubjectName).collect(Collectors.toSet());
        List examInfoScreenDynamic = this.examMapper.examInfoScreenDynamic(subjectNameList);
        res.put("examInfoScreenDynamic", examInfoScreenDynamic);
        Map<String, Long> sumPersonCountBySubjectName = rawInfo.stream().collect(Collectors.groupingBy(ExamInfoScreenRaw::getSubjectName, Collectors.summingLong(ExamInfoScreenRaw::getTakingCount)));
        res.put("sumPersonCountBySubjectName", sumPersonCountBySubjectName);
        Map<String, Long> sumExamCountBySubjectName = rawInfo.stream().collect(Collectors.groupingBy(ExamInfoScreenRaw::getSubjectName, Collectors.counting()));
        res.put("sumExamCountBySubjectName", sumExamCountBySubjectName);
        Double sumAvgUserTime = rawInfo.stream().map(ExamInfoScreenRaw::getAvgUserTime).collect(Collectors.summingDouble(Double::doubleValue));
        double AvgUserTime = sumAvgUserTime / (double)examCount;
        res.put("avgUserTime", AvgUserTime);
        HashMap examHandingRate = new HashMap();
        for (Object examInfoScreenRaw : rawInfo) {
            String handingRate = formater.format(examInfoScreenRaw.getHandingCount().doubleValue() / examInfoScreenRaw.getTakingCount().doubleValue());
            String unHandingRate = formater.format(1.0 - Double.parseDouble(handingRate));
            HashMap<String, String> tmp = new HashMap<String, String>();
            tmp.put("handingRate", handingRate);
            tmp.put("unHandingRate", unHandingRate);
            examHandingRate.put(examInfoScreenRaw.getExamName(), tmp);
        }
        res.put("examHandingRate", examHandingRate);
        HashMap<String, Double> examAvgUserTime = new HashMap<String, Double>();
        for (ExamInfoScreenRaw examInfoScreenRaw : rawInfo) {
            examAvgUserTime.put(examInfoScreenRaw.getExamName(), examInfoScreenRaw.getAvgUserTime());
        }
        res.put("examAvgUserTime", examAvgUserTime);
        Long sumHandingCount = rawInfo.stream().map(ExamInfoScreenRaw::getHandingCount).collect(Collectors.summingLong(Long::longValue));
        res.put("sumHandingCount", sumHandingCount);
        HashMap<String, Long> HandingDetail = new HashMap<String, Long>();
        for (ExamInfoScreenRaw examInfoScreenRaw : rawInfo) {
            HandingDetail.put(examInfoScreenRaw.getExamName(), examInfoScreenRaw.getHandingCount());
        }
        res.put("HandingDetail", HandingDetail);
        Long sumCheaterCount = rawInfo.stream().map(ExamInfoScreenRaw::getCheaterCount).collect(Collectors.summingLong(Long::longValue));
        res.put("sumCheaterCount", sumCheaterCount);
        HashMap<String, Long> cheaterDetail = new HashMap<String, Long>();
        for (ExamInfoScreenRaw examInfoScreenRaw : rawInfo) {
            cheaterDetail.put(examInfoScreenRaw.getExamName(), examInfoScreenRaw.getCheaterCount());
        }
        res.put("cheaterDetail", cheaterDetail);
        HashMap<String, Long> absenceDetail = new HashMap<String, Long>();
        for (ExamInfoScreenRaw examInfoScreenRaw : rawInfo) {
            absenceDetail.put(examInfoScreenRaw.getExamName(), examInfoScreenRaw.getAbsenceCount());
        }
        res.put("absenceDetail", absenceDetail);
        return res;
    }

    @Scheduled(fixedDelay=10000L)
    public void examInfoCollector() {
        SysParam serviceIpSys = this.sysParamService.getByType(SysParamEnum.REGION_SERVE_IP.getType());
        if (null == serviceIpSys) {
            log.error("\u8bf7\u914d\u7f6e\u670d\u52a1\u7aef\u7684ip/\u57df\u540d");
            return;
        }
        HashMap<String, String> obj = new HashMap<String, String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String now = sdf.format(new Date());
        Map res = this.examInfoScreen0(now, Boolean.valueOf(true));
        if (res == null) {
            log.info("\u5927\u5c4f\u6570\u636e\u67e5\u8be2\u4e3a\u7a7a");
            return;
        }
        String jsonStr = JSONUtil.toJsonStr((Object)res);
        List list = this.schoolService.list();
        if (list.size() < 0) {
            log.error("\u6ca1\u6709\u8bbe\u7f6e\u5b66\u6821\u6570\u636e\uff0c\u8bf7\u68c0\u67e5");
            return;
        }
        School school = (School)list.get(0);
        obj.put("schoolCode", school.getCode());
        String encrypt = SM2Utils.encrypt((String)jsonStr, (String)school.getPublicKey());
        obj.put("msg", encrypt);
        String objStr = JSONUtil.toJsonStr(obj);
        String post = HttpUtil.post((String)(serviceIpSys.getValue() + "/api/exams/invigilating/collector"), (String)objStr);
    }

    @Scheduled(fixedDelay=30000L, initialDelay=3000L)
    public void autoPushToRemote() {
        List exams = this.examMapper.queryEndedExamAndNotPush();
        List examIds = exams.stream().filter(e -> {
            Long examId = e.getId();
            Long numberOfUnmarked = this.userExamsScoreMapper.getNumberOfUnmarked(examId);
            return numberOfUnmarked <= 0L;
        }).map(e -> e.getId()).collect(Collectors.toList());
        this.pushToRemote0(examIds);
    }

    public Result pushToRemote(List<Long> examIds) {
        return this.pushToRemote0(examIds);
    }

    public Result pushToRemote0(List<Long> examIds) {
        for (Long examId : examIds) {
            Exam exam = (Exam)this.examMapper.selectById((Serializable)examId);
            if (exam == null) {
                return Result.failed((String)"\u6ca1\u6709\u627e\u5230\u8003\u8bd5\uff0c\u8bf7\u68c0\u67e5");
            }
            if (LocalDateTime.now().isBefore(exam.getEndTime())) {
                return Result.failed((String)"\u8be5\u8003\u8bd5[%s]\u8fd8\u672a\u7ed3\u675f\u65e0\u6cd5\u4e0a\u4f20\u5230\u670d\u52a1\u5668\uff0c\u8bf7\u68c0\u67e5".formatted(exam.getTitle()));
            }
            Long numberOfUnmarked = this.userExamsScoreMapper.getNumberOfUnmarked(examId);
            if (numberOfUnmarked <= 0L) continue;
            return Result.failed((String)"\u8be5\u8003\u8bd5[%s]\u9605\u5377\u8fd8\u672a\u7ed3\u675f\u65e0\u6cd5\u4e0a\u4f20\u5230\u670d\u52a1\u5668\uff0c\u8bf7\u68c0\u67e5".formatted(exam.getTitle()));
        }
        for (Long examId : examIds) {
            List examAllInfos = this.examMapper.selectExamAllInformation(examId);
            examAllInfos.forEach(e -> {
                String mobile;
                String idNo = (String)e.get("id_no");
                if (idNo != null) {
                    e.put("id_no", AESEncryptUtils.decrypt((String)idNo));
                }
                if ((mobile = (String)e.get("mobile")) != null) {
                    e.put("mobile", AESEncryptUtils.decrypt((String)mobile));
                }
            });
            if (examAllInfos != null && examAllInfos.size() > 0) {
                JSONConfig jsonConfig = new JSONConfig().setDateFormat("yyyy-MM-dd HH:mm:ss");
                Integer batchSize = 1;
                if (examAllInfos.size() > 10) {
                    batchSize = (int)Math.ceil(examAllInfos.size() / 10);
                }
                List partition = Lists.partition((List)examAllInfos, (int)batchSize);
                for (List maps : partition) {
                    String jsonStr = JSONUtil.toJsonStr((Object)maps, (JSONConfig)jsonConfig);
                    CompletableFuture future = this.kafkaTemplate.send("exam_info_collection", (Object)jsonStr);
                    try {
                        future.get(20L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e2) {
                        log.error("\u53d1\u9001\u8003\u8bd5\u6570\u636e\u5230\u4e2d\u5fc3\u670d\u52a1\u5668\u5931\u8d25", (Throwable)e2);
                        throw new RuntimeException(e2);
                    }
                    catch (ExecutionException e3) {
                        log.error("\u53d1\u9001\u8003\u8bd5\u6570\u636e\u5230\u4e2d\u5fc3\u670d\u52a1\u5668\u5931\u8d25", (Throwable)e3);
                        throw new RuntimeException(e3);
                    }
                    catch (TimeoutException e4) {
                        log.error("\u53d1\u9001\u8003\u8bd5\u6570\u636e\u5230\u4e2d\u5fc3\u670d\u52a1\u5668\u8d85\u65f6", (Throwable)e4);
                        throw new RuntimeException(e4);
                    }
                }
            }
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(Exam::getId, (Object)examId);
            updateWrapper.set(Exam::getIsPush, (Object)true);
            this.examMapper.update((Wrapper)updateWrapper);
        }
        return Result.ok();
    }

    public static void main(String[] args) {
        LocalDateTime now = LocalDateTime.parse("2024-09-10T14:10:00").minusMinutes(10L);
        boolean before = now.isAfter(LocalDateTime.parse("2024-09-10T13:10:00"));
        LocalDateTime now1 = LocalDateTime.now();
        boolean after = now.isAfter(now1);
        System.out.println(after);
        Duration between = Duration.between(now, now1);
        long seconds = between.getSeconds();
        System.out.println(seconds);
        String s = "1833789799174082562,1833789799169888258";
        List list = Arrays.stream(s.split(",")).map(e -> Long.parseLong(e)).collect(Collectors.toList());
        List<Long> options = Arrays.asList(1833789799169888258L, 1833789799174082562L);
        Collections.sort(list);
        Collections.sort(options);
        boolean equals = list.equals(options);
        System.out.println(equals);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String now2 = sdf.format(new Date());
        System.out.println(now2);
    }
}

