/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.constant.RoleEnum;
import com.zsy.exam.mapper.ExaminationCatalogueMapper;
import com.zsy.exam.model.dto.ExaminationCatalogueDTO;
import com.zsy.exam.model.entity.ExaminationCatalogue;
import com.zsy.exam.model.entity.ExaminationPaper;
import com.zsy.exam.model.vo.ExaminationCatalogueTreeListVO;
import com.zsy.exam.service.IExaminationCatalogueService;
import com.zsy.exam.service.IExaminationPaperService;
import com.zsy.exam.service.IRoleService;
import com.zsy.exam.service.ISubjectService;
import com.zsy.exam.util.SecurityUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class ExaminationCatalogueServiceImpl
extends ServiceImpl<ExaminationCatalogueMapper, ExaminationCatalogue>
implements IExaminationCatalogueService {
    @Autowired
    ExaminationCatalogueMapper examinationCatalogueMapper;
    @Autowired
    private ISubjectService subjectService;
    @Autowired
    @Lazy
    private IExaminationPaperService examinationPaperService;
    @Autowired
    private IRoleService roleService;

    public ExaminationCatalogue getExaminationCatalogue(Long id) {
        return (ExaminationCatalogue)this.examinationCatalogueMapper.selectById((Serializable)id);
    }

    public List<ExaminationCatalogueTreeListVO> getAllExaminationCatalogue(String examinationName) {
        List subjectCodes = SecurityUtil.getSubjectCode();
        List roles = this.roleService.getCurrentRoles();
        if (!roles.contains(RoleEnum.ADMIN.getCode()) && !roles.contains(RoleEnum.SUPER_ADMIN.getCode()) && CollectionUtils.isEmpty((Collection)subjectCodes)) {
            throw new AppException("\u5f53\u524d\u8d26\u53f7\u6ca1\u6709\u6559\u5b66\u79d1\u76ee");
        }
        List vos = this.examinationCatalogueMapper.queryList(subjectCodes, examinationName);
        if (CollectionUtils.isEmpty((Collection)vos)) {
            return vos;
        }
        List pList = vos.stream().filter(item -> null == item.getParentId()).collect(Collectors.toList());
        List treeListVOS = this.treeList(pList, vos);
        return treeListVOS;
    }

    public void add(ExaminationCatalogueDTO dto) {
        ExaminationCatalogue examinationCatalogue = new ExaminationCatalogue();
        BeanUtils.copyProperties((Object)dto, (Object)examinationCatalogue);
        ExaminationCatalogue examinationCatalogueOld = (ExaminationCatalogue)((ExaminationCatalogueMapper)this.baseMapper).selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ExaminationCatalogue::getIsDeleted, (Object)false)).eq(ExaminationCatalogue::getCode, (Object)dto.getCode())).eq(ExaminationCatalogue::getSubjectCode, (Object)dto.getSubjectCode()));
        if (null != examinationCatalogueOld) {
            throw new AppException("\u7f16\u7801\u91cd\u590d");
        }
        if (null != examinationCatalogue.getParentId()) {
            ExaminationCatalogue parentExam = (ExaminationCatalogue)this.getById((Serializable)examinationCatalogue.getParentId());
            if (null != parentExam) {
                if (StringUtils.isNotBlank((CharSequence)parentExam.getPath())) {
                    examinationCatalogue.setPath(parentExam.getPath() + "," + parentExam.getId());
                } else {
                    examinationCatalogue.setPath("" + parentExam.getId());
                }
                examinationCatalogue.setLevel(Integer.valueOf(parentExam.getLevel() + 1));
            } else {
                examinationCatalogue.setLevel(Integer.valueOf(1));
            }
        } else {
            examinationCatalogue.setLevel(Integer.valueOf(1));
        }
        this.examinationCatalogueMapper.insert((Object)examinationCatalogue);
    }

    public void update(ExaminationCatalogueDTO dto) {
        if (null == dto.getId()) {
            throw new AppException("\u53c2\u6570\u9519\u8bef");
        }
        ExaminationCatalogue examinationCatalogueOld = (ExaminationCatalogue)((ExaminationCatalogueMapper)this.baseMapper).selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ExaminationCatalogue::getIsDeleted, (Object)false)).eq(ExaminationCatalogue::getSubjectCode, (Object)dto.getSubjectCode())).eq(ExaminationCatalogue::getCode, (Object)dto.getCode())).ne(ExaminationCatalogue::getId, (Object)dto.getId()));
        if (null != examinationCatalogueOld) {
            throw new AppException("\u7f16\u7801\u91cd\u590d");
        }
        ExaminationCatalogue examinationCatalogue = (ExaminationCatalogue)this.getById((Serializable)dto.getId());
        BeanUtils.copyProperties((Object)dto, (Object)examinationCatalogue);
        if (null != dto.getParentId()) {
            ExaminationCatalogue pExam = (ExaminationCatalogue)this.getById((Serializable)dto.getParentId());
            if (null != pExam) {
                if (StringUtils.isNotBlank((CharSequence)pExam.getPath())) {
                    examinationCatalogue.setPath(pExam.getPath() + "," + pExam.getId());
                } else {
                    examinationCatalogue.setPath("" + pExam.getId());
                }
                examinationCatalogue.setLevel(Integer.valueOf(pExam.getLevel() + 1));
            } else {
                examinationCatalogue.setLevel(Integer.valueOf(1));
            }
        } else {
            examinationCatalogue.setLevel(Integer.valueOf(1));
        }
        this.examinationCatalogueMapper.updateById((Object)examinationCatalogue);
    }

    public void remove(String ids) {
        List<String> list = Arrays.asList(ids.split(","));
        if (!CollectionUtils.isEmpty(list)) {
            for (String id : list) {
                List exams = ((ExaminationCatalogueMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ExaminationCatalogue::getIsDeleted, (Object)false)).like(ExaminationCatalogue::getPath, (Object)id));
                if (CollectionUtils.isNotEmpty((Collection)exams)) {
                    throw new AppException("\u5f53\u524d\u76ee\u5f55\u6709\u4e0b\u7ea7\u76ee\u5f55,\u4e0d\u80fd\u5220\u9664");
                }
                List examinationPapers = this.examinationPaperService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ExaminationPaper::getExaminationCatalogueId, (Object)id)).eq(ExaminationPaper::getDeleted, (Object)false));
                if (null != examinationPapers) continue;
                throw new AppException("\u5f53\u524d\u76ee\u5f55\u5173\u8054\u4e86\u8bd5\u5377,\u4e0d\u80fd\u5220\u9664");
            }
            this.examinationCatalogueMapper.deleteBatchIds(list);
        }
    }

    private List<ExaminationCatalogueTreeListVO> treeList(List<ExaminationCatalogueTreeListVO> calalogueTree, List<ExaminationCatalogueTreeListVO> all) {
        if (CollectionUtils.isEmpty(calalogueTree)) {
            return calalogueTree;
        }
        for (ExaminationCatalogueTreeListVO vo : calalogueTree) {
            List collect = all.stream().filter(item -> vo.getId().equals(item.getParentId())).collect(Collectors.toList());
            vo.setChildren(collect);
            this.treeList(collect, all);
        }
        return calalogueTree;
    }
}

