/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.mapper.ExaminationPaperHtmlMapper;
import com.zsy.exam.model.entity.ExaminationPaperHtml;
import com.zsy.exam.service.IExaminationPaperHtmlService;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class ExaminationPaperHtmlServiceImpl
extends ServiceImpl<ExaminationPaperHtmlMapper, ExaminationPaperHtml>
implements IExaminationPaperHtmlService {
    @Autowired
    ExaminationPaperHtmlMapper examinationPaperHtmlMapper;

    public ExaminationPaperHtml getExaminationPaperHtml(Long id) {
        return (ExaminationPaperHtml)this.examinationPaperHtmlMapper.selectById((Serializable)id);
    }

    @Transactional(rollbackFor={Exception.class})
    public void add(ExaminationPaperHtml examinationPaperHtml) {
        Long examId = examinationPaperHtml.getExamId();
        if (null == examId) {
            throw new AppException("\u8003\u8bd5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ExaminationPaperHtml byExamId = this.getByExamId(examId);
        if (null != byExamId) {
            throw new AppException("\u8be5\u8003\u8bd5\u5df2\u7ecf\u5b58\u5728\u6253\u5370\u6a21\u7248\uff0c\u4e0d\u53ef\u91cd\u590d\u6dfb\u52a0");
        }
        this.examinationPaperHtmlMapper.insert((Object)examinationPaperHtml);
    }

    @Transactional(rollbackFor={Exception.class})
    public int modify(ExaminationPaperHtml examinationPaperHtml) {
        ExaminationPaperHtml db = (ExaminationPaperHtml)this.getById((Serializable)examinationPaperHtml.getId());
        if (!db.getExamId().equals(examinationPaperHtml.getExamId())) {
            throw new AppException("\u53ea\u80fd\u4fee\u6539\u5f53\u524d\u8003\u8bd5");
        }
        return this.examinationPaperHtmlMapper.updateById((Object)examinationPaperHtml);
    }

    @Transactional(rollbackFor={Exception.class})
    public void remove(String ids) {
        String[] array;
        if (StringUtils.isNotEmpty((CharSequence)ids) && !CollectionUtils.isEmpty(Arrays.asList(array = ids.split(",")))) {
            this.examinationPaperHtmlMapper.deleteBatchIds(Arrays.asList(array));
        }
    }

    public ExaminationPaperHtml getByExamId(Long examId) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(ExaminationPaperHtml::getExamId, (Object)examId);
        return (ExaminationPaperHtml)this.examinationPaperHtmlMapper.selectOne((Wrapper)qw);
    }
}

