/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import cn.hutool.core.util.RandomUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.constant.IQuestionApproveStatus;
import com.zsy.exam.constant.ISubmitStatusConstant;
import com.zsy.exam.constant.QuestionTypeEnum;
import com.zsy.exam.constant.RoleEnum;
import com.zsy.exam.constant.SysParamEnum;
import com.zsy.exam.mapper.ExamAreaDetailMapper;
import com.zsy.exam.mapper.ExamQuAnswerMapper;
import com.zsy.exam.mapper.ExaminationPaperMapper;
import com.zsy.exam.mapper.ExaminationTopicMapper;
import com.zsy.exam.mapper.ExaminationTopicQuestionMapper;
import com.zsy.exam.mapper.ManualScoreMapper;
import com.zsy.exam.mapper.UserExamsScoreMapper;
import com.zsy.exam.model.dto.ExaminationAutoDTO;
import com.zsy.exam.model.dto.ExaminationAutoTypeDTO;
import com.zsy.exam.model.dto.ExaminationDTO;
import com.zsy.exam.model.dto.ExaminationPointDTO;
import com.zsy.exam.model.dto.ExaminationTopicDTO;
import com.zsy.exam.model.dto.ExaminationTopicQuestionDTO;
import com.zsy.exam.model.dto.PaperApproveDto;
import com.zsy.exam.model.dto.PaperExportDto;
import com.zsy.exam.model.dto.QuestionExportDto;
import com.zsy.exam.model.entity.Catalogue;
import com.zsy.exam.model.entity.Exam;
import com.zsy.exam.model.entity.ExamArea;
import com.zsy.exam.model.entity.ExamAreaDetail;
import com.zsy.exam.model.entity.ExaminationCatalogue;
import com.zsy.exam.model.entity.ExaminationPaper;
import com.zsy.exam.model.entity.ExaminationPaperApprove;
import com.zsy.exam.model.entity.ExaminationTopic;
import com.zsy.exam.model.entity.ExaminationTopicQuestion;
import com.zsy.exam.model.entity.Grade;
import com.zsy.exam.model.entity.ManualScore;
import com.zsy.exam.model.entity.Option;
import com.zsy.exam.model.entity.Question;
import com.zsy.exam.model.entity.QuestionType;
import com.zsy.exam.model.entity.Subject;
import com.zsy.exam.model.entity.SysParam;
import com.zsy.exam.model.entity.UserExamsScore;
import com.zsy.exam.model.form.paper.PaperPageQuery;
import com.zsy.exam.model.vo.ExamAnalysisDetailVO;
import com.zsy.exam.model.vo.ExamAnalysisVO;
import com.zsy.exam.model.vo.ExamKnowledgeQuestionVO;
import com.zsy.exam.model.vo.ExamQuAnswerVO;
import com.zsy.exam.model.vo.ExamSimpleVO;
import com.zsy.exam.model.vo.ExaminationAutoBatchVO;
import com.zsy.exam.model.vo.ExaminationListVO;
import com.zsy.exam.model.vo.ExaminationPaperQuestionVO;
import com.zsy.exam.model.vo.QuestionSimpleVO;
import com.zsy.exam.model.vo.QuestionVO;
import com.zsy.exam.service.ICatalogueService;
import com.zsy.exam.service.IExamAreaService;
import com.zsy.exam.service.IExamService;
import com.zsy.exam.service.IExaminationCatalogueService;
import com.zsy.exam.service.IExaminationPaperApproveService;
import com.zsy.exam.service.IExaminationPaperService;
import com.zsy.exam.service.IGradeService;
import com.zsy.exam.service.IOptionService;
import com.zsy.exam.service.IQuestionService;
import com.zsy.exam.service.IQuestionTypeService;
import com.zsy.exam.service.IRoleService;
import com.zsy.exam.service.ISubjectService;
import com.zsy.exam.service.ISysParamService;
import com.zsy.exam.service.IUserMessageService;
import com.zsy.exam.service.impl.ExaminationPaperServiceImpl;
import com.zsy.exam.util.MinioUtil;
import com.zsy.exam.util.SecurityUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ExaminationPaperServiceImpl
extends ServiceImpl<ExaminationPaperMapper, ExaminationPaper>
implements IExaminationPaperService {
    private static final Logger log = LoggerFactory.getLogger(ExaminationPaperServiceImpl.class);
    @Autowired
    ExaminationPaperMapper examinationMapper;
    @Autowired
    private ExaminationTopicMapper examinationTopicMapper;
    @Autowired
    private ExaminationTopicQuestionMapper examinationTopicQuestionMapper;
    @Autowired
    private IQuestionService questionService;
    @Autowired
    private ICatalogueService catalogueService;
    @Autowired
    private IExamService examService;
    @Autowired
    private ISubjectService subjectService;
    @Autowired
    private IExaminationPaperApproveService approveService;
    @Autowired
    private ExamQuAnswerMapper examQuAnswerMapper;
    @Autowired
    private IOptionService optionService;
    @Autowired
    private ManualScoreMapper manualScoreMapper;
    @Autowired
    private UserExamsScoreMapper userExamsScoreMapper;
    @Autowired
    private ISysParamService sysParamService;
    @Autowired
    private MinioUtil minioUtil;
    @Autowired
    private IRoleService roleService;
    @Autowired
    private IUserMessageService userMessageService;
    @Autowired
    private IQuestionTypeService questionTypeService;
    @Autowired
    private IGradeService gradeService;
    @Autowired
    private IExamAreaService examAreaService;
    @Autowired
    private ExamAreaDetailMapper examAreaDetailMapper;
    @Autowired
    private IExaminationCatalogueService examinationCatalogueService;

    public ExaminationDTO getExamination(Long id) {
        Grade grade;
        if (null == id) {
            throw new AppException("\u53c2\u6570\u9519\u8bef");
        }
        ExaminationPaper examinationPaper = (ExaminationPaper)((ExaminationPaperMapper)this.baseMapper).selectById((Serializable)id);
        if (null == examinationPaper) {
            throw new AppException("\u53c2\u6570\u9519\u8bef");
        }
        HashSet<Long> repoIds = new HashSet<Long>();
        ExaminationDTO vo = new ExaminationDTO();
        BeanUtils.copyProperties((Object)examinationPaper, (Object)vo);
        List topics = this.examinationTopicMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ExaminationTopic::getExaminationPaperId, (Object)id)).eq(ExaminationTopic::getDeleted, (Object)false));
        if (CollectionUtils.isEmpty((Collection)topics)) {
            throw new AppException("\u8bd5\u5377\u5f55\u5165\u4e0d\u5b8c\u6574");
        }
        List list = this.catalogueService.list((Wrapper)new LambdaQueryWrapper().eq(Catalogue::getDeleted, (Object)false));
        ArrayList<ExaminationTopicDTO> examinationTopicDTOS = new ArrayList<ExaminationTopicDTO>();
        for (ExaminationTopic topic : topics) {
            ExaminationTopicDTO topicDTO = new ExaminationTopicDTO();
            BeanUtils.copyProperties((Object)topic, (Object)topicDTO);
            List topicQuestions = this.examinationTopicQuestionMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ExaminationTopicQuestion::getExaminationTopicId, (Object)topic.getId())).eq(ExaminationTopicQuestion::getDeleted, (Object)false)).orderByAsc(ExaminationTopicQuestion::getSort));
            if (CollectionUtils.isEmpty((Collection)topicQuestions)) continue;
            ArrayList<ExaminationTopicQuestionDTO> topicQuestionDTOS = new ArrayList<ExaminationTopicQuestionDTO>();
            Long start = System.currentTimeMillis();
            for (ExaminationTopicQuestion topicQuestion : topicQuestions) {
                ExaminationTopicQuestionDTO questionDTO = new ExaminationTopicQuestionDTO();
                BeanUtils.copyProperties((Object)topicQuestion, (Object)questionDTO);
                QuestionVO questionVO = this.questionService.detail(topicQuestion.getQuestionId());
                questionDTO.setQuestionVO(questionVO);
                questionDTO.setKnowledgePointName(this.getCalalogueNameById(questionVO.getRepoId(), list));
                repoIds.add(questionVO.getRepoId());
                topicQuestionDTOS.add(questionDTO);
            }
            Long end = System.currentTimeMillis();
            log.info("\u65f6\u95f4\uff1a" + (end - start));
            topicDTO.setExaminationTopicQuestions(topicQuestionDTOS);
            examinationTopicDTOS.add(topicDTO);
        }
        Subject subject = this.subjectService.getByCode(vo.getSubjectCode());
        if (null != subject) {
            vo.setSubjectName(subject.getName());
        }
        if (null != examinationPaper.getGradeId() && null != (grade = (Grade)this.gradeService.getById((Serializable)examinationPaper.getGradeId()))) {
            vo.setGradeName(grade.getName());
        }
        vo.setApproveTimes(this.approveService.getCountByPaperId(id));
        vo.setExaminationTopics(examinationTopicDTOS);
        vo.setKnowledgePointCount(Integer.valueOf(repoIds.size()));
        return vo;
    }

    public Page<ExaminationListVO> getAllExamination(Page<ExaminationListVO> page, PaperPageQuery query) {
        List roles = this.roleService.getCurrentRoles();
        query.setUserId(SecurityUtil.getUserId());
        if (roles.contains(RoleEnum.TEACHER.getCode())) {
            query.setSubjectCodes(SecurityUtil.getSubjectCode());
            page = ((ExaminationPaperMapper)this.baseMapper).queryPage(page, query, Boolean.valueOf(this.isPAP()));
        } else if (roles.contains(RoleEnum.ADMIN.getCode()) || roles.contains(RoleEnum.SUPER_ADMIN.getCode())) {
            page = ((ExaminationPaperMapper)this.baseMapper).queryPage(page, query, Boolean.TRUE);
        }
        page.getRecords().parallelStream().forEach(a -> {
            a.setApproveTimes(this.approveService.getCountByPaperId(a.getId()));
            a.setCatalogueName(a.getSubjectName() + (String)(StringUtils.isBlank((CharSequence)a.getCatalogueName()) ? "" : "-" + a.getCatalogueName()));
        });
        return page;
    }

    @Transactional(rollbackFor={Exception.class})
    public void add(ExaminationDTO dto) {
        if (dto == null || CollectionUtils.isEmpty((Collection)dto.getExaminationTopics())) {
            throw new AppException("\u53c2\u6570\u9519\u8bef");
        }
        SysParam examPaperLimit = this.sysParamService.getByType(SysParamEnum.EXAM_PAPER_LIMIT.getType());
        if (null != examPaperLimit && StringUtils.isNotBlank((CharSequence)examPaperLimit.getValue())) {
            Integer count = ((ExaminationPaperMapper)this.baseMapper).getAllCount();
            if (Integer.valueOf(examPaperLimit.getValue()) < count) {
                throw new AppException("\u7ec4\u5377\u6b21\u6570\u8d85\u8fc7\u6700\u5927\u503c,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
        }
        ExaminationPaper examination = new ExaminationPaper();
        examination.setExaminationCatalogueId(dto.getExaminationCatalogueId());
        examination.setName(dto.getName());
        examination.setSubjectCode(dto.getSubjectCode());
        examination.setSubmitStatus(Integer.valueOf(0));
        examination.setApproveStatus(IQuestionApproveStatus.APPROVE_WAIT);
        examination.setExamStartTime(dto.getExamStartTime());
        examination.setExamEndTime(dto.getExamEndTime());
        examination.setExamMinuteDuration(dto.getExamMinuteDuration());
        examination.setGradeId(dto.getGradeId());
        examination.setExamAreaId(dto.getExamAreaId());
        ((ExaminationPaperMapper)this.baseMapper).insert((Object)examination);
        for (ExaminationTopicDTO topicDTO : dto.getExaminationTopics()) {
            ExaminationTopic examinationTopic = new ExaminationTopic();
            examinationTopic.setExaminationPaperId(examination.getId());
            examinationTopic.setName(topicDTO.getName());
            examinationTopic.setDes(topicDTO.getDes());
            examinationTopic.setSort(topicDTO.getSort());
            this.examinationTopicMapper.insert((Object)examinationTopic);
            for (ExaminationTopicQuestionDTO questionDTO : topicDTO.getExaminationTopicQuestions()) {
                Long questionId = questionDTO.getQuestionId();
                this.questionService.checkApprovedQuestion(questionId);
                ExaminationTopicQuestion examinationTopicQuestion = new ExaminationTopicQuestion();
                examinationTopicQuestion.setExaminationTopicId(examinationTopic.getId());
                examinationTopicQuestion.setQuestionId(questionId);
                examinationTopicQuestion.setSort(questionDTO.getSort());
                examinationTopicQuestion.setPoint(questionDTO.getPoint());
                this.examinationTopicQuestionMapper.insert((Object)examinationTopicQuestion);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(ExaminationDTO dto) {
        if (dto == null || dto.getId() == null || CollectionUtils.isEmpty((Collection)dto.getExaminationTopics())) {
            throw new AppException("\u53c2\u6570\u9519\u8bef");
        }
        ExaminationPaper examination = (ExaminationPaper)((ExaminationPaperMapper)this.baseMapper).selectById((Serializable)dto.getId());
        List roles = this.roleService.getCurrentRoles();
        if (this.openApprove() && ISubmitStatusConstant.SUBMITTED.equals(examination.getSubmitStatus())) {
            if (!this.isPAP()) {
                throw new AppException("\u63d0\u4ea4\u540e\u53ea\u80fd\u7531\u5ba1\u6279\u4eba\u4fee\u6539\u8bd5\u9898");
            }
        } else if (roles.contains(RoleEnum.TEACHER.getCode()) && !examination.getCreatorId().equals(SecurityUtil.getUserId())) {
            throw new AppException("\u6ca1\u6709\u7f16\u8f91\u6743\u9650,\u53ea\u80fd\u7f16\u8f91\u81ea\u5df1\u521b\u5efa\u7684\u8bd5\u5377");
        }
        examination.setExaminationCatalogueId(dto.getExaminationCatalogueId());
        examination.setExamStartTime(dto.getExamStartTime());
        examination.setExamEndTime(dto.getExamEndTime());
        examination.setName(dto.getName());
        examination.setSubjectCode(dto.getSubjectCode());
        examination.setExamMinuteDuration(dto.getExamMinuteDuration());
        examination.setGradeId(dto.getGradeId());
        examination.setExamAreaId(dto.getExamAreaId());
        ((ExaminationPaperMapper)this.baseMapper).updateById((Object)examination);
        this.deleteAllRelation(dto.getId());
        for (ExaminationTopicDTO topicDTO : dto.getExaminationTopics()) {
            ExaminationTopic examinationTopic = new ExaminationTopic();
            examinationTopic.setExaminationPaperId(examination.getId());
            examinationTopic.setName(topicDTO.getName());
            examinationTopic.setDes(topicDTO.getDes());
            examinationTopic.setSort(topicDTO.getSort());
            this.examinationTopicMapper.insert((Object)examinationTopic);
            for (ExaminationTopicQuestionDTO questionDTO : topicDTO.getExaminationTopicQuestions()) {
                Long questionId = questionDTO.getQuestionId();
                this.questionService.checkApprovedQuestion(questionId);
                ExaminationTopicQuestion examinationTopicQuestion = new ExaminationTopicQuestion();
                examinationTopicQuestion.setExaminationTopicId(examinationTopic.getId());
                examinationTopicQuestion.setQuestionId(questionDTO.getQuestionId());
                examinationTopicQuestion.setSort(questionDTO.getSort());
                examinationTopicQuestion.setPoint(questionDTO.getPoint());
                this.examinationTopicQuestionMapper.insert((Object)examinationTopicQuestion);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void remove(String ids) {
        List<String> array = Arrays.asList(ids.split(","));
        List roles = this.roleService.getCurrentRoles();
        for (String id : array) {
            ExaminationPaper examination = (ExaminationPaper)((ExaminationPaperMapper)this.baseMapper).selectById((Serializable)Long.valueOf(id));
            if (roles.contains(RoleEnum.TEACHER.getCode()) && !examination.getCreatorId().equals(SecurityUtil.getUserId())) {
                throw new AppException("\u6ca1\u6709\u5220\u9664\u6743\u9650,\u53ea\u80fd\u5220\u9664\u81ea\u5df1\u521b\u5efa\u7684\u8bd5\u5377");
            }
            this.deleteAllRelation(Long.valueOf(id));
        }
        this.examinationMapper.deleteBatchIds(array);
    }

    @Transactional(rollbackFor={Exception.class})
    public void point(List<ExaminationPointDTO> dtos) {
        if (CollectionUtils.isEmpty(dtos)) {
            throw new AppException("\u53c2\u6570\u9519\u8bef");
        }
        for (ExaminationPointDTO dto : dtos) {
            ExaminationTopicQuestion examinationTopicQuestion = (ExaminationTopicQuestion)this.examinationTopicQuestionMapper.selectById((Serializable)dto.getId());
            examinationTopicQuestion.setPoint(dto.getPoint());
            this.examinationTopicQuestionMapper.updateById((Object)examinationTopicQuestion);
        }
    }

    public List<QuestionVO> generatePaper(ExaminationAutoDTO dto) {
        List list = null;
        if (Integer.valueOf(1).equals(dto.getType())) {
            list = this.generatePaperNumber(dto);
        } else if (Integer.valueOf(2).equals(dto.getType())) {
            list = this.generatePaperRandom(dto);
        }
        return list;
    }

    public List<QuestionVO> generatePaperNumber(ExaminationAutoDTO dto) {
        ArrayList<QuestionVO> questionVOS = new ArrayList<QuestionVO>();
        for (ExaminationAutoTypeDTO typeDTO : dto.getExaminationAutoTypeDTO()) {
            QuestionVO questionVO;
            int i;
            if (0 == typeDTO.getLevelCountA() && 0 == typeDTO.getLevelCountB() && 0 == typeDTO.getLevelCountC() && 0 == typeDTO.getLevelCountD()) {
                throw new AppException("\u53c2\u6570\u9519\u8bef\uff0c\u8bd5\u9898\u6570\u91cf\u4e0d\u80fd\u90fd\u4e3a0");
            }
            if (0 != typeDTO.getLevelCountA()) {
                for (i = 0; i < typeDTO.getLevelCountA(); ++i) {
                    questionVO = this.questionService.getRandomByCatalogueId(dto.getCatalogueIds(), Integer.valueOf(1), typeDTO.getType(), questionVOS.stream().map(QuestionVO::getId).collect(Collectors.toList()), dto.getSubjectCode());
                    questionVOS.add(questionVO);
                }
            }
            if (0 != typeDTO.getLevelCountB()) {
                for (i = 0; i < typeDTO.getLevelCountB(); ++i) {
                    questionVO = this.questionService.getRandomByCatalogueId(dto.getCatalogueIds(), Integer.valueOf(2), typeDTO.getType(), questionVOS.stream().map(QuestionVO::getId).collect(Collectors.toList()), dto.getSubjectCode());
                    questionVOS.add(questionVO);
                }
            }
            if (0 != typeDTO.getLevelCountC()) {
                for (i = 0; i < typeDTO.getLevelCountC(); ++i) {
                    questionVO = this.questionService.getRandomByCatalogueId(dto.getCatalogueIds(), Integer.valueOf(3), typeDTO.getType(), questionVOS.stream().map(QuestionVO::getId).collect(Collectors.toList()), dto.getSubjectCode());
                    questionVOS.add(questionVO);
                }
            }
            if (0 == typeDTO.getLevelCountD()) continue;
            for (i = 0; i < typeDTO.getLevelCountD(); ++i) {
                questionVO = this.questionService.getRandomByCatalogueId(dto.getCatalogueIds(), Integer.valueOf(4), typeDTO.getType(), questionVOS.stream().map(QuestionVO::getId).collect(Collectors.toList()), dto.getSubjectCode());
                questionVOS.add(questionVO);
            }
        }
        return questionVOS;
    }

    public List<QuestionVO> generatePaperRandom(ExaminationAutoDTO dto) {
        ArrayList<QuestionVO> questionVOS = new ArrayList<QuestionVO>();
        for (ExaminationAutoTypeDTO typeDTO : dto.getExaminationAutoTypeDTO()) {
            if (0 == typeDTO.getLevelCountA() && 0 == typeDTO.getLevelCountB() && 0 == typeDTO.getLevelCountC() && 0 == typeDTO.getLevelCountD()) {
                throw new AppException("\u53c2\u6570\u9519\u8bef\uff0c\u96be\u5ea6\u6bd4\u4f8b\u4e0d\u80fd\u90fd\u4e3a0");
            }
            ArrayList list = new ArrayList();
            this.addMapCount(Integer.valueOf(list.size()), Integer.valueOf(list.size() + typeDTO.getLevelCountA() * 100), Integer.valueOf(1), list);
            this.addMapCount(Integer.valueOf(list.size()), Integer.valueOf(list.size() + typeDTO.getLevelCountB() * 100), Integer.valueOf(2), list);
            this.addMapCount(Integer.valueOf(list.size()), Integer.valueOf(list.size() + typeDTO.getLevelCountC() * 100), Integer.valueOf(3), list);
            this.addMapCount(Integer.valueOf(list.size()), Integer.valueOf(list.size() + typeDTO.getLevelCountD() * 100), Integer.valueOf(4), list);
            for (int i = 0; i < typeDTO.getCount(); ++i) {
                RandomDomain randomDomain = null;
                int lastCount = 0;
                QuestionVO questionVO = null;
                while (questionVO == null) {
                    if (CollectionUtils.isEmpty(list)) {
                        QuestionType questionType = (QuestionType)this.questionTypeService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(QuestionType::getType, (Object)typeDTO.getType())).last(" limit 1"));
                        throw new AppException("\u83b7\u53d6\u9898\u578b\u5931\u8d25,[" + questionType.getDescription() + "]\u5728\u5bf9\u5e94\u96be\u5ea6\u4e0b\u9898\u6570\u4e0d\u591f");
                    }
                    int randomInt = RandomUtil.randomInt((int)list.size());
                    randomDomain = (RandomDomain)list.get(randomInt);
                    questionVO = this.questionService.getRandomByCatalogueId(dto.getCatalogueIds(), randomDomain.getType(), typeDTO.getType(), questionVOS.stream().map(QuestionVO::getId).collect(Collectors.toList()), dto.getSubjectCode());
                    if (null == questionVO) {
                        Integer type = randomDomain.getType();
                        List randomDomains = list.stream().filter(item -> item.getType().equals(type)).collect(Collectors.toList());
                        list.removeAll(randomDomains);
                    }
                    if (lastCount > 20) {
                        throw new AppException("\u83b7\u53d6\u8bd5\u9898\u5931\u8d25\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u96be\u5ea6\u8bd5\u9898\uff0c\u9898\u76ee\u7c7b\u578b:" + typeDTO.getType() + ",\u96be\u5ea6:" + randomDomain.getType());
                    }
                    ++lastCount;
                }
                questionVOS.add(questionVO);
                list.remove(randomDomain);
            }
        }
        return questionVOS;
    }

    public List<ExaminationAutoBatchVO> generatePaperBatch(ExaminationAutoDTO dto) {
        ArrayList<ExaminationAutoBatchVO> list = new ArrayList<ExaminationAutoBatchVO>();
        for (int i = 0; i < dto.getExaminationPaperCount(); ++i) {
            ExaminationAutoBatchVO vo = new ExaminationAutoBatchVO();
            vo.setExaminationPaperCount(Integer.valueOf(i));
            ArrayList<QuestionSimpleVO> simpleVOS = new ArrayList<QuestionSimpleVO>();
            List questionVOS = this.generatePaper(dto);
            for (QuestionVO questionVO : questionVOS) {
                QuestionSimpleVO questionSimpleVO = new QuestionSimpleVO();
                questionSimpleVO.setQuType(questionVO.getQuType());
                questionSimpleVO.setId(questionVO.getId());
                simpleVOS.add(questionSimpleVO);
            }
            vo.setQuestionSimpleVOS(simpleVOS);
            list.add(vo);
        }
        return list;
    }

    public List<ExamSimpleVO> examInfo(Long id) {
        List list = this.examService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Exam::getExaminationPaperId, (Object)id)).eq(Exam::getEnable, (Object)1)).eq(Exam::getIsDeleted, (Object)false));
        ArrayList<ExamSimpleVO> examSimpleVOS = new ArrayList<ExamSimpleVO>();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return examSimpleVOS;
        }
        for (Exam exam : list) {
            ExamSimpleVO vo = new ExamSimpleVO();
            vo.setId(exam.getId());
            vo.setStartTime(exam.getStartTime());
            vo.setEndTime(exam.getEndTime());
            vo.setName(exam.getTitle());
            examSimpleVOS.add(vo);
        }
        return examSimpleVOS;
    }

    private void addMapCount(Integer start, Integer count, Integer type, List<RandomDomain> list) {
        if (count == null || count == 0) {
            return;
        }
        for (int i = start.intValue(); i < count; ++i) {
            RandomDomain randomDomain = new RandomDomain(this, Integer.valueOf(i), type);
            list.add(randomDomain);
        }
    }

    private void deleteAllRelation(Long id) {
        List examinationTopics = this.examinationTopicMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(ExaminationTopic::getExaminationPaperId, (Object)id));
        if (CollectionUtils.isNotEmpty((Collection)examinationTopics)) {
            List topicIds = examinationTopics.stream().map(ExaminationTopic::getId).collect(Collectors.toList());
            this.examinationTopicMapper.deleteBatchIds(topicIds);
            for (Long topicId : topicIds) {
                this.examinationTopicQuestionMapper.delete((Wrapper)new LambdaQueryWrapper().eq(ExaminationTopicQuestion::getExaminationTopicId, (Object)topicId));
            }
        }
    }

    public boolean isPAP() {
        List postCodeList = SecurityUtil.getPostCodeList();
        return postCodeList.contains("pap");
    }

    public boolean openApprove() {
        SysParam isPaperApprove = this.sysParamService.getByType(SysParamEnum.PAPER_APPROVE.getType());
        if (null != isPaperApprove && !"1".equals(isPaperApprove.getValue())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public void approve(PaperApproveDto dto) {
        if (!this.isPAP()) {
            throw new AppException("\u53ea\u80fd\u7531\u5ba1\u6838\u5458\u624d\u80fd\u5ba1\u6838");
        }
        List paperIds = dto.getPaperIds();
        for (Long id : paperIds) {
            ExaminationPaper db = (ExaminationPaper)this.getById((Serializable)id);
            if (ISubmitStatusConstant.DRAFT.equals(db.getSubmitStatus())) {
                throw new AppException("\u672a\u63d0\u4ea4\u72b6\u6001\u7684\u8bd5\u5377\u4e0d\u80fd\u5ba1\u6838");
            }
            Integer approveStatus = dto.getApproveStatus();
            db.setApproveStatus(dto.getApproveStatus());
            if (IQuestionApproveStatus.APPROVE_PASS.equals(approveStatus)) {
                if (StringUtils.isBlank((CharSequence)dto.getRejectReason())) {
                    db.setRejectReason("");
                } else {
                    db.setRejectReason(dto.getRejectReason());
                }
            } else if (IQuestionApproveStatus.APPROVE_REJECT.equals(approveStatus)) {
                db.setRejectReason(dto.getRejectReason());
                db.setSubmitStatus(ISubmitStatusConstant.DRAFT);
            }
            db.setApproveTime(LocalDateTime.now());
            this.updateById((Object)db);
            ExaminationPaperApprove examinationPaperApprove = new ExaminationPaperApprove();
            examinationPaperApprove.setPaperId(id);
            examinationPaperApprove.setApproveTime(LocalDateTime.now());
            examinationPaperApprove.setApproveUser(SecurityUtil.getUserId());
            examinationPaperApprove.setApproveStatus(approveStatus);
            examinationPaperApprove.setRejectReason(dto.getRejectReason());
            examinationPaperApprove.setApplicantUser(db.getCreatorId());
            examinationPaperApprove.setSubmitTime(db.getSubmitTime());
            this.approveService.save((Object)examinationPaperApprove);
            this.userMessageService.sendMessageExaminationPaper(db, Integer.valueOf(2));
        }
    }

    public void submit(Long id) {
        ExaminationPaper db = (ExaminationPaper)this.getById((Serializable)id);
        if (null == db) {
            throw new AppException("\u8bd5\u5377\u4e0d\u5b58\u5728");
        }
        if (!this.openApprove()) {
            db.setSubmitStatus(Integer.valueOf(1));
            LocalDateTime now = LocalDateTime.now();
            db.setSubmitTime(now);
            db.setApproveStatus(IQuestionApproveStatus.APPROVE_PASS);
            db.setApproveTime(now);
            ExaminationPaperApprove examinationPaperApprove = new ExaminationPaperApprove();
            examinationPaperApprove.setPaperId(db.getId());
            examinationPaperApprove.setApproveTime(now);
            examinationPaperApprove.setApproveUser(SecurityUtil.getUserId());
            examinationPaperApprove.setRejectReason("\u7cfb\u7edf\u5df2\u914d\u7f6e\u65e0\u9700\u5ba1\u6279\uff0c\u81ea\u52a8\u5ba1\u6279\u901a\u8fc7");
            examinationPaperApprove.setApproveStatus(IQuestionApproveStatus.APPROVE_PASS);
            examinationPaperApprove.setApplicantUser(db.getCreatorId());
            examinationPaperApprove.setSubmitTime(db.getSubmitTime());
            this.approveService.save((Object)examinationPaperApprove);
        } else {
            db.setSubmitStatus(ISubmitStatusConstant.SUBMITTED);
            db.setApproveStatus(IQuestionApproveStatus.APPROVE_WAIT);
            db.setSubmitTime(LocalDateTime.now());
            this.userMessageService.sendMessageExaminationPaper(db, Integer.valueOf(1));
        }
        this.updateById((Object)db);
    }

    public ExamAnalysisVO getAnalysisResult(Long id) {
        ExaminationPaper examinationPaper = (ExaminationPaper)this.getById((Serializable)id);
        if (null == examinationPaper) {
            throw new AppException("\u83b7\u53d6\u8bd5\u5377\u5931\u8d25");
        }
        List exams = this.examService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{Exam::getId}).eq(Exam::getExaminationPaperId, (Object)id)).eq(Exam::getIsDeleted, (Object)false));
        ExamAnalysisVO examAnalysisVO = new ExamAnalysisVO();
        ArrayList<ExamAnalysisDetailVO> details = new ArrayList<ExamAnalysisDetailVO>();
        ArrayList<ExamKnowledgeQuestionVO> examKnowledgeQuestionVOS = new ArrayList<ExamKnowledgeQuestionVO>();
        HashSet<Long> examKnowledgeIds = new HashSet<Long>();
        if (CollectionUtils.isEmpty((Collection)exams)) {
            throw new AppException("\u5f53\u524d\u8bd5\u5377\u6ca1\u6709\u8003\u8bd5\u8bb0\u5f55");
        }
        List examQuAnswerVOS = this.examQuAnswerMapper.selectExamQuAnswerForAnalysis(id);
        List examinationPaperQuestionVOS = this.examQuAnswerMapper.selectPaperQuestion(id);
        List allUserExam = this.userExamsScoreMapper.getAllUserExamByPaperId(id);
        BigDecimal examDifficultyPoint = BigDecimal.ZERO;
        for (ExaminationPaperQuestionVO questionVO : examinationPaperQuestionVOS) {
            ExamKnowledgeQuestionVO examKnowledgeQuestionVO;
            Object isRightAnswer;
            ExamAnalysisDetailVO detailVO = new ExamAnalysisDetailVO();
            Long questionId = questionVO.getQuestionId();
            detailVO.setSort(questionVO.getSort());
            detailVO.setTopicSort(questionVO.getTopicSort());
            detailVO.setQuestionId(questionId);
            detailVO.setKnowledgeName(questionVO.getKnowledgeName());
            detailVO.setQuestionCode(questionVO.getQuestionCode());
            detailVO.setIsCombination(questionVO.getIsCombination());
            detailVO.setMainCombinationId(questionVO.getMainCombinationId());
            Integer totalCount = 0;
            Integer isRightCount = 0;
            BigDecimal questionPoint = BigDecimal.ZERO;
            BigDecimal isGetPoint = BigDecimal.ZERO;
            boolean hasQuestion = false;
            boolean hasOtherQuestion = false;
            HashMap<String, Integer> answerMap = new HashMap<String, Integer>();
            if (QuestionTypeEnum.getObjective().contains(questionVO.getQuestionType())) {
                detailVO.setIsObjective(Integer.valueOf(1));
            } else {
                detailVO.setIsObjective(Integer.valueOf(0));
            }
            List optionRightList = this.optionService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{Option::getContent}).eq(Option::getQuId, (Object)questionId)).eq(Option::getIsRight, (Object)1));
            if (CollectionUtils.isNotEmpty((Collection)optionRightList) && Integer.valueOf(1).equals(detailVO.getIsObjective())) {
                List isRightAnswers = optionRightList.stream().map(Option::getContent).collect(Collectors.toList());
                ArrayList<String> splitRightAnswer = new ArrayList<String>();
                if (questionVO.getQuestionType().equals(QuestionTypeEnum.SINGLE.getType()) || questionVO.getQuestionType().equals(QuestionTypeEnum.MULTI.getType())) {
                    Iterator iterator = isRightAnswers.iterator();
                    while (iterator.hasNext()) {
                        isRightAnswer = (String)iterator.next();
                        splitRightAnswer.add(((String)isRightAnswer).substring(0, 1));
                    }
                } else {
                    splitRightAnswer.addAll(isRightAnswers);
                }
                detailVO.setAnswer(String.join((CharSequence)",", splitRightAnswer));
            }
            block7: for (UserExamsScore userExamsScore : allUserExam) {
                Optional<ExamQuAnswerVO> answerFirst = examQuAnswerVOS.stream().filter(item -> item.getUserId().equals(userExamsScore.getUserId()) && item.getExamId().equals(userExamsScore.getExamId()) && item.getQuestionId().equals(questionId)).findFirst();
                isRightAnswer = totalCount;
                totalCount = totalCount + 1;
                if (!answerFirst.isPresent()) {
                    if (null == answerMap.get("\u65e0")) {
                        answerMap.put("\u65e0", 1);
                        continue;
                    }
                    answerMap.put("\u65e0", (Integer)answerMap.get("\u65e0") + 1);
                    continue;
                }
                ExamQuAnswerVO vo = answerFirst.get();
                if (Integer.valueOf(1).equals(detailVO.getIsObjective())) {
                    if (Integer.valueOf(1).equals(vo.getIsRight())) {
                        Integer n = isRightCount;
                        isRightCount = isRightCount + 1;
                    }
                    hasQuestion = true;
                    if (!QuestionTypeEnum.getObjective().contains(vo.getExamQuestionType())) continue;
                    if (null == vo.getAnswer()) {
                        if (null == answerMap.get("\u65e0")) {
                            answerMap.put("\u65e0", 1);
                            continue;
                        }
                        answerMap.put("\u65e0", (Integer)answerMap.get("\u65e0") + 1);
                        continue;
                    }
                    switch (2.$SwitchMap$com$zsy$exam$constant$QuestionTypeEnum[vo.getQuestionType().ordinal()]) {
                        case 1: {
                            String option = vo.getAnswer().substring(0, 1);
                            if (null == answerMap.get(option)) {
                                answerMap.put(option, 1);
                                continue block7;
                            }
                            answerMap.put(option, (Integer)answerMap.get(option) + 1);
                            continue block7;
                        }
                        case 2: {
                            if (null == answerMap.get(vo.getAnswer())) {
                                answerMap.put(vo.getAnswer(), 1);
                                continue block7;
                            }
                            answerMap.put(vo.getAnswer(), (Integer)answerMap.get(vo.getAnswer()) + 1);
                            continue block7;
                        }
                        case 3: {
                            List options = this.optionService.list((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{Option::getContent}).in(Option::getId, (Object[])vo.getAnswerId().split(",")));
                            String answer = String.join((CharSequence)",", options.stream().map(item -> item.getContent().substring(0, 1)).collect(Collectors.toList()));
                            if (null == answerMap.get(answer)) {
                                answerMap.put(answer, 1);
                                continue block7;
                            }
                            answerMap.put(answer, (Integer)answerMap.get(answer) + 1);
                            continue block7;
                        }
                    }
                    continue;
                }
                hasOtherQuestion = true;
                questionPoint = vo.getPoint();
                ManualScore manualScore = (ManualScore)this.manualScoreMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(ManualScore::getExamQuAnswerId, (Object)vo.getId()));
                if (null == manualScore) continue;
                isGetPoint = isGetPoint.add(manualScore.getScore());
            }
            if (hasQuestion) {
                detailVO.setQuestionDifficultyPoint(new BigDecimal(1).subtract(new BigDecimal(isRightCount).divide(new BigDecimal(totalCount), 2, RoundingMode.HALF_UP)));
                detailVO.setAnswerScale(new BigDecimal(isRightCount).divide(new BigDecimal(totalCount), 2, RoundingMode.HALF_UP));
                String sortKey = ExaminationPaperServiceImpl.sortMap(answerMap);
                Integer sortValue = (Integer)answerMap.get(sortKey);
                detailVO.setMaxAnswer(sortKey);
                detailVO.setMaxAnswerScale(new BigDecimal(sortValue).divide(new BigDecimal(totalCount), 2, RoundingMode.HALF_UP));
                if (sortKey.equals(detailVO.getAnswer())) {
                    detailVO.setOtherAnswerScale(new BigDecimal(1).subtract(detailVO.getAnswerScale()));
                } else {
                    detailVO.setOtherAnswerScale(new BigDecimal(1).subtract(detailVO.getAnswerScale()).subtract(detailVO.getMaxAnswerScale()));
                }
                detailVO.setQuestionErrorScale(new BigDecimal(1).subtract(detailVO.getAnswerScale()));
            }
            if (hasOtherQuestion) {
                BigDecimal totalPoint = new BigDecimal(totalCount).multiply(questionPoint);
                if (BigDecimal.ZERO.equals(totalPoint)) {
                    detailVO.setQuestionDifficultyPoint(new BigDecimal(1));
                } else {
                    detailVO.setQuestionDifficultyPoint(new BigDecimal(1).subtract(isGetPoint.divide(totalPoint, 2, RoundingMode.HALF_UP)));
                }
            }
            examDifficultyPoint = examDifficultyPoint.add(detailVO.getQuestionDifficultyPoint());
            details.add(detailVO);
            if (examKnowledgeIds.contains(questionVO.getRepoId())) {
                examKnowledgeQuestionVO = examKnowledgeQuestionVOS.stream().filter(item -> item.getKnowledgeName().equals(questionVO.getKnowledgeName())).findFirst().get();
                examKnowledgeQuestionVO.setCount(Integer.valueOf(examKnowledgeQuestionVO.getCount() + 1));
                continue;
            }
            examKnowledgeQuestionVO = new ExamKnowledgeQuestionVO();
            examKnowledgeQuestionVO.setKnowledgeName(questionVO.getKnowledgeName());
            examKnowledgeQuestionVO.setCount(Integer.valueOf(1));
            examKnowledgeQuestionVOS.add(examKnowledgeQuestionVO);
            examKnowledgeIds.add(questionVO.getRepoId());
        }
        examAnalysisVO.setExamDifficultyPoint(examDifficultyPoint.divide(new BigDecimal(examinationPaperQuestionVOS.size()), 2, RoundingMode.HALF_UP));
        examAnalysisVO.setDetails(details);
        examAnalysisVO.setKnowledgeQuestions(examKnowledgeQuestionVOS);
        List list = this.catalogueService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Catalogue::getDeleted, (Object)false)).eq(Catalogue::getSubjectCode, (Object)examinationPaper.getSubjectCode())).eq(Catalogue::getLevel, (Object)4));
        examAnalysisVO.setKnowledgeScale(new BigDecimal(examKnowledgeIds.size()).divide(new BigDecimal(list.size()), 2, RoundingMode.HALF_UP));
        return examAnalysisVO;
    }

    public Boolean hasPaperUsedQuestion(Long questionId) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(ExaminationTopicQuestion::getQuestionId, (Object)questionId);
        return this.examinationTopicQuestionMapper.exists((Wrapper)qw);
    }

    public Integer getExaminationCount() {
        Integer count = ((ExaminationPaperMapper)this.baseMapper).getAllCount();
        return count;
    }

    public PaperExportDto export(Long id) {
        String examinationCataloguePath;
        PaperExportDto exportDto = new PaperExportDto();
        ExaminationPaper examinationPaper = (ExaminationPaper)this.getById((Serializable)id);
        exportDto.setPaper(examinationPaper);
        List examinationTopics = this.examinationTopicMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(ExaminationTopic::getExaminationPaperId, (Object)id));
        exportDto.setTopicList(examinationTopics);
        examinationTopics.parallelStream().forEach(examinationTopic -> {
            Long topicId = examinationTopic.getId();
            List topicQuestions = this.examinationTopicQuestionMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(ExaminationTopicQuestion::getExaminationTopicId, (Object)topicId));
            exportDto.getTopicQuestionList().addAll(topicQuestions);
            topicQuestions.parallelStream().forEach(topic -> {
                Long questionId = topic.getQuestionId();
                List questionList = this.questionService.getExportByMainId(questionId);
                exportDto.getQuestionList().addAll(questionList);
            });
        });
        Long examinationCatalogueId = examinationPaper.getExaminationCatalogueId();
        ExaminationCatalogue examinationCatalogue = (ExaminationCatalogue)this.examinationCatalogueService.getById((Serializable)examinationCatalogueId);
        exportDto.getExaminationCatalogues().add(examinationCatalogue);
        if (null != examinationCatalogue && StringUtils.isNotBlank((CharSequence)(examinationCataloguePath = examinationCatalogue.getPath()))) {
            List<Long> fatherIds = Arrays.stream(examinationCataloguePath.split(",")).map(Long::parseLong).toList();
            ArrayList<Long> repoIds = new ArrayList<Long>();
            for (Long l : fatherIds) {
                if (repoIds.contains(l)) continue;
                ExaminationCatalogue fatherCa = (ExaminationCatalogue)this.examinationCatalogueService.getById((Serializable)l);
                exportDto.getExaminationCatalogues().add(fatherCa);
                repoIds.add(l);
            }
        }
        ArrayList picList = new ArrayList();
        ArrayList<Long> repoIds = new ArrayList<Long>();
        ArrayList<Catalogue> repoList = new ArrayList<Catalogue>();
        List questionList = exportDto.getQuestionList();
        for (QuestionExportDto dt : questionList) {
            Question q = dt.getQuestion();
            Long repoId = q.getRepoId();
            if (!repoIds.contains(repoId)) {
                repoIds.add(repoId);
                Catalogue catalogue4 = (Catalogue)this.catalogueService.getById((Serializable)repoId);
                repoList.add(catalogue4);
                String path = catalogue4.getPath();
                if (path.startsWith("/")) {
                    path = path.substring(1, path.length() - 1);
                }
                List<Long> fatherIds = Arrays.stream(path.split("/")).map(Long::parseLong).toList();
                for (Long fatherId : fatherIds) {
                    if (repoIds.contains(fatherId)) continue;
                    Catalogue fatherCa = (Catalogue)this.catalogueService.getById((Serializable)fatherId);
                    repoList.add(fatherCa);
                    repoIds.add(fatherId);
                }
            }
            picList.addAll(this.questionService.getImgSrcByContent(q.getContent()));
            picList.addAll(this.questionService.getImgSrcByContent(q.getAnalysis()));
            List optionList = dt.getOptionList();
            optionList.forEach(o -> picList.addAll(this.questionService.getImgSrcByContent(o.getContent())));
        }
        exportDto.setCatalogueList(repoList);
        List list = this.minioUtil.getPicBase64(picList);
        exportDto.setPicList(list);
        if (null != examinationPaper.getExamAreaId()) {
            ExamArea examArea = (ExamArea)this.examAreaService.getById((Serializable)examinationPaper.getExamAreaId());
            List examAreaDetails = this.examAreaDetailMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(ExamAreaDetail::getExamAreaId, (Object)examinationPaper.getExamAreaId()));
            exportDto.setExamArea(examArea);
            exportDto.setExamAreaDetails(examAreaDetails);
        }
        return exportDto;
    }

    @Transactional(rollbackFor={Exception.class})
    public void importPaper(PaperExportDto exportDto, Integer exportWay) {
        List questionList = exportDto.getQuestionList();
        List catalogueList = exportDto.getCatalogueList();
        catalogueList.forEach(catalogue -> {
            Long id = catalogue.getId();
            Catalogue catalogueDb = (Catalogue)this.catalogueService.getById((Serializable)id);
            this.catalogueService.saveOrUpdate(catalogue);
        });
        questionList.forEach(q -> {
            Question question = q.getQuestion();
            List optionList = q.getOptionList();
            String code = question.getCode();
            Question qDb = this.questionService.getByCode(code);
            if (null == qDb) {
                qDb = (Question)this.questionService.getById((Serializable)question.getId());
            }
            if (null != qDb) {
                this.questionService.physicalDelete(qDb.getId());
            }
            this.questionService.save((Object)question);
            this.optionService.saveBatch((Collection)optionList);
        });
        ExaminationPaper paper = exportDto.getPaper();
        ExaminationPaper paperDb = (ExaminationPaper)this.getById((Serializable)paper.getId());
        paper.setUpdateTime(LocalDateTime.now());
        paper.setCreateTime(LocalDateTime.now());
        paper.setCreatorId(SecurityUtil.getUserId());
        paper.setExportWay(exportWay);
        this.deleteAllRelation(paper.getId());
        this.saveOrUpdate((Object)paper);
        List examinationCatalogues = exportDto.getExaminationCatalogues();
        this.examinationCatalogueService.saveOrUpdateBatch((Collection)examinationCatalogues);
        List topicList = exportDto.getTopicList();
        topicList.forEach(a -> this.examinationTopicMapper.insert(a));
        List topicQuestionList = exportDto.getTopicQuestionList();
        topicQuestionList.forEach(a -> this.examinationTopicQuestionMapper.insert(a));
        List picList = exportDto.getPicList();
        picList.forEach(pic -> this.minioUtil.upload(pic));
        if (null != exportDto.getExamArea()) {
            this.examAreaService.saveOrUpdate((Object)exportDto.getExamArea());
            this.examAreaService.addOrUpdateAreaDetail(exportDto.getExamArea().getId(), exportDto.getExamAreaDetails());
        }
    }

    public static String sortMap(Map<String, Integer> map) {
        if (MapUtils.isEmpty(map)) {
            return null;
        }
        ArrayList<Map.Entry<String, Integer>> entryList = new ArrayList<Map.Entry<String, Integer>>(map.entrySet());
        Collections.sort(entryList, new /* Unavailable Anonymous Inner Class!! */);
        return (String)((Map.Entry)entryList.get(0)).getKey();
    }

    private String getCalalogueNameById(Long id, List<Catalogue> list) {
        if (null == id) {
            return null;
        }
        Catalogue catalogue = list.stream().filter(item -> item.getId().equals(id)).findFirst().get();
        List pathCodes = ExaminationPaperServiceImpl.getStringList((String)catalogue.getPathCode());
        List collect = list.stream().filter(item -> pathCodes.subList(1, pathCodes.size()).contains(item.getPathCode())).collect(Collectors.toList());
        String pathName = collect.stream().map(Catalogue::getName).collect(Collectors.joining("/"));
        return pathName;
    }

    public static List<String> getStringList(String pathCode) {
        Integer count = 0;
        ArrayList<String> list = new ArrayList<String>();
        while (true) {
            String s = "";
            int i = pathCode.indexOf("\uff0d", count + 1);
            if (i < 0) break;
            String result = pathCode.substring(0, i);
            list.add(result);
            count = i;
        }
        list.add(pathCode);
        return list;
    }
}

