/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.constant.RoleEnum;
import com.zsy.exam.mapper.ExerciseCatalogueMapper;
import com.zsy.exam.model.entity.Exercise;
import com.zsy.exam.model.entity.ExerciseCatalogue;
import com.zsy.exam.model.vo.exercise.ExerciseCatalogueDTO;
import com.zsy.exam.model.vo.exercise.ExerciseCatalogueTreeListVO;
import com.zsy.exam.service.IExerciseCatalogueService;
import com.zsy.exam.service.IExerciseService;
import com.zsy.exam.service.IRoleService;
import com.zsy.exam.service.ISubjectService;
import com.zsy.exam.util.SecurityUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExerciseCatalogueServiceImpl
extends ServiceImpl<ExerciseCatalogueMapper, ExerciseCatalogue>
implements IExerciseCatalogueService {
    @Autowired
    ExerciseCatalogueMapper exerciseCatalogueMapper;
    @Autowired
    private IExerciseService exerciseService;
    @Autowired
    private ISubjectService subjectService;
    @Autowired
    private IRoleService roleService;

    public ExerciseCatalogue getExerciseCatalogue(Long id) {
        return (ExerciseCatalogue)this.exerciseCatalogueMapper.selectById((Serializable)id);
    }

    public List<ExerciseCatalogueTreeListVO> getAllExerciseCatalogue() {
        List roles = this.roleService.getCurrentRoles();
        List subjectCodes = null;
        if (roles.contains(RoleEnum.TEACHER.getCode())) {
            subjectCodes = SecurityUtil.getSubjectCode();
        } else if (roles.contains(RoleEnum.ADMIN.getCode()) || roles.contains(RoleEnum.SUPER_ADMIN.getCode())) {
            // empty if block
        }
        List vos = this.exerciseCatalogueMapper.queryList(subjectCodes);
        if (CollectionUtils.isEmpty((Collection)vos)) {
            return vos;
        }
        List pList = vos.stream().filter(item -> null == item.getParentId()).collect(Collectors.toList());
        List treeListVOS = this.treeList(pList, vos);
        return treeListVOS;
    }

    public void add(ExerciseCatalogueDTO dto) {
        ExerciseCatalogue exerciseCatalogue = new ExerciseCatalogue();
        BeanUtils.copyProperties((Object)dto, (Object)exerciseCatalogue);
        ExerciseCatalogue exerciseCatalogueOld = (ExerciseCatalogue)((ExerciseCatalogueMapper)this.baseMapper).selectOne((Wrapper)new LambdaQueryWrapper().eq(ExerciseCatalogue::getCode, (Object)dto.getCode()));
        if (null != exerciseCatalogueOld) {
            throw new AppException("\u7f16\u7801\u91cd\u590d");
        }
        Object path = "";
        if (null != exerciseCatalogue.getParentId()) {
            ExerciseCatalogue parentExam = (ExerciseCatalogue)this.getById((Serializable)exerciseCatalogue.getParentId());
            path = (String)path + parentExam.getPath() + ",";
            exerciseCatalogue.setLevel(Integer.valueOf(parentExam.getLevel() + 1));
        } else {
            exerciseCatalogue.setLevel(Integer.valueOf(1));
        }
        this.exerciseCatalogueMapper.insert((Object)exerciseCatalogue);
        exerciseCatalogue.setPath((String)path + exerciseCatalogue.getId());
        this.updateById((Object)exerciseCatalogue);
    }

    public void update(ExerciseCatalogueDTO dto) {
        if (null == dto.getId()) {
            throw new AppException("\u53c2\u6570\u9519\u8bef");
        }
        ExerciseCatalogue exerciseCatalogueOld = (ExerciseCatalogue)((ExerciseCatalogueMapper)this.baseMapper).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ExerciseCatalogue::getCode, (Object)dto.getCode())).ne(ExerciseCatalogue::getId, (Object)dto.getId()));
        if (null != exerciseCatalogueOld) {
            throw new AppException("\u7f16\u7801\u91cd\u590d");
        }
        ExerciseCatalogue exerciseCatalogue = (ExerciseCatalogue)this.getById((Serializable)dto.getId());
        BeanUtils.copyProperties((Object)dto, (Object)exerciseCatalogue);
        if (null != dto.getParentId()) {
            ExerciseCatalogue pExam = (ExerciseCatalogue)this.getById((Serializable)dto.getParentId());
            exerciseCatalogue.setPath(pExam.getPath() + "," + exerciseCatalogue.getId());
            exerciseCatalogue.setLevel(Integer.valueOf(pExam.getLevel() + 1));
        } else {
            exerciseCatalogue.setLevel(Integer.valueOf(1));
            exerciseCatalogue.setPath("" + exerciseCatalogue.getId());
        }
        this.exerciseCatalogueMapper.updateById((Object)exerciseCatalogue);
    }

    public void remove(String ids) {
        List<String> list = Arrays.asList(ids.split(","));
        if (!CollectionUtils.isEmpty(list)) {
            for (String id : list) {
                List exams = ((ExerciseCatalogueMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(ExerciseCatalogue::getPath, (Object)id)).ne(ExerciseCatalogue::getId, (Object)id));
                if (CollectionUtils.isNotEmpty((Collection)exams)) {
                    throw new AppException("\u5f53\u524d\u76ee\u5f55\u6709\u4e0b\u7ea7\u76ee\u5f55,\u4e0d\u80fd\u5220\u9664");
                }
                List exercises = this.exerciseService.list((Wrapper)new LambdaQueryWrapper().eq(Exercise::getCatalogueId, (Object)id));
                if (!CollUtil.isNotEmpty((Collection)exercises)) continue;
                throw new AppException("\u5f53\u524d\u76ee\u5f55\u6709\u5173\u8054\u7684\u7ec3\u4e60,\u4e0d\u80fd\u5220\u9664");
            }
            this.exerciseCatalogueMapper.deleteBatchIds(list);
        }
    }

    private List<ExerciseCatalogueTreeListVO> treeList(List<ExerciseCatalogueTreeListVO> calalogueTree, List<ExerciseCatalogueTreeListVO> all) {
        if (CollectionUtils.isEmpty(calalogueTree)) {
            return calalogueTree;
        }
        for (ExerciseCatalogueTreeListVO vo : calalogueTree) {
            List collect = all.stream().filter(item -> vo.getId().equals(item.getParentId())).collect(Collectors.toList());
            vo.setChildren(collect);
            this.treeList(collect, all);
        }
        return calalogueTree;
    }
}

