/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.mapper.ExerciseClbumMapper;
import com.zsy.exam.model.entity.ExerciseClbum;
import com.zsy.exam.service.IExerciseClbumService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ExerciseClbumServiceImpl
extends ServiceImpl<ExerciseClbumMapper, ExerciseClbum>
implements IExerciseClbumService {
    @Autowired
    ExerciseClbumMapper exerciseClbumMapper;

    public ExerciseClbum getExerciseClbum(Long id) {
        return (ExerciseClbum)this.exerciseClbumMapper.selectById((Serializable)id);
    }

    public Page<List<ExerciseClbum>> getAllExerciseClbum(Page page) {
        return (Page)this.exerciseClbumMapper.selectPage((IPage)page, null);
    }

    public void add(ExerciseClbum exerciseClbum) {
        this.exerciseClbumMapper.insert((Object)exerciseClbum);
    }

    public int modify(ExerciseClbum exerciseClbum) {
        return this.exerciseClbumMapper.updateById((Object)exerciseClbum);
    }

    public void remove(String ids) {
        String[] array;
        if (StringUtils.isNotEmpty((CharSequence)ids) && !CollectionUtils.isEmpty(Arrays.asList(array = ids.split(",")))) {
            this.exerciseClbumMapper.deleteBatchIds(Arrays.asList(array));
        }
    }

    public void removeAndAdd(Long exerciseId, List<Long> clbumIds) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(ExerciseClbum::getExerciseId, (Object)exerciseId);
        ((ExerciseClbumMapper)this.baseMapper).delete((Wrapper)qw);
        if (CollUtil.isNotEmpty(clbumIds)) {
            clbumIds.forEach(clbumId -> {
                ExerciseClbum exerciseClbum = new ExerciseClbum();
                exerciseClbum.setExerciseId(exerciseId);
                exerciseClbum.setClbumId(clbumId);
                this.save((Object)exerciseClbum);
            });
        }
    }

    public List<Long> getByExerciseId(Long exerciseId) {
        return ((ExerciseClbumMapper)this.baseMapper).getByExerciseId(exerciseId);
    }

    public Integer getTotalExerciseStudentCount(Long exerciseId) {
        return ((ExerciseClbumMapper)this.baseMapper).getTotalExerciseStudentCount(exerciseId);
    }
}

