/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.mapper.ExerciseQuestionMapper;
import com.zsy.exam.model.entity.ExerciseQuestion;
import com.zsy.exam.model.entity.Question;
import com.zsy.exam.service.IExerciseQuestionService;
import com.zsy.exam.service.IQuestionService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ExerciseQuestionServiceImpl
extends ServiceImpl<ExerciseQuestionMapper, ExerciseQuestion>
implements IExerciseQuestionService {
    @Autowired
    ExerciseQuestionMapper exerciseQuestionMapper;
    @Autowired
    private IQuestionService questionService;

    public ExerciseQuestion getExerciseQuestion(Long id) {
        return (ExerciseQuestion)this.exerciseQuestionMapper.selectById((Serializable)id);
    }

    public Page<List<ExerciseQuestion>> getAllExerciseQuestion(Page page) {
        return (Page)this.exerciseQuestionMapper.selectPage((IPage)page, null);
    }

    public void add(ExerciseQuestion exerciseQuestion) {
        this.exerciseQuestionMapper.insert((Object)exerciseQuestion);
    }

    public int modify(ExerciseQuestion exerciseQuestion) {
        return this.exerciseQuestionMapper.updateById((Object)exerciseQuestion);
    }

    public void remove(String ids) {
        String[] array;
        if (StringUtils.isNotEmpty((CharSequence)ids) && !CollectionUtils.isEmpty(Arrays.asList(array = ids.split(",")))) {
            this.exerciseQuestionMapper.deleteBatchIds(Arrays.asList(array));
        }
    }

    public void removeAndAdd(Long exerciseId, List<Long> questionList) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(ExerciseQuestion::getExerciseId, (Object)exerciseId);
        ((ExerciseQuestionMapper)this.baseMapper).delete((Wrapper)qw);
        if (CollUtil.isNotEmpty(questionList)) {
            questionList.forEach(id -> {
                ExerciseQuestion db = new ExerciseQuestion();
                Question question = (Question)this.questionService.getById((Serializable)id);
                if (null == question) {
                    throw new AppException("\u8bd5\u9898\u4e0d\u5b58\u5728");
                }
                if (question.getIsCombination().booleanValue()) {
                    throw new AppException("\u4e0d\u652f\u6301\u7ec4\u5408\u9898:" + question.getCode());
                }
                db.setExerciseId(exerciseId);
                db.setQuestionId(id);
                this.save((Object)db);
            });
        }
    }

    public List<Long> getQuestionIdByExerciseId(Long exerciseId) {
        return ((ExerciseQuestionMapper)this.baseMapper).getQuestionIdByExerciseId(exerciseId);
    }

    public List<Long> getExerciseIddByQuestionId(Long questionId) {
        return ((ExerciseQuestionMapper)this.baseMapper).getExerciseIddByQuestionId(questionId);
    }
}

