/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.constant.QuestionTypeEnum;
import com.zsy.exam.mapper.ExerciseRecordMapper;
import com.zsy.exam.model.dto.exercise.AnswerProcessDto;
import com.zsy.exam.model.dto.exercise.ExerciseRecordDto;
import com.zsy.exam.model.entity.ExerciseRecord;
import com.zsy.exam.model.entity.ExerciseRecordDetail;
import com.zsy.exam.model.entity.ExerciseRecordDetailHistory;
import com.zsy.exam.model.entity.ExerciseRecordHistory;
import com.zsy.exam.model.entity.Question;
import com.zsy.exam.model.vo.exercise.ExerciseRecordStudentPageVO;
import com.zsy.exam.service.IExerciseQuestionService;
import com.zsy.exam.service.IExerciseRecordDetailHistoryService;
import com.zsy.exam.service.IExerciseRecordDetailService;
import com.zsy.exam.service.IExerciseRecordHistoryService;
import com.zsy.exam.service.IExerciseRecordService;
import com.zsy.exam.service.IExerciseService;
import com.zsy.exam.service.IQuestionService;
import com.zsy.exam.util.SecurityUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExerciseRecordServiceImpl
extends ServiceImpl<ExerciseRecordMapper, ExerciseRecord>
implements IExerciseRecordService {
    @Autowired
    private IExerciseQuestionService exerciseQuestionService;
    @Autowired
    private IQuestionService questionService;
    @Autowired
    private IExerciseService exerciseService;
    @Autowired
    private IExerciseRecordDetailService detailService;
    @Autowired
    private IExerciseRecordDetailHistoryService detailHisService;
    @Autowired
    IExerciseRecordHistoryService historyService;
    @Autowired
    private StringRedisTemplate redisTemplate;

    public ExerciseRecord addRecord(ExerciseRecordDto dto) {
        Long quId = dto.getQuId();
        Long exerciseId = dto.getExerciseId();
        Long userId = SecurityUtil.getUserId();
        String answer = dto.getAnswer();
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)qw.eq(ExerciseRecord::getUserId, (Object)userId)).eq(ExerciseRecord::getExerciseId, (Object)exerciseId);
        ExerciseRecord db = (ExerciseRecord)this.getOne((Wrapper)qw);
        if (null == db) {
            Integer repeatNumber = this.historyService.getLastRepeatNumber(userId, exerciseId);
            repeatNumber = null == repeatNumber ? Integer.valueOf(1) : Integer.valueOf(repeatNumber + 1);
            db = new ExerciseRecord();
            db.setExerciseId(exerciseId);
            db.setUserId(userId);
            db.setCreatorId(userId);
            db.setStartTime(LocalDateTime.now());
            db.setCompleted(Boolean.FALSE);
            db.setRepeatNumber(repeatNumber);
        }
        List exerciseIdList = this.exerciseService.checkQuestionExist(exerciseId, quId);
        List answerProcessDtoList = this.checkAnswerProcess(db.getAnswerProcess(), quId);
        Boolean isRight = null;
        if (StrUtil.isNotBlank((CharSequence)answer)) {
            Question question = (Question)this.questionService.getById((Serializable)quId);
            if (QuestionTypeEnum.getObjective().contains(question.getQuType())) {
                List<Long> answerList = Arrays.stream(answer.split(",")).map(Long::parseLong).toList();
                isRight = this.questionService.getObjectiveTF(quId, answerList);
                if (isRight.booleanValue()) {
                    db.setRightNum(Integer.valueOf(db.getRightNum() + 1));
                } else {
                    db.setErrorNum(Integer.valueOf(db.getErrorNum() + 1));
                }
            }
        } else {
            isRight = Boolean.FALSE;
            db.setErrorNum(Integer.valueOf(db.getErrorNum() + 1));
        }
        AnswerProcessDto answerProcessDto = new AnswerProcessDto(StrUtil.toString((Object)quId), answer, isRight, DateUtil.now());
        answerProcessDtoList.add(answerProcessDto);
        db.setAnswerProcess(JSONUtil.toJsonStr((Object)answerProcessDtoList));
        if (dto.getCompleted().booleanValue() || exerciseIdList.size() == answerProcessDtoList.size()) {
            db.setEndTime(LocalDateTime.now());
            db.setCompleted(Boolean.TRUE);
        } else {
            db.setCompleted(Boolean.FALSE);
        }
        this.saveOrUpdate((Object)db);
        ExerciseRecordDetail exerciseRecordDetail = new ExerciseRecordDetail();
        BeanUtil.copyProperties((Object)answerProcessDto, (Object)exerciseRecordDetail, (String[])new String[0]);
        exerciseRecordDetail.setExerciseId(exerciseId);
        exerciseRecordDetail.setUserId(userId);
        exerciseRecordDetail.setRight(isRight);
        exerciseRecordDetail.setRepeatNumber(db.getRepeatNumber());
        this.detailService.add(exerciseRecordDetail);
        return db;
    }

    @Transactional(rollbackFor={Exception.class})
    public void repeatExercise(List<ExerciseRecordDto> dtos) {
        Long userId = SecurityUtil.getUserId();
        if (CollUtil.isEmpty(dtos)) {
            throw new AppException("\u56de\u987e\u7ec3\u4e60\u4e3a\u7a7a");
        }
        Long exerciseId = dtos.get(0).getExerciseId();
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)qw.eq(ExerciseRecord::getUserId, (Object)userId)).eq(ExerciseRecord::getExerciseId, (Object)exerciseId);
        ExerciseRecord sourceDb = (ExerciseRecord)this.getOne((Wrapper)qw);
        if (null != sourceDb) {
            ExerciseRecordHistory his = new ExerciseRecordHistory();
            BeanUtil.copyProperties((Object)sourceDb, (Object)his, (String[])new String[]{"id"});
            his.setSourceId(sourceDb.getId());
            this.historyService.save((Object)his);
            ((ExerciseRecordMapper)this.baseMapper).actualDel(sourceDb.getId());
            List detailList = this.detailService.list(userId, exerciseId);
            if (CollUtil.isNotEmpty((Collection)detailList)) {
                detailList.forEach(de -> {
                    ExerciseRecordDetailHistory detailHistory = new ExerciseRecordDetailHistory();
                    BeanUtil.copyProperties((Object)de, (Object)detailHistory, (String[])new String[]{"id"});
                    detailHistory.setSourceId(de.getId());
                    detailHistory.setRight(de.getRight());
                    this.detailHisService.save((Object)detailHistory);
                    this.detailService.actualDel(de.getId());
                });
            }
        }
        dtos.forEach(arg_0 -> this.addRecord(arg_0));
        String key = "REPEAT_EXERCISE_CACHE:" + userId + "_" + exerciseId;
        this.redisTemplate.delete((Object)key);
    }

    public String repeatExerciseCache(Long exerciseId, HashMap<String, String> answerProcess) {
        Long userId = SecurityUtil.getUserId();
        String key = "REPEAT_EXERCISE_CACHE:" + userId + "_" + exerciseId;
        String answerProcessJson = answerProcess.get("answerProcess");
        if (StrUtil.isNotBlank((CharSequence)answerProcessJson)) {
            this.redisTemplate.opsForValue().set((Object)key, (Object)answerProcessJson, 60L, TimeUnit.MINUTES);
            return answerProcessJson;
        }
        return (String)this.redisTemplate.opsForValue().get((Object)key);
    }

    public ExerciseRecord detail(Long exerciseId) {
        Long userId = SecurityUtil.getUserId();
        return this.detail(userId, exerciseId);
    }

    public ExerciseRecord detail(Long studentUserId, Long exerciseId) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)qw.eq(ExerciseRecord::getUserId, (Object)studentUserId)).eq(ExerciseRecord::getExerciseId, (Object)exerciseId);
        ExerciseRecord db = (ExerciseRecord)this.getOne((Wrapper)qw);
        return db;
    }

    public Page<ExerciseRecordStudentPageVO> getExerciseRecordStudentPage(Page page, Long exerciseId, String key) {
        Page rePage = ((ExerciseRecordMapper)this.baseMapper).getExerciseRecordStudentPage(page, exerciseId, key);
        return rePage;
    }

    public Page<ExerciseRecordStudentPageVO> getAllRecordGroupByStudent(Page page, String key, Long clbumId, String subjectCode) {
        ArrayList<Long> clbumIds = new ArrayList<Long>();
        if (clbumId != null) {
            clbumIds.add(clbumId);
        }
        Page vo = ((ExerciseRecordMapper)this.baseMapper).getAllRecordGroupByStudent(page, key, clbumIds, subjectCode);
        return vo;
    }

    public Long getTotalCount() {
        return this.detailService.count();
    }

    public Long todayRecords() {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)qw.ge(ExerciseRecordDetail::getTime, (Object)(DateUtil.formatDate((Date)DateUtil.date()) + " 00:00:00"))).le(ExerciseRecordDetail::getTime, (Object)(DateUtil.formatDate((Date)DateUtil.date()) + " 23:59:59"));
        return this.detailService.count((Wrapper)qw);
    }

    public HashMap<String, Object> WeekOnWeek(String subjectCode) {
        List subjectCodeList = SecurityUtil.getSubjectCode();
        if (null != subjectCode && (CollUtil.isEmpty((Collection)subjectCodeList) || !subjectCodeList.contains(subjectCode))) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        DateTime now = DateUtil.date();
        DateTime lastWeekStart = DateUtil.beginOfWeek((Date)DateUtil.offsetWeek((Date)now, (int)-1));
        DateTime lastWeekEnd = DateUtil.endOfWeek((Date)DateUtil.offsetDay((Date)lastWeekStart, (int)6));
        DateTime lastLastWeekStart = DateUtil.beginOfWeek((Date)DateUtil.offsetWeek((Date)now, (int)-2));
        DateTime lastLastWeekEnd = DateUtil.endOfWeek((Date)DateUtil.offsetDay((Date)lastLastWeekStart, (int)6));
        long countLast = this.getCountByStartBetweenEnd(DateUtil.format((Date)lastLastWeekStart, (String)"yyyy-MM-dd"), DateUtil.format((Date)lastWeekEnd, (String)"yyyy-MM-dd"), subjectCode);
        long countLastLst = this.getCountByStartBetweenEnd(DateUtil.format((Date)lastLastWeekEnd, (String)"yyyy-MM-dd"), DateUtil.format((Date)lastWeekEnd, (String)"yyyy-MM-dd"), subjectCode);
        BigDecimal bdCountLast = new BigDecimal(countLast);
        BigDecimal bdCountLastLst = new BigDecimal(countLastLst);
        BigDecimal bdResult = new BigDecimal(0);
        if (0L != countLastLst && 0L != countLast) {
            bdResult = bdCountLast.subtract(bdCountLastLst).divide(bdCountLast, 2, RoundingMode.HALF_UP);
        }
        String bd = bdResult.toString();
        DateTime last7dayStart = DateUtil.offsetDay((Date)now, (int)-6);
        long weekCount = this.getCountByStartBetweenEnd(DateUtil.format((Date)last7dayStart, (String)"yyyy-MM-dd"), DateUtil.format((Date)now, (String)"yyyy-MM-dd"), subjectCode);
        map.put("weekCount", weekCount);
        map.put("weekOnWeek", bd);
        return map;
    }

    public Long studentRecordCount() {
        Long userId = SecurityUtil.getUserId();
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(ExerciseRecord::getUserId, (Object)userId);
        return this.count((Wrapper)qw);
    }

    public List<AnswerProcessDto> checkAnswerProcess(String answerProcess, Long quId) {
        if (StrUtil.isNotBlank((CharSequence)answerProcess)) {
            List answerProcessDtos = JSONUtil.toList((String)answerProcess, AnswerProcessDto.class);
            answerProcessDtos.forEach(answer -> {
                String qu = answer.getQuId();
                if (qu.equals(quId.toString())) {
                    throw new AppException("\u8be5\u8bd5\u9898\u5df2\u7b54\uff0c\u8bf7\u52ff\u91cd\u590d\u4f5c\u7b54");
                }
            });
            return answerProcessDtos;
        }
        return new ArrayList<AnswerProcessDto>();
    }

    public long getCountByStartBetweenEnd(String startTime, String endTime, String subjectCode) {
        long count = this.detailService.getCountGroupByUser(startTime + " 00:00:00", endTime + " 23:59:59", subjectCode);
        return count;
    }
}

