/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.constant.RoleEnum;
import com.zsy.exam.mapper.ExerciseMapper;
import com.zsy.exam.model.dto.exercise.ExerciseDTO;
import com.zsy.exam.model.entity.Catalogue;
import com.zsy.exam.model.entity.Exercise;
import com.zsy.exam.model.entity.ExerciseCatalogue;
import com.zsy.exam.model.entity.ExerciseRecord;
import com.zsy.exam.model.entity.Student;
import com.zsy.exam.model.entity.Subject;
import com.zsy.exam.model.form.exercise.ExerciseForm;
import com.zsy.exam.model.vo.UserVO;
import com.zsy.exam.model.vo.exercise.ExerciseByStudentPageVO;
import com.zsy.exam.model.vo.exercise.ExerciseForStudentVO;
import com.zsy.exam.model.vo.exercise.ExerciseVO;
import com.zsy.exam.service.ICatalogueService;
import com.zsy.exam.service.IExerciseCatalogueService;
import com.zsy.exam.service.IExerciseClbumService;
import com.zsy.exam.service.IExerciseQuestionService;
import com.zsy.exam.service.IExerciseRecordService;
import com.zsy.exam.service.IExerciseService;
import com.zsy.exam.service.IExerciseStudentService;
import com.zsy.exam.service.IQuestionService;
import com.zsy.exam.service.IRoleService;
import com.zsy.exam.service.IStudentService;
import com.zsy.exam.service.ISubjectService;
import com.zsy.exam.util.SecurityUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExerciseServiceImpl
extends ServiceImpl<ExerciseMapper, Exercise>
implements IExerciseService {
    @Autowired
    private ExerciseMapper exerciseMapper;
    @Autowired
    private IExerciseClbumService exerciseClbumService;
    @Autowired
    private IExerciseStudentService exerciseStudentService;
    @Autowired
    private IExerciseQuestionService exerciseQuestionService;
    @Autowired
    private IStudentService studentService;
    @Autowired
    private ICatalogueService catalogueService;
    @Autowired
    private IExerciseCatalogueService exerciseCatalogueService;
    @Autowired
    @Lazy
    private IExerciseRecordService recordService;
    @Autowired
    private IQuestionService questionService;
    @Autowired
    private ISubjectService subjectService;
    @Autowired
    private IRoleService roleService;

    public ExerciseVO detail(Long id) {
        ExerciseVO vo = new ExerciseVO();
        Exercise db = (Exercise)this.exerciseMapper.selectById((Serializable)id);
        this.hasAuth(db.getCreatorId());
        BeanUtil.copyProperties((Object)db, (Object)vo, (String[])new String[0]);
        List clbumList = this.exerciseClbumService.getByExerciseId(id);
        List questionIList = this.exerciseQuestionService.getQuestionIdByExerciseId(id);
        List studentList = this.exerciseStudentService.getByExerciseId(id);
        vo.setClbumList(clbumList);
        vo.setQuestionList(questionIList);
        vo.setStudentList(studentList);
        String repoIdStr = db.getRepoId();
        String repoName = this.getRepoNameByRepoIdStr(repoIdStr);
        vo.setRepoName(repoName);
        return vo;
    }

    public Page<ExerciseVO> getPage(Page page, ExerciseForm query) {
        List roles = this.roleService.getCurrentRoles();
        if (roles.contains(RoleEnum.TEACHER.getCode())) {
            Long userId = SecurityUtil.getUserId();
            query.setUserId(userId);
        } else if (!roles.contains(RoleEnum.ADMIN.getCode()) && !roles.contains(RoleEnum.SUPER_ADMIN.getCode())) {
            throw new AppException("\u6ca1\u6709\u67e5\u8be2\u6743\u9650");
        }
        Page rePage = this.exerciseMapper.getPage(page, query);
        rePage.getRecords().forEach(a -> {
            a.setTotalStudentNumber(this.exerciseClbumService.getTotalExerciseStudentCount(a.getId()));
            String repoIdStr = a.getRepoId();
            String repoName = this.getRepoNameByRepoIdStr(repoIdStr);
            a.setRepoName(repoName);
        });
        return rePage;
    }

    @Transactional(rollbackFor={Exception.class})
    public void add(ExerciseDTO dto) {
        Exercise db = new Exercise();
        if (StringUtils.isBlank((CharSequence)dto.getRepoId())) {
            throw new AppException("\u8bf7\u9009\u62e9\u77e5\u8bc6\u70b9");
        }
        BeanUtil.copyProperties((Object)dto, (Object)db, (String[])new String[0]);
        db.setCreatorId(SecurityUtil.getUserId());
        this.save((Object)db);
        this.removeAndAddAssociationInfo(db.getId(), dto);
    }

    @Transactional(rollbackFor={Exception.class})
    public int modify(ExerciseDTO dto) {
        Long id = dto.getId();
        if (null == dto.getRepoId()) {
            throw new AppException("\u8bf7\u9009\u62e9\u77e5\u8bc6\u70b9");
        }
        Exercise db = (Exercise)this.getById((Serializable)id);
        this.hasAuth(db.getCreatorId());
        LocalDateTime startTime = db.getStartTime();
        LocalDateTime now = LocalDateTime.now();
        if (startTime.isBefore(now)) {
            throw new AppException("\u8be5\u7ec3\u4e60\u5df2\u7ecf\u751f\u6548\uff0c\u4e0d\u80fd\u4fee\u6539");
        }
        BeanUtil.copyProperties((Object)dto, (Object)db, (String[])new String[0]);
        this.removeAndAddAssociationInfo(id, dto);
        return ((ExerciseMapper)this.baseMapper).updateById((Object)db);
    }

    @Transactional(rollbackFor={Exception.class})
    public void remove(String ids) {
        if (StringUtils.isNotEmpty((CharSequence)ids)) {
            List<Long> list = Arrays.stream(ids.split(",")).map(Long::parseLong).toList();
            list.forEach(id -> {
                Exercise db = (Exercise)this.getById((Serializable)id);
                this.hasAuth(db.getCreatorId());
                LambdaQueryWrapper qw = new LambdaQueryWrapper();
                qw.eq(ExerciseRecord::getExerciseId, id);
                if (CollUtil.isNotEmpty((Collection)this.recordService.list((Wrapper)qw))) {
                    throw new AppException("\u8be5\u7ec3\u4e60\u5df2\u6709\u5b66\u751f\u8fdb\u884c\u7ec3\u4e60\uff0c\u4e0d\u80fd\u5220\u9664");
                }
                this.exerciseClbumService.removeAndAdd(id, null);
                this.exerciseQuestionService.removeAndAdd(id, null);
                this.exerciseStudentService.removeAndAdd(id, null);
                ((ExerciseMapper)this.baseMapper).deleteById((Serializable)id);
            });
        }
    }

    public Page<ExerciseByStudentPageVO> getExerciseByStudent(Page page, String key, Long userId, String subjectCode) {
        Page vo = ((ExerciseMapper)this.baseMapper).getExerciseByStudent(page, key, userId, subjectCode);
        vo.getRecords().forEach(a -> {
            String repoId = a.getRepoId();
            a.setRepoName(this.getRepoNameByRepoIdStr(repoId));
        });
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    void removeAndAddAssociationInfo(Long dbId, ExerciseDTO dto) {
        String repoIdStr = dto.getRepoId();
        String repoId = repoIdStr.split(",")[0];
        Catalogue catalogue = (Catalogue)this.catalogueService.getById((Serializable)((Object)repoId));
        if (null == catalogue) {
            throw new AppException("\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u77e5\u8bc6\u70b9");
        }
        List clbumList = dto.getClbumList();
        List studentListList = dto.getStudentList();
        if (CollUtil.isEmpty((Collection)clbumList) && CollUtil.isNotEmpty((Collection)studentListList)) {
            throw new AppException("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u73ed\u7ea7\u6216\u8005\u5b66\u751f");
        }
        List questionList = dto.getQuestionList();
        if (CollUtil.isEmpty((Collection)questionList)) {
            throw new AppException("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u8bd5\u9898");
        }
        questionList = this.questionService.checkApprovedQuestion(questionList);
        Integer maxExerciseNumber = this.maxExerciseNumber(catalogue.getSubjectCode());
        if (maxExerciseNumber < questionList.size()) {
            throw new AppException("\u6700\u591a\u9009\u62e9" + maxExerciseNumber + "\u9053\u8bd5\u9898");
        }
        this.exerciseClbumService.removeAndAdd(dbId, clbumList);
        this.exerciseStudentService.removeAndAdd(dbId, studentListList);
        this.exerciseQuestionService.removeAndAdd(dbId, questionList);
    }

    void hasAuth(Long creatorId) {
        List roles = this.roleService.getCurrentRoles();
        if (roles.contains(RoleEnum.TEACHER.getCode())) {
            Long userId = SecurityUtil.getUserId();
            if (!userId.equals(creatorId)) {
                throw new AppException("\u6ca1\u6709\u5bf9\u5e94\u7684\u6743\u9650");
            }
        } else if (!roles.contains(RoleEnum.ADMIN.getCode()) && !roles.contains(RoleEnum.SUPER_ADMIN.getCode())) {
            throw new AppException("\u6ca1\u6709\u67e5\u8be2\u6743\u9650");
        }
    }

    public Page<ExerciseForStudentVO> getPage4Student(Page page, ExerciseForm query) {
        Long userId = SecurityUtil.getUserId();
        query.setUserId(userId);
        Student student = this.studentService.getByUserId(userId);
        if (null == student) {
            throw new AppException("\u8be5\u5b66\u751f\u4e0d\u5b58\u5728");
        }
        Long clbumId = student.getAdministrativeClbumId();
        if (null == clbumId) {
            throw new AppException("\u8be5\u5b66\u751f\u672a\u8bbe\u7f6e\u73ed\u7ea7");
        }
        Page page4Student = this.exerciseMapper.getPage4Student(page, query, clbumId);
        List records = page4Student.getRecords();
        records.forEach(v -> {
            List questionIdByExerciseId = this.exerciseQuestionService.getQuestionIdByExerciseId(v.getId());
            v.setQuIdList(questionIdByExerciseId);
            String repoName = this.getRepoNameByRepoIdStr(v.getRepoId());
            v.setRepoName(repoName);
        });
        return page4Student;
    }

    public ExerciseForStudentVO getDetail4Student(Long id) {
        ExerciseForStudentVO vo = new ExerciseForStudentVO();
        Exercise db = (Exercise)this.exerciseMapper.selectById((Serializable)id);
        if (!db.getStatus().booleanValue()) {
            throw new AppException("\u6ca1\u6709\u67e5\u8be2\u6743\u9650");
        }
        BeanUtil.copyProperties((Object)db, (Object)vo, (String[])new String[0]);
        String repoIdStr = db.getRepoId();
        String repoName = this.getRepoNameByRepoIdStr(repoIdStr);
        vo.setRepoName(repoName);
        ExerciseCatalogue catalogue = (ExerciseCatalogue)this.exerciseCatalogueService.getById((Serializable)db.getCatalogueId());
        if (null != catalogue) {
            vo.setSubjectCode(catalogue.getSubjectCode());
        }
        List questionIList = this.exerciseQuestionService.getQuestionIdByExerciseId(id);
        vo.setQuIdList(questionIList);
        return vo;
    }

    public List<Long> checkQuestionExist(Long exerciseId, Long quId) {
        Long userId = SecurityUtil.getUserId();
        Exercise db = (Exercise)this.getById((Serializable)exerciseId);
        if (null == db) {
            throw new AppException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u7ec3\u4e60");
        }
        LocalDateTime startTime = db.getStartTime();
        if (startTime.isAfter(LocalDateTime.now())) {
            throw new AppException("\u8be5\u7ec3\u4e60\u8fd8\u672a\u5f00\u59cb");
        }
        Student student = this.studentService.getByUserId(userId);
        Long clbumId = student.getAdministrativeClbumId();
        List clbums = this.exerciseClbumService.getByExerciseId(exerciseId);
        List<Long> students = this.exerciseStudentService.getByExerciseId(exerciseId).stream().map(UserVO::getId).toList();
        if (!clbums.contains(clbumId) && !students.contains(student.getUserId())) {
            throw new AppException("\u4f60\u4e0d\u5728\u8be5\u7ec3\u4e60\u4e2d");
        }
        List exerciseIdList = this.exerciseQuestionService.getQuestionIdByExerciseId(exerciseId);
        if (!exerciseIdList.contains(quId)) {
            throw new AppException("\u8be5\u7ec3\u4e60\u4e2d\u6ca1\u6709\u627e\u5230\u8be5\u8bd5\u9898");
        }
        return exerciseIdList;
    }

    public HashMap<String, Object> weekOnWeek() {
        DateTime now = DateUtil.date();
        DateTime lastWeekStart = DateUtil.beginOfWeek((Date)DateUtil.offsetWeek((Date)now, (int)-1));
        DateTime lastWeekEnd = DateUtil.endOfWeek((Date)DateUtil.offsetDay((Date)lastWeekStart, (int)6));
        DateTime lastLastWeekStart = DateUtil.beginOfWeek((Date)DateUtil.offsetWeek((Date)now, (int)-2));
        DateTime lastLastWeekEnd = DateUtil.endOfWeek((Date)DateUtil.offsetDay((Date)lastLastWeekStart, (int)6));
        Long countLast = this.getCountByStartBetweenEnd(DateUtil.format((Date)lastLastWeekStart, (String)"yyyy-MM-dd"), DateUtil.format((Date)lastWeekEnd, (String)"yyyy-MM-dd"));
        Long countLastLst = this.getCountByStartBetweenEnd(DateUtil.format((Date)lastLastWeekEnd, (String)"yyyy-MM-dd"), DateUtil.format((Date)lastWeekEnd, (String)"yyyy-MM-dd"));
        String bd = "0";
        if (null != countLast && null != countLastLst && 0L != countLast * countLastLst) {
            BigDecimal bdCountLast = new BigDecimal(countLast);
            BigDecimal bdCountLastLst = new BigDecimal(countLastLst);
            BigDecimal bdResult = bdCountLast.subtract(bdCountLastLst).divide(bdCountLast, 2, RoundingMode.HALF_UP);
            bd = bdResult.toString();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        DateTime last7dayStart = DateUtil.offsetDay((Date)now, (int)-6);
        long weekCount = this.getCountByStartBetweenEnd(DateUtil.format((Date)last7dayStart, (String)"yyyy-MM-dd"), DateUtil.format((Date)now, (String)"yyyy-MM-dd"));
        map.put("weekOnWeek", bd);
        map.put("weekCount", weekCount);
        return map;
    }

    public Long getCountByStartBetweenEnd(String startTime, String endTime) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.between(Exercise::getCreateTime, (Object)(startTime + " 00:00:00"), (Object)(endTime + " 23:59:59"));
        return this.count((Wrapper)qw);
    }

    public Integer maxExerciseNumber(String subjectCode) {
        Subject subject = this.subjectService.getByCode(subjectCode);
        if (null == subject) {
            throw new AppException("\u6ca1\u6709\u627e\u5230\u6240\u9009\u79d1\u76ee");
        }
        return subject.getExerciseNumber();
    }

    public String getRepoNameByRepoIdStr(String repoIdStr) {
        StringBuilder repoNameSb = new StringBuilder();
        if (StringUtils.isBlank((CharSequence)repoIdStr)) {
            return null;
        }
        for (String repoId : repoIdStr.split(",")) {
            Catalogue catalogue = (Catalogue)this.catalogueService.getById((Serializable)((Object)repoId));
            if (null == catalogue) continue;
            repoNameSb.append(catalogue.getName()).append(",");
        }
        String repoName = repoNameSb.toString();
        return StrUtil.removeSuffix((CharSequence)repoName, (CharSequence)",");
    }
}

