/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.mapper.GradeMapper;
import com.zsy.exam.model.dto.GradeExcelDTO;
import com.zsy.exam.model.entity.Grade;
import com.zsy.exam.service.IGradeService;
import com.zsy.exam.util.excel.ExcelUtils;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class GradeServiceImpl
extends ServiceImpl<GradeMapper, Grade>
implements IGradeService {
    @Autowired
    GradeMapper gradeMapper;

    public Grade getGrade(Long id) {
        return (Grade)this.gradeMapper.selectById((Serializable)id);
    }

    public Page<List<Grade>> getAllGrade(Page page, String name, String code) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)qw.like(StringUtils.isNotBlank((CharSequence)name), Grade::getName, (Object)name)).or()).like(StringUtils.isNotBlank((CharSequence)code), Grade::getCode, (Object)code);
        return (Page)this.gradeMapper.selectPage((IPage)page, (Wrapper)qw);
    }

    public Set<String> listGradeFromExam(Long examId) {
        Set list = this.gradeMapper.listGradeFromExam(examId);
        return list;
    }

    public void deleteAll() {
        this.gradeMapper.deleteAll();
    }

    public void add(Grade grade) {
        this.gradeMapper.insert((Object)grade);
    }

    public int modify(Grade grade) {
        return this.gradeMapper.updateById((Object)grade);
    }

    public void remove(String ids) {
        String[] array;
        if (StringUtils.isNotEmpty((CharSequence)ids) && !CollectionUtils.isEmpty(Arrays.asList(array = ids.split(",")))) {
            this.gradeMapper.deleteBatchIds(Arrays.asList(array));
        }
    }

    public void importGrade(MultipartFile file) {
        if (!ExcelUtils.isExcel((String)Objects.requireNonNull(file.getOriginalFilename()))) {
            throw new AppException("\u6587\u4ef6\u7c7b\u578b\u5fc5\u987b\u662fxls\u6216xlsx");
        }
        List list = ExcelUtils.readMultipartFile((MultipartFile)file, GradeExcelDTO.class);
        for (GradeExcelDTO dto : list) {
            Grade grade = new Grade();
            grade.setCode(dto.getCode());
            grade.setName(dto.getName());
            this.gradeMapper.insert((Object)grade);
        }
    }

    public void exportGrade(HttpServletResponse response, String name, String code) {
        List gradeExcelDTOS = this.gradeMapper.selectExcel(name, code);
        ExcelUtils.export((HttpServletResponse)response, (String)"\u5e74\u7ea7\u4fe1\u606f\u5bfc\u51fa", (List)gradeExcelDTOS, GradeExcelDTO.class);
    }
}

