/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.annotation.enums.BusinessStatus;
import com.zsy.exam.mapper.LoginLogMapper;
import com.zsy.exam.mapper.OptLogMapper;
import com.zsy.exam.model.dto.LoginPageListDTO;
import com.zsy.exam.model.dto.PdfLogAddDTO;
import com.zsy.exam.model.entity.LoginLog;
import com.zsy.exam.model.entity.OptLog;
import com.zsy.exam.service.ILoginLogService;
import com.zsy.exam.util.IpUtils;
import com.zsy.exam.util.SecurityUtil;
import com.zsy.exam.util.excel.ExcelUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoginLogServiceImpl
extends ServiceImpl<LoginLogMapper, LoginLog>
implements ILoginLogService {
    @Autowired
    LoginLogMapper loginLogMapper;
    @Autowired
    private OptLogMapper optLogMapper;

    public Page<OptLog> getPage(Page page, LoginPageListDTO dto) {
        Page optLogPage = ((LoginLogMapper)this.baseMapper).getPage(page, dto);
        return optLogPage;
    }

    public Page<LoginLog> getLoginLogPage(Page page, LoginPageListDTO dto) {
        Page loginPage = ((LoginLogMapper)this.baseMapper).getLoginPage(page, dto);
        return loginPage;
    }

    public void addPdfLog(HttpServletRequest request, PdfLogAddDTO dto) {
        OptLog optLog = new OptLog();
        optLog.setOptUserId(SecurityUtil.getUserId());
        optLog.setOptUserName(SecurityUtil.getUserName());
        optLog.setStatus(BusinessStatus.SUCCESS.getType());
        optLog.setRequestIp(IpUtils.getIpAddr((HttpServletRequest)request));
        optLog.setRequestUrl(request.getRequestURI());
        optLog.setRequestMethod(request.getMethod());
        optLog.setUserAgent(request.getHeader("user-agent"));
        optLog.setTitle("PDF\u4e0b\u8f7d");
        optLog.setOptTime(LocalDateTime.now());
        optLog.setRequestParam(JSON.toJSONString((Object)dto));
        this.optLogMapper.insert((Object)optLog);
    }

    public void exportOptLog(HttpServletResponse response, LoginPageListDTO dto) {
        List pageExcel = this.loginLogMapper.getPageExcel(dto);
        ExcelUtils.export((HttpServletResponse)response, (String)"\u7cfb\u7edf\u65e5\u5fd7\u5bfc\u51fa", (List)pageExcel, OptLog.class);
    }

    public void exportLoginLog(HttpServletResponse response, LoginPageListDTO dto) {
        List pageExcel = this.loginLogMapper.getLoginPageExcel(dto);
        ExcelUtils.export((HttpServletResponse)response, (String)"\u767b\u5f55\u65e5\u5fd7\u5bfc\u51fa", (List)pageExcel, LoginLog.class);
    }
}

