/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.constant.RoleEnum;
import com.zsy.exam.mapper.CertificateUserMapper;
import com.zsy.exam.mapper.ExamClbumMapper;
import com.zsy.exam.mapper.ExamMapper;
import com.zsy.exam.mapper.ExamQuAnswerMapper;
import com.zsy.exam.mapper.ExamStudentTeacherMappingMapper;
import com.zsy.exam.mapper.ExaminationPaperMapper;
import com.zsy.exam.mapper.ManualScoreMapper;
import com.zsy.exam.mapper.QuestionMapper;
import com.zsy.exam.mapper.UserExamsScoreMapper;
import com.zsy.exam.mapper.WrongQuestionBookMapper;
import com.zsy.exam.model.entity.Exam;
import com.zsy.exam.model.entity.ExamQuAnswer;
import com.zsy.exam.model.entity.ExamStudentTeacherMapping;
import com.zsy.exam.model.entity.ExaminationPaper;
import com.zsy.exam.model.entity.ManualScore;
import com.zsy.exam.model.entity.Question;
import com.zsy.exam.model.entity.UserExamsScore;
import com.zsy.exam.model.entity.WrongQuestionBook;
import com.zsy.exam.model.form.answer.CorrectAnswerFrom;
import com.zsy.exam.model.vo.answer.AnswerExamVO;
import com.zsy.exam.model.vo.answer.ProgressAnalysisVO;
import com.zsy.exam.model.vo.answer.ProgressDetailsVO;
import com.zsy.exam.model.vo.answer.UncorrectedUserVO;
import com.zsy.exam.model.vo.answer.UserAnswerDetailVO;
import com.zsy.exam.service.IManualScoreService;
import com.zsy.exam.service.IRoleService;
import com.zsy.exam.util.SecurityUtil;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ManualScoreServiceImpl
extends ServiceImpl<ManualScoreMapper, ManualScore>
implements IManualScoreService {
    @Resource
    private ExamMapper examMapper;
    @Resource
    private ExamClbumMapper examClbumMapper;
    @Resource
    private UserExamsScoreMapper userExamsScoreMapper;
    @Resource
    private ExamQuAnswerMapper examQuAnswerMapper;
    @Resource
    private ManualScoreMapper manualScoreMapper;
    @Resource
    private CertificateUserMapper certificateUserMapper;
    @Resource
    private QuestionMapper questionMapper;
    @Resource
    private ExaminationPaperMapper examinationPaperMapper;
    @Resource
    private WrongQuestionBookMapper wrongQuestionBookMapper;
    @Resource
    private ExamStudentTeacherMappingMapper examStudentTeacherMappingMapper;
    @Resource
    private IRoleService roleService;
    private ExecutorService threadPool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());

    public Result<List<UserAnswerDetailVO>> getDetail(Long userId, Long examId) {
        List list = this.examQuAnswerMapper.selectUserAnswer(userId, examId);
        return Result.success(null, (Object)list);
    }

    @Transactional
    public Result<String> correct(List<CorrectAnswerFrom> correctAnswerFroms) {
        CorrectAnswerFrom first = null;
        if (correctAnswerFroms == null || correctAnswerFroms.size() <= 0) {
            return Result.failed((String)"\u63d0\u4ea4\u7684\u8bc4\u5206\u5217\u8868\u4e3a\u7a7a");
        }
        first = correctAnswerFroms.get(0);
        LocalDateTime nowTime = LocalDateTime.now();
        ArrayList<ManualScore> list = new ArrayList<ManualScore>(correctAnswerFroms.size());
        BigDecimal manualTotalScore = new BigDecimal(0);
        Exam exam = (Exam)this.examMapper.selectById((Serializable)first.getExamId());
        Long userId = exam.getUserId();
        if (!exam.getEnable().booleanValue()) {
            return Result.failed((String)"\u8003\u8bd5\u5904\u4e8e\u672a\u5f00\u653e\u72b6\u6001");
        }
        if (exam.getStartTime().isAfter(nowTime)) {
            return Result.failed((String)"\u8003\u8bd5\u8fd8\u672a\u5f00\u59cb");
        }
        if (exam.getEndTime().isAfter(nowTime)) {
            return Result.failed((String)"\u8003\u8bd5\u8fd8\u672a\u7ed3\u675f");
        }
        if (exam.getMarkingEndTime() != null && exam.getMarkingEndTime().isBefore(nowTime)) {
            return Result.failed((String)"\u9605\u5377\u65f6\u95f4\u5df2\u8fc7");
        }
        LambdaQueryWrapper examStudentTeacherMappingLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)examStudentTeacherMappingLambdaQueryWrapper.eq(ExamStudentTeacherMapping::getExamId, (Object)exam.getId())).eq(ExamStudentTeacherMapping::getUserId, (Object)SecurityUtil.getUserId());
        Long waitHandleCount = this.examStudentTeacherMappingMapper.selectCount((Wrapper)examStudentTeacherMappingLambdaQueryWrapper);
        if (waitHandleCount < 1L) {
            return Result.failed((String)"\u60a8\u4e0d\u662f\u9605\u5377\u8001\u5e08\uff0c\u65e0\u6cd5\u9605\u5377");
        }
        LambdaQueryWrapper userExamsScoreLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)userExamsScoreLambdaQueryWrapper.eq(UserExamsScore::getExamId, (Object)first.getExamId())).eq(UserExamsScore::getUserId, (Object)first.getUserId());
        UserExamsScore examsScore = (UserExamsScore)this.userExamsScoreMapper.selectOne((Wrapper)userExamsScoreLambdaQueryWrapper);
        if (!examsScore.getIsAttend().booleanValue()) {
            return Result.failed((String)"\u8be5\u8003\u751f\u6ca1\u6709\u53c2\u52a0\u8003\u8bd5\uff0c\u65e0\u6cd5\u9605\u5377");
        }
        ExaminationPaper examinationPaper = (ExaminationPaper)this.examinationPaperMapper.selectById((Serializable)exam.getExaminationPaperId());
        HashSet<WrongQuestionBook> userBookArraySet = new HashSet<WrongQuestionBook>();
        for (CorrectAnswerFrom correctAnswerFrom : correctAnswerFroms) {
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ExamQuAnswer::getExamId, (Object)correctAnswerFrom.getExamId())).eq(ExamQuAnswer::getUserId, (Object)correctAnswerFrom.getUserId())).eq(ExamQuAnswer::getQuestionId, (Object)correctAnswerFrom.getQuestionId());
            ExamQuAnswer examQuAnswer = (ExamQuAnswer)this.examQuAnswerMapper.selectOne((Wrapper)wrapper);
            Question question = (Question)this.questionMapper.selectById((Serializable)correctAnswerFrom.getQuestionId());
            ManualScore manualScore = new ManualScore();
            if (examQuAnswer == null) continue;
            int isRight = correctAnswerFrom.getScore().compareTo(examQuAnswer.getPoint()) == 0 ? 1 : 0;
            examQuAnswer.setIsRight(Integer.valueOf(isRight));
            this.examQuAnswerMapper.updateById((Object)examQuAnswer);
            manualScore.setExamQuAnswerId(examQuAnswer.getId());
            manualScore.setUserId(correctAnswerFrom.getUserId());
            manualScore.setScore(correctAnswerFrom.getScore());
            manualScore.setTeacherId(SecurityUtil.getUserId());
            manualScore.setComments(correctAnswerFrom.getComments());
            list.add(manualScore);
            if (isRight == 0) {
                if (question.getMainCombinationId() != null) {
                    question = (Question)this.questionMapper.selectById((Serializable)question.getMainCombinationId());
                }
                WrongQuestionBook userBook = new WrongQuestionBook();
                userBook.setType(Integer.valueOf(1));
                userBook.setUserId(correctAnswerFrom.getUserId());
                userBook.setSubjectCode(examinationPaper.getSubjectCode());
                userBook.setRelationId(correctAnswerFrom.getExamId());
                userBook.setQuestionId(question.getId());
                userBook.setRepoId(question.getRepoId());
                userBook.setCreateTime(nowTime);
                userBook.setIsMiss(Boolean.valueOf(false));
                userBook.setCreatorId(SecurityUtil.getUserId());
                userBookArraySet.add(userBook);
            }
            manualTotalScore = manualTotalScore.add(correctAnswerFrom.getScore());
        }
        if (!list.isEmpty()) {
            this.manualScoreMapper.insertList(list);
        }
        if (!userBookArraySet.isEmpty()) {
            this.threadPool.execute(() -> {
                for (WrongQuestionBook wrongQuestionBook : userBookArraySet) {
                    LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(WrongQuestionBook::getUserId, (Object)wrongQuestionBook.getUserId())).eq(WrongQuestionBook::getRelationId, (Object)wrongQuestionBook.getRelationId())).eq(WrongQuestionBook::getQuestionId, (Object)wrongQuestionBook.getQuestionId());
                    boolean exists = this.wrongQuestionBookMapper.exists((Wrapper)wrapper);
                    if (!exists) continue;
                    userBookArraySet.remove(wrongQuestionBook);
                }
                this.wrongQuestionBookMapper.insertWrongQestionList(userBookArraySet.stream().toList());
            });
        }
        LambdaUpdateWrapper userExamsScoreLambdaUpdateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UserExamsScore::getExamId, (Object)first.getExamId())).eq(UserExamsScore::getUserId, (Object)first.getUserId())).set(UserExamsScore::getWhetherMark, (Object)1)).set(UserExamsScore::getSubjectiveScore, (Object)manualTotalScore)).set(UserExamsScore::getUserScore, (Object)examsScore.getUserScore().add(manualTotalScore));
        this.userExamsScoreMapper.update((Wrapper)userExamsScoreLambdaUpdateWrapper);
        return Result.success((String)"\u6279\u6539\u6210\u529f");
    }

    public Result<IPage<AnswerExamVO>> examPage(Integer pageNum, Integer pageSize, String examName) {
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        Long userId = SecurityUtil.getUserId();
        Boolean isAdmin = false;
        List roles = this.roleService.getCurrentRoles();
        if (roles.contains(RoleEnum.ADMIN.getCode()) || roles.contains(RoleEnum.SUPER_ADMIN.getCode())) {
            isAdmin = true;
        }
        List list = this.examMapper.selectMarkedList((IPage)page, userId, examName, isAdmin).getRecords();
        list.forEach(answerExamVO -> {
            Exam exam = (Exam)this.examMapper.selectById((Serializable)answerExamVO.getExamId());
            answerExamVO.setCreatorId(exam.getUserId());
            if (userId.equals(exam.getUserId())) {
                answerExamVO.setIsOwner(Boolean.valueOf(true));
            } else {
                answerExamVO.setIsOwner(Boolean.valueOf(false));
            }
            Long isMarker = this.examStudentTeacherMappingMapper.selectCount((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ExamStudentTeacherMapping::getExamId, (Object)exam.getId())).and(wq -> wq.eq(ExamStudentTeacherMapping::getUserId, (Object)userId)));
            if (isMarker > 0L) {
                answerExamVO.setIsMarker(Boolean.valueOf(true));
            } else {
                answerExamVO.setIsMarker(Boolean.valueOf(false));
            }
            answerExamVO.setClassSize(this.examClbumMapper.selectClassSize(answerExamVO.getExamId()));
            LambdaQueryWrapper numberWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UserExamsScore::getExamId, (Object)answerExamVO.getExamId())).eq(UserExamsScore::getIsAttend, (Object)true);
            answerExamVO.setNumberOfApplicants(Integer.valueOf(this.userExamsScoreMapper.selectCount((Wrapper)numberWrapper).intValue()));
            if (exam.getUserId().equals(userId)) {
                Long totalMarkCount = this.examStudentTeacherMappingMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(ExamStudentTeacherMapping::getExamId, (Object)exam.getId()));
                List shouldMarkList = this.examStudentTeacherMappingMapper.shouldMarkList(exam.getId(), userId);
                LambdaQueryWrapper correctedWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UserExamsScore::getExamId, (Object)answerExamVO.getExamId())).eq(UserExamsScore::getIsAttend, (Object)true)).and(wp -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wp.eq(UserExamsScore::getWhetherMark, (Object)1)).or()).eq(UserExamsScore::getWhetherMark, (Object)-1));
                answerExamVO.setTotalMarkCount(Integer.valueOf(totalMarkCount.intValue()));
                answerExamVO.setShouldMarkCount(Integer.valueOf(shouldMarkList.size()));
                answerExamVO.setCorrectedPaper(Integer.valueOf(this.userExamsScoreMapper.selectCount((Wrapper)correctedWrapper).intValue()));
            } else {
                List shouldMarkList = this.examStudentTeacherMappingMapper.shouldMarkList(exam.getId(), userId);
                LambdaQueryWrapper correctedWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UserExamsScore::getExamId, (Object)answerExamVO.getExamId())).eq(UserExamsScore::getIsAttend, (Object)true)).and(wp -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wp.eq(UserExamsScore::getWhetherMark, (Object)1)).or()).eq(UserExamsScore::getWhetherMark, (Object)-1));
                answerExamVO.setTotalMarkCount(null);
                answerExamVO.setShouldMarkCount(Integer.valueOf(shouldMarkList.size()));
                answerExamVO.setCorrectedPaper(Integer.valueOf(this.userExamsScoreMapper.selectCount((Wrapper)correctedWrapper).intValue()));
            }
        });
        return Result.success(null, (Object)page);
    }

    public Result<IPage<UncorrectedUserVO>> stuExamPage(Integer pageNum, Integer pageSize, Long examId, String realName, Integer isAttend, Integer whetherMark) {
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        Long userId = SecurityUtil.getUserId();
        Exam exam = (Exam)this.examMapper.selectById((Serializable)examId);
        boolean is_owner = false;
        if (userId.equals(exam.getUserId())) {
            is_owner = true;
        }
        Boolean isAdmin = false;
        List roles = this.roleService.getCurrentRoles();
        if (roles.contains(RoleEnum.ADMIN.getCode()) || roles.contains(RoleEnum.SUPER_ADMIN.getCode())) {
            isAdmin = true;
        }
        page = this.userExamsScoreMapper.uncorrectedUser((IPage)page, examId, realName, isAttend, whetherMark, userId, is_owner, isAdmin);
        if (roles.contains(RoleEnum.ADMIN.getCode()) || roles.contains(RoleEnum.SUPER_ADMIN.getCode())) {
            Boolean is_marker = this.examStudentTeacherMappingMapper.shouldMarkList(examId, userId).size() > 0;
            for (UncorrectedUserVO record : page.getRecords()) {
                record.setIsMarker(is_marker);
            }
        }
        return Result.success(null, (Object)page);
    }

    public Result<IPage<ProgressAnalysisVO>> correctProgressAnalysis(Page page, Long examId, Long userId, String teacherName) {
        IPage res = this.userExamsScoreMapper.correctProgressAnalysis(page, examId, userId, teacherName);
        return Result.success(null, (Object)res);
    }

    public Result<IPage<ProgressDetailsVO>> correctProgressDetails(Page page, Long examId, Long userId, String studentName, String teacherName) {
        IPage res = this.userExamsScoreMapper.correctProgressDetails(page, examId, userId, studentName, teacherName);
        return Result.success(null, (Object)res);
    }
}

