/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.mapper.MenuMapper;
import com.zsy.exam.mapper.RoleMenuMapper;
import com.zsy.exam.model.dto.MenuDTO;
import com.zsy.exam.model.entity.Menu;
import com.zsy.exam.model.entity.RoleMenu;
import com.zsy.exam.model.vo.MenuTreeListVO;
import com.zsy.exam.service.IMenuService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MenuServiceImpl
extends ServiceImpl<MenuMapper, Menu>
implements IMenuService {
    @Autowired
    MenuMapper menuMapper;
    @Autowired
    private RoleMenuMapper roleMenuMapper;
    public static final String[] ONLY_SUPER_URL = new String[]{"code_008_04", "code_003_01_03", "code_003_01_04", "code_003_01_05"};

    public MenuDTO getMenu(Long id) {
        Menu menu = (Menu)this.getById((Serializable)id);
        MenuDTO dto = new MenuDTO();
        BeanUtils.copyProperties((Object)menu, (Object)dto);
        return dto;
    }

    public List<MenuTreeListVO> getTree() {
        List menuList = this.menuMapper.getMenuList(null, Arrays.asList(ONLY_SUPER_URL));
        if (CollectionUtils.isEmpty((Collection)menuList)) {
            return menuList;
        }
        List firstMenus = menuList.stream().filter(item -> null == item.getParentId()).collect(Collectors.toList());
        List menuTreeListVOS = this.treeList(firstMenus, menuList);
        return menuTreeListVOS;
    }

    public Page<MenuTreeListVO> page(Page page, String name) {
        Page listVOPage = this.menuMapper.queryPage(page, name);
        return listVOPage;
    }

    public List<MenuTreeListVO> getTree(Long roleId) {
        List menuList = this.menuMapper.getMenuListByRoleId(roleId, Arrays.asList(ONLY_SUPER_URL));
        if (CollectionUtils.isEmpty((Collection)menuList)) {
            return menuList;
        }
        List firstMenus = menuList.stream().filter(item -> null == item.getParentId()).collect(Collectors.toList());
        List menuTreeListVOS = this.treeList(firstMenus, menuList);
        return menuTreeListVOS;
    }

    @Transactional(rollbackFor={Exception.class})
    public void add(MenuDTO dto) {
        Menu menu = new Menu();
        BeanUtils.copyProperties((Object)dto, (Object)menu);
        Menu menuOld = (Menu)((MenuMapper)this.baseMapper).selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Menu::getDeleted, (Object)false)).eq(Menu::getCode, (Object)dto.getCode()));
        if (null != menuOld) {
            throw new AppException("\u7f16\u7801\u91cd\u590d");
        }
        if (null != dto.getParentId()) {
            Menu parentMenu = (Menu)this.getById((Serializable)dto.getParentId());
            if (StringUtils.isNotBlank((CharSequence)parentMenu.getPath())) {
                menu.setPath(parentMenu.getPath() + "," + parentMenu.getId());
            } else {
                menu.setPath("" + parentMenu.getId());
            }
            menu.setLevel(Integer.valueOf(parentMenu.getLevel() + 1));
        } else {
            menu.setLevel(Integer.valueOf(1));
        }
        menu.setIsCreate(Integer.valueOf(0));
        this.menuMapper.insert((Object)menu);
    }

    @Transactional(rollbackFor={Exception.class})
    public void modify(MenuDTO dto) {
        if (null == dto.getId()) {
            throw new AppException("\u53c2\u6570\u9519\u8bef");
        }
        Menu menuOld = (Menu)((MenuMapper)this.baseMapper).selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Menu::getDeleted, (Object)false)).eq(Menu::getCode, (Object)dto.getCode())).ne(Menu::getId, (Object)dto.getId()));
        if (null != menuOld) {
            throw new AppException("\u7f16\u7801\u91cd\u590d");
        }
        Menu menu = (Menu)this.getById((Serializable)dto.getId());
        BeanUtils.copyProperties((Object)dto, (Object)menu);
        if (null != dto.getParentId()) {
            Menu parentMenu = (Menu)this.getById((Serializable)dto.getParentId());
            if (StringUtils.isNotBlank((CharSequence)parentMenu.getPath())) {
                menu.setPath(parentMenu.getPath() + "," + parentMenu.getId());
            } else {
                menu.setPath("" + parentMenu.getId());
            }
            menu.setLevel(Integer.valueOf(parentMenu.getLevel() + 1));
        } else {
            menu.setLevel(Integer.valueOf(1));
        }
        this.menuMapper.updateById((Object)menu);
    }

    @Transactional(rollbackFor={Exception.class})
    public void remove(String ids) {
        List<String> list = Arrays.asList(ids.split(","));
        for (String id : list) {
            List menus = ((MenuMapper)this.baseMapper).selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Menu::getDeleted, (Object)false)).like(Menu::getPath, (Object)id));
            if (CollectionUtils.isNotEmpty((Collection)menus)) {
                throw new AppException("\u5f53\u524d\u83dc\u5355\u6709\u4e0b\u7ea7\u83dc\u5355,\u4e0d\u80fd\u5220\u9664");
            }
            List roleMenus = this.roleMenuMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(RoleMenu::getMenuId, (Object)Long.valueOf(id)));
            if (!CollectionUtils.isNotEmpty((Collection)roleMenus)) continue;
            throw new AppException("\u5f53\u524d\u83dc\u5355\u5df2\u7ecf\u5173\u8054\u4e86\u89d2\u8272,\u4e0d\u80fd\u5220\u9664");
        }
        this.menuMapper.deleteBatchIds(list);
    }

    private List<MenuTreeListVO> treeList(List<MenuTreeListVO> menuList, List<MenuTreeListVO> all) {
        if (CollectionUtils.isEmpty(menuList)) {
            return menuList;
        }
        for (MenuTreeListVO vo : menuList) {
            List collect = all.stream().filter(item -> vo.getId().equals(item.getParentId())).collect(Collectors.toList());
            vo.setChildren(collect);
            this.treeList(collect, all);
        }
        return menuList;
    }
}

