/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.mapper.NoticeClickMapper;
import com.zsy.exam.mapper.NoticeMapper;
import com.zsy.exam.mapper.UserNoticeMapper;
import com.zsy.exam.model.entity.Notice;
import com.zsy.exam.model.entity.NoticeClick;
import com.zsy.exam.model.entity.UserNotice;
import com.zsy.exam.model.form.NoticeForm;
import com.zsy.exam.model.vo.NoticeVO;
import com.zsy.exam.service.INoticeService;
import com.zsy.exam.util.SecurityUtil;
import jakarta.annotation.Resource;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NoticeServiceImpl
extends ServiceImpl<NoticeMapper, Notice>
implements INoticeService {
    @Resource
    private NoticeMapper noticeMapper;
    @Resource
    private NoticeClickMapper noticeClickMapper;
    @Resource
    private UserNoticeMapper userNoticeMapper;

    @Transactional
    public void addNotice(NoticeForm noticeForm) {
        noticeForm.setUserId(SecurityUtil.getUserId());
        Notice notice = new Notice();
        BeanUtils.copyProperties((Object)noticeForm, (Object)notice, (String[])new String[]{"id"});
        this.noticeMapper.insert((Object)notice);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteNotice(String ids) {
        List<Long> noticeIds = Arrays.stream(ids.split(",")).map(Long::parseLong).toList();
        this.noticeMapper.deleteBatchIds(noticeIds);
    }

    public void updateNotice(NoticeForm noticeForm) {
        LambdaUpdateWrapper noticeWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)noticeWrapper.eq(Notice::getId, (Object)noticeForm.getId())).eq(Notice::getIsDeleted, (Object)0)).set(Notice::getContent, (Object)noticeForm.getContent())).set(Notice::getTitle, (Object)noticeForm.getTitle());
        this.noticeMapper.update((Wrapper)noticeWrapper);
    }

    public IPage<NoticeVO> getNotice(Page page, String title, Integer isCollect) {
        Long userId = SecurityUtil.getUserId();
        IPage noticeVOIPage = this.noticeMapper.queryPage(page, title, userId, isCollect);
        return noticeVOIPage;
    }

    public void click(NoticeClick noticeClick) {
        noticeClick.setUserId(SecurityUtil.getUserId());
        NoticeClick noticeClickOld = (NoticeClick)this.noticeClickMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(NoticeClick::getUserId, (Object)noticeClick.getUserId())).eq(NoticeClick::getNoticeId, (Object)noticeClick.getNoticeId()));
        if (null == noticeClickOld) {
            this.noticeClickMapper.insert((Object)noticeClick);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void collect(Long noticeId) {
        Long userId = SecurityUtil.getUserId();
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(UserNotice::getNoticeId, (Object)noticeId)).eq(UserNotice::getUserId, (Object)userId);
        UserNotice userNotice = (UserNotice)this.userNoticeMapper.selectOne((Wrapper)wrapper);
        if (null == userNotice) {
            UserNotice newUserNotice = new UserNotice();
            newUserNotice.setNoticeId(noticeId);
            newUserNotice.setUserId(userId);
            this.userNoticeMapper.insert((Object)newUserNotice);
        } else {
            this.userNoticeMapper.delete((Wrapper)wrapper);
        }
    }
}

