/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.constant.RoleEnum;
import com.zsy.exam.mapper.PostMapper;
import com.zsy.exam.model.entity.Post;
import com.zsy.exam.service.IPostService;
import com.zsy.exam.service.IRoleService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PostServiceImpl
extends ServiceImpl<PostMapper, Post>
implements IPostService {
    @Autowired
    PostMapper postMapper;
    @Resource
    private IRoleService roleService;

    public Post getPost(Long id) {
        return (Post)this.postMapper.selectById((Serializable)id);
    }

    public Page<List<Post>> getAllPost(Page page) {
        List roles = this.roleService.getCurrentRoles();
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        if (!roles.contains(RoleEnum.SUPER_ADMIN.getCode())) {
            qw.notIn(Post::getPostCode, new Object[]{"expert"});
        }
        return (Page)this.postMapper.selectPage((IPage)page, (Wrapper)qw);
    }

    public void add(Post post) {
        this.postMapper.insert((Object)post);
    }

    public int modify(Post post) {
        return this.postMapper.updateById((Object)post);
    }

    public void remove(String ids) {
        String[] array;
        if (StringUtils.isNotEmpty((CharSequence)ids) && !CollectionUtils.isEmpty(Arrays.asList(array = ids.split(",")))) {
            this.postMapper.deleteBatchIds(Arrays.asList(array));
        }
    }

    public List<String> getPostCodeListByUserId(Long userId) {
        return ((PostMapper)this.baseMapper).getPostCodeListByUserId(userId);
    }
}

