/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.mapper.QuestionFeedbackMapper;
import com.zsy.exam.mapper.UserPostMapper;
import com.zsy.exam.model.dto.QuestionFeedbackDealDto;
import com.zsy.exam.model.dto.QuestionFeedbackDto;
import com.zsy.exam.model.entity.QuestionFeedback;
import com.zsy.exam.model.form.question.QuestionFeedbackQuery;
import com.zsy.exam.model.vo.QuestionFeedbackVo;
import com.zsy.exam.service.ICatalogueService;
import com.zsy.exam.service.IQuestionFeedbackService;
import com.zsy.exam.service.IQuestionService;
import com.zsy.exam.service.ISubjectService;
import com.zsy.exam.service.IUserMessageService;
import com.zsy.exam.service.IUserService;
import com.zsy.exam.service.IWebSocketService;
import com.zsy.exam.util.SecurityUtil;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class QuestionFeedbackServiceImpl
extends ServiceImpl<QuestionFeedbackMapper, QuestionFeedback>
implements IQuestionFeedbackService {
    @Autowired
    QuestionFeedbackMapper questionFeedbackMapper;
    @Autowired
    private IUserMessageService userMessageService;
    @Autowired
    private UserPostMapper userPostMapper;
    @Autowired
    @Lazy
    private IQuestionService questionService;
    @Autowired
    private ISubjectService subjectService;
    @Autowired
    private IUserService userService;
    @Autowired
    private IWebSocketService webSocketService;
    @Autowired
    private ICatalogueService catalogueService;

    public Page<QuestionFeedbackVo> myPage(IPage page, QuestionFeedbackQuery query) {
        query.setUserId(SecurityUtil.getUserId());
        return ((QuestionFeedbackMapper)this.baseMapper).myPage(page, query);
    }

    @Transactional(rollbackFor={Exception.class})
    public void add(QuestionFeedbackDto dto) {
        QuestionFeedback questionFeedback = new QuestionFeedback();
        BeanUtil.copyProperties((Object)dto, (Object)questionFeedback, (String[])new String[0]);
        this.questionFeedbackMapper.insert((Object)questionFeedback);
        this.userMessageService.sendMessageFeedback(questionFeedback, Integer.valueOf(1));
    }

    @Transactional(rollbackFor={Exception.class})
    public int modify(QuestionFeedbackDto dto) {
        QuestionFeedback db = (QuestionFeedback)this.getById((Serializable)dto.getId());
        if (!SecurityUtil.getUserId().equals(db.getCreatorId())) {
            throw new AppException("\u53ea\u80fd\u4fee\u6539\u81ea\u5df1\u7684\u53cd\u9988");
        }
        if (db.getDeal().booleanValue()) {
            throw new AppException("\u8be5\u53cd\u9988\u5df2\u7ecf\u5904\u7406");
        }
        BeanUtil.copyProperties((Object)dto, (Object)db, (String[])new String[0]);
        return this.questionFeedbackMapper.updateById((Object)db);
    }

    @Transactional(rollbackFor={Exception.class})
    public void remove(String ids) {
        if (StringUtils.isNotEmpty((CharSequence)ids)) {
            List<Long> list = Arrays.stream(ids.split(",")).map(Long::parseLong).toList();
            list.forEach(id -> {
                QuestionFeedback db = (QuestionFeedback)this.getById((Serializable)id);
                if (db.getDeal().booleanValue()) {
                    throw new AppException("\u8be5\u53cd\u9988\u5df2\u7ecf\u5904\u7406");
                }
                if (!SecurityUtil.getUserId().equals(db.getCreatorId())) {
                    throw new AppException("\u53ea\u80fd\u5220\u9664\u81ea\u5df1\u7684\u53cd\u9988");
                }
                this.removeById((Serializable)id);
            });
        }
    }

    public List<QuestionFeedbackVo> getByQuestion(Long questionId, Boolean deal) {
        return ((QuestionFeedbackMapper)this.baseMapper).getByQuestion(questionId, deal);
    }

    public void deal(QuestionFeedbackDealDto dto) {
        List postCodeList = SecurityUtil.getPostCodeList();
        boolean contains = postCodeList.contains("qap");
        if (!contains) {
            throw new AppException("\u60a8\u6ca1\u6709\u5ba1\u6838\u6743\u9650");
        }
        QuestionFeedback db = (QuestionFeedback)this.getById((Serializable)dto.getId());
        BeanUtil.copyProperties((Object)dto, (Object)db, (String[])new String[0]);
        db.setDealTime(LocalDateTime.now());
        db.setDealUserId(SecurityUtil.getUserId());
        this.updateById((Object)db);
        this.userMessageService.sendMessageFeedback(db, Integer.valueOf(2));
    }
}

