/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.common.result.Key2Value;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.common.result.UEFileUploadResult;
import com.zsy.exam.constant.ICodeRule;
import com.zsy.exam.constant.IQuestionApproveStatus;
import com.zsy.exam.constant.IQuestionBelongConstant;
import com.zsy.exam.constant.QuestionTypeEnum;
import com.zsy.exam.constant.RoleEnum;
import com.zsy.exam.converter.QuestionConverter;
import com.zsy.exam.mapper.OptionMapper;
import com.zsy.exam.mapper.QuestionMapper;
import com.zsy.exam.model.QuestionApproveDto;
import com.zsy.exam.model.dto.ExaminationAutoTypeDTO;
import com.zsy.exam.model.dto.QuestionExportDto;
import com.zsy.exam.model.entity.Catalogue;
import com.zsy.exam.model.entity.CodeRule;
import com.zsy.exam.model.entity.Option;
import com.zsy.exam.model.entity.Question;
import com.zsy.exam.model.entity.QuestionAndMisc;
import com.zsy.exam.model.entity.SensitiveWords;
import com.zsy.exam.model.entity.WrongQuestionBook;
import com.zsy.exam.model.form.question.QuestionFrom;
import com.zsy.exam.model.form.question.QuestionImportError;
import com.zsy.exam.model.form.question.QuestionImportResult;
import com.zsy.exam.model.form.question.QuestionOnlyContentFrom;
import com.zsy.exam.model.form.question.QuestionPageQuery;
import com.zsy.exam.model.vo.QuestionVO;
import com.zsy.exam.service.ICatalogueService;
import com.zsy.exam.service.IExaminationPaperService;
import com.zsy.exam.service.IExerciseQuestionService;
import com.zsy.exam.service.IOptionService;
import com.zsy.exam.service.IQuestionService;
import com.zsy.exam.service.IQuestionTypeService;
import com.zsy.exam.service.IRoleService;
import com.zsy.exam.service.ISensitiveWordsService;
import com.zsy.exam.service.IUserMessageService;
import com.zsy.exam.service.IWrongQuestionBookService;
import com.zsy.exam.service.impl.QuestionServiceImpl;
import com.zsy.exam.util.FileUtil;
import com.zsy.exam.util.GenerateIdUtils;
import com.zsy.exam.util.MinioUtil;
import com.zsy.exam.util.SecurityUtil;
import com.zsy.exam.util.Wmf2PngUtil;
import com.zsy.exam.util.tree.ScopeCatalogueUtils;
import jakarta.annotation.Resource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class QuestionServiceImpl
extends ServiceImpl<QuestionMapper, Question>
implements IQuestionService {
    @Resource
    private QuestionConverter questionConverter;
    @Resource
    private OptionMapper optionMapper;
    @Resource
    private IOptionService optionService;
    @Resource
    private ICatalogueService catalogueService;
    @Resource
    private MinioUtil minioUtil;
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    @Resource
    @Lazy
    private IQuestionTypeService questionTypeService;
    @Resource
    private IExerciseQuestionService exerciseQuestionService;
    @Resource
    @Lazy
    private IWrongQuestionBookService wrongQuestionBookService;
    @Resource
    private ISensitiveWordsService sensitiveWordsService;
    @Resource
    @Lazy
    private IExaminationPaperService paperService;
    @Resource
    private IRoleService roleService;
    @Resource
    private IUserMessageService userMessageService;
    public static String answerAndExplanationRegexPattern = "(?<=\u7b54\u6848\uff1a)(.*?)(?=\\s*\u89e3\u6790\uff1a|\u5f97\u5206\u6743\u91cd\uff1a|$)(?:(\\s*\u5f97\u5206\u6743\u91cd\uff1a.*?)(?=\\s*\u89e3\u6790\uff1a|$))?(?:\\s*\u89e3\u6790\uff1a(.*))?";

    @Transactional
    public List<Long> addQuestion(List<QuestionFrom> dtoList, Integer belong) {
        this.belongCheck(belong);
        ArrayList<Long> ids = new ArrayList<Long>();
        List sensitiveWords = this.sensitiveWordsService.list();
        for (QuestionFrom dto : dtoList) {
            this.checkSensitiveWords(dto, sensitiveWords);
            List options = dto.getOptions();
            Question db = this.questionConverter.fromToEntity(dto);
            if (IQuestionBelongConstant.PERSONAL_BELONG.equals(belong) || IQuestionBelongConstant.MAJOR_BELONG.equals(belong)) {
                db.setApproveStatus(IQuestionApproveStatus.APPROVE_PASS);
            } else {
                db.setApproveStatus(IQuestionApproveStatus.APPROVE_WAIT);
            }
            String pathCode = this.getPathCode(dto);
            if (StrUtil.isNotBlank((CharSequence)dto.getCode())) {
                pathCode = dto.getCode();
            }
            db.setCode(pathCode);
            db.setBelong(belong);
            ((QuestionMapper)this.baseMapper).insert((Object)db);
            Long id = db.getId();
            this.optionService.removeAndAdd(id, options);
            ids.add(id);
            List combinationList = dto.getCombinationList();
            if (!dto.getIsCombination().booleanValue() || !CollUtil.isNotEmpty((Collection)combinationList)) continue;
            ArrayList<Long> weightList = new ArrayList<Long>();
            weightList.add(dto.getWeightDistribution());
            combinationList.forEach(a -> {
                Long weightDistribution = a.getWeightDistribution();
                weightList.add(weightDistribution);
                a.setCombinationList(null);
                a.setMainCombinationId(db.getId());
                a.setIsCombination(Boolean.TRUE);
            });
            long totalWeight = weightList.stream().mapToLong(Long::longValue).sum();
            if (100L != totalWeight) {
                throw new AppException("\u5f53\u524d\u7ec4\u5408\u9898\u6743\u91cd\u76f8\u52a0\u603b\u548c\u4e3a\uff1a" + totalWeight + "\uff0c\u8bf7\u4fdd\u8bc1\u6743\u91cd\u603b\u548c\u4e3a100");
            }
            this.addQuestion(combinationList, belong);
        }
        return ids;
    }

    @Transactional
    public Result<String> deleteBatchByIds(List<Long> list) {
        List roles = this.roleService.getCurrentRoles();
        list.forEach(id -> {
            List questionVOS;
            Question db = (Question)this.getById((Serializable)id);
            Long userId = SecurityUtil.getUserId();
            if (roles.contains(RoleEnum.TEACHER.getCode()) && !db.getUserId().equals(userId)) {
                throw new AppException("\u6559\u5e08\u53ea\u80fd\u64cd\u4f5c\u81ea\u5df1\u521b\u5efa\u7684\u8bd5\u9898");
            }
            List exerciseIds = this.exerciseQuestionService.getExerciseIddByQuestionId(id);
            if (CollUtil.isNotEmpty((Collection)exerciseIds)) {
                String content = db.getContent();
                String text = StrUtil.subPre((CharSequence)content, (int)10);
                throw new AppException("\u3010" + text + "\u3011\u8be5\u8bd5\u9898\u5df2\u88ab\u7ec3\u4e60\u4f7f\u7528,\u4e0d\u53ef\u5220\u9664");
            }
            if (db.getIsCombination().booleanValue() && null == db.getMainCombinationId() && CollUtil.isNotEmpty((Collection)(questionVOS = ((QuestionMapper)this.baseMapper).detailByMainCombinationId(id)))) {
                List combinationList = questionVOS.stream().map(QuestionVO::getId).collect(Collectors.toList());
                this.deleteBatchByIds(combinationList);
            }
        });
        this.optionMapper.deleteBatchByQuIds(list);
        ((QuestionMapper)this.baseMapper).deleteBatchIdsQu(list);
        return Result.success((String)"\u5220\u9664\u6210\u529f");
    }

    public void physicalDelete(Long id) {
        ((QuestionMapper)this.baseMapper).physicalDelete(id);
        this.optionService.physicalDeleteByQuId(id);
    }

    public IPage<QuestionVO> pagingQuestion(Integer pageNum, Integer pageSize, QuestionPageQuery query) {
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        query.setBelongUserId(SecurityUtil.getUserId());
        List roles = this.roleService.getCurrentRoles();
        if (roles.contains(RoleEnum.TEACHER.getCode())) {
            List approveStatus = query.getApproveStatus();
            boolean qap = this.isQAP();
            if (!qap && (approveStatus.contains(IQuestionApproveStatus.APPROVE_WAIT) || approveStatus.contains(IQuestionApproveStatus.APPROVE_REJECT))) {
                query.setUserId(SecurityUtil.getUserId());
            }
            if (IQuestionBelongConstant.PERSONAL_BELONG.equals(query.getBelong())) {
                query.setUserId(SecurityUtil.getUserId());
            }
            query.setSubjectCodes(SecurityUtil.getSubjectCode());
            page = ((QuestionMapper)this.baseMapper).pagingQuestion((IPage)page, query);
        } else if (roles.contains(RoleEnum.ADMIN.getCode()) || roles.contains(RoleEnum.SUPER_ADMIN.getCode())) {
            query.setUserId(Long.valueOf(0L));
            page = ((QuestionMapper)this.baseMapper).pagingQuestion((IPage)page, query);
        }
        page.getRecords().parallelStream().forEach(a -> {
            if (StringUtils.isNotBlank((CharSequence)a.getPath())) {
                String pathName = this.catalogueService.getAllPathName(a.getPath());
                a.setPathName(pathName);
                a.setHasPaperUsed(this.paperService.hasPaperUsedQuestion(a.getId()));
            }
        });
        return page;
    }

    public IPage<QuestionVO> demoPreviewModePagingQuestion(Integer pageNum, Integer pageSize, QuestionPageQuery query) {
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        query.setApproveStatus(Arrays.asList(IQuestionApproveStatus.APPROVE_PASS));
        query.setSubjectCodes(SecurityUtil.getSubjectCode());
        query.setBelongUserId(SecurityUtil.getUserId());
        ((QuestionMapper)this.baseMapper).setDemoRank();
        Long count = ((QuestionMapper)this.baseMapper).demoPreviewModePagingQuestionCount(query);
        page.setTotal(count.longValue());
        if (count > 0L) {
            ((QuestionMapper)this.baseMapper).setDemoRank();
            List questionVOS = ((QuestionMapper)this.baseMapper).demoPreviewModePagingQuestion(query, Long.valueOf((page.getCurrent() - 1L) * page.getSize()), Long.valueOf(page.getSize()));
            questionVOS.parallelStream().forEach(a -> {
                if (StringUtils.isNotBlank((CharSequence)a.getPath())) {
                    String pathName = this.catalogueService.getAllPathName(a.getPath());
                    a.setPathName(pathName);
                }
            });
            page.setRecords(questionVOS);
        }
        return page;
    }

    public void personalBelongShare2School(Long id) {
        List questionVOS;
        Question db = (Question)this.getById((Serializable)id);
        Integer belong = db.getBelong();
        if (!IQuestionBelongConstant.PERSONAL_BELONG.equals(belong)) {
            throw new AppException("\u53ea\u80fd\u5171\u4eab\u4e2a\u4eba\u5e93\u7684\u8bd5\u9898");
        }
        if (!db.getUserId().equals(SecurityUtil.getUserId())) {
            throw new AppException("\u53ea\u80fd\u5171\u4eab\u81ea\u5df1\u7684\u8bd5\u9898");
        }
        db.setApproveStatus(IQuestionApproveStatus.APPROVE_WAIT);
        this.updateById((Object)db);
        if (db.getIsCombination().booleanValue() && null == db.getMainCombinationId() && CollUtil.isNotEmpty((Collection)(questionVOS = ((QuestionMapper)this.baseMapper).detailByMainCombinationId(id)))) {
            questionVOS.forEach(a -> this.personalBelongShare2School(a.getId()));
        }
        this.userMessageService.sendMessageQuestion(db, Integer.valueOf(1));
    }

    public QuestionVO detail(Long id) {
        QuestionVO questionVO = ((QuestionMapper)this.baseMapper).detail(id);
        if (null == questionVO) {
            throw new AppException("\u6ca1\u6709\u627e\u5230\u8be5\u8bd5\u9898");
        }
        questionVO.setHasPaperUsed(this.paperService.hasPaperUsedQuestion(id));
        List roles = this.roleService.getCurrentRoles();
        if (roles.contains(RoleEnum.ADMIN.getCode()) || roles.contains(RoleEnum.SUPER_ADMIN.getCode()) || SecurityUtil.getSubjectCode().contains(questionVO.getSubjectCode())) {
            if (questionVO.getIsCombination().booleanValue()) {
                List questionVOS = ((QuestionMapper)this.baseMapper).detailByMainCombinationId(id);
                questionVO.setCombinationList(questionVOS);
            }
            return questionVO;
        }
        throw new AppException("\u60a8\u6ca1\u6709\u6743\u9650\u67e5\u770b\u8be5\u8bd5\u9898");
    }

    @Transactional(rollbackFor={Exception.class})
    public List<QuestionVO> batchDetail(String ids) {
        if (StringUtils.isBlank((CharSequence)ids)) {
            throw new AppException("\u53c2\u6570\u9519\u8bef");
        }
        List<String> idList = Arrays.asList(ids.split(","));
        ArrayList<QuestionVO> list = new ArrayList<QuestionVO>();
        List roles = this.roleService.getCurrentRoles();
        for (String id : idList) {
            QuestionVO questionVO = ((QuestionMapper)this.baseMapper).detail(Long.valueOf(id));
            if (null == questionVO) {
                throw new AppException("\u6ca1\u6709\u627e\u5230\u8be5\u8bd5\u9898");
            }
            if (roles.contains(RoleEnum.ADMIN.getCode()) || roles.contains(RoleEnum.SUPER_ADMIN.getCode()) || SecurityUtil.getSubjectCode().contains(questionVO.getSubjectCode())) {
                if (questionVO.getIsCombination().booleanValue()) {
                    List questionVOS = ((QuestionMapper)this.baseMapper).detailByMainCombinationId(Long.valueOf(id));
                    questionVO.setCombinationList(questionVOS);
                }
                list.add(questionVO);
                continue;
            }
            throw new AppException("\u60a8\u6ca1\u6709\u6743\u9650\u67e5\u770b\u8be5\u8bd5\u9898");
        }
        return list;
    }

    public List<QuestionExportDto> getExportByMainId(Long id) {
        ArrayList<QuestionExportDto> dots = new ArrayList<QuestionExportDto>();
        LambdaQueryWrapper qw = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Question::getId, (Object)id)).or()).eq(Question::getMainCombinationId, (Object)id);
        List questionList = ((QuestionMapper)this.baseMapper).selectList((Wrapper)qw);
        for (Question q : questionList) {
            QuestionExportDto questionExportDto = new QuestionExportDto();
            questionExportDto.setQuestion(q);
            List options = this.optionService.getByQuId(q.getId());
            questionExportDto.setOptionList(options);
            dots.add(questionExportDto);
        }
        return dots;
    }

    @Transactional
    public Result<String> updateQuestion(QuestionFrom dto) {
        Boolean hasPaperUsed = this.paperService.hasPaperUsedQuestion(dto.getId());
        if (hasPaperUsed.booleanValue()) {
            throw new AppException("\u8be5\u8bd5\u9898\u5df2\u7ecf\u88ab\u8bd5\u5377\u5f15\u7528\uff0c\u53ea\u80fd\u4fee\u6539\u8bd5\u9898\u5185\u5bb9");
        }
        List sensitiveWords = this.sensitiveWordsService.list();
        this.checkSensitiveWords(dto, sensitiveWords);
        Question question = this.questionConverter.fromToEntity(dto);
        Question db = (Question)this.getById((Serializable)dto.getId());
        Integer belong = db.getBelong();
        this.belongCheck(belong);
        Integer approveStatus = db.getApproveStatus();
        List roles = this.roleService.getCurrentRoles();
        if (IQuestionApproveStatus.APPROVE_PASS.equals(approveStatus) && !IQuestionBelongConstant.PERSONAL_BELONG.equals(belong)) {
            if (!this.isQAP()) {
                throw new AppException("\u5ba1\u6279\u901a\u8fc7\u4e86\u53ea\u80fd\u7531\u5ba1\u6279\u4eba\u4fee\u6539\u8bd5\u9898");
            }
        } else {
            if (!(roles.contains(RoleEnum.ADMIN.getCode()) || roles.contains(RoleEnum.SUPER_ADMIN.getCode()) || SecurityUtil.getUserId().equals(db.getUserId()))) {
                throw new AppException("\u60a8\u6ca1\u6709\u66f4\u65b0\u8be5\u8bd5\u9898\u6743\u9650");
            }
            if (!IQuestionBelongConstant.PERSONAL_BELONG.equals(belong)) {
                question.setApproveStatus(IQuestionApproveStatus.APPROVE_WAIT);
            }
        }
        ((QuestionMapper)this.baseMapper).updateById((Object)question);
        List options = dto.getOptions();
        List deleteOptions = dto.getDeleteOptions();
        if (CollUtil.isNotEmpty((Collection)deleteOptions)) {
            this.optionMapper.deleteBatchIds((Collection)deleteOptions);
        }
        for (Option option : options) {
            if (null != option.getId()) {
                this.optionMapper.updateById((Object)option);
                continue;
            }
            option.setQuId(question.getId());
            this.optionMapper.insert((Object)option);
        }
        List combinationList = dto.getCombinationList();
        if (dto.getIsCombination().booleanValue() && CollUtil.isNotEmpty((Collection)combinationList)) {
            ArrayList<Long> weightList = new ArrayList<Long>();
            weightList.add(dto.getWeightDistribution());
            combinationList.forEach(co -> {
                Long id = co.getId();
                if (null == id) {
                    co.setCombinationList(null);
                    co.setMainCombinationId(dto.getId());
                    List saveIds = this.addQuestion(List.of(co), belong);
                    if (IQuestionApproveStatus.APPROVE_PASS.equals(approveStatus)) {
                        Question combinationBb = (Question)this.getById((Serializable)saveIds.get(0));
                        combinationBb.setApproveStatus(IQuestionApproveStatus.APPROVE_PASS);
                        this.updateById((Object)combinationBb);
                    }
                } else {
                    this.updateQuestion(co);
                }
                weightList.add(co.getWeightDistribution());
            });
            long totalWeight = weightList.stream().mapToLong(Long::longValue).sum();
            if (100L != totalWeight) {
                throw new AppException("\u5f53\u524d\u7ec4\u5408\u9898\u6743\u91cd\u76f8\u52a0\u603b\u548c\u4e3a\uff1a" + totalWeight + "\uff0c\u8bf7\u4fdd\u8bc1\u6743\u91cd\u603b\u548c\u4e3a100");
            }
        }
        return Result.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @Transactional
    public Result<String> updateQuestionOnlyContent(QuestionOnlyContentFrom dto) {
        Question db = (Question)this.getById((Serializable)dto.getId());
        List sensitiveWords = this.sensitiveWordsService.list();
        QuestionFrom questionFrom = new QuestionFrom();
        BeanUtil.copyProperties((Object)dto, (Object)questionFrom, (String[])new String[0]);
        questionFrom.setOptions(dto.getOptions());
        questionFrom.setCode(db.getCode());
        this.checkSensitiveWords(questionFrom, sensitiveWords);
        Integer belong = db.getBelong();
        this.belongCheck(belong);
        Integer approveStatus = db.getApproveStatus();
        List roles = this.roleService.getCurrentRoles();
        if (IQuestionApproveStatus.APPROVE_PASS.equals(approveStatus) && !IQuestionBelongConstant.PERSONAL_BELONG.equals(belong)) {
            if (!this.isQAP()) {
                throw new AppException("\u5ba1\u6279\u901a\u8fc7\u4e86\u53ea\u80fd\u7531\u5ba1\u6279\u4eba\u4fee\u6539\u8bd5\u9898");
            }
        } else {
            if (!(roles.contains(RoleEnum.ADMIN.getCode()) || roles.contains(RoleEnum.SUPER_ADMIN.getCode()) || SecurityUtil.getUserId().equals(db.getUserId()))) {
                throw new AppException("\u60a8\u6ca1\u6709\u66f4\u65b0\u8be5\u8bd5\u9898\u6743\u9650");
            }
            db.setApproveStatus(IQuestionApproveStatus.APPROVE_WAIT);
            this.userMessageService.sendMessageQuestion(db, Integer.valueOf(1));
        }
        db.setContent(dto.getContent());
        db.setAnalysis(dto.getAnalysis());
        ((QuestionMapper)this.baseMapper).updateById((Object)db);
        List options = dto.getOptions();
        for (Option option : options) {
            option.setQuId(db.getId());
            this.optionService.saveOrUpdate((Object)option);
        }
        return Result.success((String)"\u4fee\u6539\u6210\u529f");
    }

    @Transactional
    public QuestionImportResult importQuestion(Long repoId, String text, Integer masteryLevel, Integer belong) {
        this.belongCheck(belong);
        HashMap combinationNoMap = new HashMap();
        QuestionImportResult result = new QuestionImportResult();
        Catalogue catalogue = this.catalogueService.getCatalogue(repoId);
        if (null == catalogue) {
            throw new AppException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u5b66\u79d1");
        }
        String prefix = catalogue.getPathCode().split("\uff0d")[0] + "\uff0d";
        List splitQuestions = StrUtil.split((CharSequence)text, (CharSequence)prefix);
        Integer errorNumber = 0;
        ArrayList<QuestionFrom> mainCombinationList = new ArrayList<QuestionFrom>();
        for (int i = 1; i < splitQuestions.size(); ++i) {
            System.out.println("\u7b2c " + i + "\u4e2a\u95ee\u9898:");
            String str = prefix + ((String)splitQuestions.get(i)).trim();
            try {
                QuestionFrom question = this.getQuestionByText(str, combinationNoMap);
                CodeRule codeRule = CodeRule.getByCode((String)question.getCode());
                if (null == codeRule) {
                    throw new AppException("\u9898\u53f7\u7684\u7f16\u7801\u89c4\u5219\u4e0d\u5bf9");
                }
                String difficulty = codeRule.getDifficulty();
                question.setDifficulty(Integer.valueOf(Integer.parseInt(difficulty)));
                question.setSerialNumber(codeRule.getSerialNumber());
                question.setQuType(codeRule.getQuType());
                String repoPath = CodeRule.getRepoPathCode((String)question.getCode());
                List listByPathCode = this.catalogueService.getListByPathCode(repoPath);
                if (CollUtil.isEmpty((Collection)listByPathCode)) {
                    throw new AppException("\u6ca1\u6709\u627e\u5230\u6302\u9760\u7684\u77e5\u8bc6\u70b9\uff0c\u8bf7\u5728\u8bd5\u9898\u5206\u7c7b\u65b0\u589e\u8be5\u77e5\u8bc6\u70b9");
                }
                question.setRepoId(((Catalogue)listByPathCode.get(0)).getId());
                question.setMasteryLevel(masteryLevel);
                question.setSource(Integer.valueOf(1));
                question.setImportNumber(Integer.valueOf(i));
                if (null == question.getMainCombinationId()) {
                    result.getQuestionFromList().add(question);
                    if (question.getIsCombination().booleanValue()) {
                        mainCombinationList.add(question);
                    }
                }
            }
            catch (Exception e) {
                QuestionImportError error = new QuestionImportError();
                error.setNumber(Integer.valueOf(i));
                error.setCode(StrUtil.sub((CharSequence)str, (int)0, (int)26));
                error.setError(e.getMessage());
                result.getErrorList().add(error);
            }
            System.out.println("----------------------");
        }
        errorNumber = result.getErrorList().size();
        ArrayList<QuestionFrom> errorList = new ArrayList<QuestionFrom>();
        for (int i = 0; i < mainCombinationList.size(); ++i) {
            QuestionFrom q = (QuestionFrom)mainCombinationList.get(i);
            Long weightDistribution = q.getWeightDistribution();
            long totalWeight = q.getCombinationList().stream().mapToLong(QuestionFrom::getWeightDistribution).sum();
            if (null != weightDistribution) {
                totalWeight += weightDistribution.longValue();
            }
            if (100L == totalWeight) continue;
            QuestionImportError error = new QuestionImportError();
            error.setNumber(q.getImportNumber());
            error.setCode(q.getCode());
            error.setError("\u5f53\u524d\u7ec4\u5408\u9898\u6743\u91cd\u76f8\u52a0\u603b\u548c\u4e3a\uff1a" + totalWeight + "\uff0c\u8bf7\u4fdd\u8bc1\u6743\u91cd\u603b\u548c\u4e3a100");
            result.getErrorList().add(error);
            errorList.add(q);
            errorNumber = errorNumber + 1;
        }
        int total = splitQuestions.size() - 1;
        result.getQuestionFromList().removeAll(errorList);
        result.setTotal(Integer.valueOf(total));
        result.setRightNumber(Integer.valueOf(total - errorNumber));
        result.setErrorNumber(errorNumber);
        return result;
    }

    public Boolean getJudgeQuestionResult(String answer) {
        if (StringUtils.isNotBlank((CharSequence)answer)) {
            for (String a : ICodeRule.JUDGE_RIGHT) {
                if (!answer.contains(a)) continue;
                return Boolean.TRUE;
            }
            for (String a : ICodeRule.JUDGE_ERROR) {
                if (!answer.contains(a)) continue;
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private QuestionFrom getQuestionByText(String text, HashMap<String, QuestionFrom> combinationNoMap) throws Exception {
        text = text.replace("\u89e3\u6790:", "\u89e3\u6790\uff1a").replace("\u7b54\u6848:", "\u7b54\u6848\uff1a").replace("\u6743\u91cd:", "\u6743\u91cd\uff1a");
        QuestionFrom question = new QuestionFrom();
        String zh = "&amp;";
        String regexPattern = "(\\w{3}\uff0d\\w{3}\uff0d\\w{3}\uff0d\\w{4}\uff0d\\w{2}\uff0d\\w{1}\uff0d\\w{4})\\s*(?:" + zh + "([^" + zh + "]*)" + zh + ")?\\s*((?:[\\s\\S]*?)(?=\\s*[A-Z]\\.|\\s*\u7b54\u6848\uff1a))(.*)";
        Pattern pattern = Pattern.compile(regexPattern, 32);
        Matcher matcher = pattern.matcher(text);
        QuestionFrom mainForm = null;
        Boolean isSonQuestion = Boolean.FALSE;
        if (matcher.find()) {
            String questionCode = matcher.group(1);
            String combinationNo = matcher.group(2);
            String questionContent = matcher.group(3);
            String questionText = matcher.group(4);
            String lastFourChars = questionCode.substring(questionCode.length() - 4);
            if (StrUtil.isNotBlank((CharSequence)combinationNo)) {
                question.setIsCombination(Boolean.TRUE);
                combinationNo = combinationNo.replace("#", "");
                if (lastFourChars.contains(combinationNo)) {
                    question.setId(GenerateIdUtils.generateId((Object)question));
                    combinationNoMap.put(combinationNo, question);
                    mainForm = question;
                } else {
                    isSonQuestion = Boolean.TRUE;
                    mainForm = combinationNoMap.get(combinationNo);
                    if (null == mainForm) {
                        throw new AppException("\u6ca1\u6709\u627e\u5230\u7ec4\u5408\u9898\u4e3b\u9898\u7684\u5bfc\u5165\uff0c\u8bf7\u786e\u4fdd\u4e3b\u9898\u683c\u5f0f\u6b63\u786e\u6216\u5b50\u9898\u987a\u5e8f\u5728\u4e3b\u9898\u4e4b\u540e");
                    }
                    question.setMainCombinationId(mainForm.getId());
                }
            }
            question.setCode(questionCode);
            question.setContent(questionContent);
            String quType = this.getTypeByQuestionCode(questionCode);
            switch (1.$SwitchMap$com$zsy$exam$constant$QuestionTypeEnum[QuestionTypeEnum.getByType((String)quType).ordinal()]) {
                case 1: 
                case 2: {
                    this.analysisSingle(question, questionText);
                    break;
                }
                case 3: {
                    this.analysisJudge(question, questionText);
                    break;
                }
                default: {
                    this.analysisSubjective(question, questionText);
                    break;
                }
            }
        } else {
            throw new AppException("\u6ca1\u6709\u627e\u5230\u5339\u914d\u7684\u8bd5\u9898,\u8bf7\u68c0\u67e5\u9898\u53f7\u7684\u7f16\u7801\u683c\u5f0f\u662f\u5426\u6b63\u786e\u6216\u8005\u662f\u5426\u5305\u542b\u7b54\u6848\uff1a");
        }
        if (question.getIsCombination().booleanValue() && null == question.getWeightDistribution()) {
            throw new AppException("\u7ec4\u5408\u9898\u7684\u5f97\u5206\u6743\u91cd\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        if (isSonQuestion.booleanValue()) {
            mainForm.getCombinationList().add(question);
        }
        return question;
    }

    private void analysisSubjective(QuestionFrom question, String text) {
        String answer;
        HashMap questionMap;
        ArrayList<Option> optionList = new ArrayList<Option>();
        Pattern pattern = Pattern.compile(answerAndExplanationRegexPattern, 32);
        Matcher matcher = pattern.matcher(text);
        Long weightDistribution = null;
        if (!text.contains("\u7b54\u6848\uff1a")) {
            throw new AppException("\u6ca1\u6709\u5339\u914d\u5230\u7b54\u6848");
        }
        String[] split = text.split("\u7b54\u6848\uff1a");
        String others = split[0];
        question.setContent(question.getContent() + others);
        if (matcher.find()) {
            questionMap = this.getQuestionMap(matcher);
            answer = String.valueOf(questionMap.get("answer"));
            Object weightDistributionStr = questionMap.get("weightDistribution");
            if (null != weightDistributionStr && NumberUtil.isNumber((CharSequence)String.valueOf(weightDistributionStr))) {
                weightDistribution = Long.parseLong(String.valueOf(weightDistributionStr));
            }
        } else {
            throw new AppException("\u6ca1\u6709\u627e\u5230\u5339\u914d\u7684\u5185\u5bb9\u3002");
        }
        String explanation = String.valueOf(questionMap.get("explanation"));
        Option rightOption = new Option();
        rightOption.setContent(answer);
        rightOption.setSort(Integer.valueOf(1));
        optionList.add(rightOption);
        question.setOptions(optionList);
        question.setWeightDistribution(weightDistribution);
        question.setAnalysis(explanation);
    }

    private void analysisSingle(QuestionFrom question, String text) {
        Long weightDistribution;
        String explanation;
        ArrayList<Option> optionList = new ArrayList<Option>();
        String regexPattern = "(.*?)(?=\\s*\u7b54\u6848\uff1a|\\s*\u89e3\u6790\uff1a|$)(?:(\\s*\u7b54\u6848\uff1a.*?)(?=\\s*\u89e3\u6790\uff1a|\\s*\u5f97\u5206\u6743\u91cd\uff1a|$))?(?:(\\s*\u5f97\u5206\u6743\u91cd\uff1a.*?)(?=\\s*\u89e3\u6790\uff1a|$))?(?:\\s*\u89e3\u6790\uff1a(.*))?";
        Pattern pattern = Pattern.compile(regexPattern, 32);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            String optionsText = "";
            String answer = "";
            explanation = "";
            weightDistribution = null;
            try {
                optionsText = matcher.group(1);
            }
            catch (Exception e) {
                throw new AppException("\u9009\u9879\u683c\u5f0f\u6709\u8bef");
            }
            try {
                answer = matcher.group(2).trim();
            }
            catch (Exception e) {
                throw new AppException("\u7b54\u6848\u683c\u5f0f\u6709\u8bef");
            }
            try {
                String weightDistributionStr = matcher.group(3).trim();
                weightDistribution = QuestionServiceImpl.getWeightDistributionByStr((String)weightDistributionStr);
            }
            catch (Exception e) {
                System.out.println("\u6ca1\u6709\u5f97\u5206\u6743\u91cd");
            }
            try {
                explanation = matcher.group(4).trim();
            }
            catch (Exception e) {
                throw new AppException("\u89e3\u6790\u683c\u5f0f\u6709\u8bef");
            }
            Pattern optionPattern = Pattern.compile("[A-Z]\\.[\\s\\S]*?(?=[A-Z]\\.|$)");
            Matcher optionMatcher = optionPattern.matcher(optionsText);
            int sort = 1;
            while (optionMatcher.find()) {
                Option option = new Option();
                String optionLabel = optionMatcher.group();
                int index = optionLabel.indexOf(46);
                if (index != -1) {
                    String key = optionLabel.substring(0, index);
                    String value = optionLabel.substring(index + 1);
                    option.setContent(key + "." + value);
                    if (answer.contains(key)) {
                        option.setIsRight(Integer.valueOf(1));
                    } else {
                        option.setIsRight(Integer.valueOf(0));
                    }
                } else {
                    throw new AppException("\u5355\u9009\u591a\u9009\u7684\u9009\u9879\u6ca1\u6709\u627e\u5230.\u7684\u5206\u5272\u3002");
                }
                option.setSort(Integer.valueOf(sort++));
                optionList.add(option);
            }
            if (CollUtil.isEmpty(optionList)) {
                throw new AppException("\u5355\u9009\u591a\u9009\u7684\u9009\u9879\u6ca1\u6709\u627e\u5230\u5339\u914d\u7684\u5185\u5bb9\u3002");
            }
        } else {
            throw new AppException("\u5355\u9009\u591a\u9009\u7684\u9009\u9879\u6ca1\u6709\u627e\u5230\u5339\u914d\u7684\u5185\u5bb9\u3002");
        }
        question.setOptions(optionList);
        question.setWeightDistribution(weightDistribution);
        question.setAnalysis(explanation);
    }

    private void analysisJudge(QuestionFrom question, String text) {
        Option errorOption;
        Option rightOption;
        String explanation;
        ArrayList<Option> optionList = new ArrayList<Option>();
        Pattern pattern = Pattern.compile(answerAndExplanationRegexPattern, 32);
        Matcher matcher = pattern.matcher(text);
        Long weightDistribution = null;
        if (!text.contains("\u7b54\u6848\uff1a")) {
            throw new AppException("\u6ca1\u6709\u5339\u914d\u5230\u7b54\u6848");
        }
        String[] split = text.split("\u7b54\u6848\uff1a");
        String others = split[0];
        question.setContent(question.getContent() + others);
        if (matcher.find()) {
            HashMap questionMap = this.getQuestionMap(matcher);
            String answer = String.valueOf(questionMap.get("answer"));
            Object weightDistributionStr = questionMap.get("weightDistribution");
            if (null != weightDistributionStr && NumberUtil.isNumber((CharSequence)String.valueOf(weightDistributionStr))) {
                weightDistribution = Long.parseLong(String.valueOf(weightDistributionStr));
            }
            explanation = String.valueOf(questionMap.get("explanation"));
            rightOption = new Option();
            rightOption.setContent("\u6b63\u786e");
            rightOption.setSort(Integer.valueOf(1));
            errorOption = new Option();
            errorOption.setContent("\u9519\u8bef");
            errorOption.setSort(Integer.valueOf(2));
            Boolean result = this.getJudgeQuestionResult(answer);
            if (null == result) {
                throw new AppException("\u7b54\u6848\u89e3\u6790\u5931\u8d25\uff0c\u8bf7\u8f93\u5165\u3010\u6b63\u786e\u3011/\u3010A\u3011\u6216\u8005\u3010\u9519\u8bef\u3011/\u3010B\u3011");
            }
            if (result.booleanValue()) {
                rightOption.setIsRight(Integer.valueOf(1));
                errorOption.setIsRight(Integer.valueOf(0));
            } else {
                rightOption.setIsRight(Integer.valueOf(0));
                errorOption.setIsRight(Integer.valueOf(1));
            }
        } else {
            throw new AppException("\u6ca1\u6709\u627e\u5230\u5339\u914d\u7684\u5185\u5bb9\u3002");
        }
        optionList.add(rightOption);
        optionList.add(errorOption);
        question.setOptions(optionList);
        question.setWeightDistribution(weightDistribution);
        question.setAnalysis(explanation);
    }

    HashMap<String, Object> getQuestionMap(Matcher matcher) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String answer = "";
        String explanation = "";
        Long weightDistribution = null;
        try {
            answer = matcher.group(1).trim();
            map.put("answer", answer);
        }
        catch (Exception e) {
            throw new AppException("\u7b54\u6848\u683c\u5f0f\u6709\u8bef");
        }
        try {
            String weightDistributionStr = matcher.group(2).trim();
            weightDistribution = QuestionServiceImpl.getWeightDistributionByStr((String)weightDistributionStr);
            map.put("weightDistribution", weightDistribution);
        }
        catch (Exception e) {
            System.out.println("\u6ca1\u6709\u89e3\u6790\u5230\u5f97\u5206\u6743\u91cd");
        }
        try {
            explanation = matcher.group(3).trim();
            map.put("explanation", explanation);
        }
        catch (Exception e) {
            throw new AppException("\u89e3\u6790\u683c\u5f0f\u6709\u8bef");
        }
        return map;
    }

    public String getPathCode(QuestionFrom dto) {
        Long repoId = dto.getRepoId();
        Catalogue catalogue = this.catalogueService.getCatalogue(repoId);
        if (null == catalogue) {
            throw new AppException("\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u77e5\u8bc6\u70b9");
        }
        if (4 != catalogue.getLevel()) {
            throw new AppException("\u53ea\u80fd\u9009\u62e9\u5230\u77e5\u8bc6\u70b9\u7684\u5206\u7c7b");
        }
        String quType = dto.getQuType();
        if (StrUtil.isBlank((CharSequence)quType) || null == this.questionTypeService.getByType(quType)) {
            throw new AppException("\u8bd5\u9898\u7f16\u7801\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u83b7\u53d6\u8bd5\u9898\u7c7b\u578b");
        }
        Object pathCode = catalogue.getPathCode();
        pathCode = (String)pathCode + "\uff0d" + quType + "\uff0d" + dto.getDifficulty() + "\uff0d" + dto.getSerialNumber();
        LambdaUpdateWrapper qw = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)qw.eq(Question::getCode, pathCode)).ne(null != dto.getId(), Question::getId, (Object)dto.getId());
        if (CollUtil.isNotEmpty((Collection)this.list((Wrapper)qw))) {
            throw new AppException("\u8be5\u8bd5\u9898\u4ee3\u7801\u5df2\u7ecf\u5b58\u5728\u3010" + (String)pathCode + "\u3011");
        }
        return pathCode;
    }

    public List<Question> getByType(String type) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(Question::getQuType, (Object)type);
        return this.list((Wrapper)qw);
    }

    public QuestionVO selectDetailWithOutAnswer(Long id) {
        QuestionVO questionVO = ((QuestionMapper)this.baseMapper).selectDetailWithOutAnswer(id);
        if (null == questionVO) {
            return null;
        }
        if (!QuestionTypeEnum.getObjective().contains(questionVO.getQuType())) {
            questionVO.setOptions(null);
        }
        return questionVO;
    }

    public QuestionVO getAnswer(Long quId) {
        QuestionVO questionVO = new QuestionVO();
        Question question = (Question)this.getById((Serializable)quId);
        List rightAnswer = this.optionService.getRightAnswer(quId);
        questionVO.setAnalysis(question.getAnalysis());
        questionVO.setOptions(rightAnswer);
        questionVO.setId(questionVO.getId());
        return questionVO;
    }

    public List<Key2Value> getNumByCatalogue(QuestionPageQuery query) {
        List allCatalogue = new ArrayList();
        List roles = this.roleService.getCurrentRoles();
        if (roles.contains(RoleEnum.ADMIN.getCode()) || roles.contains(RoleEnum.SUPER_ADMIN.getCode())) {
            query.setUserId(Long.valueOf(0L));
        } else if (roles.contains(RoleEnum.TEACHER.getCode())) {
            List approveStatus = query.getApproveStatus();
            boolean qap = this.isQAP();
            if (!qap && (approveStatus.contains(IQuestionApproveStatus.APPROVE_WAIT) || approveStatus.contains(IQuestionApproveStatus.APPROVE_REJECT))) {
                query.setUserId(SecurityUtil.getUserId());
            }
            if (IQuestionBelongConstant.PERSONAL_BELONG.equals(query.getBelong())) {
                query.setUserId(SecurityUtil.getUserId());
            }
            query.setSubjectCodes(SecurityUtil.getSubjectCode());
        }
        allCatalogue = this.catalogueService.getAllCatalogue();
        query.setBelongUserId(SecurityUtil.getUserId());
        query.setMergeCombination(Boolean.FALSE);
        List numByCatalogue = ((QuestionMapper)this.baseMapper).getNumByCatalogue(query);
        return ScopeCatalogueUtils.getValuse(allCatalogue, (List)numByCatalogue);
    }

    public Boolean getObjectiveTF(Long quId, List<Long> optionIds) {
        List rightAnswers = this.optionService.getRightAnswer(quId);
        List rightIds = rightAnswers.stream().map(Option::getId).collect(Collectors.toList());
        Collection disjunction = CollUtil.disjunction(rightIds, optionIds);
        return CollUtil.isEmpty((Collection)disjunction);
    }

    public QuestionVO detailByWrongBook(Long id) {
        QuestionVO questionVO = ((QuestionMapper)this.baseMapper).detail(id);
        if (null == questionVO) {
            throw new AppException("\u6ca1\u6709\u627e\u5230\u8be5\u8bd5\u9898");
        }
        List wrongQuestionBooks = this.wrongQuestionBookService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WrongQuestionBook::getQuestionId, (Object)id)).eq(WrongQuestionBook::getUserId, (Object)SecurityUtil.getUserId()));
        if (CollectionUtils.isEmpty((Collection)wrongQuestionBooks)) {
            throw new AppException("\u60a8\u6ca1\u6709\u6743\u9650\u67e5\u770b\u8be5\u8bd5\u9898");
        }
        if (questionVO.getIsCombination().booleanValue()) {
            List questionVOS = ((QuestionMapper)this.baseMapper).detailByMainCombinationId(id);
            questionVO.setCombinationList(questionVOS);
        }
        return questionVO;
    }

    public List<HashMap<String, Integer>> groupByType(String subjectCode) {
        List subjectCodeList = SecurityUtil.getSubjectCode();
        if (null != subjectCode && (CollUtil.isEmpty((Collection)subjectCodeList) || !subjectCodeList.contains(subjectCode))) {
            return null;
        }
        return ((QuestionMapper)this.baseMapper).groupByType(subjectCode);
    }

    public boolean isQAP() {
        List postCodeList = SecurityUtil.getPostCodeList();
        return postCodeList.contains("qap");
    }

    public boolean isExpert() {
        List postCodeList = SecurityUtil.getPostCodeList();
        return postCodeList.contains("expert");
    }

    public List<Long> checkApprovedQuestion(List<Long> questionIds) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.in(Question::getId, questionIds);
        List dbList = this.list((Wrapper)qw);
        ArrayList<Long> reList = new ArrayList<Long>();
        dbList.forEach(q -> {
            Integer approveStatus = q.getApproveStatus();
            if (!IQuestionApproveStatus.APPROVE_PASS.equals(approveStatus)) {
                throw new AppException("\u8be5\u8bd5\u9898\u6ca1\u6709\u901a\u8fc7\u5ba1\u6838:" + q.getCode());
            }
            reList.add(q.getId());
        });
        return reList;
    }

    public void checkApprovedQuestion(Long questionId) {
        Question db = (Question)this.getById((Serializable)questionId);
        if (null == db) {
            throw new AppException("\u6ca1\u6709\u627e\u5230\u8be5\u8bd5\u9898");
        }
        Integer approveStatus = db.getApproveStatus();
        if (!IQuestionApproveStatus.APPROVE_PASS.equals(approveStatus)) {
            throw new AppException("\u8be5\u8bd5\u9898\u6ca1\u6709\u901a\u8fc7\u5ba1\u6838:" + db.getCode());
        }
    }

    public void approve(QuestionApproveDto dto) {
        if (!this.isQAP()) {
            throw new AppException("\u53ea\u80fd\u7531\u5ba1\u6838\u5458\u624d\u80fd\u5ba1\u6838");
        }
        List questionIds = dto.getQuestionId();
        for (Long questionId : questionIds) {
            List questionVOS;
            Question db = (Question)this.getById((Serializable)questionId);
            Integer approveStatus = dto.getApproveStatus();
            db.setApproveStatus(dto.getApproveStatus());
            if (IQuestionApproveStatus.APPROVE_PASS.equals(approveStatus)) {
                db.setRejectReason("");
                if (IQuestionBelongConstant.PERSONAL_BELONG.equals(db.getBelong())) {
                    db.setBelong(IQuestionBelongConstant.SCHOOL_BELONG);
                }
            } else if (IQuestionApproveStatus.APPROVE_REJECT.equals(approveStatus)) {
                db.setRejectReason(dto.getRejectReason());
            }
            if (db.getIsCombination().booleanValue() && null == db.getMainCombinationId() && CollUtil.isNotEmpty((Collection)(questionVOS = ((QuestionMapper)this.baseMapper).detailByMainCombinationId(questionId)))) {
                QuestionApproveDto dto2 = new QuestionApproveDto();
                List<Long> combinationIds = questionVOS.stream().map(QuestionVO::getId).toList();
                dto2.setApproveStatus(dto.getApproveStatus());
                dto2.setRejectReason(dto.getRejectReason());
                dto2.setQuestionId(combinationIds);
                this.approve(dto2);
            }
            this.updateById((Object)db);
            this.userMessageService.sendMessageQuestion(db, Integer.valueOf(2));
        }
    }

    public List<Question> selectF4Minio(String bucketName) {
        return ((QuestionMapper)this.baseMapper).selectF4Minio(bucketName);
    }

    public long countBySubject(Boolean isMainCombination, Boolean isPass, String subjectCode) {
        List subjectCodeList = SecurityUtil.getSubjectCode();
        if (null != subjectCode && (CollUtil.isEmpty((Collection)subjectCodeList) || !subjectCodeList.contains(subjectCode))) {
            return 0L;
        }
        return ((QuestionMapper)this.baseMapper).countBySubject(isMainCombination, isPass, subjectCode);
    }

    public Question getByCode(String code) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(Question::getCode, (Object)code);
        return (Question)((QuestionMapper)this.baseMapper).selectOne((Wrapper)qw);
    }

    public List<String> getImgSrcByContent(String content) {
        if (content == null) {
            return null;
        }
        Object img = "";
        ArrayList<String> pics = new ArrayList<String>();
        String regEx_img = "<img[^>]*src\\s*=\\s*\"?(.*?)(\"|>|\\s+)";
        Pattern p_image = Pattern.compile(regEx_img, 2);
        Matcher m_image = p_image.matcher(content);
        while (m_image.find()) {
            img = (String)img + "," + m_image.group();
            Matcher m = Pattern.compile("src\\s*=\\s*\"?(.*?)(\"|>|\\s+)").matcher((CharSequence)img);
            while (m.find()) {
                if (!m.group(1).contains("/db-exam")) continue;
                pics.add(m.group(1));
            }
        }
        return pics;
    }

    public String getMaxSerialNumber(Long repoId) {
        String maxSerialNumber = ((QuestionMapper)this.baseMapper).getMaxSerialNumber(repoId);
        if (StrUtil.isBlank((CharSequence)maxSerialNumber)) {
            maxSerialNumber = "0001";
        } else if (maxSerialNumber.length() < 4) {
            maxSerialNumber = String.format("%0" + (4 - maxSerialNumber.length()) + "d%s", 0, maxSerialNumber);
        }
        return maxSerialNumber;
    }

    public QuestionVO getRandomByCatalogueId(List<Long> catalogueIds, Integer level, String type, List<Long> ids, String subjectCode) {
        Long userId = SecurityUtil.getUserId();
        QuestionVO questionVO = ((QuestionMapper)this.baseMapper).getRandomByCatalogueId(catalogueIds, level, type, ids, userId, subjectCode);
        return questionVO;
    }

    public List<ExaminationAutoTypeDTO> getAutoType(List<Long> catalogueIds) {
        Long userId = SecurityUtil.getUserId();
        List autoType = ((QuestionMapper)this.baseMapper).getAutoType(catalogueIds, userId, null);
        return autoType;
    }

    public List<ExaminationAutoTypeDTO> getAutoTypeBySubject(String subjectCode) {
        Long userId = SecurityUtil.getUserId();
        List autoType = ((QuestionMapper)this.baseMapper).getAutoType(null, userId, subjectCode);
        return autoType;
    }

    public Result<String> uploadImage(MultipartFile file) {
        if (!this.minioUtil.isImage(Objects.requireNonNull(file.getOriginalFilename()))) {
            return Result.failed((String)"\u8be5\u6587\u4ef6\u4e0d\u662f\u5e38\u7528\u56fe\u7247\u683c\u5f0f(png\u3001jpg\u3001jpeg\u3001bmp)");
        }
        if (this.minioUtil.isOverSize(file)) {
            return Result.failed((String)"\u56fe\u7247\u8fc7\u5927");
        }
        String url = this.minioUtil.upload(file, Integer.valueOf(0));
        if (StringUtils.isBlank((CharSequence)url)) {
            return Result.failed((String)"\u56fe\u7247\u4e0a\u4f20\u5931\u8d25");
        }
        return Result.success((String)"\u56fe\u7247\u4e0a\u4f20\u6210\u529f", (Object)url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object uploadImageForUE(String action, MultipartFile file, Integer uploadType) {
        InputStream inputStream = null;
        File outFile = null;
        File pngFile = null;
        try {
            if (action.equals("config")) {
                String string = UEFileUploadResult.UeConfig;
                return string;
            }
            String originalFilename = file.getOriginalFilename();
            inputStream = file.getInputStream();
            if (!this.minioUtil.isImage(Objects.requireNonNull(originalFilename)) && !this.minioUtil.isFile(Objects.requireNonNull(originalFilename))) {
                UEFileUploadResult e = UEFileUploadResult.error();
                return e;
            }
            String fileHash = FileUtil.getFileHash((byte[])file.getBytes());
            String lastName = originalFilename.substring(originalFilename.lastIndexOf(".") + 1);
            if ("wmf".equalsIgnoreCase(lastName)) {
                String svgPath = MinioUtil.TEMP_PATH + originalFilename + RandomUtil.randomString((int)4) + "_temp.svg";
                outFile = new File(svgPath);
                Wmf2PngUtil.wmfToSvg((InputStream)inputStream, (String)svgPath);
                String pngPath = MinioUtil.TEMP_PATH + originalFilename + RandomUtil.randomString((int)4) + "_temp.png";
                pngFile = new File(pngPath);
                Wmf2PngUtil.svgToPng((File)outFile, (String)pngPath);
                originalFilename = pngFile.getName();
                inputStream = new FileInputStream(pngFile);
            }
            String redisHashKey = "fileHash_type_" + uploadType + "_" + fileHash;
            String url = (String)this.stringRedisTemplate.opsForValue().get((Object)redisHashKey);
            if (StringUtils.isBlank((CharSequence)url)) {
                try {
                    url = this.minioUtil.upload(inputStream, originalFilename, uploadType);
                }
                catch (Exception e) {
                    UEFileUploadResult uEFileUploadResult = UEFileUploadResult.error();
                    try {
                        if (null != inputStream) {
                            inputStream.close();
                        }
                        if (null != outFile) {
                            outFile.delete();
                        }
                        if (null != pngFile) {
                            pngFile.delete();
                        }
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    return uEFileUploadResult;
                }
                if (StringUtils.isNotBlank((CharSequence)url)) {
                    this.stringRedisTemplate.opsForValue().set((Object)redisHashKey, (Object)url, 120L, TimeUnit.MINUTES);
                }
            }
            UEFileUploadResult uEFileUploadResult = UEFileUploadResult.ok((String)url, (String)originalFilename, (String)originalFilename);
            return uEFileUploadResult;
        }
        catch (Exception e) {
            UEFileUploadResult uEFileUploadResult = UEFileUploadResult.error();
            return uEFileUploadResult;
        }
        finally {
            try {
                if (null != inputStream) {
                    inputStream.close();
                }
                if (null != outFile) {
                    outFile.delete();
                }
                if (null != pngFile) {
                    pngFile.delete();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String getTypeByQuestionCode(String code) {
        List split1 = StrUtil.split((CharSequence)code, (CharSequence)"\uff0d");
        if (4 > split1.size()) {
            throw new AppException("\u8bd5\u9898\u7f16\u7801\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u83b7\u53d6\u8bd5\u9898\u7c7b\u578b");
        }
        String type = (String)split1.get(4);
        if (StrUtil.isBlank((CharSequence)type) || null == this.questionTypeService.getByType(type)) {
            throw new AppException("\u8bd5\u9898\u7f16\u7801\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u83b7\u53d6\u8bd5\u9898\u7c7b\u578b");
        }
        return type;
    }

    private static Long getWeightDistributionByStr(String weightDistributionStr) {
        String weight = weightDistributionStr.contains("%") ? StrUtil.subBetween((CharSequence)weightDistributionStr, (CharSequence)"\u5f97\u5206\u6743\u91cd\uff1a", (CharSequence)"%") : StrUtil.subAfter((CharSequence)weightDistributionStr, (CharSequence)"\u5f97\u5206\u6743\u91cd\uff1a", (boolean)true);
        return Long.parseLong(weight.trim());
    }

    public QuestionAndMisc getQuestion(Long examinationPaperId, Long questionId) {
        return ((QuestionMapper)this.baseMapper).getQuestion(examinationPaperId, questionId);
    }

    private void checkSensitiveWords(QuestionFrom questionFrom, List<SensitiveWords> sensitiveWords) {
        if (CollectionUtils.isEmpty(sensitiveWords)) {
            return;
        }
        for (SensitiveWords words : sensitiveWords) {
            String name = words.getName();
            if (questionFrom.getContent().contains(name)) {
                throw new AppException("\u8bd5\u9898\u5e8f\u53f7:" + questionFrom.getCode() + "\u4e2d\u9898\u5e72\u5305\u542b\u654f\u611f\u8bcd\uff1a[" + name + "],\u4e0d\u80fd\u65b0\u589e");
            }
            if (questionFrom.getAnalysis().contains(name)) {
                throw new AppException("\u8bd5\u9898\u5e8f\u53f7:" + questionFrom.getCode() + "\u4e2d\u89e3\u6790\u5305\u542b\u654f\u611f\u8bcd\uff1a[" + name + "],\u4e0d\u80fd\u65b0\u589e");
            }
            List options = questionFrom.getOptions();
            if (!options.stream().filter(option -> option.getContent().contains(name)).findFirst().isPresent()) continue;
            throw new AppException("\u8bd5\u9898\u5e8f\u53f7:" + questionFrom.getCode() + "\u4e2d\u9009\u9879\u5305\u542b\u654f\u611f\u8bcd\uff1a[" + name + "],\u4e0d\u80fd\u65b0\u589e");
        }
    }

    private void belongCheck(Integer belong) {
        if (null == belong) {
            throw new AppException("\u8bf7\u9009\u62e9\u6240\u5c5e\u5e93");
        }
        if (IQuestionBelongConstant.MAJOR_BELONG.equals(belong) && !this.isExpert()) {
            throw new AppException("\u53ea\u6709\u4e13\u5bb6\u53ef\u4ee5\u5f55\u5165\u4e13\u5bb6\u5e93");
        }
    }
}

