/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.constant.QuestionTypeEnum;
import com.zsy.exam.mapper.QuestionTypeMapper;
import com.zsy.exam.model.entity.QuestionType;
import com.zsy.exam.service.IQuestionService;
import com.zsy.exam.service.IQuestionTypeService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class QuestionTypeServiceImpl
extends ServiceImpl<QuestionTypeMapper, QuestionType>
implements IQuestionTypeService {
    @Autowired
    QuestionTypeMapper questionTypeMapper;
    @Autowired
    IQuestionService questionService;

    public QuestionType getQuestionType(Long id) {
        return (QuestionType)this.questionTypeMapper.selectById((Serializable)id);
    }

    public Page<List<QuestionType>> getAllQuestionType(Page page) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.orderByAsc(QuestionType::getType);
        return (Page)this.questionTypeMapper.selectPage((IPage)page, (Wrapper)qw);
    }

    public void add(QuestionType questionType) {
        String type = questionType.getType();
        this.check(questionType);
        int length = type.length();
        if (length != 2) {
            throw new AppException("\u7c7b\u578b\u957f\u5ea6\u5fc5\u987b\u4e3a2\u4f4d\uff0c\u4f8b\uff1a09\uff0c10");
        }
        this.questionTypeMapper.insert((Object)questionType);
    }

    public int modify(QuestionType questionType) {
        String type;
        if (null == questionType.getId()) {
            throw new AppException("\u6ca1\u6709\u627e\u5230\u8be5\u8bd5\u9898");
        }
        List typeList = QuestionTypeEnum.getTypeList();
        if (typeList.contains(type = questionType.getType())) {
            throw new AppException("\u7cfb\u7edf\u5185\u7f6e\u8bd5\u9898\u7c7b\u578b\u4e0d\u5141\u8bb8\u4fee\u6539");
        }
        this.check(questionType);
        QuestionType db = (QuestionType)this.getById((Serializable)questionType.getId());
        if (!db.getType().equals(type)) {
            List list = this.questionService.getByType(db.getType());
            if (CollUtil.isNotEmpty((Collection)list)) {
                throw new AppException("\u8be5\u7c7b\u578b\u5df2\u7ecf\u7ed1\u5b9a\u8bd5\u9898\uff0c\u65e0\u6cd5\u4fee\u6539\u7f16\u7801");
            }
            int length = type.length();
            if (length != 2) {
                throw new AppException("\u7c7b\u578b\u957f\u5ea6\u5fc5\u987b\u4e3a2\u4f4d\uff0c\u4f8b\uff1a09\uff0c10");
            }
        }
        return this.questionTypeMapper.updateById((Object)questionType);
    }

    @Transactional(rollbackFor={Exception.class})
    public void remove(String ids) {
        if (StringUtils.isNotEmpty((CharSequence)ids)) {
            List<Long> split = Arrays.stream(ids.split(",")).map(Long::parseLong).toList();
            split.forEach(id -> {
                QuestionType db = (QuestionType)this.getById((Serializable)id);
                List list = this.questionService.getByType(db.getType());
                if (CollUtil.isNotEmpty((Collection)list)) {
                    throw new AppException("\u8be5\u7c7b\u578b\u5df2\u7ecf\u7ed1\u5b9a\u8bd5\u9898\uff0c\u65e0\u6cd5\u5220\u9664");
                }
            });
            if (!CollectionUtils.isEmpty(split)) {
                this.questionTypeMapper.deleteBatchIds(split);
            }
        }
    }

    public QuestionType getByType(String type) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(QuestionType::getType, (Object)type);
        List list = this.list((Wrapper)queryWrapper);
        if (CollUtil.isNotEmpty((Collection)list)) {
            return (QuestionType)list.get(0);
        }
        return null;
    }

    void check(QuestionType questionType) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)qw.eq(QuestionType::getType, (Object)questionType.getType())).ne(null != questionType.getId(), QuestionType::getId, (Object)questionType.getId());
        List list1 = this.list((Wrapper)qw);
        if (CollUtil.isNotEmpty((Collection)list1)) {
            throw new AppException("\u8be5\u7c7b\u578b\u5df2\u7ecf\u5b58\u5728");
        }
    }
}

