/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.constant.SysParamEnum;
import com.zsy.exam.mapper.ExaminationPaperMapper;
import com.zsy.exam.model.dto.PaperExportDto;
import com.zsy.exam.model.dto.region.RegionPaperPageQuery;
import com.zsy.exam.model.dto.sm2.Sm2ResultData;
import com.zsy.exam.model.entity.ExaminationPaper;
import com.zsy.exam.model.entity.SysParam;
import com.zsy.exam.service.IExaminationPaperService;
import com.zsy.exam.service.IRegionSchoolServer;
import com.zsy.exam.service.ISM2Service;
import com.zsy.exam.service.ISysParamService;
import com.zsy.exam.task.RegionServeTask;
import com.zsy.exam.util.SecurityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class RegionSchoolServerImpl
extends ServiceImpl<ExaminationPaperMapper, ExaminationPaper>
implements IRegionSchoolServer {
    private static final Logger log = LoggerFactory.getLogger(RegionSchoolServerImpl.class);
    @Autowired
    private ISysParamService sysParamService;
    @Autowired
    private ISM2Service sm2Service;
    @Autowired
    private IExaminationPaperService examinationService;
    @Autowired
    private StringRedisTemplate redisTemplate;

    public Result getRegionPage(Page page, RegionPaperPageQuery query) {
        SysParam serviceIpSys = this.sysParamService.getByType(SysParamEnum.REGION_SERVE_IP.getType());
        if (null == serviceIpSys) {
            throw new AppException("\u8bf7\u914d\u7f6e\u670d\u52a1\u7aef\u7684ip/\u57df\u540d");
        }
        String queryJson = JSONUtil.toJsonStr((Object)query);
        String encrypt = this.sm2Service.encrypt(queryJson, null);
        String ip = serviceIpSys.getValue();
        String url = ip + "/examination-paper-region/page?current=" + page.getCurrent() + "&size=" + page.getSize() + "&sign=" + encrypt;
        String reJson = HttpUtil.get((String)url);
        Result result = (Result)JSONUtil.toBean((String)reJson, Result.class);
        if (Result.isSuccess((Result)result).booleanValue()) {
            String data = result.getData().toString();
            Sm2ResultData decrypt = null;
            try {
                decrypt = this.sm2Service.decrypt(data);
            }
            catch (Exception e) {
                result.setData(null);
                return result;
            }
            String json = decrypt.getJson();
            Page vo = (Page)JSONUtil.toBean((String)json, Page.class);
            System.out.println(json);
            return Result.ok((Object)vo);
        }
        result.setData(null);
        return result;
    }

    public Result importPaperOnLine(Long paperId) {
        SysParam serviceIpSys = this.sysParamService.getByType(SysParamEnum.REGION_SERVE_IP.getType());
        if (null == serviceIpSys) {
            throw new AppException("\u8bf7\u914d\u7f6e\u670d\u52a1\u7aef\u7684ip/\u57df\u540d");
        }
        String encrypt = this.sm2Service.encrypt(null, null);
        String ip = serviceIpSys.getValue();
        Long userId = SecurityUtil.getUserId();
        String url = ip + "/examination-paper-region/export/" + paperId + "/" + userId + "?sign=" + encrypt;
        String reJson = HttpUtil.get((String)url);
        Sm2ResultData decrypt = null;
        try {
            decrypt = this.sm2Service.decrypt(reJson);
        }
        catch (Exception e) {
            Result result = (Result)JSONUtil.toBean((String)reJson, Result.class);
            result.setData(null);
            return result;
        }
        String json = decrypt.getJson();
        PaperExportDto exportDto = (PaperExportDto)JSONUtil.toBean((String)json, PaperExportDto.class);
        this.examinationService.importPaper(exportDto, Integer.valueOf(1));
        return Result.ok();
    }

    public String getConnectionTime() {
        return (String)this.redisTemplate.opsForValue().get((Object)RegionServeTask.REDIS_REGION_CONNECTION_TIME);
    }
}

