/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.mapper.MenuMapper;
import com.zsy.exam.mapper.RoleMapper;
import com.zsy.exam.mapper.RoleMenuMapper;
import com.zsy.exam.mapper.UserRoleMapper;
import com.zsy.exam.model.dto.RoleListDTO;
import com.zsy.exam.model.dto.RoleMenuUpdateDTO;
import com.zsy.exam.model.entity.Menu;
import com.zsy.exam.model.entity.Role;
import com.zsy.exam.model.entity.RoleMenu;
import com.zsy.exam.model.entity.UserRole;
import com.zsy.exam.model.vo.MenuRoleListVO;
import com.zsy.exam.model.vo.MenuTreeListVO;
import com.zsy.exam.model.vo.RoleVO;
import com.zsy.exam.service.IRoleService;
import com.zsy.exam.util.SecurityUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RoleServiceImpl
extends ServiceImpl<RoleMapper, Role>
implements IRoleService {
    @Autowired
    RoleMapper roleMapper;
    @Autowired
    private RoleMenuMapper roleMenuMapper;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private MenuMapper menuMapper;
    @Autowired
    private UserRoleMapper userRoleMapper;

    public Role getRole(Long id) {
        return (Role)this.roleMapper.selectById((Serializable)id);
    }

    public IPage<RoleVO> getAllRole(Page page, RoleListDTO dto) {
        IPage roleIPage = this.roleMapper.pageQuery(page, dto);
        if (CollectionUtils.isEmpty((Collection)roleIPage.getRecords())) {
            return roleIPage;
        }
        for (RoleVO vo : roleIPage.getRecords()) {
            List userRoles = this.userRoleMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(UserRole::getRoleId, (Object)vo.getId()));
            if (CollectionUtils.isEmpty((Collection)userRoles)) continue;
            List userIds = userRoles.stream().map(UserRole::getUserId).collect(Collectors.toList());
            vo.setUserIds(userIds);
        }
        return roleIPage;
    }

    public void add(Role role) {
        Role checkRole = (Role)this.getOne((Wrapper)new LambdaQueryWrapper().eq(Role::getCode, (Object)role.getCode()));
        if (checkRole != null) {
            throw new AppException("\u7f16\u7801\u91cd\u590d");
        }
        this.roleMapper.insert((Object)role);
    }

    public int modify(Role role) {
        Role checkRole = (Role)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Role::getCode, (Object)role.getCode())).ne(Role::getId, (Object)role.getId()));
        if (checkRole != null) {
            throw new AppException("\u7f16\u7801\u91cd\u590d");
        }
        return this.roleMapper.updateById((Object)role);
    }

    public void remove(String ids) {
        if (StringUtils.isNotEmpty((CharSequence)ids)) {
            String[] array = ids.split(",");
            for (String id : Arrays.asList(array)) {
                List list = this.roleMenuMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(RoleMenu::getRoleId, (Object)Long.valueOf(id)));
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    throw new AppException("\u5220\u9664\u5931\u8d25,\u8bf7\u5148\u89e3\u9664\u83dc\u5355\u5173\u8054");
                }
                List userRoles = this.userRoleMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(UserRole::getRoleId, (Object)Long.valueOf(id)));
                if (!CollectionUtils.isNotEmpty((Collection)userRoles)) continue;
                throw new AppException("\u5220\u9664\u5931\u8d25,\u8bf7\u5148\u89e3\u9664\u7528\u6237\u5173\u8054");
            }
            if (!CollectionUtils.isEmpty(Arrays.asList(array))) {
                this.roleMapper.deleteBatchIds(Arrays.asList(array));
            }
        }
    }

    public List<MenuRoleListVO> getRoleMenuList(Long id) {
        List roleMenuList = this.roleMapper.getRoleMenuListById(id);
        return roleMenuList;
    }

    public List<MenuTreeListVO> getRoleMenuList(List<String> codes) {
        List roleMenuList = this.roleMapper.getRoleMenuList(codes);
        return roleMenuList;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateRoleMenu(RoleMenuUpdateDTO dto) {
        if (null == dto || null == dto.getRoleId()) {
            throw new AppException("\u53c2\u6570\u9519\u8bef");
        }
        this.roleMenuMapper.delete((Wrapper)new LambdaQueryWrapper().eq(RoleMenu::getRoleId, (Object)dto.getRoleId()));
        Role role = (Role)this.getById((Serializable)dto.getRoleId());
        ArrayList menus = this.menuMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(Menu::getIsCreate, (Object)1));
        if (null == menus) {
            menus = new ArrayList();
        }
        this.deleteRedisHashKey(role.getCode());
        if (CollectionUtils.isNotEmpty((Collection)dto.getMenuRoleListVO())) {
            HashMap<String, String> map = new HashMap<String, String>();
            List ids = dto.getMenuRoleListVO().stream().map(MenuRoleListVO::getId).collect(Collectors.toList());
            List menuList = this.menuMapper.selectList((Wrapper)new LambdaQueryWrapper().in(Menu::getId, ids));
            menus.addAll(menuList);
            for (Menu menu : menus) {
                RoleMenu roleMenu = new RoleMenu();
                roleMenu.setRoleId(dto.getRoleId());
                roleMenu.setMenuId(menu.getId());
                this.roleMenuMapper.insert((Object)roleMenu);
                map.put(menu.getId().toString(), menu.getPermission());
            }
            this.stringRedisTemplate.opsForHash().putAll((Object)role.getCode(), map);
            this.stringRedisTemplate.expire((Object)role.getCode(), 1L, TimeUnit.DAYS);
        }
    }

    public List<String> getCurrentRoles() {
        Long userId = SecurityUtil.getUserId();
        List userRoles = this.userRoleMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(UserRole::getUserId, (Object)userId));
        ArrayList<String> list = new ArrayList<String>();
        if (CollectionUtils.isEmpty((Collection)userRoles)) {
            return list;
        }
        List ids = userRoles.stream().map(UserRole::getRoleId).collect(Collectors.toList());
        List roles = this.list((Wrapper)new LambdaQueryWrapper().in(Role::getId, ids));
        if (CollectionUtils.isEmpty((Collection)roles)) {
            return list;
        }
        return roles.stream().map(Role::getCode).collect(Collectors.toList());
    }

    private void deleteRedisHashKey(String key) {
        HashOperations hashOperations = this.stringRedisTemplate.opsForHash();
        Set sets = hashOperations.keys((Object)key);
        if (CollectionUtils.isNotEmpty((Collection)sets)) {
            hashOperations.delete((Object)key, sets.toArray());
        }
    }
}

