/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.constant.SysParamEnum;
import com.zsy.exam.model.dto.sm2.SendDataOrigin;
import com.zsy.exam.model.dto.sm2.Sm2ResultData;
import com.zsy.exam.model.dto.sm2.Sm2SendData;
import com.zsy.exam.model.entity.School;
import com.zsy.exam.model.entity.SysParam;
import com.zsy.exam.service.ISM2Service;
import com.zsy.exam.service.ISchoolService;
import com.zsy.exam.service.ISysParamService;
import com.zsy.exam.util.SM2Utils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SM2ServiceImpl
implements ISM2Service {
    @Autowired
    private ISysParamService sysParamService;
    @Autowired
    private ISchoolService schoolService;

    public String encrypt(String json, String schoolCode) {
        School school = (School)this.schoolService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().orderByAsc(School::getId)).last(" limit 1"));
        if (null == school) {
            throw new AppException("\u83b7\u53d6\u5b66\u6821\u5931\u8d25");
        }
        String publicKey = "";
        if (StringUtils.isBlank((CharSequence)schoolCode)) {
            SysParam regionPublicKey = this.sysParamService.getByType(SysParamEnum.REGION_PUBLIC_KEY.getType());
            if (null == regionPublicKey) {
                throw new AppException("\u83b7\u53d6\u4e2d\u5fc3\u7aef\u516c\u94a5\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u521d\u59cb\u5316\u6570\u636e");
            }
            publicKey = regionPublicKey.getValue();
        } else {
            School targetSchool = (School)this.schoolService.getOne((Wrapper)new LambdaQueryWrapper().eq(School::getCode, (Object)schoolCode));
            if (null == targetSchool) {
                throw new AppException("\u83b7\u53d6\u76ee\u6807\u5b66\u6821\u5931\u8d25,\u5b66\u6821\u7801\u4e0d\u5b58\u5728");
            }
            publicKey = targetSchool.getPublicKey();
        }
        SendDataOrigin sendDataOrigin = new SendDataOrigin();
        sendDataOrigin.setSchoolCode(school.getCode());
        sendDataOrigin.setJson(json);
        Sm2SendData sm2SendData = new Sm2SendData();
        sm2SendData.setSendDataOrigin(sendDataOrigin);
        sm2SendData.setSign(SM2Utils.sign((String)JSON.toJSONString((Object)sendDataOrigin), (String)school.getPrivateKey()));
        String cipherData = SM2Utils.encrypt((String)JSON.toJSONString((Object)sm2SendData), (String)publicKey);
        return cipherData;
    }

    public Sm2ResultData decrypt(String sign) {
        School school = (School)this.schoolService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().orderByAsc(School::getId)).last(" limit 1"));
        if (null == school) {
            throw new AppException("\u83b7\u53d6\u5b66\u6821\u5931\u8d25");
        }
        String json = SM2Utils.decrypt((String)sign, (String)school.getPrivateKey());
        Sm2SendData sendData = (Sm2SendData)JSON.parseObject((String)json, Sm2SendData.class);
        String schoolCode = sendData.getSendDataOrigin().getSchoolCode();
        String publicKey = "";
        Sm2ResultData resultData = new Sm2ResultData();
        if ("001".equals(schoolCode)) {
            SysParam regionPublicKey = this.sysParamService.getByType(SysParamEnum.REGION_PUBLIC_KEY.getType());
            if (null == regionPublicKey) {
                throw new AppException("\u83b7\u53d6\u4e2d\u5fc3\u7aef\u516c\u94a5\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u521d\u59cb\u5316\u6570\u636e");
            }
            publicKey = regionPublicKey.getValue();
        } else {
            School sourceSchool = (School)this.schoolService.getOne((Wrapper)new LambdaQueryWrapper().eq(School::getCode, (Object)schoolCode));
            if (null == sourceSchool) {
                throw new AppException("\u83b7\u53d6\u6765\u6e90\u5b66\u6821\u5931\u8d25,\u5b66\u6821\u7801\u4e0d\u5b58\u5728");
            }
            publicKey = sourceSchool.getPublicKey();
            resultData.setSchool(sourceSchool);
        }
        boolean verifyResult = SM2Utils.verify((String)JSON.toJSONString((Object)sendData.getSendDataOrigin()), (String)sendData.getSign(), (String)publicKey);
        if (!verifyResult) {
            throw new AppException("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25");
        }
        resultData.setJson(sendData.getSendDataOrigin().getJson());
        return resultData;
    }
}

