/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.mapper.SchoolMapper;
import com.zsy.exam.model.entity.School;
import com.zsy.exam.service.ISchoolService;
import com.zsy.exam.util.SM2Utils;
import java.io.Serializable;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SchoolServiceImpl
extends ServiceImpl<SchoolMapper, School>
implements ISchoolService {
    @Autowired
    SchoolMapper schoolMapper;

    public School getSchool(Long id) {
        return (School)this.schoolMapper.selectById((Serializable)id);
    }

    public IPage<School> getAllSchool(Page page, Long examAreaId) {
        return this.schoolMapper.pageQuery(page, examAreaId);
    }

    public void add(School school) {
        KeyPair keyPair = SM2Utils.geneSM2KeyPair();
        PublicKey publicKey = keyPair.getPublic();
        String pubKeyHexString = SM2Utils.getPubKeyHexString((PublicKey)publicKey);
        PrivateKey privateKey = keyPair.getPrivate();
        String priKeyHexString = SM2Utils.getPriKeyHexString((PrivateKey)privateKey);
        school.setPublicKey(pubKeyHexString);
        school.setPrivateKey(priKeyHexString);
        this.schoolMapper.insert((Object)school);
    }

    public int modify(School school) {
        return this.schoolMapper.updateById((Object)school);
    }

    public void remove(String ids) {
        String[] array;
        if (StringUtils.isNotEmpty((CharSequence)ids) && !CollectionUtils.isEmpty(Arrays.asList(array = ids.split(",")))) {
            this.schoolMapper.deleteBatchIds(Arrays.asList(array));
        }
    }
}

