/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.mapper.SensitiveWordsMapper;
import com.zsy.exam.model.dto.SensitiveWordsDTO;
import com.zsy.exam.model.entity.SensitiveWords;
import com.zsy.exam.model.vo.SensitiveWordsVO;
import com.zsy.exam.service.ISensitiveWordsService;
import com.zsy.exam.util.SecurityUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SensitiveWordsServiceImpl
extends ServiceImpl<SensitiveWordsMapper, SensitiveWords>
implements ISensitiveWordsService {
    @Autowired
    SensitiveWordsMapper sensitiveWordsMapper;

    public SensitiveWords getSensitiveWords(Long id) {
        return (SensitiveWords)this.sensitiveWordsMapper.selectById((Serializable)id);
    }

    public Page<SensitiveWordsVO> getAllSensitiveWords(Page page, SensitiveWordsDTO dto) {
        return this.sensitiveWordsMapper.pageQuery(page, dto);
    }

    @Transactional(rollbackFor={Exception.class})
    public void add(SensitiveWords sensitiveWords) {
        SensitiveWords words = (SensitiveWords)this.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SensitiveWords::getName, (Object)sensitiveWords.getName())).eq(SensitiveWords::getDeleted, (Object)false));
        if (null != words) {
            throw new AppException("\u654f\u611f\u8bcd\uff1a" + words.getName() + "\u91cd\u590d");
        }
        sensitiveWords.setCreatorId(SecurityUtil.getUserId());
        this.sensitiveWordsMapper.insert((Object)sensitiveWords);
    }

    @Transactional(rollbackFor={Exception.class})
    public int modify(SensitiveWords sensitiveWords) {
        return this.sensitiveWordsMapper.updateById((Object)sensitiveWords);
    }

    @Transactional(rollbackFor={Exception.class})
    public void remove(String ids) {
        String[] array;
        if (StringUtils.isNotEmpty((CharSequence)ids) && !CollectionUtils.isEmpty(Arrays.asList(array = ids.split(",")))) {
            this.sensitiveWordsMapper.deleteBatchIds(Arrays.asList(array));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void importTxt(MultipartFile file) {
        int lastDotIndex;
        String filename = file.getOriginalFilename();
        String lastName = filename.substring((lastDotIndex = filename.lastIndexOf(46)) + 1);
        if (!lastName.equalsIgnoreCase("txt")) {
            throw new AppException("\u6587\u4ef6\u7c7b\u578b\u5fc5\u987b\u662ftxt");
        }
        StringBuffer sb = new StringBuffer();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(file.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new AppException("\u89e3\u6790\u6587\u4ef6\u5931\u8d25");
        }
        if (StringUtils.isBlank((CharSequence)sb)) {
            return;
        }
        List sensitiveWords = this.list();
        String txt = sb.toString();
        List<String> list = Arrays.asList(txt.split(";"));
        ArrayList<String> newList = new ArrayList<String>();
        for (String s : list) {
            Optional<SensitiveWords> first = sensitiveWords.stream().filter(item -> item.getName().equals(s)).findFirst();
            if (first.isPresent()) continue;
            newList.add(s);
        }
        for (String s : newList) {
            SensitiveWords words = new SensitiveWords();
            words.setName(s);
            words.setCreatorId(SecurityUtil.getUserId());
            this.save((Object)words);
        }
    }
}

