/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.handler.WeChatLoginHandler;
import com.zsy.exam.model.dto.wx.BindSocialDTO;
import com.zsy.exam.model.entity.ThirdConfig;
import com.zsy.exam.model.entity.User;
import com.zsy.exam.model.vo.wx.BindResultVO;
import com.zsy.exam.model.vo.wx.SocialLoginTypeVO;
import com.zsy.exam.service.ISocialLoginService;
import com.zsy.exam.service.IThirdConfigService;
import com.zsy.exam.util.SecurityUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SocialLoginServiceImpl
implements ISocialLoginService {
    @Autowired
    private WeChatLoginHandler weChatLoginHandler;
    @Autowired
    private IThirdConfigService thirdConfigService;

    public BindResultVO bind(BindSocialDTO bindSocialDto) {
        String[] inStrs = bindSocialDto.getState().split("_");
        String socalType = inStrs[0];
        String handType = inStrs[1];
        String identify = "";
        if (handType.equals("BIND")) {
            if (StringUtils.isBlank((CharSequence)bindSocialDto.getAuthCode())) {
                throw new AppException("\u6388\u6743\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            identify = this.weChatLoginHandler.identify(bindSocialDto.getAuthCode());
        } else {
            if (StringUtils.isBlank((CharSequence)bindSocialDto.getIdentity())) {
                throw new AppException("\u552f\u4e00\u8eab\u4efd\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            identify = bindSocialDto.getIdentity();
        }
        if (StringUtils.isBlank((CharSequence)identify)) {
            throw new AppException("\u83b7\u53d6\u8eab\u4efd\u4fe1\u606f\u5931\u8d25");
        }
        Long userId = SecurityUtil.getUserId();
        User sysUser = new User();
        sysUser.setId(userId);
        Boolean bindResult = this.weChatLoginHandler.bind(sysUser, identify);
        BindResultVO bindResultVo = new BindResultVO();
        if (!bindResult.booleanValue()) {
            bindResultVo.setBindResult(bindResult);
            bindResultVo.setResultMsg("\u7ed1\u5b9a\u5931\u8d25\uff0c\u8be5\u8d26\u53f7\u5df2\u7ed1\u5b9a");
        }
        return bindResultVo;
    }

    public Boolean unbind(BindSocialDTO bindSocialDto) {
        String[] inStrs = bindSocialDto.getState().split("_");
        String socalType = inStrs[0];
        Long userId = SecurityUtil.getUserId();
        User sysUser = new User();
        sysUser.setId(userId);
        this.weChatLoginHandler.unbind(sysUser);
        return Boolean.TRUE;
    }

    public User getUserInfo(String inStr, String userId) {
        return this.weChatLoginHandler.info(userId);
    }

    public String identify(String inStr, String authCode) {
        return this.weChatLoginHandler.identify(authCode);
    }

    public List<SocialLoginTypeVO> getSocialLoginTypeList() {
        ThirdConfig wx = (ThirdConfig)this.thirdConfigService.getOne((Wrapper)new LambdaQueryWrapper().eq(ThirdConfig::getType, (Object)"WX"));
        ArrayList<SocialLoginTypeVO> loginTypeList = new ArrayList<SocialLoginTypeVO>();
        SocialLoginTypeVO vo = new SocialLoginTypeVO();
        vo.setType(wx.getType());
        vo.setRequestUrl(wx.getUrl());
        loginTypeList.add(vo);
        for (SocialLoginTypeVO socialLoginType : loginTypeList) {
            String requestUrl = String.format("https://open.weixin.qq.com/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=code&scope=snsapi_userinfo&state=WX_LOGIN&connect_redirect=1#wechat_redirect", wx.getAppId(), wx.getUrl());
            socialLoginType.setRequestUrl(requestUrl);
        }
        return loginTypeList;
    }
}

