/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.constant.SysParamEnum;
import com.zsy.exam.mapper.ClbumMapper;
import com.zsy.exam.mapper.SpecialtyMapper;
import com.zsy.exam.mapper.SubjectSpecialtyMappingMapper;
import com.zsy.exam.model.dto.SpecialtyExcelDTO;
import com.zsy.exam.model.dto.sm2.Sm2ResultData;
import com.zsy.exam.model.entity.Clbum;
import com.zsy.exam.model.entity.Grade;
import com.zsy.exam.model.entity.Notice;
import com.zsy.exam.model.entity.School;
import com.zsy.exam.model.entity.Specialty;
import com.zsy.exam.model.entity.SubjectSpecialtyMapping;
import com.zsy.exam.model.entity.SysParam;
import com.zsy.exam.model.vo.region.GradeSpecVO;
import com.zsy.exam.service.IGradeService;
import com.zsy.exam.service.INoticeService;
import com.zsy.exam.service.ISM2Service;
import com.zsy.exam.service.ISchoolService;
import com.zsy.exam.service.ISpecialtyService;
import com.zsy.exam.service.ISysParamService;
import com.zsy.exam.util.CryptoUtils;
import com.zsy.exam.util.ZhglUtil;
import com.zsy.exam.util.excel.ExcelUtils;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SpecialtyServiceImpl
extends ServiceImpl<SpecialtyMapper, Specialty>
implements ISpecialtyService {
    @Autowired
    SpecialtyMapper specialtyMapper;
    @Autowired
    SubjectSpecialtyMappingMapper subjectSpecialtyMappingMapper;
    @Autowired
    ClbumMapper clbumMapper;
    @Autowired
    private ISysParamService sysParamService;
    @Autowired
    private ISM2Service sm2Service;
    @Autowired
    private IGradeService gradeService;
    @Autowired
    private INoticeService noticeService;
    @Autowired
    private ISchoolService schoolService;
    public static final String REGION_SYNC_URL = "/specialty/getGradeAndSpec?schoolCode=";
    public static final String YZS_SYNC_URL = "/specialty/syncGradeAndSpec";
    public static final String exportSecretKey = "T9FrGWgvjhi/ZY8mS12wBg==";

    public Specialty getSpecialty(Long id) {
        return (Specialty)this.specialtyMapper.selectById((Serializable)id);
    }

    public Page<List<Specialty>> getAllSpecialty(Page page, String name, String code, Boolean enable) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)qw.like(StringUtils.isNotBlank((CharSequence)name), Specialty::getName, (Object)name)).or()).like(StringUtils.isNotBlank((CharSequence)code), Specialty::getCode, (Object)code)).orderByDesc(Specialty::getCreateTime);
        return (Page)this.specialtyMapper.selectPage((IPage)page, (Wrapper)qw);
    }

    public void add(Specialty specialty) {
        this.specialtyMapper.insert((Object)specialty);
    }

    public int modify(Specialty specialty) {
        return this.specialtyMapper.updateById((Object)specialty);
    }

    public void remove(String ids) {
        String[] array;
        if (StringUtils.isNotEmpty((CharSequence)ids) && !org.springframework.util.CollectionUtils.isEmpty(Arrays.asList(array = ids.split(",")))) {
            for (String id : array) {
                Specialty specialty = (Specialty)this.specialtyMapper.selectById((Serializable)((Object)id));
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(SubjectSpecialtyMapping::getSpecialtyId, (Object)id);
                Long a = this.subjectSpecialtyMappingMapper.selectCount((Wrapper)queryWrapper);
                if (a > 0L) {
                    throw new RuntimeException("\u5f53\u524d[%s]\u4e13\u4e1a\u5df2\u5173\u8054\u79d1\u76ee\u65e0\u6cd5\u5220\u9664".formatted(specialty.getName()));
                }
                LambdaQueryWrapper queryWrapper2 = new LambdaQueryWrapper();
                queryWrapper2.eq(Clbum::getSpecialtyId, (Object)id);
                Long b = this.clbumMapper.selectCount((Wrapper)queryWrapper2);
                if (b <= 0L) continue;
                throw new RuntimeException("\u5f53\u524d[%s]\u4e13\u4e1a\u5df2\u5173\u8054\u73ed\u7ea7\u65e0\u6cd5\u5220\u9664".formatted(specialty.getName()));
            }
            this.specialtyMapper.deleteBatchIds(Arrays.asList(array));
        }
    }

    public void importSpecialty(MultipartFile file) {
        if (!ExcelUtils.isExcel((String)Objects.requireNonNull(file.getOriginalFilename()))) {
            throw new AppException("\u6587\u4ef6\u7c7b\u578b\u5fc5\u987b\u662fxls\u6216xlsx");
        }
        List list = ExcelUtils.readMultipartFile((MultipartFile)file, SpecialtyExcelDTO.class);
        this.checkImportSpecialty(list);
        for (SpecialtyExcelDTO specialtyExcelDTO : list) {
            Specialty specialty = new Specialty();
            specialty.setName(specialtyExcelDTO.getName());
            specialty.setCode(specialtyExcelDTO.getCode());
            this.specialtyMapper.insert((Object)specialty);
        }
    }

    public void exportSpecialty(HttpServletResponse response, String name, String code, Boolean enable) {
        List specialtyExcelDTOS = this.specialtyMapper.selectExcel(name, code, enable);
        ExcelUtils.export((HttpServletResponse)response, (String)"\u4e13\u4e1a\u4fe1\u606f\u5bfc\u51fa", (List)specialtyExcelDTOS, SpecialtyExcelDTO.class);
    }

    @Transactional(rollbackFor={Exception.class})
    public void syncGradeAndSpec() {
        School school = (School)this.schoolService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().orderByAsc(School::getId)).last(" limit 1"));
        if (null == school) {
            throw new AppException("\u83b7\u53d6\u5b66\u6821\u5931\u8d25");
        }
        SysParam regionServeIp = this.sysParamService.getByType(SysParamEnum.REGION_SERVE_IP.getType());
        if (null == regionServeIp) {
            throw new AppException("\u83b7\u53d6\u5b66\u6821\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u521d\u59cb\u5316\u6570\u636e");
        }
        SysParam yzsServerIp = this.sysParamService.getByType(SysParamEnum.YZS_SERVE_IP.getType());
        String url = regionServeIp.getValue() + REGION_SYNC_URL + school.getCode();
        JSONObject jsonObject = JSONObject.parseObject((String)ZhglUtil.httpGet((String)url));
        String msg = jsonObject.getString("msg");
        if (!Integer.valueOf(1).equals(jsonObject.getInteger("code"))) {
            this.log.error(msg);
            throw new AppException("\u540c\u6b65\u5931\u8d25,\u8bf7\u786e\u8ba4\u4e2d\u5fc3\u7aef\u662f\u5426\u542f\u52a8");
        }
        Sm2ResultData resultData = this.sm2Service.decrypt(msg);
        GradeSpecVO gradeSpecVO = (GradeSpecVO)JSONObject.parseObject((String)resultData.getJson(), GradeSpecVO.class);
        this.syncGradeAndSpec(gradeSpecVO);
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)gradeSpecVO.getNotices())) {
            for (Notice notice : gradeSpecVO.getNotices()) {
                Notice noticeSelect = (Notice)this.noticeService.getById((Serializable)notice.getId());
                if (null == noticeSelect) {
                    this.noticeService.save((Object)notice);
                    continue;
                }
                this.noticeService.updateById((Object)notice);
            }
        }
        if (!org.springframework.util.CollectionUtils.isEmpty((Collection)gradeSpecVO.getSubjectSpecialtyMappings())) {
            for (SubjectSpecialtyMapping mapping : gradeSpecVO.getSubjectSpecialtyMappings()) {
                List subjectSpecialtyMappings = this.subjectSpecialtyMappingMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SubjectSpecialtyMapping::getSubjectId, (Object)mapping.getSubjectId())).eq(SubjectSpecialtyMapping::getSpecialtyId, (Object)mapping.getSpecialtyId()));
                if (!org.springframework.util.CollectionUtils.isEmpty((Collection)subjectSpecialtyMappings)) continue;
                this.subjectSpecialtyMappingMapper.insert((Object)mapping);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)gradeSpecVO.getRegionSeeScore())) {
            SysParam sysParam = this.sysParamService.getByType(SysParamEnum.REGION_SEE_SCORE.getType());
            if (null != sysParam) {
                sysParam.setValue(gradeSpecVO.getRegionSeeScore());
                this.sysParamService.updateById((Object)sysParam);
            } else {
                sysParam = new SysParam();
                sysParam.setId(Long.valueOf(24L));
                sysParam.setType(SysParamEnum.REGION_SEE_SCORE.getType());
                sysParam.setValue(gradeSpecVO.getRegionSeeScore());
                this.sysParamService.save((Object)sysParam);
            }
        }
        if (null != yzsServerIp) {
            String json = CryptoUtils.encryptSymmetrically((String)exportSecretKey, null, (String)JSON.toJSONString((Object)gradeSpecVO), (CryptoUtils.Algorithm)CryptoUtils.Algorithm.Encryption.AES_ECB_PKCS5);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("s", json);
            ZhglUtil.httpPost((String)(yzsServerIp.getValue() + YZS_SYNC_URL), map);
        }
    }

    private void syncGradeAndSpec(GradeSpecVO gradeSpecVO) {
        if (null == gradeSpecVO) {
            return;
        }
        List gradesSync = gradeSpecVO.getGrades();
        List specialtiesSync = gradeSpecVO.getSpecialties();
        if (CollectionUtils.isNotEmpty((Collection)gradesSync)) {
            this.gradeService.deleteAll();
            for (Grade vo : gradesSync) {
                if (!StringUtils.isNotBlank((CharSequence)vo.getCode())) continue;
                this.gradeService.add(vo);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)specialtiesSync)) {
            ((SpecialtyMapper)this.baseMapper).deleteAll();
            for (Grade vo : specialtiesSync) {
                if (!StringUtils.isNotBlank((CharSequence)vo.getCode())) continue;
                this.add((Specialty)vo);
            }
        }
    }

    private void checkImportSpecialty(List<SpecialtyExcelDTO> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new AppException("\u5f53\u524d\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a,\u5bfc\u5165\u5931\u8d25");
        }
        for (int i = 0; i < list.size(); ++i) {
            SpecialtyExcelDTO dto = list.get(i);
            if (StringUtils.isBlank((CharSequence)dto.getCode())) {
                throw new AppException("\u4e13\u4e1a\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a,\u884c\u53f7\uff1a" + i + "2");
            }
            if (StringUtils.isBlank((CharSequence)dto.getName())) {
                throw new AppException("\u4e13\u4e1a\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a,\u884c\u53f7\uff1a" + i + "2");
            }
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(Specialty::getDeleted, (Object)false);
            wrapper.and(wp -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wp.eq(Specialty::getCode, (Object)dto.getCode())).or()).eq(Specialty::getName, (Object)dto.getName()));
            List specialties = this.specialtyMapper.selectList((Wrapper)wrapper);
            if (!CollectionUtils.isNotEmpty((Collection)specialties)) continue;
            throw new AppException("\u4e13\u4e1a\u7f16\u7801/\u540d\u79f0\u91cd\u590d,\u884c\u53f7\uff1a" + i + "2");
        }
    }
}

