/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.constant.RoleEnum;
import com.zsy.exam.constant.SysParamEnum;
import com.zsy.exam.mapper.ClbumHeadTeacherMapper;
import com.zsy.exam.mapper.SchoolMapper;
import com.zsy.exam.mapper.StaffMapper;
import com.zsy.exam.mapper.UserRoleMapper;
import com.zsy.exam.model.dto.StaffAddDTO;
import com.zsy.exam.model.dto.StaffExcelDTO;
import com.zsy.exam.model.dto.StaffListDTO;
import com.zsy.exam.model.dto.StaffRoleDTO;
import com.zsy.exam.model.dto.UpdateStatusDTO;
import com.zsy.exam.model.dto.UserPostDTO;
import com.zsy.exam.model.entity.ClbumHeadTeacher;
import com.zsy.exam.model.entity.ClbumMisc;
import com.zsy.exam.model.entity.Role;
import com.zsy.exam.model.entity.Staff;
import com.zsy.exam.model.entity.Subject;
import com.zsy.exam.model.entity.SysParam;
import com.zsy.exam.model.entity.User;
import com.zsy.exam.model.entity.UserRole;
import com.zsy.exam.model.vo.ClbumSimpleVO;
import com.zsy.exam.model.vo.StaffListVO;
import com.zsy.exam.model.vo.UserOperateLogStaffVO;
import com.zsy.exam.service.IClbumService;
import com.zsy.exam.service.IRoleService;
import com.zsy.exam.service.IStaffService;
import com.zsy.exam.service.ISubjectService;
import com.zsy.exam.service.ISysParamService;
import com.zsy.exam.service.IUserService;
import com.zsy.exam.util.AESEncryptUtils;
import com.zsy.exam.util.PinYinUtil;
import com.zsy.exam.util.SecurityUtil;
import com.zsy.exam.util.excel.ExcelUtils;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class StaffServiceImpl
extends ServiceImpl<StaffMapper, Staff>
implements IStaffService {
    private static final Logger log = LoggerFactory.getLogger(StaffServiceImpl.class);
    @Autowired
    StaffMapper staffMapper;
    @Autowired
    private ClbumHeadTeacherMapper clbumHeadTeacherMapper;
    @Autowired
    private IUserService userService;
    @Autowired
    private SchoolMapper schoolMapper;
    @Autowired
    private ISubjectService subjectService;
    @Autowired
    private IClbumService clbumService;
    @Autowired
    private UserRoleMapper userRoleMapper;
    @Autowired
    private IRoleService roleService;
    @Autowired
    private ISysParamService sysParamService;

    public StaffAddDTO detail(Long id) {
        StaffAddDTO detail = this.staffMapper.detail(id);
        if (null != detail) {
            detail.setMobile(AESEncryptUtils.decrypt((String)detail.getMobile()));
            detail.setIdNo(AESEncryptUtils.decrypt((String)detail.getIdNo()));
            List headTeacherClbum = this.clbumHeadTeacherMapper.getHeadTeacherClbum(id);
            detail.setClbumSimpleVOS(headTeacherClbum);
            detail.setPostIds(this.userService.getUserPosts(detail.getUserId()));
            List userRoles = this.userRoleMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(UserRole::getUserId, (Object)detail.getUserId()));
            if (CollectionUtils.isNotEmpty((Collection)userRoles)) {
                detail.setRoleIds(userRoles.stream().map(UserRole::getRoleId).collect(Collectors.toList()));
            }
        }
        return detail;
    }

    public IPage<StaffListVO> pageList(Page page, StaffListDTO dto) {
        IPage staffListVOIPage = this.staffMapper.pageQuery(page, dto);
        if (CollectionUtils.isNotEmpty((Collection)staffListVOIPage.getRecords())) {
            for (StaffListVO vo : staffListVOIPage.getRecords()) {
                vo.setMobile(AESEncryptUtils.decrypt((String)vo.getMobile()));
                vo.setIdNo(AESEncryptUtils.decrypt((String)vo.getIdNo()));
                if (StringUtils.isNotEmpty((CharSequence)vo.getSubjectId())) {
                    String names = this.getSubjectNameById(vo.getSubjectId());
                    vo.setSubjectName(names);
                }
                List headTeacherClbum = this.clbumHeadTeacherMapper.getHeadTeacherClbum(vo.getId());
                vo.setClbumSimpleVOS(headTeacherClbum);
            }
        }
        return staffListVOIPage;
    }

    @Transactional(rollbackFor={Exception.class})
    public void add(StaffAddDTO dto) {
        Role role = (Role)this.roleService.getOne((Wrapper)new LambdaQueryWrapper().eq(Role::getCode, (Object)RoleEnum.TEACHER.getCode()));
        if (null == role) {
            throw new AppException("\u65b0\u589e\u6559\u5e08\u8bf7\u786e\u8ba4\u6709\u6559\u5e08\u5bf9\u5e94\u89d2\u8272");
        }
        this.checkUser(dto.getIdNo(), dto.getMobile(), dto.getStaffNo(), null, null, dto.getUserName());
        User user = new User();
        BeanUtils.copyProperties((Object)dto, (Object)user);
        user.setUserName(dto.getUserName());
        user.setPassword(this.getPasswordDefault(dto.getIdNo()));
        user.setRoleId(role.getId());
        user.setSchoolId(SecurityUtil.getSchoolId());
        this.userService.save((Object)user);
        if (CollectionUtils.isNotEmpty((Collection)dto.getRoleIds())) {
            for (Long roleId : dto.getRoleIds()) {
                UserRole userRole = new UserRole();
                userRole.setUserId(user.getId());
                userRole.setRoleId(roleId);
                this.userRoleMapper.insert((Object)userRole);
            }
        }
        UserPostDTO userPostDTO = new UserPostDTO();
        userPostDTO.setUserId(user.getId());
        userPostDTO.setPostIds(dto.getPostIds());
        this.userService.addUserPosts(List.of(userPostDTO));
        Staff staff = new Staff();
        staff.setUserId(user.getId());
        staff.setStaffNo(dto.getStaffNo());
        staff.setSubjectId(dto.getSubjectId());
        this.staffMapper.insert((Object)staff);
        if (CollectionUtils.isNotEmpty((Collection)dto.getClbumSimpleVOS())) {
            for (ClbumSimpleVO vo : dto.getClbumSimpleVOS()) {
                ClbumHeadTeacher clbumHeadTeacher = new ClbumHeadTeacher();
                clbumHeadTeacher.setClbumId(vo.getClbumId());
                clbumHeadTeacher.setHeadTeacherId(staff.getId());
                this.clbumHeadTeacherMapper.insert((Object)clbumHeadTeacher);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(StaffAddDTO dto) {
        Staff staff = (Staff)this.getById((Serializable)dto.getId());
        if (null == staff) {
            throw new AppException("\u53c2\u6570\u9519\u8bef");
        }
        this.checkUser(dto.getIdNo(), dto.getMobile(), dto.getStaffNo(), staff.getUserId(), staff.getId(), dto.getUserName());
        User user = (User)this.userService.getById((Serializable)staff.getUserId());
        BeanUtils.copyProperties((Object)dto, (Object)user, (String[])new String[]{"id"});
        this.userService.updateById((Object)user);
        if (null == dto.getEffectiveTime()) {
            this.userService.unbind(user.getId(), "effective_time");
        }
        staff.setStaffNo(dto.getStaffNo());
        staff.setSubjectId(dto.getSubjectId());
        this.staffMapper.updateById((Object)staff);
        UserPostDTO userPostDTO = new UserPostDTO();
        userPostDTO.setUserId(user.getId());
        userPostDTO.setPostIds(dto.getPostIds());
        this.userService.addUserPosts(List.of(userPostDTO));
        this.userRoleMapper.delete((Wrapper)new LambdaQueryWrapper().eq(UserRole::getUserId, (Object)user.getId()));
        if (CollectionUtils.isNotEmpty((Collection)dto.getRoleIds())) {
            for (Long roleId : dto.getRoleIds()) {
                UserRole userRole = new UserRole();
                userRole.setUserId(user.getId());
                userRole.setRoleId(roleId);
                this.userRoleMapper.insert((Object)userRole);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getClbumSimpleVOS())) {
            this.clbumHeadTeacherMapper.delete((Wrapper)new LambdaQueryWrapper().eq(ClbumHeadTeacher::getHeadTeacherId, (Object)staff.getId()));
            for (ClbumSimpleVO vo : dto.getClbumSimpleVOS()) {
                ClbumHeadTeacher clbumHeadTeacher = new ClbumHeadTeacher();
                clbumHeadTeacher.setClbumId(vo.getClbumId());
                clbumHeadTeacher.setHeadTeacherId(staff.getId());
                this.clbumHeadTeacherMapper.insert((Object)clbumHeadTeacher);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateStatus(UpdateStatusDTO dto) {
        User user = (User)this.userService.getById((Serializable)dto.getUserId());
        if (null == user) {
            throw new AppException("\u7528\u6237\u83b7\u53d6\u5931\u8d25");
        }
        user.setStatus(dto.getStatus());
        this.userService.updateById((Object)user);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(String ids) {
        List<String> list = Arrays.asList(ids.split(","));
        for (String s : list) {
            Long id = Long.valueOf(s);
            if (null == id) {
                throw new AppException("\u53c2\u6570\u9519\u8bef");
            }
            Staff staff = (Staff)this.getById((Serializable)id);
            if (null == staff) {
                throw new AppException("\u4f20\u53c2\u9519\u8bef");
            }
            this.userService.removeById((Serializable)staff.getUserId());
            this.removeById((Serializable)id);
            this.clbumHeadTeacherMapper.delete((Wrapper)new LambdaQueryWrapper().eq(ClbumHeadTeacher::getHeadTeacherId, (Object)staff.getId()));
        }
    }

    public StaffListVO getByUserId(Long userId) {
        StaffListVO vo = this.staffMapper.getByUserId(userId);
        return vo;
    }

    public List<ClbumMisc> getMyClbum() {
        Long userId = null;
        List roles = this.roleService.getCurrentRoles();
        if (roles.contains(RoleEnum.ADMIN.getCode())) {
            return this.staffMapper.getAllClbumForAdminRole();
        }
        if (roles.contains(RoleEnum.TEACHER.getCode())) {
            userId = SecurityUtil.getUserId();
        }
        return this.staffMapper.getMyClbum(userId);
    }

    public void importStaff(MultipartFile file) {
        if (!ExcelUtils.isExcel((String)Objects.requireNonNull(file.getOriginalFilename()))) {
            throw new AppException("\u6587\u4ef6\u7c7b\u578b\u5fc5\u987b\u662fxls\u6216xlsx");
        }
        Role role = (Role)this.roleService.getOne((Wrapper)new LambdaQueryWrapper().eq(Role::getCode, (Object)RoleEnum.TEACHER.getCode()));
        if (null == role) {
            throw new AppException("\u65b0\u589e\u6559\u5e08\u8bf7\u786e\u8ba4\u6709\u6559\u5e08\u5bf9\u5e94\u89d2\u8272");
        }
        List list = ExcelUtils.readMultipartFile((MultipartFile)file, StaffExcelDTO.class);
        List staffs = this.checkImportUser(list);
        for (StaffExcelDTO dto : list) {
            Optional<Staff> first;
            List subjects;
            String subjectIdString = null;
            List<String> subjectNames = Arrays.asList(dto.getSubjectName().split(","));
            if (subjectNames.size() <= 1) {
                subjectNames = Arrays.asList(dto.getSubjectName().split("\uff0c"));
            }
            if (CollectionUtils.isNotEmpty((Collection)(subjects = this.subjectService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(Subject::getName, subjectNames)).eq(Subject::getDeleted, (Object)false))))) {
                ArrayList<String> subjectIds = new ArrayList<String>();
                for (Subject subject : subjects) {
                    subjectIds.add(subject.getId().toString());
                }
                subjectIdString = String.join((CharSequence)",", subjectIds);
            }
            if (!(first = staffs.stream().filter(staff -> dto.getStaffNo().equals(staff.getStaffNo())).findFirst()).isPresent()) {
                User user = new User();
                BeanUtils.copyProperties((Object)dto, (Object)user);
                user.setUserName(dto.getUserName());
                user.setPassword(this.getPasswordDefault(dto.getIdNo()));
                user.setRoleId(RoleEnum.TEACHER.getId());
                user.setSchoolId(SecurityUtil.getSchoolId());
                this.userService.save((Object)user);
                UserRole userRole = new UserRole();
                userRole.setUserId(user.getId());
                userRole.setRoleId(role.getId());
                this.userRoleMapper.insert((Object)userRole);
                Staff staff2 = new Staff();
                staff2.setUserId(user.getId());
                staff2.setStaffNo(dto.getStaffNo());
                staff2.setSubjectId(subjectIdString);
                this.staffMapper.insert((Object)staff2);
                continue;
            }
            Staff staffOld = first.get();
            staffOld.setSubjectId(subjectIdString);
            this.staffMapper.updateById((Object)staffOld);
        }
    }

    public void exportStaff(HttpServletResponse response, StaffListDTO dto) {
        List staffExcelDTOS = this.staffMapper.selectExcel(dto);
        if (CollectionUtils.isNotEmpty((Collection)staffExcelDTOS)) {
            for (StaffExcelDTO staffExcelDTO : staffExcelDTOS) {
                staffExcelDTO.setMobile(AESEncryptUtils.decrypt((String)staffExcelDTO.getMobile()));
                staffExcelDTO.setIdNo(AESEncryptUtils.decrypt((String)staffExcelDTO.getIdNo()));
                if (!StringUtils.isNotEmpty((CharSequence)staffExcelDTO.getSubjectName())) continue;
                String names = this.getSubjectNameById(staffExcelDTO.getSubjectName());
                staffExcelDTO.setSubjectName(names);
            }
        }
        ExcelUtils.export((HttpServletResponse)response, (String)"\u6559\u5e08\u4fe1\u606f\u5bfc\u51fa", (List)staffExcelDTOS, StaffExcelDTO.class);
    }

    public void exportStaffTemp(HttpServletResponse response) {
        ExcelUtils.export((HttpServletResponse)response, (String)"\u6559\u5e08\u4fe1\u606f\u5bfc\u51fa", null, StaffExcelDTO.class);
    }

    public void syncStaff(List<UserOperateLogStaffVO> vos) {
        if (CollectionUtils.isEmpty(vos)) {
            log.info("\u540c\u6b65\u6559\u804c\u5de5\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        List staffs = this.staffMapper.selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{Staff::getStaffNo, Staff::getUserId}));
        for (UserOperateLogStaffVO vo : vos) {
            Staff staff;
            Optional<Staff> first = staffs.stream().filter(item -> item.getStaffNo().equals(vo.getStaffNo())).findFirst();
            if (first.isPresent()) {
                staff = first.get();
                if (Integer.valueOf(3).equals(vo.getType())) {
                    this.delete(staff.getId().toString());
                    continue;
                }
                if (!Integer.valueOf(2).equals(vo.getType())) {
                    log.warn("\u540c\u6b65\u6559\u804c\u5de5\u5f02\u5e38\u6570\u636e,{}", (Object)vo);
                }
                this.updateSyncStaff(staff.getUserId(), vo);
                continue;
            }
            if (!Integer.valueOf(1).equals(vo.getType())) {
                log.warn("\u540c\u6b65\u6559\u804c\u5de5\u5f02\u5e38\u6570\u636e,{}", (Object)vo);
            }
            staff = this.addSyncStaff(vo);
            staffs.add(staff);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void bindUserRole(StaffRoleDTO dto) {
        this.userRoleMapper.delete((Wrapper)new LambdaQueryWrapper().eq(UserRole::getRoleId, (Object)dto.getRoleId()));
        if (CollectionUtils.isEmpty((Collection)dto.getUserIds())) {
            return;
        }
        for (Long userId : dto.getUserIds()) {
            UserRole userRole = new UserRole();
            userRole.setRoleId(dto.getRoleId());
            userRole.setUserId(userId);
            this.userRoleMapper.insert((Object)userRole);
        }
    }

    public void physicalDeleteBySyncSource(Integer syncSource) {
        ((StaffMapper)this.baseMapper).physicalDeleteBySyncSource(syncSource);
    }

    private List<Staff> checkImportUser(List<StaffExcelDTO> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new AppException("\u5f53\u524d\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a,\u5bfc\u5165\u5931\u8d25");
        }
        ArrayList<Staff> staffs = new ArrayList<Staff>();
        List users = this.userService.list();
        ArrayList<String> userNames = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)users)) {
            userNames.addAll(users.stream().map(User::getUserName).collect(Collectors.toList()));
        }
        for (int i = 0; i < list.size(); ++i) {
            StaffExcelDTO dto = list.get(i);
            if (StringUtils.isBlank((CharSequence)dto.getUserName())) {
                throw new AppException("\u7528\u6237\u540d\u4e0d\u5141\u8bb8\u4e3a\u7a7a,\u884c\u53f7\uff1a" + i + "2");
            }
            if (StringUtils.isBlank((CharSequence)dto.getRealName())) {
                throw new AppException("\u59d3\u540d\u4e0d\u5141\u8bb8\u4e3a\u7a7a,\u884c\u53f7\uff1a" + i + "2");
            }
            if (StringUtils.isBlank((CharSequence)dto.getIdNo())) {
                throw new AppException("\u8bc1\u4ef6\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a,\u884c\u53f7\uff1a" + i + "2");
            }
            if (StringUtils.isBlank((CharSequence)dto.getStaffNo())) {
                throw new AppException("\u5de5\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a,\u884c\u53f7\uff1a" + i + "2");
            }
            if (StringUtils.isBlank((CharSequence)dto.getUserName())) {
                throw new AppException("\u6559\u5e08\u7528\u6237\u540d\u4e0d\u5141\u8bb8\u4e3a\u7a7a,\u884c\u53f7\uff1a" + i + "2");
            }
            Staff staffOnly = this.staffMapper.existsAllUnique(AESEncryptUtils.encrypt((String)dto.getMobile()), AESEncryptUtils.encrypt((String)dto.getIdNo()), dto.getStaffNo(), dto.getUserName());
            if (null != staffOnly) {
                staffs.add(staffOnly);
            } else {
                Staff staffOne = this.staffMapper.existsOneUnique(AESEncryptUtils.encrypt((String)dto.getMobile()), AESEncryptUtils.encrypt((String)dto.getIdNo()), dto.getStaffNo(), dto.getUserName());
                if (staffOne != null) {
                    throw new AppException("\u6559\u5e08\u624b\u673a\u53f7/\u8eab\u4efd\u8bc1\u53f7/\u5de5\u53f7/\u7528\u6237\u540d\u91cd\u590d,\u884c\u53f7\uff1a" + i + "2");
                }
            }
            userNames.add(dto.getUserName());
        }
        return staffs;
    }

    private void checkUser(String idNo, String mobile, String staffNo, Long id, Long staffId, String userName) {
        List staffList;
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(User::getIsDeleted, (Object)false);
        if (null != id) {
            wrapper.ne(User::getId, (Object)id);
        }
        wrapper.and(wp -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wp.eq(User::getIdNo, (Object)AESEncryptUtils.encrypt((String)idNo))).or()).eq(User::getMobile, (Object)AESEncryptUtils.encrypt((String)mobile)));
        List users = this.userService.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)users)) {
            if (id == null) {
                throw new AppException("\u5f53\u524d\u8eab\u4efd\u8bc1/\u624b\u673a\u53f7\u91cd\u590d,\u4e0d\u652f\u6301\u65b0\u589e");
            }
            throw new AppException("\u5f53\u524d\u8eab\u4efd\u8bc1/\u624b\u673a\u53f7\u91cd\u590d,\u4e0d\u652f\u6301\u4fee\u6539");
        }
        LambdaQueryWrapper staffWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(Staff::getStaffNo, (Object)staffNo);
        if (null != id) {
            staffWrapper.ne(Staff::getId, (Object)staffId);
        }
        if (CollectionUtils.isNotEmpty((Collection)(staffList = this.list((Wrapper)staffWrapper)))) {
            if (id == null) {
                throw new AppException("\u5f53\u524d\u804c\u5de5\u53f7\u91cd\u590d,\u4e0d\u652f\u6301\u65b0\u589e");
            }
            throw new AppException("\u5f53\u524d\u804c\u5de5\u53f7\u91cd\u590d,\u4e0d\u652f\u6301\u4fee\u6539");
        }
        LambdaQueryWrapper userNameWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(User::getIsDeleted, (Object)false);
        if (null != id) {
            userNameWrapper.ne(User::getId, (Object)id);
        }
        userNameWrapper.and(wp -> wp.eq(User::getUserName, (Object)userName));
        List userNames = this.userService.list((Wrapper)userNameWrapper);
        if (CollectionUtils.isNotEmpty((Collection)userNames)) {
            if (id == null) {
                throw new AppException("\u5f53\u524d\u7528\u6237\u540d\u91cd\u590d,\u4e0d\u652f\u6301\u65b0\u589e");
            }
            throw new AppException("\u5f53\u524d\u7528\u6237\u540d\u91cd\u590d,\u4e0d\u652f\u6301\u4fee\u6539");
        }
    }

    private String getSubjectNameById(String subjectId) {
        List subjects = this.subjectService.list();
        List<String> ids = Arrays.asList(subjectId.split(","));
        List names = subjects.stream().filter(subject -> ids.contains(subject.getId().toString())).map(Subject::getName).collect(Collectors.toList());
        return String.join((CharSequence)",", names);
    }

    private Staff addSyncStaff(UserOperateLogStaffVO vo) {
        User user = new User();
        user.setRealName(vo.getRealName());
        user.setSex(vo.getSex());
        user.setIdNo(vo.getIdNo());
        user.setMobile(vo.getMobile());
        String pinyin = PinYinUtil.chinese2PinYinFirst((String)vo.getRealName());
        user.setUserName(PinYinUtil.chinese2PinYinFirst((String)vo.getRealName()) + vo.getMobile());
        user.setPassword(this.getPasswordDefault(vo.getIdNo()));
        user.setRoleId(RoleEnum.TEACHER.getId());
        user.setSchoolId(SecurityUtil.getSchoolId());
        this.userService.save((Object)user);
        Staff staff = new Staff();
        staff.setUserId(user.getId());
        staff.setStaffNo(vo.getStaffNo());
        this.staffMapper.insert((Object)staff);
        return staff;
    }

    private void updateSyncStaff(Long userId, UserOperateLogStaffVO vo) {
        User user = (User)this.userService.getById((Serializable)userId);
        user.setRealName(vo.getRealName());
        user.setSex(vo.getSex());
        user.setIdNo(vo.getIdNo());
        user.setMobile(vo.getMobile());
        this.userService.updateById((Object)user);
    }

    private String getPasswordDefault(String idNo) {
        SysParam passwordGenerateType = this.sysParamService.getByType(SysParamEnum.PASSWORD_GENERATE_TYPE.getType());
        SysParam passwordTeacher = this.sysParamService.getByType(SysParamEnum.PASSWORD_TEACHER.getType());
        if (null == passwordGenerateType || null == passwordTeacher || "1".equals(passwordGenerateType.getValue())) {
            return new BCryptPasswordEncoder().encode((CharSequence)idNo.substring(idNo.length() - 6));
        }
        return new BCryptPasswordEncoder().encode((CharSequence)passwordTeacher.getValue());
    }
}

