/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.constant.RoleEnum;
import com.zsy.exam.mapper.ClbumMapper;
import com.zsy.exam.mapper.ExamClbumMapper;
import com.zsy.exam.mapper.ExamMapper;
import com.zsy.exam.mapper.QuestionMapper;
import com.zsy.exam.mapper.StatMapper;
import com.zsy.exam.mapper.UserDailyLoginDurationMapper;
import com.zsy.exam.model.entity.Clbum;
import com.zsy.exam.model.entity.Exam;
import com.zsy.exam.model.entity.ExamClbum;
import com.zsy.exam.model.entity.Question;
import com.zsy.exam.model.vo.stat.AllStatsVO;
import com.zsy.exam.model.vo.stat.ClbumExamVO;
import com.zsy.exam.model.vo.stat.ClbumStudentVO;
import com.zsy.exam.model.vo.stat.DailyVO;
import com.zsy.exam.service.IRoleService;
import com.zsy.exam.service.IStatService;
import com.zsy.exam.util.SecurityUtil;
import jakarta.annotation.Resource;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class StatServiceImpl
extends ServiceImpl<ExamClbumMapper, ExamClbum>
implements IStatService {
    @Resource
    private StatMapper statMapper;
    @Resource
    private ClbumMapper clbumMapper;
    @Resource
    private ExamMapper examMapper;
    @Resource
    private QuestionMapper questionMapper;
    @Resource
    private UserDailyLoginDurationMapper userDailyLoginDurationMapper;
    @Resource
    private IRoleService roleService;

    public Result<List<ClbumStudentVO>> getStudentClbumCount() {
        List roles = this.roleService.getCurrentRoles();
        List clbumStudentVOs = roles.contains(RoleEnum.TEACHER.getCode()) ? this.statMapper.StudentClbumCount(Long.valueOf(2L), SecurityUtil.getUserId()) : this.statMapper.StudentClbumCount(Long.valueOf(3L), SecurityUtil.getUserId());
        return Result.success((String)"\u67e5\u8be2\u6210\u529f", (Object)clbumStudentVOs);
    }

    public Result<List<ClbumExamVO>> getExamClbumCount() {
        List roles = this.roleService.getCurrentRoles();
        List clbumExamVOs = roles.contains(RoleEnum.TEACHER.getCode()) ? this.statMapper.ExamClbumCount(Long.valueOf(2L), SecurityUtil.getUserId()) : this.statMapper.ExamClbumCount(Long.valueOf(3L), SecurityUtil.getUserId());
        return Result.success((String)"\u67e5\u8be2\u6210\u529f", (Object)clbumExamVOs);
    }

    public Result<AllStatsVO> getAllCount() {
        AllStatsVO allStatsVO = new AllStatsVO();
        List roles = this.roleService.getCurrentRoles();
        if (roles.contains(RoleEnum.ADMIN.getCode()) || roles.contains(RoleEnum.SUPER_ADMIN.getCode())) {
            allStatsVO.setClassCount(Integer.valueOf(this.clbumMapper.selectCount(null).intValue()));
            allStatsVO.setExamCount(Integer.valueOf(this.examMapper.selectCount(null).intValue()));
            allStatsVO.setQuestionCount(Integer.valueOf(this.questionMapper.selectCount(null).intValue()));
        } else if (roles.contains(RoleEnum.TEACHER.getCode())) {
            allStatsVO.setClassCount(Integer.valueOf(this.clbumMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(Clbum::getUserId, (Object)SecurityUtil.getUserId())).intValue()));
            allStatsVO.setExamCount(Integer.valueOf(this.examMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(Exam::getUserId, (Object)SecurityUtil.getUserId())).intValue()));
            allStatsVO.setQuestionCount(Integer.valueOf(this.questionMapper.selectCount((Wrapper)new LambdaQueryWrapper().eq(Question::getUserId, (Object)SecurityUtil.getUserId())).intValue()));
        }
        return Result.success((String)"\u67e5\u8be2\u6210\u529f", (Object)allStatsVO);
    }

    public Result<List<DailyVO>> getDaily() {
        List daily = this.userDailyLoginDurationMapper.getDaily(SecurityUtil.getUserId());
        return Result.success((String)"\u8bf7\u6c42\u6210\u529f", (Object)daily);
    }
}

