/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.constant.RoleEnum;
import com.zsy.exam.constant.SysParamEnum;
import com.zsy.exam.mapper.ExamMapper;
import com.zsy.exam.mapper.ExerciseMapper;
import com.zsy.exam.mapper.StudentMapper;
import com.zsy.exam.mapper.UserExamsScoreMapper;
import com.zsy.exam.mapper.UserRoleMapper;
import com.zsy.exam.mapper.WrongQuestionBookMapper;
import com.zsy.exam.model.dto.StudentAddDTO;
import com.zsy.exam.model.dto.StudentConditionDTO;
import com.zsy.exam.model.dto.StudentExcelDTO;
import com.zsy.exam.model.dto.StudentParentDTO;
import com.zsy.exam.model.dto.StudentSimpleDTO;
import com.zsy.exam.model.dto.UpdateStatusDTO;
import com.zsy.exam.model.entity.Catalogue;
import com.zsy.exam.model.entity.Clbum;
import com.zsy.exam.model.entity.Grade;
import com.zsy.exam.model.entity.Role;
import com.zsy.exam.model.entity.Specialty;
import com.zsy.exam.model.entity.Student;
import com.zsy.exam.model.entity.StudentParent;
import com.zsy.exam.model.entity.SysParam;
import com.zsy.exam.model.entity.User;
import com.zsy.exam.model.entity.UserRole;
import com.zsy.exam.model.entity.WrongQuestionBook;
import com.zsy.exam.model.form.ClbumForm;
import com.zsy.exam.model.vo.ExamAllStudentScoreListlVO;
import com.zsy.exam.model.vo.ExamStudentScoreAllVO;
import com.zsy.exam.model.vo.ExamStudentScoreDetailVO;
import com.zsy.exam.model.vo.ExamStudentScoreEveryMouthVO;
import com.zsy.exam.model.vo.ExamStudentScoreListlVO;
import com.zsy.exam.model.vo.ExamStudentScoreSelectVO;
import com.zsy.exam.model.vo.ExamStudentScoreVO;
import com.zsy.exam.model.vo.StudentPlusVO;
import com.zsy.exam.model.vo.UserOperateLogStudentVO;
import com.zsy.exam.service.ICatalogueService;
import com.zsy.exam.service.IClbumService;
import com.zsy.exam.service.IGradeService;
import com.zsy.exam.service.IRoleService;
import com.zsy.exam.service.ISpecialtyService;
import com.zsy.exam.service.IStudentParentService;
import com.zsy.exam.service.IStudentService;
import com.zsy.exam.service.ISysParamService;
import com.zsy.exam.service.IUserService;
import com.zsy.exam.util.AESEncryptUtils;
import com.zsy.exam.util.DateTimeUtil;
import com.zsy.exam.util.PinYinUtil;
import com.zsy.exam.util.SecurityUtil;
import com.zsy.exam.util.excel.ExcelUtils;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class StudentServiceImpl
extends ServiceImpl<StudentMapper, Student>
implements IStudentService {
    private static final Logger log = LoggerFactory.getLogger(StudentServiceImpl.class);
    @Autowired
    StudentMapper studentMapper;
    @Autowired
    private IUserService userService;
    @Autowired
    private IStudentParentService studentParentService;
    @Autowired
    private IGradeService gradeService;
    @Autowired
    private ISpecialtyService specialtyService;
    @Autowired
    private IClbumService clbumService;
    @Autowired
    private IRoleService roleService;
    @Autowired
    private ICatalogueService catalogueService;
    @Autowired
    private ExerciseMapper exerciseMapper;
    @Autowired
    private ExamMapper examMapper;
    @Autowired
    private WrongQuestionBookMapper wrongQuestionBookMapper;
    @Autowired
    private UserExamsScoreMapper userExamsScoreMapper;
    @Autowired
    private UserRoleMapper userRoleMapper;
    @Autowired
    private ISysParamService sysParamService;

    public IPage<StudentSimpleDTO> selectPage(StudentConditionDTO condition, Page<StudentSimpleDTO> page) {
        IPage iPage = this.studentMapper.selectPage(page, condition);
        if (CollectionUtils.isNotEmpty((Collection)iPage.getRecords())) {
            for (StudentSimpleDTO vo : iPage.getRecords()) {
                vo.setMobile(AESEncryptUtils.decrypt((String)vo.getMobile()));
                vo.setIdNo(AESEncryptUtils.decrypt((String)vo.getIdNo()));
            }
        }
        return iPage;
    }

    public StudentAddDTO detail(Long id) {
        StudentAddDTO dto = new StudentAddDTO();
        Student student = (Student)this.getById((Serializable)id);
        if (null == student) {
            return dto;
        }
        User user = (User)this.userService.getById((Serializable)student.getUserId());
        BeanUtils.copyProperties((Object)user, (Object)dto);
        BeanUtils.copyProperties((Object)student, (Object)dto);
        List studentParents = this.studentParentService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(StudentParent::getStudentId, (Object)id)).eq(StudentParent::getIsDeleted, (Object)false));
        if (CollectionUtils.isEmpty((Collection)studentParents)) {
            return dto;
        }
        ArrayList<StudentParentDTO> list = new ArrayList<StudentParentDTO>();
        for (StudentParent studentParent : studentParents) {
            User parentUser = (User)this.userService.getById((Serializable)studentParent.getUserId());
            StudentParentDTO studentParentDTO = this.parentEntity2VO(studentParent, parentUser);
            list.add(studentParentDTO);
        }
        dto.setStudentParents(list);
        return dto;
    }

    @Transactional(rollbackFor={Exception.class})
    public void add(StudentAddDTO dto) {
        Role role = (Role)this.roleService.getOne((Wrapper)new LambdaQueryWrapper().eq(Role::getCode, (Object)RoleEnum.STUDENT.getCode()));
        if (null == role) {
            throw new AppException("\u65b0\u589e\u5b66\u751f\u8bf7\u786e\u8ba4\u6709\u5b66\u751f\u5bf9\u5e94\u89d2\u8272");
        }
        this.checkUser(dto.getIdNo(), dto.getMobile(), null, dto.getUserName());
        User user = new User();
        BeanUtils.copyProperties((Object)dto, (Object)user);
        user.setUserName(dto.getUserName());
        user.setPassword(this.getPasswordDefault(dto.getIdNo()));
        user.setRoleId(role.getId());
        user.setClbumId(dto.getAdministrativeClbumId());
        user.setSchoolId(SecurityUtil.getSchoolId());
        this.userService.save((Object)user);
        Student student = new Student();
        BeanUtils.copyProperties((Object)dto, (Object)student);
        student.setUserId(user.getId());
        this.save((Object)student);
        UserRole userRole = new UserRole();
        userRole.setUserId(user.getId());
        userRole.setRoleId(role.getId());
        this.userRoleMapper.insert((Object)userRole);
        if (CollectionUtils.isNotEmpty((Collection)dto.getStudentParents())) {
            this.changeStudentParent(dto.getStudentParents(), student.getId());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void update(StudentAddDTO dto) {
        if (dto == null || dto.getId() == null) {
            throw new AppException("\u53c2\u6570\u9519\u8bef");
        }
        Student student = (Student)this.getById((Serializable)dto.getId());
        this.checkUser(dto.getIdNo(), dto.getMobile(), student.getUserId(), dto.getUserName());
        User user = (User)this.userService.getById((Serializable)student.getUserId());
        BeanUtils.copyProperties((Object)dto, (Object)user, (String[])new String[]{"id"});
        this.userService.updateById((Object)user);
        if (null == dto.getEffectiveTime()) {
            this.userService.unbind(user.getId(), "effective_time");
        }
        BeanUtils.copyProperties((Object)dto, (Object)student);
        this.updateById((Object)student);
        List studentParents = this.studentParentService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(StudentParent::getStudentId, (Object)student.getId())).eq(StudentParent::getIsDeleted, (Object)false));
        if (CollectionUtils.isNotEmpty((Collection)studentParents)) {
            studentParents.stream().forEach(item -> this.studentParentService.remove(item.getId().toString()));
        }
        if (CollectionUtils.isNotEmpty((Collection)dto.getStudentParents())) {
            this.changeStudentParent(dto.getStudentParents(), student.getId());
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(String ids) {
        List<String> list = Arrays.asList(ids.split(","));
        for (String s : list) {
            Long id = Long.valueOf(s);
            Student student = (Student)this.getById((Serializable)id);
            this.userService.removeById((Serializable)student.getUserId());
            this.removeById((Serializable)id);
            List studentParents = this.studentParentService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(StudentParent::getStudentId, (Object)id)).eq(StudentParent::getIsDeleted, (Object)false));
            if (!CollectionUtils.isNotEmpty((Collection)studentParents)) continue;
            for (StudentParent studentParent : studentParents) {
                this.userService.removeById((Serializable)studentParent.getUserId());
                this.studentParentService.removeById((Serializable)studentParent.getId());
            }
        }
    }

    public void exportStudent(HttpServletResponse response, StudentConditionDTO condition) {
        List studentExcelDTOS = this.studentMapper.selectExcel(condition);
        if (CollectionUtils.isNotEmpty((Collection)studentExcelDTOS)) {
            for (StudentExcelDTO studentExcelDTO : studentExcelDTOS) {
                studentExcelDTO.setMobile(AESEncryptUtils.decrypt((String)studentExcelDTO.getMobile()));
                studentExcelDTO.setIdNo(AESEncryptUtils.decrypt((String)studentExcelDTO.getIdNo()));
                studentExcelDTO.setParentIdNo(AESEncryptUtils.decrypt((String)studentExcelDTO.getParentIdNo()));
                studentExcelDTO.setParentPhone(AESEncryptUtils.decrypt((String)studentExcelDTO.getParentPhone()));
            }
        }
        ExcelUtils.export((HttpServletResponse)response, (String)"\u5b66\u751f\u4fe1\u606f\u5bfc\u51fa", (List)studentExcelDTOS, StudentExcelDTO.class);
    }

    public void exportStudentTemp(HttpServletResponse response) {
        ExcelUtils.export((HttpServletResponse)response, (String)"\u5b66\u751f\u4fe1\u606f\u5bfc\u51fa", null, StudentExcelDTO.class);
    }

    @Transactional(rollbackFor={Exception.class})
    public void importStudent(MultipartFile file) {
        if (!ExcelUtils.isExcel((String)Objects.requireNonNull(file.getOriginalFilename()))) {
            throw new AppException("\u6587\u4ef6\u7c7b\u578b\u5fc5\u987b\u662fxls\u6216xlsx");
        }
        Role role = (Role)this.roleService.getOne((Wrapper)new LambdaQueryWrapper().eq(Role::getCode, (Object)RoleEnum.STUDENT.getCode()));
        if (null == role) {
            throw new AppException("\u65b0\u589e\u5b66\u751f\u8bf7\u786e\u8ba4\u6709\u5b66\u751f\u5bf9\u5e94\u89d2\u8272");
        }
        List list = ExcelUtils.readMultipartFile((MultipartFile)file, StudentExcelDTO.class);
        List grades = this.gradeService.list();
        List specialties = this.specialtyService.list();
        List clbums = this.clbumService.list();
        this.checkImportUser(list, grades.stream().map(Grade::getName).collect(Collectors.toList()), specialties.stream().map(Specialty::getName).collect(Collectors.toList()), clbums.stream().map(Clbum::getClbumName).collect(Collectors.toList()));
        for (StudentExcelDTO dto : list) {
            Optional<Grade> first;
            User user = new User();
            BeanUtils.copyProperties((Object)dto, (Object)user);
            user.setUserName(dto.getUserName());
            user.setPassword(this.getPasswordDefault(dto.getIdNo()));
            user.setRoleId(role.getId());
            user.setSchoolId(SecurityUtil.getSchoolId());
            this.userService.save((Object)user);
            UserRole userRole = new UserRole();
            userRole.setUserId(user.getId());
            userRole.setRoleId(role.getId());
            this.userRoleMapper.insert((Object)userRole);
            Student student = new Student();
            BeanUtils.copyProperties((Object)dto, (Object)student);
            student.setUserId(user.getId());
            if (StringUtils.isNotBlank((CharSequence)dto.getGradeName()) && (first = grades.stream().filter(item -> item.getName().equals(dto.getGradeName())).findFirst()).isPresent()) {
                Grade grade = first.get();
                student.setAdministrativeGradeId(grade.getId());
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getMajorName()) && (first = specialties.stream().filter(item -> item.getName().equals(dto.getMajorName())).findFirst()).isPresent()) {
                Specialty specialty = (Specialty)first.get();
                student.setAdministrativeSpecialtyId(specialty.getId());
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getClbumName()) && (first = clbums.stream().filter(item -> item.getClbumName().equals(dto.getClbumName())).findFirst()).isPresent()) {
                Clbum clbum = (Clbum)first.get();
                student.setAdministrativeClbumId(clbum.getId());
            }
            this.save((Object)student);
            if (!StringUtils.isNotBlank((CharSequence)dto.getParentName()) || !StringUtils.isNotBlank((CharSequence)dto.getParentPhone()) || !StringUtils.isNotBlank((CharSequence)dto.getParentIdNo())) continue;
            StudentParentDTO studentParentDTO = new StudentParentDTO();
            studentParentDTO.setParentSex(dto.getParentSex());
            studentParentDTO.setParentUserName(dto.getParentUserName());
            studentParentDTO.setParentName(dto.getParentName());
            studentParentDTO.setParentPhone(dto.getParentPhone());
            studentParentDTO.setParentIdNo(dto.getParentIdNo());
            studentParentDTO.setParentRelation(dto.getParentRelation());
            this.changeStudentParent(Arrays.asList(studentParentDTO), student.getId());
        }
    }

    private void changeStudentParent(List<StudentParentDTO> dtos, Long studentId) {
        for (StudentParentDTO dto : dtos) {
            StudentParent studentParent;
            User parent;
            StudentParent studentParentOld = (StudentParent)this.studentParentService.getById((Serializable)dto.getStudentParentId());
            UserRole userRole = null;
            if (null == studentParentOld) {
                this.checkUser(dto.getParentIdNo(), dto.getParentPhone(), null, dto.getParentUserName());
                parent = new User();
                parent.setPassword(this.getPasswordDefault(dto.getParentIdNo()));
                studentParent = new StudentParent();
                userRole = new UserRole();
            } else {
                this.checkUser(dto.getParentIdNo(), dto.getParentPhone(), studentParentOld.getUserId(), dto.getParentUserName());
                parent = (User)this.userService.getById((Serializable)studentParentOld.getUserId());
                studentParent = studentParentOld;
            }
            Role role = (Role)this.roleService.getOne((Wrapper)new LambdaQueryWrapper().eq(Role::getCode, (Object)RoleEnum.PARENT.getCode()));
            parent.setRoleId(role.getId());
            parent.setRealName(dto.getParentName());
            parent.setUserName(dto.getParentUserName());
            parent.setMobile(dto.getParentPhone());
            parent.setSex(dto.getParentSex());
            parent.setIdNo(dto.getParentIdNo());
            parent.setSchoolId(SecurityUtil.getSchoolId());
            this.userService.saveOrUpdate((Object)parent);
            if (null != userRole) {
                userRole.setRoleId(role.getId());
                userRole.setUserId(parent.getId());
                this.userRoleMapper.insert((Object)userRole);
            }
            studentParent.setStudentId(studentId);
            studentParent.setUserId(parent.getId());
            studentParent.setName(dto.getParentName());
            studentParent.setRelation(dto.getParentRelation());
            this.studentParentService.saveOrUpdate((Object)studentParent);
        }
    }

    private StudentParentDTO parentEntity2VO(StudentParent studentParent, User user) {
        StudentParentDTO dto = new StudentParentDTO();
        dto.setParentUserName(user.getUserName());
        dto.setStudentParentId(studentParent.getId());
        dto.setParentPhone(user.getMobile());
        dto.setParentIdNo(user.getIdNo());
        dto.setParentName(user.getRealName());
        dto.setParentSex(user.getSex());
        dto.setParentRelation(studentParent.getRelation());
        return dto;
    }

    private void checkImportUser(List<StudentExcelDTO> list, List<String> gradeNames, List<String> specNames, List<String> clbumNames) {
        if (CollectionUtils.isEmpty(list)) {
            throw new AppException("\u5f53\u524d\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a,\u5bfc\u5165\u5931\u8d25");
        }
        List users = this.userService.list((Wrapper)new LambdaQueryWrapper());
        ArrayList<String> userNames = new ArrayList<String>();
        ArrayList<String> idNos = new ArrayList<String>();
        ArrayList<String> mobiles = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)users)) {
            userNames.addAll(users.stream().map(User::getUserName).collect(Collectors.toList()));
            idNos.addAll(users.stream().map(User::getIdNo).collect(Collectors.toList()));
            mobiles.addAll(users.stream().map(User::getMobile).collect(Collectors.toList()));
        }
        for (int i = 0; i < list.size(); ++i) {
            StudentExcelDTO dto = list.get(i);
            if (StringUtils.isBlank((CharSequence)dto.getUserName())) {
                throw new AppException("\u7528\u6237\u540d\u4e0d\u5141\u8bb8\u4e3a\u7a7a,\u884c\u53f7\uff1a" + i + "2");
            }
            if (StringUtils.isBlank((CharSequence)dto.getRealName())) {
                throw new AppException("\u59d3\u540d\u4e0d\u5141\u8bb8\u4e3a\u7a7a,\u884c\u53f7\uff1a" + i + "2");
            }
            if (StringUtils.isBlank((CharSequence)dto.getIdNo())) {
                throw new AppException("\u8bc1\u4ef6\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a,\u884c\u53f7\uff1a" + i + "2");
            }
            if (StringUtils.isBlank((CharSequence)dto.getMobile())) {
                throw new AppException("\u624b\u673a\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a,\u884c\u53f7\uff1a" + i + "2");
            }
            if (StringUtils.isBlank((CharSequence)dto.getGradeName())) {
                throw new AppException("\u5e74\u7ea7\u4e0d\u5141\u8bb8\u4e3a\u7a7a,\u884c\u53f7\uff1a" + i + "2");
            }
            if (CollectionUtils.isNotEmpty(gradeNames) && !gradeNames.contains(dto.getGradeName())) {
                throw new AppException("\u5e74\u7ea7\u540d\u79f0\u4e0d\u5b58\u5728,\u884c\u53f7\uff1a" + i + "2");
            }
            if (StringUtils.isBlank((CharSequence)dto.getMajorName())) {
                throw new AppException("\u4e13\u4e1a\u4e0d\u5141\u8bb8\u4e3a\u7a7a,\u884c\u53f7\uff1a" + i + "2");
            }
            if (CollectionUtils.isNotEmpty(specNames) && !specNames.contains(dto.getMajorName())) {
                throw new AppException("\u4e13\u4e1a\u540d\u79f0\u4e0d\u5b58\u5728,\u884c\u53f7\uff1a" + i + "2");
            }
            if (StringUtils.isBlank((CharSequence)dto.getClbumName())) {
                throw new AppException("\u73ed\u7ea7\u4e0d\u5141\u8bb8\u4e3a\u7a7a,\u884c\u53f7\uff1a" + i + "2");
            }
            if (CollectionUtils.isNotEmpty(clbumNames) && !clbumNames.contains(dto.getClbumName())) {
                throw new AppException("\u73ed\u7ea7\u540d\u79f0\u4e0d\u5b58\u5728,\u884c\u53f7\uff1a" + i + "2");
            }
            if (userNames.contains(dto.getUserName())) {
                throw new AppException("\u5b66\u751f\u7528\u6237\u540d\u91cd\u590d,\u884c\u53f7\uff1a" + i + "2");
            }
            if (mobiles.contains(dto.getMobile())) {
                throw new AppException("\u5b66\u751f\u624b\u673a\u53f7\u91cd\u590d,\u884c\u53f7\uff1a" + i + "2");
            }
            if (idNos.contains(dto.getIdNo())) {
                throw new AppException("\u5b66\u751f\u8eab\u4efd\u8bc1\u53f7\u7801\u91cd\u590d,\u884c\u53f7\uff1a" + i + "2");
            }
            if (userNames.contains(dto.getParentUserName())) {
                throw new AppException("\u5bb6\u957f\u7528\u6237\u540d\u91cd\u590d,\u884c\u53f7\uff1a" + i + "2");
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getParentPhone()) && mobiles.contains(dto.getParentPhone())) {
                throw new AppException("\u5bb6\u957f\u624b\u673a\u53f7\u91cd\u590d,\u884c\u53f7\uff1a" + i + "2");
            }
            if (StringUtils.isNotBlank((CharSequence)dto.getParentIdNo()) && idNos.contains(dto.getParentIdNo())) {
                throw new AppException("\u5bb6\u957f\u8eab\u4efd\u8bc1\u53f7\u7801\u91cd\u590d,\u884c\u53f7\uff1a" + i + "2");
            }
            userNames.add(dto.getUserName());
            mobiles.add(dto.getMobile());
            gradeNames.add(dto.getGradeName());
            specNames.add(dto.getMajorName());
            clbumNames.add(dto.getClbumName());
            if (StringUtils.isNotBlank((CharSequence)dto.getParentPhone())) {
                mobiles.add(dto.getParentPhone());
            }
            idNos.add(dto.getIdNo());
            if (StringUtils.isNotBlank((CharSequence)dto.getParentIdNo())) {
                idNos.add(dto.getParentIdNo());
            }
            if (!StringUtils.isNotBlank((CharSequence)dto.getParentUserName())) continue;
            userNames.add(dto.getParentUserName());
        }
    }

    public Student getByUserId(Long userId) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(Student::getUserId, (Object)userId);
        return (Student)this.getOne((Wrapper)qw);
    }

    public void updateStatus(UpdateStatusDTO dto) {
        Student student;
        List parentList;
        User user = (User)this.userService.getById((Serializable)dto.getUserId());
        if (null == user) {
            throw new AppException("\u7528\u6237\u83b7\u53d6\u5931\u8d25");
        }
        if (RoleEnum.STUDENT.getId().equals(user.getRoleId()) && CollectionUtils.isNotEmpty((Collection)(parentList = this.studentParentService.list((Wrapper)new LambdaQueryWrapper().eq(StudentParent::getStudentId, (Object)(student = this.getByUserId(user.getId())).getId()))))) {
            for (StudentParent studentParent : parentList) {
                User userParent = (User)this.userService.getById((Serializable)studentParent.getUserId());
                userParent.setStatus(dto.getStatus());
                this.userService.updateById((Object)userParent);
            }
        }
        user.setStatus(dto.getStatus());
        this.userService.updateById((Object)user);
    }

    public ExamStudentScoreVO studentAnalysis(Integer type, String subjectCode, Long userId) {
        Date date = null;
        date = type == null || type == 1 ? DateTimeUtil.addMonth((Date)new Date(), (int)-3) : DateTimeUtil.addMonth((Date)new Date(), (int)-6);
        ExamStudentScoreVO vo = new ExamStudentScoreVO();
        List scoreListlVOS = this.studentMapper.selectStudentScore(subjectCode, userId, date, new Date());
        if (CollectionUtils.isEmpty((Collection)scoreListlVOS)) {
            return vo;
        }
        Student student = this.getByUserId(userId);
        ArrayList<ExamStudentScoreDetailVO> details = new ArrayList<ExamStudentScoreDetailVO>();
        Integer specAllCount = 0;
        BigDecimal specAllAvgScore = BigDecimal.ZERO;
        BigDecimal slefAllAvgScore = BigDecimal.ZERO;
        Integer specAllRank = 0;
        Integer clbumAllRank = 0;
        HashSet repoIds = new HashSet();
        for (ExamStudentScoreListlVO studentScoreListlVO : scoreListlVOS) {
            int i;
            List allList = this.studentMapper.selectAllStudentScore(studentScoreListlVO.getExamId(), null, null);
            List specList = this.studentMapper.selectAllStudentScore(studentScoreListlVO.getExamId(), student.getAdministrativeSpecialtyId(), null);
            List clbumList = this.studentMapper.selectAllStudentScore(studentScoreListlVO.getExamId(), null, student.getAdministrativeClbumId());
            ExamStudentScoreDetailVO examStudentScoreDetailVO = new ExamStudentScoreDetailVO();
            examStudentScoreDetailVO.setScore(studentScoreListlVO.getScore());
            examStudentScoreDetailVO.setName(studentScoreListlVO.getName());
            BigDecimal specAllScore = BigDecimal.ZERO;
            for (i = 0; i < specList.size(); ++i) {
                ExamAllStudentScoreListlVO specUser = (ExamAllStudentScoreListlVO)specList.get(i);
                if (specUser.getUserId().equals(student.getUserId())) {
                    examStudentScoreDetailVO.setSpecialtyRank(Integer.valueOf(i + 1));
                    specAllRank = specAllRank + (i + 1);
                    slefAllAvgScore = slefAllAvgScore.add(specUser.getScore());
                }
                specAllScore = specAllScore.add(specUser.getScore());
            }
            specAllCount = specAllCount + specList.size();
            specAllAvgScore = specAllAvgScore.add(specAllScore.divide(new BigDecimal(specList.size()), 2, RoundingMode.HALF_UP));
            for (i = 0; i < clbumList.size(); ++i) {
                ExamAllStudentScoreListlVO clbumUser = (ExamAllStudentScoreListlVO)clbumList.get(i);
                if (!clbumUser.getUserId().equals(student.getUserId())) continue;
                clbumAllRank = clbumAllRank + (i + 1);
                examStudentScoreDetailVO.setClassRank(Integer.valueOf(i + 1));
            }
            details.add(examStudentScoreDetailVO);
            List ids = this.examMapper.getkonwledgeCount(studentScoreListlVO.getExamId(), subjectCode);
            studentScoreListlVO.setExamKnowledgeCount(ids);
            repoIds.addAll(ids);
        }
        vo.setDetails(details);
        vo.setAvgScore(slefAllAvgScore.divide(new BigDecimal(scoreListlVOS.size()), 2, RoundingMode.HALF_UP));
        vo.setExamCount(Integer.valueOf(scoreListlVOS.size()));
        vo.setJoinStudentCount(specAllCount);
        vo.setAllAvgScore(specAllAvgScore.divide(new BigDecimal(scoreListlVOS.size()), 2, RoundingMode.HALF_UP));
        vo.setSpecialtyAvgRank(Integer.valueOf(specAllRank / scoreListlVOS.size()));
        vo.setClubmAvgRank(Integer.valueOf(clbumAllRank / scoreListlVOS.size()));
        List catalogues = this.catalogueService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{Catalogue::getId}).eq(Catalogue::getSubjectCode, (Object)subjectCode)).eq(Catalogue::getLevel, (Object)4)).eq(Catalogue::getDeleted, (Object)false));
        vo.setKnowledgeAllCount(Integer.valueOf(catalogues.size()));
        vo.setKnowledgeContainCount(Integer.valueOf(repoIds.size()));
        List wrongQuestionBooks = this.wrongQuestionBookMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{WrongQuestionBook::getRepoId, WrongQuestionBook::getCreateTime}).eq(WrongQuestionBook::getType, (Object)1)).eq(WrongQuestionBook::getUserId, (Object)userId)).eq(WrongQuestionBook::getDeleted, (Object)false)).eq(WrongQuestionBook::getSubjectCode, (Object)subjectCode)).gt(WrongQuestionBook::getCreateTime, (Object)date));
        if (CollectionUtils.isNotEmpty((Collection)wrongQuestionBooks)) {
            Set wrongIds = wrongQuestionBooks.stream().map(WrongQuestionBook::getRepoId).collect(Collectors.toSet());
            vo.setKnowledgeNotMasterCount(Integer.valueOf(wrongIds.size()));
        } else {
            vo.setKnowledgeNotMasterCount(Integer.valueOf(0));
        }
        vo.setKnowledgeMasterCount(Integer.valueOf(vo.getKnowledgeContainCount() - vo.getKnowledgeNotMasterCount()));
        List examStudentScoreEveryMouthVOS = this.everyMouthKnowledge(scoreListlVOS, wrongQuestionBooks);
        vo.setExamStudentScoreEveryMouthVOS(examStudentScoreEveryMouthVOS);
        return vo;
    }

    public List<ExamStudentScoreAllVO> studentTotalAnalysis(Integer type, Long userId) {
        Date date = null;
        date = type == null || type == 1 ? DateTimeUtil.addMonth((Date)new Date(), (int)-3) : DateTimeUtil.addMonth((Date)new Date(), (int)-6);
        ArrayList<ExamStudentScoreAllVO> list = new ArrayList<ExamStudentScoreAllVO>();
        List studentAllAnalyzeList = this.userExamsScoreMapper.getStudentAllAnalyzeList(userId, date);
        if (CollectionUtils.isEmpty((Collection)studentAllAnalyzeList)) {
            return list;
        }
        for (ExamStudentScoreSelectVO selectVO : studentAllAnalyzeList) {
            ExamStudentScoreAllVO vo = new ExamStudentScoreAllVO();
            vo.setSubjectName(selectVO.getSubjectName());
            vo.setAvgScore(selectVO.getScore().divide(new BigDecimal(selectVO.getExamCount()), 2, RoundingMode.HALF_UP));
            list.add(vo);
        }
        return list;
    }

    public void syncStudent(List<UserOperateLogStudentVO> vos) {
        if (CollectionUtils.isEmpty(vos)) {
            log.info("\u540c\u6b65\u5b66\u751f\u6570\u636e\u4e3a\u7a7a");
            return;
        }
        List students = this.studentMapper.selectList((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{Student::getStudyCode, Student::getUserId}));
        List clbums = this.clbumService.list();
        List specialties = this.specialtyService.list();
        List grades = this.gradeService.list();
        for (UserOperateLogStudentVO vo : vos) {
            Student student;
            Optional<Grade> first;
            Long gradeId = null;
            Long specId = null;
            Long clbumId = null;
            if (StringUtils.isNotBlank((CharSequence)vo.getGradeCode())) {
                first = grades.stream().filter(grade -> grade.getCode().equals(vo.getGradeCode())).findFirst();
                if (!first.isPresent()) {
                    grade = new Grade();
                    grade.setCode(vo.getGradeCode());
                    grade.setName(vo.getGradeName());
                    this.gradeService.add(grade);
                    grades.add(grade);
                    gradeId = grade.getId();
                } else {
                    grade = first.get();
                    gradeId = grade.getId();
                }
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getSpecialtyCode())) {
                first = specialties.stream().filter(specialty -> specialty.getCode().equals(vo.getSpecialtyCode())).findFirst();
                if (!first.isPresent()) {
                    specialty = new Specialty();
                    specialty.setCode(vo.getSpecialtyCode());
                    specialty.setName(vo.getSpecialtyName());
                    this.specialtyService.add(specialty);
                    specialties.add(specialty);
                    specId = specialty.getId();
                } else {
                    specialty = (Specialty)first.get();
                    specId = specialty.getId();
                }
            }
            if (StringUtils.isNotBlank((CharSequence)vo.getClbumCode())) {
                first = clbums.stream().filter(clbum -> clbum.getCode().equals(vo.getClbumCode())).findFirst();
                if (!first.isPresent()) {
                    ClbumForm clbumForm = new ClbumForm();
                    clbumForm.setClbumName(vo.getClbumName());
                    clbumForm.setCode(vo.getClbumCode());
                    clbumForm.setClbumCount(vo.getClbumCount());
                    clbumForm.setSpecialtyId(specId);
                    clbumForm.setGradeId(gradeId);
                    Clbum clbum2 = this.clbumService.addClbum(clbumForm);
                    clbums.add(clbum2);
                    clbumId = clbum2.getId();
                } else {
                    Clbum clbum3 = (Clbum)first.get();
                    clbumId = clbum3.getId();
                }
            }
            if ((first = students.stream().filter(item -> item.getStudyCode().equals(vo.getStudyCode())).findFirst()).isPresent()) {
                student = (Student)first.get();
                if (Integer.valueOf(3).equals(vo.getType())) {
                    this.delete(student.getId().toString());
                    continue;
                }
                if (!Integer.valueOf(2).equals(vo.getType())) {
                    log.warn("\u540c\u6b65\u6559\u804c\u5de5\u5f02\u5e38\u6570\u636e,{}", (Object)vo);
                }
                this.updateSyncStudent(vo, student, clbumId, specId, gradeId);
                continue;
            }
            if (!Integer.valueOf(1).equals(vo.getType())) {
                log.warn("\u540c\u6b65\u6559\u804c\u5de5\u5f02\u5e38\u6570\u636e,{}", (Object)vo);
            }
            student = this.addSyncStudent(vo, clbumId, specId, gradeId);
            students.add(student);
        }
    }

    private List<ExamStudentScoreEveryMouthVO> everyMouthKnowledge(List<ExamStudentScoreListlVO> scoreListlVOS, List<WrongQuestionBook> wrongQuestionBooks) {
        LocalDateTime now = LocalDateTime.now();
        List last30Days = wrongQuestionBooks.stream().filter(book -> ChronoUnit.DAYS.between(book.getCreateTime(), now) < 30L).collect(Collectors.toList());
        List last60Days = wrongQuestionBooks.stream().filter(book -> ChronoUnit.DAYS.between(book.getCreateTime(), now) < 60L).collect(Collectors.toList());
        List examLast30Days = scoreListlVOS.stream().filter(book -> ChronoUnit.DAYS.between(book.getCreateTime(), now) < 30L).collect(Collectors.toList());
        List examLast60Days = scoreListlVOS.stream().filter(book -> ChronoUnit.DAYS.between(book.getCreateTime(), now) < 60L).collect(Collectors.toList());
        ArrayList<ExamStudentScoreEveryMouthVO> list = new ArrayList<ExamStudentScoreEveryMouthVO>();
        ExamStudentScoreEveryMouthVO returnVO = new ExamStudentScoreEveryMouthVO();
        returnVO.setName("\u8fd130\u5929");
        if (CollectionUtils.isNotEmpty(examLast30Days)) {
            HashSet set = new HashSet();
            for (Object vo : examLast30Days) {
                set.addAll(vo.getExamKnowledgeCount());
            }
            Set<Object> wrongIds = new HashSet();
            if (CollectionUtils.isNotEmpty(last30Days)) {
                wrongIds = last30Days.stream().map(WrongQuestionBook::getRepoId).collect(Collectors.toSet());
            }
            returnVO.setCount(Integer.valueOf(set.size() - wrongIds.size()));
        }
        list.add(returnVO);
        ExamStudentScoreEveryMouthVO returnVO1 = new ExamStudentScoreEveryMouthVO();
        returnVO1.setName("\u8fd160\u5929");
        if (CollectionUtils.isNotEmpty(examLast60Days)) {
            HashSet set = new HashSet();
            for (Object vo : examLast60Days) {
                set.addAll(vo.getExamKnowledgeCount());
            }
            Set<Object> wrongIds = new HashSet();
            if (CollectionUtils.isNotEmpty(last60Days)) {
                wrongIds = last60Days.stream().map(WrongQuestionBook::getRepoId).collect(Collectors.toSet());
            }
            returnVO1.setCount(Integer.valueOf(set.size() - wrongIds.size()));
        }
        list.add(returnVO1);
        ExamStudentScoreEveryMouthVO returnVO2 = new ExamStudentScoreEveryMouthVO();
        returnVO2.setName("\u8fd190\u5929");
        if (CollectionUtils.isNotEmpty(scoreListlVOS)) {
            HashSet set = new HashSet();
            for (ExamStudentScoreListlVO vo : scoreListlVOS) {
                set.addAll(vo.getExamKnowledgeCount());
            }
            Set<Object> wrongIds = new HashSet();
            if (CollectionUtils.isNotEmpty(wrongQuestionBooks)) {
                wrongIds = wrongQuestionBooks.stream().map(WrongQuestionBook::getRepoId).collect(Collectors.toSet());
            }
            returnVO2.setCount(Integer.valueOf(set.size() - wrongIds.size()));
        }
        list.add(returnVO2);
        return list;
    }

    private void checkUser(String idNo, String mobile, Long id, String userName) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(User::getIsDeleted, (Object)false);
        if (null != id) {
            wrapper.ne(User::getId, (Object)id);
        }
        wrapper.and(wp -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wp.eq(User::getIdNo, (Object)AESEncryptUtils.encrypt((String)idNo))).or()).eq(User::getMobile, (Object)AESEncryptUtils.encrypt((String)mobile)));
        List users = this.userService.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)users)) {
            if (id == null) {
                throw new AppException("\u5f53\u524d\u8eab\u4efd\u8bc1/\u624b\u673a\u53f7\u91cd\u590d,\u4e0d\u652f\u6301\u65b0\u589e");
            }
            throw new AppException("\u5f53\u524d\u8eab\u4efd\u8bc1/\u624b\u673a\u53f7\u91cd\u590d,\u4e0d\u652f\u6301\u4fee\u6539");
        }
        LambdaQueryWrapper userNameWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(User::getIsDeleted, (Object)false);
        if (null != id) {
            userNameWrapper.ne(User::getId, (Object)id);
        }
        userNameWrapper.and(wp -> wp.eq(User::getUserName, (Object)userName));
        List userNames = this.userService.list((Wrapper)userNameWrapper);
        if (CollectionUtils.isNotEmpty((Collection)userNames)) {
            if (id == null) {
                throw new AppException("\u5f53\u524d\u7528\u6237\u540d\u91cd\u590d,\u4e0d\u652f\u6301\u65b0\u589e");
            }
            throw new AppException("\u5f53\u524d\u7528\u6237\u540d\u91cd\u590d,\u4e0d\u652f\u6301\u4fee\u6539");
        }
    }

    private Student addSyncStudent(UserOperateLogStudentVO vo, Long clbumId, Long specId, Long gradeId) {
        User user = new User();
        user.setRealName(vo.getRealName());
        user.setSex(vo.getSex());
        user.setIdNo(vo.getIdNo());
        user.setMobile(vo.getMobile());
        user.setUserName(PinYinUtil.chinese2PinYinFirst((String)vo.getRealName()) + vo.getMobile());
        user.setPassword(this.getPasswordDefault(vo.getIdNo()));
        user.setRoleId(RoleEnum.STUDENT.getId());
        user.setClbumId(clbumId);
        user.setSchoolId(SecurityUtil.getSchoolId());
        this.userService.save((Object)user);
        Student student = new Student();
        student.setStudyCode(vo.getStudyCode());
        student.setUserId(user.getId());
        student.setAdministrativeGradeId(gradeId);
        student.setAdministrativeSpecialtyId(specId);
        student.setAdministrativeClbumId(clbumId);
        this.save((Object)student);
        return student;
    }

    private void updateSyncStudent(UserOperateLogStudentVO vo, Student student, Long clbumId, Long specId, Long gradeId) {
        User user = (User)this.userService.getById((Serializable)student.getUserId());
        user.setRealName(vo.getRealName());
        user.setSex(vo.getSex());
        user.setIdNo(vo.getIdNo());
        user.setMobile(vo.getMobile());
        user.setClbumId(clbumId);
        this.userService.updateById((Object)user);
        student.setAdministrativeGradeId(gradeId);
        student.setAdministrativeSpecialtyId(specId);
        student.setAdministrativeClbumId(clbumId);
        this.updateById((Object)student);
    }

    public List<StudentPlusVO> listByClbumList(List<Long> clbumList) {
        return this.studentMapper.selectAllByClbumList(clbumList);
    }

    private String getPasswordDefault(String idNo) {
        SysParam passwordGenerateType = this.sysParamService.getByType(SysParamEnum.PASSWORD_GENERATE_TYPE.getType());
        SysParam passwordTeacher = this.sysParamService.getByType(SysParamEnum.PASSWORD_TEACHER.getType());
        if (null == passwordGenerateType || null == passwordTeacher || "1".equals(passwordGenerateType.getValue())) {
            return new BCryptPasswordEncoder().encode((CharSequence)idNo.substring(idNo.length() - 6));
        }
        return new BCryptPasswordEncoder().encode((CharSequence)passwordTeacher.getValue());
    }

    public void physicalDeleteBySyncSource(Integer syncSource) {
        ((StudentMapper)this.baseMapper).physicalDeleteBySyncSource(syncSource);
    }
}

