/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.mapper.SubjectMapper;
import com.zsy.exam.mapper.SubjectSpecialtyMappingMapper;
import com.zsy.exam.model.dto.SubjectExerciseNumberDto;
import com.zsy.exam.model.dto.SubjectUpdatePaperCountDTO;
import com.zsy.exam.model.entity.Catalogue;
import com.zsy.exam.model.entity.Question;
import com.zsy.exam.model.entity.Subject;
import com.zsy.exam.model.entity.SubjectSpecialtyMapping;
import com.zsy.exam.model.vo.subject.SubjectForTeacherVO;
import com.zsy.exam.model.vo.subject.SubjectVO;
import com.zsy.exam.service.ICatalogueService;
import com.zsy.exam.service.IQuestionService;
import com.zsy.exam.service.ISubjectService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SubjectServiceImpl
extends ServiceImpl<SubjectMapper, Subject>
implements ISubjectService {
    @Autowired
    SubjectMapper subjectMapper;
    @Autowired
    SubjectSpecialtyMappingMapper subjectSpecialtyMappingMapper;
    @Autowired
    ICatalogueService catalogueService;
    @Autowired
    IQuestionService questionService;

    public Subject getSubject(Long id) {
        return (Subject)this.subjectMapper.selectById((Serializable)id);
    }

    public Page<SubjectVO> getAllSubject(Page page, String name, String code, Boolean enable, Long examAreaId) {
        Page list = this.subjectMapper.selectPageList(page, name, code, enable, examAreaId);
        for (SubjectVO subject : list.getRecords()) {
            Long id = subject.getId();
            List specialties = this.subjectSpecialtyMappingMapper.selectSpecialtyList(id);
            subject.setSpecialtyVO(specialties);
        }
        return list;
    }

    @Transactional(rollbackFor={Exception.class})
    public void add(Subject subject) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(subject.getCode() != null, Subject::getCode, (Object)subject.getCode())).or()).eq(subject.getName() != null, Subject::getName, (Object)subject.getName());
        Subject one = (Subject)this.subjectMapper.selectOne((Wrapper)wrapper);
        if (one != null) {
            throw new RuntimeException("\u8be5\u79d1\u76ee\u540d\u79f0\u6216\u79d1\u76ee\u4ee3\u7801\u5df2\u5b58\u5728");
        }
        this.subjectMapper.insert((Object)subject);
        List specialtyIdList = subject.getSpecialtyList();
        for (Long specialtyId : specialtyIdList) {
            SubjectSpecialtyMapping subjectSpecialtyMapping = new SubjectSpecialtyMapping();
            subjectSpecialtyMapping.setSubjectId(subject.getId());
            subjectSpecialtyMapping.setSpecialtyId(specialtyId);
            this.subjectSpecialtyMappingMapper.insert((Object)subjectSpecialtyMapping);
        }
        Catalogue catalogue = new Catalogue();
        catalogue.setCode(subject.getCode());
        catalogue.setName(subject.getName());
        catalogue.setType("repo");
        this.catalogueService.add(catalogue, Boolean.FALSE);
    }

    @Transactional(rollbackFor={Exception.class})
    public int modify(Subject subject) {
        long count;
        LambdaQueryWrapper wrapper;
        String code;
        Subject oldsubject = (Subject)this.subjectMapper.selectById((Serializable)subject.getId());
        if (!subject.getCode().equals(oldsubject.getCode())) {
            code = subject.getCode();
            wrapper = new LambdaQueryWrapper();
            wrapper.likeRight(code != null, Question::getCode, (Object)(code + "\uff0d"));
            count = this.questionService.count((Wrapper)wrapper);
            if (count > 0L) {
                throw new RuntimeException("\u8be5\u79d1\u76ee\u4ee3\u7801\u5df2\u5b58\u5728");
            }
        }
        if (!oldsubject.getCode().equals(subject.getCode())) {
            code = oldsubject.getCode();
            wrapper = new LambdaQueryWrapper();
            wrapper.likeRight(code != null, Question::getCode, (Object)(code + "\uff0d"));
            count = this.questionService.count((Wrapper)wrapper);
            if (count > 0L) {
                throw new RuntimeException("\u8be5\u79d1\u76ee\u5df2\u5b58\u5728\u76f8\u5173\u8bd5\u9898\u65e0\u6cd5\u66f4\u65b0\u4ee3\u7801");
            }
        }
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        wrapper2.eq(Catalogue::getCode, (Object)oldsubject.getCode());
        Catalogue catalogue = (Catalogue)this.catalogueService.getOne((Wrapper)wrapper2);
        catalogue.setCode(subject.getCode());
        catalogue.setName(subject.getName());
        this.catalogueService.modify(catalogue);
        LambdaQueryWrapper subjectSpecialtyMappingLambdaQueryWrapper = new LambdaQueryWrapper();
        subjectSpecialtyMappingLambdaQueryWrapper.eq(SubjectSpecialtyMapping::getSubjectId, (Object)subject.getId());
        this.subjectSpecialtyMappingMapper.delete((Wrapper)subjectSpecialtyMappingLambdaQueryWrapper);
        for (Long specialtyId : subject.getSpecialtyList()) {
            SubjectSpecialtyMapping subjectSpecialtyMapping = new SubjectSpecialtyMapping();
            subjectSpecialtyMapping.setSubjectId(subject.getId());
            subjectSpecialtyMapping.setSpecialtyId(specialtyId);
            this.subjectSpecialtyMappingMapper.insert((Object)subjectSpecialtyMapping);
        }
        return this.subjectMapper.updateById((Object)subject);
    }

    @Transactional(rollbackFor={Exception.class})
    public void remove(String ids) {
        String[] array;
        if (StringUtils.isNotEmpty((CharSequence)ids) && !CollectionUtils.isEmpty(Arrays.asList(array = ids.split(",")))) {
            for (String id : array) {
                Subject subject = (Subject)this.subjectMapper.selectById((Serializable)((Object)id));
                String code = subject.getCode();
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.likeRight(code != null, Question::getCode, (Object)(code + "\uff0d"));
                long count = this.questionService.count((Wrapper)wrapper);
                if (count > 0L) {
                    throw new RuntimeException("\u8be5\u79d1\u76ee\u5df2\u5b58\u5728\u76f8\u5173\u8bd5\u9898\u65e0\u6cd5\u5220\u9664");
                }
                if (subject.getIsBuiltIn().booleanValue()) {
                    throw new RuntimeException("\u8be5\u79d1\u76ee\u4e3a\u5185\u7f6e\u79d1\u76ee\u65e0\u6cd5\u5220\u9664");
                }
                this.subjectMapper.deleteById((Serializable)((Object)id));
                LambdaQueryWrapper catalogueLambdaQueryWrapper = new LambdaQueryWrapper();
                catalogueLambdaQueryWrapper.eq(Catalogue::getCode, (Object)code);
                Catalogue catalogue = (Catalogue)this.catalogueService.getOne((Wrapper)catalogueLambdaQueryWrapper);
                this.catalogueService.remove(catalogue.getId().toString());
                LambdaQueryWrapper subjectSpecialtyMappingLambdaQueryWrapper = new LambdaQueryWrapper();
                subjectSpecialtyMappingLambdaQueryWrapper.eq(SubjectSpecialtyMapping::getSubjectId, (Object)subject.getId());
                this.subjectSpecialtyMappingMapper.delete((Wrapper)subjectSpecialtyMappingLambdaQueryWrapper);
            }
        }
    }

    public List<Subject> listForStudent() {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.select(new SFunction[]{Subject::getName, Subject::getCode, Subject::getType}).eq(Subject::getEnable, (Object)Boolean.TRUE);
        return this.list((Wrapper)qw);
    }

    public List<SubjectForTeacherVO> listForTeacher(String userId, String subjectId) {
        return this.subjectMapper.listForTeacher(userId, subjectId);
    }

    public Subject getByCode(String code) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(Subject::getCode, (Object)code);
        List list = this.list((Wrapper)qw);
        if (CollUtil.isNotEmpty((Collection)list)) {
            return (Subject)list.get(0);
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateExerciseNumber(SubjectExerciseNumberDto dto) {
        List subjectCodeList = dto.getSubjectCodeList();
        if (CollUtil.isNotEmpty((Collection)subjectCodeList)) {
            subjectCodeList.forEach(code -> {
                Subject subject = this.getByCode(code);
                if (null == subject) {
                    return;
                }
                subject.setExerciseNumber(dto.getExerciseNumber());
                this.updateById((Object)subject);
            });
        }
    }

    public void updatePaperCount(SubjectUpdatePaperCountDTO dto) {
        if (null == dto || null == dto.getId()) {
            throw new AppException("\u53c2\u6570\u9519\u8bef");
        }
        Subject subject = (Subject)this.getById((Serializable)dto.getId());
        subject.setExaminationPaperNumber(dto.getCount());
        this.updateById((Object)subject);
    }
}

