/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.constant.RoleEnum;
import com.zsy.exam.constant.SysParamEnum;
import com.zsy.exam.mapper.SysParamMapper;
import com.zsy.exam.model.entity.SysParam;
import com.zsy.exam.service.IRoleService;
import com.zsy.exam.service.ISysParamService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SysParamServiceImpl
extends ServiceImpl<SysParamMapper, SysParam>
implements ISysParamService {
    @Autowired
    SysParamMapper sysParamMapper;
    @Resource
    private IRoleService roleService;

    public SysParam getSysParam(Long id) {
        return (SysParam)this.sysParamMapper.selectById((Serializable)id);
    }

    public Page<SysParam> getAllSysParam(Page page) {
        List roles = this.roleService.getCurrentRoles();
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        if (!roles.contains(RoleEnum.SUPER_ADMIN.getCode())) {
            qw.notIn(SysParam::getType, new Object[]{SysParamEnum.QUESTION_LIST_DEMO.getType()});
        }
        return (Page)this.sysParamMapper.selectPage((IPage)page, (Wrapper)qw);
    }

    @Transactional(rollbackFor={Exception.class})
    public void add(SysParam sysParam) {
        this.sysParamMapper.insert((Object)sysParam);
    }

    @Transactional(rollbackFor={Exception.class})
    public int modify(SysParam sysParam) {
        String type = sysParam.getType();
        SysParam db = (SysParam)this.getById((Serializable)sysParam.getId());
        if (!db.getType().equals(type)) {
            throw new AppException("\u4e0d\u80fd\u4fee\u6539\u7c7b\u578b\u6807\u8bc6");
        }
        return this.sysParamMapper.updateById((Object)sysParam);
    }

    @Transactional(rollbackFor={Exception.class})
    public void remove(String ids) {
        String[] array;
        if (StringUtils.isNotEmpty((CharSequence)ids) && !CollectionUtils.isEmpty(Arrays.asList(array = ids.split(",")))) {
            this.sysParamMapper.deleteBatchIds(Arrays.asList(array));
        }
    }

    public SysParam getByType(String type) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(SysParam::getType, (Object)type);
        return (SysParam)this.getOne((Wrapper)qw);
    }
}

