/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.mapper.UploadFileTypeMapper;
import com.zsy.exam.model.dto.UploadFileTypeChangeStatusDto;
import com.zsy.exam.model.dto.UploadFileTypeDto;
import com.zsy.exam.model.entity.UploadFileType;
import com.zsy.exam.service.IUploadFileTypeService;
import io.micrometer.common.util.StringUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class UploadFileTypeServiceImpl
extends ServiceImpl<UploadFileTypeMapper, UploadFileType>
implements IUploadFileTypeService {
    public Boolean save(UploadFileTypeDto dto) {
        this.validDto(dto);
        UploadFileType db = new UploadFileType();
        BeanUtil.copyProperties((Object)dto, (Object)db, (String[])new String[0]);
        db.setStatus(Boolean.FALSE);
        return this.save((Object)db);
    }

    public Boolean update(UploadFileTypeDto dto) {
        this.validDto(dto);
        UploadFileType db = new UploadFileType();
        BeanUtil.copyProperties((Object)dto, (Object)db, (String[])new String[0]);
        return this.updateById((Object)db);
    }

    public IPage<UploadFileType> getPage(Page page, String type) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        qw.eq(StringUtils.isNotBlank((String)type), UploadFileType::getType, (Object)type);
        return this.page((IPage)page, (Wrapper)qw);
    }

    public String getTypeBySuffix(String suffix) {
        if (!((String)suffix).startsWith(".")) {
            suffix = "." + (String)suffix;
        }
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)qw.eq(UploadFileType::getSuffix, suffix)).eq(UploadFileType::getStatus, (Object)Boolean.TRUE);
        List list = this.list((Wrapper)qw);
        if (CollUtil.isNotEmpty((Collection)list)) {
            return ((UploadFileType)list.get(0)).getType();
        }
        return null;
    }

    public Boolean changeStatus(UploadFileTypeChangeStatusDto dto) {
        Boolean status = dto.getStatus();
        List ids = dto.getIds();
        if (null == status || CollUtil.isEmpty((Collection)ids)) {
            return Boolean.FALSE;
        }
        LambdaUpdateWrapper qw = new LambdaUpdateWrapper();
        qw.in(UploadFileType::getId, (Collection)ids);
        qw.set(UploadFileType::getStatus, (Object)status);
        return this.update((Wrapper)qw);
    }

    public Boolean delete(Long id) {
        return this.removeById((Serializable)id);
    }

    public Map<String, List<UploadFileType>> groupByType() {
        List list = this.list();
        if (CollUtil.isEmpty((Collection)list)) {
            return null;
        }
        Map<String, List<UploadFileType>> collect = list.stream().collect(Collectors.groupingBy(a -> a.getType()));
        return collect;
    }

    private void validDto(UploadFileTypeDto dto) {
        Long id = dto.getId();
        if (!dto.getSuffix().startsWith(".")) {
            dto.setSuffix("." + dto.getSuffix());
        }
        String suffix = dto.getSuffix();
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)qw.and(wq -> wq.eq(UploadFileType::getSuffix, (Object)suffix))).ne(null != id, UploadFileType::getId, (Object)id);
        List list = this.list((Wrapper)qw);
        if (CollUtil.isNotEmpty((Collection)list)) {
            throw new AppException("\u8be5\u540e\u7f00\u540d\u3010" + suffix + "\u3011\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4");
        }
    }
}

