/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.constant.QuestionTypeEnum;
import com.zsy.exam.converter.UserBookConverter;
import com.zsy.exam.mapper.ExamQuAnswerMapper;
import com.zsy.exam.mapper.OptionMapper;
import com.zsy.exam.mapper.QuestionMapper;
import com.zsy.exam.mapper.UserBookMapper;
import com.zsy.exam.model.entity.Option;
import com.zsy.exam.model.entity.Question;
import com.zsy.exam.model.entity.UserBook;
import com.zsy.exam.model.form.userbook.ReUserBookForm;
import com.zsy.exam.model.vo.userbook.AddBookAnswerVO;
import com.zsy.exam.model.vo.userbook.BookOneQuVO;
import com.zsy.exam.model.vo.userbook.ReUserExamBookVO;
import com.zsy.exam.model.vo.userbook.UserPageBookVO;
import com.zsy.exam.service.IOptionService;
import com.zsy.exam.service.IQuestionService;
import com.zsy.exam.service.IUserBookService;
import com.zsy.exam.service.impl.UserBookServiceImpl;
import com.zsy.exam.util.SecurityUtil;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class UserBookServiceImpl
extends ServiceImpl<UserBookMapper, UserBook>
implements IUserBookService {
    @Resource
    private UserBookMapper userBookMapper;
    @Resource
    private QuestionMapper questionMapper;
    @Resource
    private OptionMapper optionMapper;
    @Resource
    private ExamQuAnswerMapper examQuAnswerMapper;
    @Resource
    private UserBookConverter userBookConverter;
    @Resource
    private IQuestionService questionService;
    @Resource
    private IOptionService optionService;

    public Result<IPage<UserPageBookVO>> getPage(Integer pageNum, Integer pageSize, String examName) {
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        Page userPageBookVOPage = this.userBookMapper.selectPageVo(page, examName, SecurityUtil.getUserId());
        return Result.success((String)"\u67e5\u8be2\u6210\u529f", (Object)userPageBookVOPage);
    }

    public Result<List<ReUserExamBookVO>> getReUserExamBook(Long examId) {
        LambdaQueryWrapper userBookLambdaQueryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)userBookLambdaQueryWrapper.eq(UserBook::getExamId, (Object)examId)).eq(UserBook::getUserId, (Object)SecurityUtil.getUserId());
        List userBook = this.userBookMapper.selectList((Wrapper)userBookLambdaQueryWrapper);
        List reUserExamBookVOS = this.userBookConverter.listEntityToVo(userBook);
        return Result.success((String)"\u67e5\u8be2\u6210\u529f", (Object)reUserExamBookVOS);
    }

    public Result<BookOneQuVO> getBookOne(Long quId) {
        BookOneQuVO bookOneQuVO = new BookOneQuVO();
        Question quById = (Question)this.questionService.getById((Serializable)quId);
        bookOneQuVO.setImage(quById.getImage());
        bookOneQuVO.setContent(quById.getContent());
        bookOneQuVO.setQuType(QuestionTypeEnum.getByType((String)quById.getQuType()));
        LambdaQueryWrapper optionLambdaQuery = new LambdaQueryWrapper();
        optionLambdaQuery.eq(Option::getQuId, (Object)quId);
        List list = this.optionMapper.selectList((Wrapper)optionLambdaQuery);
        bookOneQuVO.setAnswerList(list);
        return Result.success((String)"\u83b7\u53d6\u6210\u529f", (Object)bookOneQuVO);
    }

    public Result<AddBookAnswerVO> addBookAnswer(ReUserBookForm reUserBookForm) {
        AddBookAnswerVO addBookAnswerVO = new AddBookAnswerVO();
        if (StringUtils.isBlank((CharSequence)reUserBookForm.getAnswer())) {
            return Result.success((String)"\u672a\u4f5c\u7b54");
        }
        LambdaQueryWrapper QuWrapper = new LambdaQueryWrapper();
        QuWrapper.eq(Question::getId, (Object)reUserBookForm.getQuId());
        Question qu = (Question)this.questionMapper.selectOne((Wrapper)QuWrapper);
        QuestionTypeEnum quType = QuestionTypeEnum.getByType((String)qu.getQuType());
        addBookAnswerVO.setAnalysis(qu.getAnalysis());
        LambdaQueryWrapper opWrapper = new LambdaQueryWrapper();
        opWrapper.eq(Option::getQuId, (Object)reUserBookForm.getQuId());
        List options = this.optionMapper.selectList((Wrapper)opWrapper);
        String current = "";
        ArrayList<Integer> strings = new ArrayList<Integer>();
        for (Option temp : options) {
            if (temp.getIsRight() != 1) continue;
            strings.add(temp.getSort());
        }
        List stringList = strings.stream().map(String::valueOf).collect(Collectors.toList());
        String result = String.join((CharSequence)",", stringList);
        if (quType.equals((Object)"04")) {
            addBookAnswerVO.setRightAnswers(((Option)options.get(0)).getContent());
        } else {
            addBookAnswerVO.setRightAnswers(result);
        }
        return switch (1.$SwitchMap$com$zsy$exam$constant$QuestionTypeEnum[quType.ordinal()]) {
            case 1 -> {
                Option byId = (Option)this.optionService.getById((Serializable)((Object)reUserBookForm.getAnswer()));
                if (byId.getIsRight() == 1) {
                    LambdaQueryWrapper userBookLambdaQueryWrapper = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)userBookLambdaQueryWrapper.eq(UserBook::getUserId, (Object)SecurityUtil.getUserId())).eq(UserBook::getExamId, (Object)reUserBookForm.getExamId())).eq(UserBook::getQuId, (Object)reUserBookForm.getQuId());
                    int row = this.userBookMapper.delete((Wrapper)userBookLambdaQueryWrapper);
                    addBookAnswerVO.setCorrect(Integer.valueOf(1));
                    yield Result.success((String)"\u56de\u7b54\u6b63\u786e\uff0c\u5df2\u79fb\u51fa\u9519\u9898\u672c", (Object)addBookAnswerVO);
                }
                addBookAnswerVO.setCorrect(Integer.valueOf(0));
                yield Result.success((String)"\u56de\u7b54\u9519\u8bef", (Object)addBookAnswerVO);
            }
            case 2 -> {
                LambdaQueryWrapper optionWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)optionWrapper.eq(Option::getIsRight, (Object)1)).eq(Option::getQuId, (Object)reUserBookForm.getQuId());
                List examQuAnswers = this.optionMapper.selectList((Wrapper)optionWrapper);
                List<Integer> quIds = Arrays.stream(reUserBookForm.getAnswer().split(",")).map(Integer::parseInt).toList();
                for (Option temp : examQuAnswers) {
                    boolean containsBanana = quIds.contains(temp.getId());
                    if (!containsBanana) continue;
                    yield Result.success((String)"\u56de\u7b54\u9519\u8bef");
                }
                LambdaQueryWrapper userBookWrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)userBookWrapper.eq(UserBook::getUserId, (Object)SecurityUtil.getUserId())).eq(UserBook::getExamId, (Object)reUserBookForm.getExamId())).eq(UserBook::getQuId, (Object)reUserBookForm.getQuId());
                this.userBookMapper.delete((Wrapper)userBookWrapper);
                yield Result.success((String)"\u56de\u7b54\u6b63\u786e");
            }
            case 3 -> {
                Option byId = (Option)this.optionService.getById((Serializable)((Object)reUserBookForm.getAnswer()));
                if (byId.getIsRight() == 1) {
                    LambdaQueryWrapper userBookLambdaQueryWrapper = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)userBookLambdaQueryWrapper.eq(UserBook::getUserId, (Object)SecurityUtil.getUserId())).eq(UserBook::getExamId, (Object)reUserBookForm.getExamId())).eq(UserBook::getQuId, (Object)reUserBookForm.getQuId());
                    this.userBookMapper.delete((Wrapper)userBookLambdaQueryWrapper);
                    addBookAnswerVO.setCorrect(Integer.valueOf(1));
                    yield Result.success((String)"\u56de\u7b54\u6b63\u786e\uff0c\u5df2\u79fb\u9664\u9519\u9898\u672c", (Object)addBookAnswerVO);
                }
                addBookAnswerVO.setCorrect(Integer.valueOf(0));
                yield Result.success((String)"\u56de\u7b54\u9519\u8bef", (Object)addBookAnswerVO);
            }
            case 4 -> {
                if ("1".equals(reUserBookForm.getAnswer())) {
                    LambdaQueryWrapper userBookLambdaQueryWrapper = new LambdaQueryWrapper();
                    ((LambdaQueryWrapper)((LambdaQueryWrapper)userBookLambdaQueryWrapper.eq(UserBook::getUserId, (Object)SecurityUtil.getUserId())).eq(UserBook::getExamId, (Object)reUserBookForm.getExamId())).eq(UserBook::getQuId, (Object)reUserBookForm.getQuId());
                    this.userBookMapper.delete((Wrapper)userBookLambdaQueryWrapper);
                    yield Result.success((String)"\u56de\u7b54\u6b63\u786e\uff0c\u5df2\u79fb\u9664\u9519\u9898\u672c", (Object)addBookAnswerVO);
                }
                addBookAnswerVO.setCorrect(Integer.valueOf(0));
                yield Result.success((String)"\u56de\u7b54\u9519\u8bef", (Object)addBookAnswerVO);
            }
            default -> Result.failed((String)"\u8bf7\u6c42\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u89e3\u51b3");
        };
    }
}

